/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.user.User;
import com.fasterxml.jackson.databind.JsonNode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

class UserImpl
implements User {
    private final String id;
    private final String username;
    private final String givenName;
    private final String familyName;
    private final String email;
    private final Date firstLogin;
    private final Date lastLogin;
    private final String locale;

    UserImpl(JsonNode json) {
        this.id = json.get("id").asText();
        this.username = json.get("username").asText();
        this.givenName = this.getStringOrEmpty(json, "name");
        this.familyName = this.getStringOrEmpty(json, "surname");
        this.email = this.getStringOrEmpty(json, "email");
        this.firstLogin = this.parseDate(json, "firstLogin");
        this.lastLogin = this.parseDate(json, "lastLogin");
        this.locale = this.getStringOrEmpty(json, "locale");
    }

    private String getStringOrEmpty(JsonNode json, String field) {
        return json.hasNonNull(field) ? json.get(field).asText() : "";
    }

    private Date parseDate(JsonNode json, String field) {
        if (json.hasNonNull(field)) {
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            try {
                return format.parse(json.get(field).asText());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        if (this.givenName.isEmpty() || this.familyName.isEmpty()) {
            return this.givenName + this.familyName;
        }
        return this.givenName + " " + this.familyName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getEmail() {
        return this.email;
    }

    public Date getFirstLogin() {
        return this.firstLogin != null ? (Date)this.firstLogin.clone() : null;
    }

    public Date getLastLogin() {
        return this.lastLogin != null ? (Date)this.lastLogin.clone() : null;
    }

    public String getLocale() {
        return this.locale;
    }

    public String toString() {
        String name = this.getName();
        if (name == null || name.isEmpty()) {
            return this.username;
        }
        return name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UserImpl) {
            return this.id.equals(((UserImpl)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

