/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.dataset.AttributeValue;
import com.belladati.sdk.exception.interval.InvalidIntervalException;
import com.belladati.sdk.filter.Filter;
import com.belladati.sdk.filter.FilterOperation;
import com.belladati.sdk.filter.FilterValue;
import com.belladati.sdk.impl.BellaDatiServiceImpl;
import com.belladati.sdk.impl.ImageViewImpl;
import com.belladati.sdk.impl.JsonViewImpl;
import com.belladati.sdk.impl.LocalizationImpl;
import com.belladati.sdk.impl.TableViewImpl;
import com.belladati.sdk.impl.ViewLoaderImpl;
import com.belladati.sdk.intervals.AbsoluteInterval;
import com.belladati.sdk.intervals.CustomInterval;
import com.belladati.sdk.intervals.DateUnit;
import com.belladati.sdk.intervals.Interval;
import com.belladati.sdk.intervals.IntervalUnit;
import com.belladati.sdk.intervals.RelativeInterval;
import com.belladati.sdk.intervals.TimeUnit;
import com.belladati.sdk.view.View;
import com.belladati.sdk.view.ViewLoader;
import com.belladati.sdk.view.ViewType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

abstract class ViewImpl
implements View {
    private final BellaDatiServiceImpl service;
    private final String id;
    private final String name;
    private final ViewType type;
    private final boolean dateIntervalSupported;
    private final boolean timeIntervalSupported;
    private final Interval<DateUnit> dateInterval;
    private final Interval<TimeUnit> timeInterval;
    private final Set<Filter<?>> filters;
    private final LocalizationImpl localization;

    static ViewImpl buildView(BellaDatiServiceImpl service, JsonNode node) throws UnknownViewTypeException {
        switch (ViewImpl.parseType(node)) {
            case TABLE: {
                return new TableViewImpl(service, node);
            }
        }
        return new JsonViewImpl(service, node);
    }

    static ViewImpl buildView(BellaDatiServiceImpl service, BufferedImage image) throws UnknownViewTypeException {
        return new ImageViewImpl(service, image);
    }

    private static ViewType parseType(JsonNode node) throws UnknownViewTypeException {
        if (node.hasNonNull("type")) {
            try {
                return ViewType.valueOf((String)node.get("type").asText().toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new UnknownViewTypeException(node.get("type").asText());
            }
        }
        throw new UnknownViewTypeException("missing type");
    }

    private static Interval<DateUnit> parseDateInterval(JsonNode node) {
        try {
            if (node.hasNonNull("dateInterval") && node.get("dateInterval").hasNonNull("aggregationType")) {
                JsonNode dateInterval = node.get("dateInterval");
                DateUnit unit = DateUnit.valueOf((String)dateInterval.get("aggregationType").asText().toUpperCase(Locale.ENGLISH));
                JsonNode interval = dateInterval.get("interval");
                String type = interval.get("type").asText().toLowerCase(Locale.ENGLISH);
                if ("relative".equals(type)) {
                    String from = interval.get("from").asText();
                    String to = interval.get("to").asText();
                    return new RelativeInterval((IntervalUnit)unit, (int)Float.parseFloat(from), (int)Float.parseFloat(to));
                }
                if ("absolute".equals(type)) {
                    return new AbsoluteInterval((IntervalUnit)unit, unit.parseAbsolute(interval.get("from")), unit.parseAbsolute(interval.get("to")));
                }
                if ("custom".equals(type)) {
                    return new CustomInterval((IntervalUnit)unit, interval.get("from").asText(), interval.get("to").asText());
                }
            }
        }
        catch (InvalidIntervalException invalidIntervalException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    private static Interval<TimeUnit> parseTimeInterval(JsonNode node) {
        try {
            if (node.hasNonNull("timeInterval") && node.get("timeInterval").hasNonNull("aggregationType")) {
                JsonNode timeInterval = node.get("timeInterval");
                TimeUnit unit = TimeUnit.valueOf((String)timeInterval.get("aggregationType").asText().toUpperCase(Locale.ENGLISH));
                JsonNode interval = timeInterval.get("interval");
                String type = interval.get("type").asText().toLowerCase(Locale.ENGLISH);
                if ("relative".equals(type)) {
                    String from = interval.get("from").asText();
                    String to = interval.get("to").asText();
                    return new RelativeInterval((IntervalUnit)unit, (int)Float.parseFloat(from), (int)Float.parseFloat(to));
                }
                if ("absolute".equals(type)) {
                    return new AbsoluteInterval((IntervalUnit)unit, unit.parseAbsolute(interval.get("from")), unit.parseAbsolute(interval.get("to")));
                }
                if ("custom".equals(type)) {
                    return new CustomInterval((IntervalUnit)unit, interval.get("from").asText(), interval.get("to").asText());
                }
            }
        }
        catch (InvalidIntervalException invalidIntervalException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    private static Set<Filter<?>> parseFilter(JsonNode node) {
        if (!(node.hasNonNull("filter") && node.get("filter").isObject() && node.get("filter").hasNonNull("drilldown") && node.get("filter").get("drilldown").isObject())) {
            return Collections.emptySet();
        }
        HashSet filters = new HashSet();
        Iterator entries = node.get("filter").get("drilldown").fields();
        while (entries.hasNext()) {
            Map.Entry entry = (Map.Entry)entries.next();
            String code = (String)entry.getKey();
            String op = ((JsonNode)entry.getValue()).get("op").asText();
            FilterOperation<?> operation = ViewImpl.findOperation(op);
            if (operation == null) continue;
            Filter filter = operation.createFilter(null, null, code);
            if (filter instanceof Filter.MultiValueFilter && ((JsonNode)entry.getValue()).hasNonNull("values")) {
                for (JsonNode value : (ArrayNode)((JsonNode)entry.getValue()).get("values")) {
                    ((Filter.MultiValueFilter)filter).addAll(new AttributeValue[]{new FilterValue(value.asText())});
                }
            }
            filters.add(filter);
        }
        return filters;
    }

    private static FilterOperation<?> findOperation(String op) {
        for (FilterOperation operation : FilterOperation.values()) {
            if (!operation.toString().equalsIgnoreCase(op)) continue;
            return operation;
        }
        return null;
    }

    ViewImpl(BellaDatiServiceImpl service, JsonNode node) throws UnknownViewTypeException {
        this.service = service;
        this.id = node.get("id").asText();
        this.name = node.get("name").asText();
        this.type = ViewImpl.parseType(node);
        this.filters = ViewImpl.parseFilter(node);
        if (node.hasNonNull("dateTimeDefinition") && this.type != ViewType.TABLE) {
            JsonNode definition = node.get("dateTimeDefinition");
            this.dateIntervalSupported = definition.hasNonNull("dateSupported") ? definition.get("dateSupported").asBoolean() : false;
            this.timeIntervalSupported = definition.hasNonNull("timeSupported") ? definition.get("timeSupported").asBoolean() : false;
            this.dateInterval = ViewImpl.parseDateInterval(definition);
            this.timeInterval = ViewImpl.parseTimeInterval(definition);
        } else {
            this.dateIntervalSupported = false;
            this.timeIntervalSupported = false;
            this.dateInterval = null;
            this.timeInterval = null;
        }
        this.localization = new LocalizationImpl(node);
    }

    ViewImpl(BellaDatiServiceImpl service, BufferedImage image) throws UnknownViewTypeException {
        this.service = service;
        this.type = ViewType.IMAGE;
        this.id = "";
        this.name = "";
        this.dateIntervalSupported = false;
        this.timeIntervalSupported = false;
        this.dateInterval = null;
        this.timeInterval = null;
        this.filters = Collections.EMPTY_SET;
        this.localization = null;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getName(Locale locale) {
        return this.localization.getName(locale);
    }

    public boolean hasLocalization(Locale locale) {
        return this.localization.hasLocalization(locale);
    }

    public ViewType getType() {
        return this.type;
    }

    public Object loadContent(Filter<?> ... filters) {
        return this.service.loadViewContent(this.id, this.type, filters);
    }

    public Object loadContent(Collection<Filter<?>> filters) {
        return this.service.loadViewContent(this.id, this.type, filters);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ViewImpl) {
            return this.id.equals(((ViewImpl)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean hasPredefinedFilters() {
        return !this.filters.isEmpty();
    }

    public Set<Filter<?>> getPredefinedFilters() {
        return this.filters;
    }

    public boolean isDateIntervalSupported() {
        return this.dateIntervalSupported;
    }

    public boolean isTimeIntervalSupported() {
        return this.timeIntervalSupported;
    }

    public boolean hasPredefinedDateInterval() {
        return this.dateInterval != null;
    }

    public boolean hasPredefinedTimeInterval() {
        return this.timeInterval != null;
    }

    public Interval<DateUnit> getPredefinedDateInterval() {
        return this.dateInterval;
    }

    public Interval<TimeUnit> getPredefinedTimeInterval() {
        return this.timeInterval;
    }

    public ViewLoader createLoader() {
        return new ViewLoaderImpl(this.service, this.id, this.type);
    }

    static class UnknownViewTypeException
    extends Exception {
        private static final long serialVersionUID = -9179478821813868612L;

        public UnknownViewTypeException(String type) {
            super("Unknown view type: " + type);
        }
    }
}

