/*
 * Decompiled with CFR 0.152.
 */
package com.belladati.sdk.impl;

import com.belladati.sdk.exception.InternalConfigurationException;
import com.belladati.sdk.filter.Filter;
import com.belladati.sdk.impl.BellaDatiServiceImpl;
import com.belladati.sdk.impl.ImageViewImpl;
import com.belladati.sdk.impl.TableViewImpl;
import com.belladati.sdk.intervals.DateUnit;
import com.belladati.sdk.intervals.Interval;
import com.belladati.sdk.intervals.TimeUnit;
import com.belladati.sdk.view.ViewLoader;
import com.belladati.sdk.view.ViewType;
import com.fasterxml.jackson.databind.JsonNode;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.http.client.utils.URIBuilder;

public class ViewLoaderImpl
implements ViewLoader {
    private final BellaDatiServiceImpl service;
    private final String viewId;
    private final ViewType viewType;
    private final List<Filter<?>> filters = new ArrayList();
    private Interval<DateUnit> dateInterval;
    private Interval<TimeUnit> timeInterval;
    private Locale locale;

    public ViewLoaderImpl(BellaDatiServiceImpl service, String viewId, ViewType viewType) {
        this.service = service;
        this.viewId = viewId;
        this.viewType = viewType;
    }

    public String getId() {
        return this.viewId;
    }

    public ViewType getType() {
        return this.viewType;
    }

    public ViewLoader setDateInterval(Interval<DateUnit> dateInterval) {
        this.dateInterval = dateInterval;
        return this;
    }

    public ViewLoader setTimeInterval(Interval<TimeUnit> timeInterval) {
        this.timeInterval = timeInterval;
        return this;
    }

    public ViewLoader addFilters(Filter<?> ... filters) {
        return this.addFilters(Arrays.asList(filters));
    }

    public ViewLoader addFilters(Collection<Filter<?>> filters) {
        this.filters.addAll(filters);
        return this;
    }

    public ViewLoader setLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public Object loadContent() {
        try {
            URIBuilder builder = new URIBuilder("api/reports/views/" + this.viewId + "/" + this.viewType.getUri());
            if (this.viewType == ViewType.IMAGE) {
                return new ImageViewImpl.ImageImpl(this.viewId, (BufferedImage)this.service.loadImage(builder.build().toString()));
            }
            JsonNode json = this.service.loadJson(this.service.appendLocale(this.service.appendDateTime(this.service.appendFilter(builder, this.filters), this.dateInterval, this.timeInterval), this.locale).build().toString());
            if (this.viewType == ViewType.TABLE) {
                return new TableViewImpl.TableImpl(this.service, this.viewId, json, this.filters).setLocale(this.locale);
            }
            return json;
        }
        catch (URISyntaxException e) {
            throw new InternalConfigurationException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalConfigurationException((Throwable)e);
        }
    }
}

