package com.bettercloud.vault.api.pki;

import java.util.List;

/**
 * <p>A container for credential details returned endpoints on the PKI backend.  (see:
 * {@link Pki#issue(String, String, List, List, Integer, CredentialFormat)} Pki.issue }.
 * This class is meant for use with a builder pattern style.  Example usage:</p>
 *
 * <blockquote>
 * <pre>{@code
 * final Credential options = new Credential()
 *                              .certificate(...)
 *                              .issuingCa(...)
 *                              .privateKey(...)
 *                              .privateKeyType(...)
 *                              .serialNumber(...);
 * }</pre>
 * </blockquote>
 */
public class Credential {

    private String certificate;
    private String issuingCa;
    private String privateKey;
    private String privateKeyType;
    private String serialNumber;

    /**
     * A certificate, in PEM format
     *
     * @param certificate
     * @return
     */
    public Credential certificate(final String certificate) {
        this.certificate = certificate;
        return this;
    }

    /**
     * The issuing CA certificate, in PEM format
     *
     * @param issuingCa
     * @return
     */
    public Credential issuingCa(final String issuingCa) {
        this.issuingCa = issuingCa;
        return this;
    }

    /**
     * The private key, in PEM format
     *
     * @param privateKey
     * @return
     */
    public Credential privateKey(final String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    /**
     * The private key type (e.g. "rsa")
     *
     * @param privateKeyType
     * @return
     */
    public Credential privateKeyType(final String privateKeyType) {
        this.privateKeyType = privateKeyType;
        return this;
    }

    /**
     * An identifier generated by Vault
     *
     * @param serialNumber
     * @return
     */
    public Credential serialNumber(final String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    public String getCertificate() {
        return certificate;
    }

    public String getIssuingCa() {
        return issuingCa;
    }

    public String getPrivateKey() {
        return privateKey;
    }

    public String getPrivateKeyType() {
        return privateKeyType;
    }

    public String getSerialNumber() {
        return serialNumber;
    }
}
