/*
 * Decompiled with CFR 0.152.
 */
package com.bitso;

import com.bitso.exchange.BookOrder;
import com.bitso.exchange.OrderBook;
import com.bitso.helpers.Helpers;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class BitsoOrderBook
extends OrderBook {
    public BitsoOrderBook(JSONObject obj) {
        BigDecimal amount;
        BigDecimal price;
        int i;
        if (obj.has("timestamp")) {
            this.timestamp = obj.getLong("timestamp");
        } else {
            System.err.println("No timestamp: " + obj);
            Helpers.printStackTrace();
        }
        if (obj.has("bids")) {
            JSONArray bidsJSON = obj.getJSONArray("bids");
            this.bids = new ArrayList(bidsJSON.length());
            for (i = 0; i < bidsJSON.length(); ++i) {
                JSONArray bid = bidsJSON.getJSONArray(i);
                price = new BigDecimal(bid.getString(0));
                amount = new BigDecimal(bid.getString(1));
                this.bids.add(new BookOrder(price, amount, BookOrder.TYPE.BUY));
            }
        } else {
            System.err.println("No bids: " + obj);
            Helpers.printStackTrace();
        }
        if (obj.has("asks")) {
            JSONArray asksJSON = obj.getJSONArray("asks");
            this.asks = new ArrayList(asksJSON.length());
            for (i = 0; i < asksJSON.length(); ++i) {
                JSONArray ask = asksJSON.getJSONArray(i);
                price = new BigDecimal(ask.getString(0));
                amount = new BigDecimal(ask.getString(1));
                this.asks.add(new BookOrder(price, amount, BookOrder.TYPE.SELL));
            }
        } else {
            System.err.println("No asks: " + obj);
            Helpers.printStackTrace();
        }
    }
}

