/*
 * Decompiled with CFR 0.152.
 */
package com.bitso.websockets;

import com.bitso.websockets.Channels;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.WebsocketVersion;
import java.util.Observable;

public class BitsoWebSocket
extends Observable {
    Vertx vertx;
    String host = "ws.bitso.com";
    String uri = "";
    WebsocketVersion v = WebsocketVersion.V08;
    private Buffer textBuf = Buffer.buffer();
    Channels[] channels;
    HttpClient client;

    public BitsoWebSocket(Channels[] channels) {
        this.vertx = Vertx.vertx();
        this.channels = channels;
        HttpClientOptions httpOptions = new HttpClientOptions().setSsl(true);
        this.client = this.vertx.createHttpClient(httpOptions);
    }

    public void connect() {
        this.connectSocket();
    }

    public void disconnect() {
        this.client.close();
    }

    private void connectSocket() {
        this.client.websocket(443, this.host, this.uri, null, this.v, websocket -> {
            for (Channels chan : this.channels) {
                String message = "{ \"action\": \"subscribe\", \"book\": \"btc_mxn\", \"type\": \"" + chan.toString() + "\" }";
                websocket.writeFinalTextFrame(message);
            }
            websocket.closeHandler(vd -> {
                System.err.println("Websocket Error, Disonnected!");
                super.notifyObservers("disconnected");
            });
            websocket.frameHandler(frame -> {
                if (frame.isText()) {
                    this.textBuf.appendString(frame.textData());
                    if (frame.isFinal()) {
                        super.setChanged();
                        super.notifyObservers(this.textBuf.toString());
                        this.textBuf = Buffer.buffer();
                    }
                }
            });
        }, throwableError -> System.err.println("Websocket Error: " + throwableError.getMessage()));
    }
}

