/*
 * Decompiled with CFR 0.152.
 */
package com.bitso;

import com.bitso.BitsoBalance;
import com.bitso.BitsoBook;
import com.bitso.BitsoLookupOrders;
import com.bitso.BitsoOpenOrders;
import com.bitso.BitsoOrderBook;
import com.bitso.BitsoTicker;
import com.bitso.BitsoTransactions;
import com.bitso.BitsoTransfer;
import com.bitso.BitsoTransferQuote;
import com.bitso.BitsoUserTransactions;
import com.bitso.exchange.BookOrder;
import com.bitso.exchange.OrderBook;
import com.bitso.helpers.Helpers;
import com.bitso.http.BlockingHttpClient;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Bitso {
    private static final String BITSO_BASE_URL_PRODUCTION = "https://api.bitso.com/v2/";
    private static final String BITSO_BASE_URL_DEV = "https://dev.bitso.com/api/v2/";
    public static long THROTTLE_MS = 1000L;
    private String key;
    private String secret;
    private String clientId;
    private int retries;
    private boolean log;
    private String baseUrl;
    private BlockingHttpClient client = new BlockingHttpClient(false, THROTTLE_MS);

    public Bitso(String key, String secret, String clientId) {
        this(key, secret, clientId, 0);
    }

    public Bitso(String key, String secret, String clientId, int retries) {
        this(key, secret, clientId, retries, true);
    }

    public Bitso(String key, String secret, String clientId, int retries, boolean log) {
        this(key, secret, clientId, retries, log, true);
    }

    public Bitso(String key, String secret, String clientId, int retries, boolean log, boolean production) {
        this.key = key;
        this.secret = secret;
        this.clientId = clientId;
        this.retries = retries;
        this.log = log;
        this.baseUrl = production ? BITSO_BASE_URL_PRODUCTION : BITSO_BASE_URL_DEV;
    }

    public void setLog(boolean log) {
        this.log = log;
    }

    private void logError(String error) {
        if (this.log) {
            System.err.println(error);
        }
    }

    private void log(String msg) {
        if (this.log) {
            System.out.println(msg);
        }
    }

    public BitsoTicker getTicker() {
        return this.getTicker(BitsoBook.BTC_MXN);
    }

    public BitsoTicker getTicker(BitsoBook book) {
        String json = this.sendGet(this.baseUrl + "ticker?book=" + book.toString());
        JSONObject o = Helpers.parseJson(json);
        if (o == null || o.has("error")) {
            this.logError("Unable to get Bitso Ticker: " + json);
            return null;
        }
        return new BitsoTicker(o);
    }

    public OrderBook getOrderBook() {
        return this.getOrderBook(BitsoBook.BTC_MXN);
    }

    public OrderBook getOrderBook(BitsoBook book) {
        String json = this.sendGet(this.baseUrl + "order_book?book=" + book.toString());
        JSONObject o = Helpers.parseJson(json);
        if (o == null) {
            this.logError("Unable to get Bitso Order Book");
            return null;
        }
        return new BitsoOrderBook(o);
    }

    public BitsoTransactions getTransactions() {
        return this.getTransactions(BitsoBook.BTC_MXN);
    }

    public BitsoTransactions getTransactions(BitsoBook book) {
        String json = this.sendGet(this.baseUrl + "transactions?book=" + book.toString());
        JSONArray a = Helpers.parseJsonArray(json);
        if (a == null) {
            this.logError("Unable to get Bitso Transactions");
            return null;
        }
        return new BitsoTransactions(a);
    }

    public BitsoBalance getBalance() {
        String json = this.sendBitsoPost(this.baseUrl + "balance");
        JSONObject o = Helpers.parseJson(json);
        if (o == null || o.has("error")) {
            this.logError("Error getting Bitso Balance: " + json);
            return null;
        }
        return new BitsoBalance(o);
    }

    public BitsoUserTransactions getUserTransactions() {
        return this.getUserTransactions(BitsoBook.BTC_MXN);
    }

    public BitsoUserTransactions getUserTransactions(BitsoBook book) {
        return this.getUserTransactions(0, 0, null, book);
    }

    public BitsoUserTransactions getUserTransactions(int offset, int limit, BitsoUserTransactions.SORT_ORDER sortOrder) {
        return this.getUserTransactions(offset, limit, sortOrder, BitsoBook.BTC_MXN);
    }

    public BitsoUserTransactions getUserTransactions(int offset, int limit, BitsoUserTransactions.SORT_ORDER sortOrder, BitsoBook book) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (offset > 0) {
            body.put("offset", offset);
        }
        if (limit > 0) {
            body.put("limit", limit);
        }
        if (sortOrder != null) {
            body.put("sort", sortOrder.getOrder());
        }
        body.put("book", book.toString());
        String json = this.sendBitsoPost(this.baseUrl + "user_transactions", body);
        JSONArray a = Helpers.parseJsonArray(json);
        if (a == null) {
            this.logError("Unable to get User Transactions: " + json);
            return null;
        }
        return new BitsoUserTransactions(a, book);
    }

    public BitsoOpenOrders getOpenOrders() {
        return this.getOpenOrders(BitsoBook.BTC_MXN);
    }

    public BitsoOpenOrders getOpenOrders(BitsoBook book) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("book", book.toString());
        String json = this.sendBitsoPost(this.baseUrl + "open_orders", body);
        JSONArray a = Helpers.parseJsonArray(json);
        if (a == null) {
            this.logError("Unable to get Open Orders: " + json);
            return null;
        }
        return new BitsoOpenOrders(a, book);
    }

    @Deprecated
    public BitsoLookupOrders getLookupOrders(String orderId) {
        return this.lookupOrder(orderId);
    }

    public BitsoLookupOrders lookupOrder(String orderId) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("id", orderId);
        String json = this.sendBitsoPost(this.baseUrl + "lookup_order", body);
        JSONArray a = Helpers.parseJsonArray(json);
        if (a == null) {
            this.logError("Unable to get Lookup Order" + json);
            return null;
        }
        return new BitsoLookupOrders(a);
    }

    public boolean cancelOrder(String orderId) {
        this.log("Attempting to cancel order: " + orderId);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("id", orderId);
        String ret = this.sendBitsoPost(this.baseUrl + "cancel_order", body);
        if (ret != null && ret.equals("\"true\"")) {
            this.log("Cancelled Order: " + orderId);
            return true;
        }
        this.logError("Unable to cancel order: " + orderId);
        this.logError(ret);
        return false;
    }

    public BookOrder placeBuyLimitOrder(BigDecimal price, BigDecimal amount) {
        return this.placeBuyLimitOrder(price, amount, BitsoBook.BTC_MXN);
    }

    public BookOrder placeBuyLimitOrder(BigDecimal price, BigDecimal amount, BitsoBook book) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("amount", amount.toPlainString());
        body.put("price", price.toPlainString());
        body.put("book", book.toString());
        this.log("Placing the following buy limit order: " + body);
        String json = this.sendBitsoPost(this.baseUrl + "buy", body);
        return Bitso.processBookOrderJSON(json);
    }

    public BigDecimal placeBuyMarketOrder(BigDecimal mxnAmountToSpend) {
        return this.placeBuyMarketOrder(mxnAmountToSpend, BitsoBook.BTC_MXN);
    }

    public BigDecimal placeBuyMarketOrder(BigDecimal minorToSpend, BitsoBook book) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("amount", minorToSpend.toPlainString());
        body.put("book", book.toString());
        this.log("Placing the following buy maket order: " + body);
        String json = this.sendBitsoPost(this.baseUrl + "buy", body);
        JSONObject o = Helpers.parseJson(json);
        if (o == null || o.has("error")) {
            this.logError("Unable to place Buy Market Order: " + json);
            return null;
        }
        BookOrder order = this.findMatchingOrders(o);
        if (order != null) {
            return order.major;
        }
        return null;
    }

    public BookOrder placeSellLimitOrder(BigDecimal price, BigDecimal amount) {
        return this.placeSellLimitOrder(price, amount, BitsoBook.BTC_MXN);
    }

    public BookOrder placeSellLimitOrder(BigDecimal price, BigDecimal amount, BitsoBook book) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("amount", amount.toPlainString());
        body.put("price", price.toPlainString());
        body.put("book", book.toString());
        this.log("Placing the following sell limit order: " + body);
        String json = this.sendBitsoPost(this.baseUrl + "sell", body);
        return Bitso.processBookOrderJSON(json);
    }

    public BigDecimal placeSellMarketOrder(BigDecimal btcAmountToSpend) {
        return this.placeSellMarketOrder(btcAmountToSpend, BitsoBook.BTC_MXN);
    }

    public BigDecimal placeSellMarketOrder(BigDecimal majorToSpend, BitsoBook book) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("amount", majorToSpend.toPlainString());
        body.put("book", book.toString());
        this.log("Placing the following sell market order: " + body);
        String json = this.sendBitsoPost(this.baseUrl + "sell", body);
        JSONObject o = Helpers.parseJson(json);
        if (o == null || o.has("error")) {
            this.logError("Unable to place Sell Market Order: " + json);
            return null;
        }
        BookOrder order = this.findMatchingOrders(o);
        if (order != null) {
            return order.minor;
        }
        return null;
    }

    public String getDepositAddress() {
        return this.quoteEliminator(this.sendBitsoPost(this.baseUrl + "bitcoin_deposit_address"));
    }

    public boolean withdrawETH(String address, BigDecimal amount) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("amount", amount.toPlainString());
        body.put("address", address);
        this.log("Executing the following ETH withdrawal: " + body);
        String ret = this.sendBitsoPost(this.baseUrl + "ether_withdrawal", body);
        if (ret != null && ret.equals("\"ok\"")) {
            this.log("ETH withdrawal executed");
            return true;
        }
        this.logError("Unable to execute ETH withdrawal");
        this.logError(ret);
        return false;
    }

    public boolean withdrawBTC(String address, BigDecimal amount) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("amount", amount.toPlainString());
        body.put("address", address);
        this.log("Executing the following BTC withdrawal: " + body);
        String ret = this.sendBitsoPost(this.baseUrl + "bitcoin_withdrawal", body);
        if (ret != null && ret.equals("\"ok\"")) {
            this.log("BTC withdrawal executed");
            return true;
        }
        this.logError("Unable to execute BTC withdrawal");
        this.logError(ret);
        return false;
    }

    public boolean speiWithdrawal(BigDecimal amount, String recipientGivenName, String recipientFamilyName, String clabe, String notesRef, String numericRef) {
        if (amount.scale() > 2) {
            this.logError("Spei withdrawal has incorrect scale " + amount);
            return false;
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("amount", amount.toPlainString());
        body.put("recipient_given_names", recipientGivenName);
        body.put("recipient_family_names", recipientFamilyName);
        body.put("clabe", clabe);
        body.put("notes_ref", notesRef);
        body.put("numeric_ref", numericRef);
        this.log("Executing the following withdrawal: " + body);
        String ret = this.sendBitsoPost(this.baseUrl + "spei_withdrawal", body);
        if (ret != null && ret.equals("\"ok\"")) {
            this.log("Withdrawal executed");
            return true;
        }
        this.logError("Unable to execute MXN withdrawal");
        this.logError(ret);
        return false;
    }

    public String debitCardWithdrawal(BigDecimal amount, String institutionCode, String beneficiary, String cardNumber) {
        if (amount.scale() > 2) {
            this.logError("Debit Card withdrawal has incorrect scale " + amount);
            return null;
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("amount", amount.toPlainString());
        body.put("institution_code", institutionCode);
        body.put("beneficiary", beneficiary);
        body.put("card_number", cardNumber);
        this.log("Executing the following withdrawal: " + body);
        String json = this.sendBitsoPost("https://api.bitso.com/v3/debit_card_withdrawal", body);
        JSONObject o = Helpers.parseJson(json);
        if (o == null || o.has("error")) {
            this.logError("Unable to execute debit card withdrawal: " + json);
            return null;
        }
        if (o.has("claveRastreo")) {
            return o.getString("claveRastreo");
        }
        System.out.println("unknown debit card withdrawal result: " + json);
        return null;
    }

    public boolean withdrawMXN(BigDecimal amount, String recipientGivenName, String recipientFamilyName, String clabe, String notesRef, String numericRef) {
        return this.speiWithdrawal(amount, recipientGivenName, recipientFamilyName, clabe, notesRef, numericRef);
    }

    public BitsoTransferQuote requestQuote(BigDecimal btcAmount, BigDecimal amount, String currency, boolean full) {
        if (btcAmount != null && amount != null) {
            this.logError("btcAmount and amount are mutually exclusive!");
            return null;
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (btcAmount != null) {
            body.put("btc_amount", btcAmount.toPlainString());
        }
        if (amount != null) {
            body.put("amount", amount.toPlainString());
        }
        body.put("currency", currency);
        body.put("full", full);
        String ret = this.sendBitsoPost(this.baseUrl + "transfer_quote", body);
        JSONObject o = Helpers.parseJson(ret);
        if (o == null || o.has("error")) {
            this.logError("Unable to request quote: " + ret);
            return null;
        }
        BitsoTransferQuote btq = null;
        try {
            btq = new BitsoTransferQuote(o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.logError(ret);
        }
        return btq;
    }

    public BitsoTransfer createTransfer(BigDecimal btcAmount, BigDecimal amount, String currency, BigDecimal rate, String paymentOutlet, HashMap<String, Object> requiredFields) {
        String ret;
        JSONObject o;
        if (btcAmount != null && amount != null) {
            this.logError("btcAmount and amount are mutually exclusive!");
            return null;
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (btcAmount != null) {
            body.put("btc_amount", btcAmount.toPlainString());
        }
        if (amount != null) {
            body.put("amount", amount.toPlainString());
        }
        body.put("currency", currency);
        body.put("rate", rate.toPlainString());
        body.put("payment_outlet", paymentOutlet);
        if (requiredFields != null) {
            for (Map.Entry<String, Object> e : requiredFields.entrySet()) {
                body.put(e.getKey(), e.getValue());
            }
        }
        if ((o = Helpers.parseJson(ret = this.sendBitsoPost(this.baseUrl + "transfer_create", body))) == null || o.has("error")) {
            this.logError("Unable to request quote: " + ret);
            return null;
        }
        BitsoTransfer bt = null;
        try {
            bt = new BitsoTransfer(o);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.logError(ret);
        }
        return bt;
    }

    public BitsoTransfer getTransferStatus(String transferId) {
        String ret = this.sendGet(this.baseUrl + "transfer/" + transferId);
        JSONObject o = Helpers.parseJson(ret);
        if (o == null || o.has("error")) {
            this.logError("Unable to get transfer status: " + ret);
            return null;
        }
        return new BitsoTransfer(o);
    }

    private String quoteEliminator(String input) {
        if (input == null) {
            this.logError("input to quoteEliminator cannot be null");
            return null;
        }
        int length = input.length();
        if (input.charAt(0) != '\"' || input.charAt(length - 1) != '\"') {
            this.logError("invalid input to quoteEliminator: " + input);
            return null;
        }
        return input.substring(1, length - 1);
    }

    private static String signRequest(String secret, String inputStr) {
        String signature = "";
        byte[] secretBytes = secret.getBytes();
        SecretKeySpec localMac = new SecretKeySpec(secretBytes, "HmacSHA256");
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(localMac);
            byte[] arrayOfByte = mac.doFinal(inputStr.getBytes());
            BigInteger localBigInteger = new BigInteger(1, arrayOfByte);
            signature = String.format("%0" + (arrayOfByte.length << 1) + "x", localBigInteger);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        return signature;
    }

    private String sendBitsoPost(String url, HashMap<String, Object> bodyExtras) {
        long nonce = System.currentTimeMillis();
        String message = nonce + this.key + this.clientId;
        String signature = Bitso.signRequest(this.secret, message);
        JSONObject json = new JSONObject();
        json.put("key", (Object)this.key);
        json.put("nonce", nonce);
        json.put("signature", (Object)signature);
        if (bodyExtras != null) {
            for (Map.Entry<String, Object> e : bodyExtras.entrySet()) {
                json.put(e.getKey(), e.getValue());
            }
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        try {
            return this.client.sendPost(url, json.toString(), headers);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String sendBitsoPost(String url) {
        return this.sendBitsoPost(url, null);
    }

    private String sendGet(String url) {
        int counter = 0;
        String ret = null;
        while (counter++ <= this.retries) {
            try {
                ret = this.client.get(url);
                return ret;
            }
            catch (Exception e) {
                this.logError("Exception when sending get to: " + url);
                this.logError(e.getMessage());
                if (counter == this.retries) {
                    this.logError("Exceeded number of retries to get: " + url);
                    e.printStackTrace();
                    return null;
                }
                try {
                    Thread.sleep(2000 * counter);
                }
                catch (InterruptedException e2) {
                    this.logError("unable to sleep");
                    e2.printStackTrace();
                }
            }
        }
        return null;
    }

    public BookOrder findMatchingOrders(String id) {
        return this.findMatchingOrders(id, BitsoBook.BTC_MXN);
    }

    public BookOrder findMatchingOrders(String id, BitsoBook book) {
        BookOrder toRet = null;
        int offset = 0;
        int limit = 10;
        block0: while (true) {
            BitsoUserTransactions but;
            if ((but = this.getUserTransactions(offset, limit, null, book)) == null) {
                return null;
            }
            if (but.trades.size() == 0) {
                return null;
            }
            for (int i = 0; i < but.trades.size(); ++i) {
                BookOrder order = but.trades.get(i);
                if (order.id.equals(id)) {
                    if (toRet == null) {
                        toRet = order;
                        continue;
                    }
                    toRet.minor = toRet.minor.add(order.minor);
                    continue;
                }
                if (toRet != null && i < but.trades.size()) break block0;
            }
            offset += limit;
            limit *= 2;
        }
        return toRet;
    }

    public BookOrder findMatchingOrders(JSONObject o) {
        return this.findMatchingOrders(o, BitsoBook.BTC_MXN);
    }

    public BookOrder findMatchingOrders(JSONObject o, BitsoBook book) {
        BookOrder toRet = null;
        if (o.has("id")) {
            toRet = this.findMatchingOrders(o.getString("id"));
        }
        if (toRet == null) {
            this.logError("Unable to find order in recent transactions");
            Helpers.printStackTrace();
        }
        return toRet;
    }

    public static BookOrder processBookOrderJSON(String json) {
        JSONObject o = Helpers.parseJson(json);
        if (o == null || o.has("error")) {
            System.err.println("Unable to processBookOrderJSON: " + json);
            return null;
        }
        BigDecimal price = null;
        BigDecimal major = null;
        if (o.has("price")) {
            price = new BigDecimal(o.getString("price"));
        }
        if (o.has("amount")) {
            major = new BigDecimal(o.getString("amount"));
        }
        if (price == null || major == null) {
            return null;
        }
        BookOrder order = new BookOrder(price, major);
        if (o.has("id")) {
            order.id = o.getString("id");
        }
        if (o.has("book")) {
            order.book = o.getString("book");
        }
        if (o.has("type")) {
            order.type = BookOrder.TYPE.values()[o.getInt("type")];
        }
        if (o.has("status")) {
            int statusInt = o.getInt("status");
            if (statusInt == -1) {
                statusInt = 3;
            }
            order.status = BookOrder.STATUS.values()[statusInt];
        }
        if (o.has("created")) {
            order.created = o.getString("created");
        }
        if (o.has("updated")) {
            order.updated = o.getString("updated");
        }
        if (o.has("datetime")) {
            order.dateTime = o.getString("datetime");
        }
        return order;
    }
}

