/*
 * Decompiled with CFR 0.152.
 */
package com.bitso;

import com.bitso.exceptions.BitsoExceptionJSONPayload;
import com.bitso.helpers.Helpers;
import java.math.BigDecimal;
import org.json.JSONArray;
import org.json.JSONObject;

public class BitsoBalance {
    public BigDecimal mxnTotal;
    public BigDecimal ethTotal;
    public BigDecimal btcTotal;
    public BigDecimal mxnLocked;
    public BigDecimal ethLocked;
    public BigDecimal btcLocked;
    public BigDecimal mxnAvailable;
    public BigDecimal ethAvailable;
    public BigDecimal btcAvailable;

    public BitsoBalance(JSONObject o) {
        String currency = "";
        if (o.has("payload")) {
            JSONObject payload = o.getJSONObject("payload");
            JSONArray jsonBalances = payload.getJSONArray("balances");
            int totalElements = jsonBalances.length();
            block10: for (int i = 0; i < totalElements; ++i) {
                JSONObject balance = jsonBalances.getJSONObject(i);
                switch (currency = Helpers.getString(balance, "currency")) {
                    case "mxn": {
                        this.mxnTotal = Helpers.getBD(balance, "total");
                        this.mxnLocked = Helpers.getBD(balance, "locked");
                        this.mxnAvailable = Helpers.getBD(balance, "available");
                        continue block10;
                    }
                    case "btc": {
                        this.btcTotal = Helpers.getBD(balance, "total");
                        this.btcLocked = Helpers.getBD(balance, "locked");
                        this.btcAvailable = Helpers.getBD(balance, "available");
                        continue block10;
                    }
                    case "eth": {
                        this.ethTotal = Helpers.getBD(balance, "total");
                        this.ethLocked = Helpers.getBD(balance, "locked");
                        this.ethAvailable = Helpers.getBD(balance, "available");
                        continue block10;
                    }
                    default: {
                        System.out.println(currency + " is not an expected currency");
                    }
                }
            }
        } else {
            throw new BitsoExceptionJSONPayload(o.toString() + "does not contains payload key");
        }
    }

    public String toString() {
        return Helpers.fieldPrinter(this);
    }
}

