/*
 * Decompiled with CFR 0.152.
 */
package com.bitso;

import com.bitso.BitsoBook;
import com.bitso.exceptions.BitsoExceptionNotExpectedValue;
import com.bitso.helpers.Helpers;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import org.json.JSONObject;

public class BitsoOrder {
    public BitsoBook book;
    public BigDecimal originalAmount;
    public BigDecimal unfilledAmount;
    public BigDecimal originalValue;
    public ZonedDateTime orderDate;
    public ZonedDateTime updateDate;
    public BigDecimal price;
    public String oid;
    public SIDE side;
    public STATUS status;
    public TYPE type;

    public static BitsoBook getBook(String book) {
        switch (book) {
            case "btc_mxn": {
                return BitsoBook.BTC_MXN;
            }
            case "eth_mxn": {
                return BitsoBook.ETH_MXN;
            }
        }
        String exceptionMessage = book + "is not a supported book";
        throw new BitsoExceptionNotExpectedValue(exceptionMessage);
    }

    public BitsoOrder(JSONObject o) {
        this.book = BitsoOrder.getBook(Helpers.getString(o, "book"));
        this.originalAmount = Helpers.getBD(o, "original_amount");
        this.unfilledAmount = Helpers.getBD(o, "unfilled_amount");
        this.originalValue = Helpers.getBD(o, "original_value");
        this.orderDate = Helpers.getZonedDatetime(o, "created_at");
        this.updateDate = Helpers.getZonedDatetime(o, "updated_at");
        this.price = Helpers.getBD(o, "price");
        this.oid = Helpers.getString(o, "oid");
        this.side = this.getSide(Helpers.getString(o, "side"));
        this.status = this.getStatus(Helpers.getString(o, "status"));
        this.type = this.getType(Helpers.getString(o, "type"));
    }

    public SIDE getSide(String side) {
        if (side.equals("buy")) {
            return SIDE.BUY;
        }
        return SIDE.SELL;
    }

    public STATUS getStatus(String status) {
        switch (status) {
            case "open": {
                return STATUS.OPEN;
            }
            case "partially filled": {
                return STATUS.PARTIALLY_FILLED;
            }
            case "completed": {
                return STATUS.COMPLETED;
            }
            case "cancelled": {
                return STATUS.CANCELLED;
            }
        }
        String exceptionMessage = status + "is not a supported order status";
        throw new BitsoExceptionNotExpectedValue(exceptionMessage);
    }

    public TYPE getType(String type) {
        switch (type) {
            case "limit": {
                return TYPE.LIMIT;
            }
            case "market": {
                return TYPE.MARKET;
            }
        }
        String exceptionMessage = type + "is not a supported order type";
        throw new BitsoExceptionNotExpectedValue(exceptionMessage);
    }

    public String toString() {
        return Helpers.fieldPrinter(this);
    }

    public static enum TYPE {
        MARKET,
        LIMIT;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum STATUS {
        OPEN,
        PARTIALLY_FILLED,
        COMPLETED,
        CANCELLED;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum SIDE {
        BUY,
        SELL;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

