/*
 * Decompiled with CFR 0.152.
 */
package com.bitso;

import com.bitso.BitsoBook;
import com.bitso.BitsoOrder;
import com.bitso.helpers.Helpers;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import org.json.JSONArray;
import org.json.JSONObject;

public class BitsoOrderBook {
    public ZonedDateTime orderDate;
    public String sequence;
    public PulicOrder[] asks;
    public PulicOrder[] bids;

    public BitsoOrderBook(JSONObject o) {
        this.orderDate = Helpers.getZonedDatetime(o, "updated_at");
        this.sequence = Helpers.getString(o, "sequence");
        this.processOrders(o);
    }

    private void processOrders(JSONObject o) {
        int i;
        if (o.has("asks")) {
            JSONArray asksArray = o.getJSONArray("asks");
            int totalAsks = asksArray.length();
            this.asks = new PulicOrder[totalAsks];
            for (i = 0; i < totalAsks; ++i) {
                this.asks[i] = new PulicOrder(asksArray.getJSONObject(i));
            }
        }
        if (o.has("bids")) {
            JSONArray bidsArray = o.getJSONArray("bids");
            int totalBids = bidsArray.length();
            this.bids = new PulicOrder[totalBids];
            for (i = 0; i < totalBids; ++i) {
                this.bids[i] = new PulicOrder(bidsArray.getJSONObject(i));
            }
        }
    }

    public String toString() {
        return Helpers.fieldPrinter(this);
    }

    public class PulicOrder {
        public BitsoBook book;
        public BigDecimal price;
        public BigDecimal amount;

        public PulicOrder(JSONObject o) {
            this.book = BitsoOrder.getBook(Helpers.getString(o, "book"));
            this.price = Helpers.getBD(o, "price");
            this.amount = Helpers.getBD(o, "amount");
        }

        public String toString() {
            return Helpers.fieldPrinter(this);
        }
    }
}

