/*
 * Decompiled with CFR 0.152.
 */
package com.bitso.examples;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.math.BigInteger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONObject;

public class BitsoJavaExample {
    public static void main(String[] args) throws Exception {
        String inputLine;
        String bitsoKey = "";
        String bitsoSecret = "";
        String bitsoClientId = "";
        long nonce = System.currentTimeMillis();
        String message = nonce + bitsoKey + bitsoClientId;
        String signature = "";
        byte[] secretBytes = bitsoSecret.getBytes();
        SecretKeySpec localMac = new SecretKeySpec(secretBytes, "HmacSHA256");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(localMac);
        byte[] arrayOfByte = mac.doFinal(message.getBytes());
        BigInteger localBigInteger = new BigInteger(1, arrayOfByte);
        signature = String.format("%0" + (arrayOfByte.length << 1) + "x", localBigInteger);
        JSONObject o = new JSONObject();
        o.put("key", (Object)bitsoKey);
        o.put("nonce", nonce);
        o.put("signature", (Object)signature);
        String body = o.toString();
        String url = "https://api.bitso.com/v2/balance";
        HttpPost postRequest = new HttpPost(url);
        postRequest.addHeader("Content-Type", "application/json");
        postRequest.setEntity((HttpEntity)new StringEntity(body));
        CloseableHttpResponse response = HttpClients.createDefault().execute((HttpUriRequest)postRequest);
        BufferedReader in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        StringBuffer responseBody = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            responseBody.append(inputLine);
        }
        in.close();
        System.out.println(responseBody.toString());
    }
}

