/*
 * Decompiled with CFR 0.152.
 */
package com.bitso.examples;

import com.bitso.Bitso;
import com.bitso.BitsoBook;
import com.bitso.BitsoOrder;
import com.bitso.BitsoOrderBook;
import com.bitso.helpers.Helpers;
import com.bitso.websockets.BitsoChannels;
import com.bitso.websockets.BitsoStreamDiffOrders;
import com.bitso.websockets.BitsoWebSocket;
import com.bitso.websockets.BitsoWebSocketObserver;
import com.bitso.websockets.BitsoWebSocketPublicOrder;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import javax.net.ssl.SSLException;
import org.json.JSONObject;

public class BitsoWebSocketExample
extends BitsoWebSocketObserver {
    private Operation mBids = new Operation();
    private Operation mAsks = new Operation();
    private BitsoOrderBook mLiveOrderBook;
    private Bitso mBitso;
    private int mCurrentSequenceNumber = 0;
    private int mExpectedNewSequenceNumber = 0;
    private boolean mCorrectSequenceNumber = Boolean.FALSE;
    private boolean mOrderBookObtained = Boolean.FALSE;

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof String) {
            String messageReceived = (String)arg;
            JSONObject jsonObject = new JSONObject(messageReceived);
            if (jsonObject.has("action") || Helpers.getString(jsonObject, "type").equals("ka")) {
                return;
            }
            BitsoStreamDiffOrders bitsoStreamDiffOrders = new BitsoStreamDiffOrders(jsonObject);
            if (this.mOrderBookObtained) {
                this.mExpectedNewSequenceNumber = this.mCurrentSequenceNumber + 1;
                boolean bl = this.mCorrectSequenceNumber = bitsoStreamDiffOrders.getSequenceNumber() == this.mExpectedNewSequenceNumber;
                if (this.mCorrectSequenceNumber) {
                    this.mergeOrders(bitsoStreamDiffOrders);
                    ++this.mCurrentSequenceNumber;
                    this.printUpdate(bitsoStreamDiffOrders);
                } else {
                    this.getInitialOrderBook();
                }
            } else {
                this.mergeOrders(bitsoStreamDiffOrders);
                this.printUpdate(bitsoStreamDiffOrders);
            }
        }
        if (arg instanceof Boolean) {
            this.mWSConnected = (Boolean)arg;
            if (this.mWSConnected.booleanValue()) {
                System.out.println("Web socket is now connected");
            } else {
                System.out.println("Web socket is now disconnected");
            }
        }
    }

    public void printUpdate(BitsoStreamDiffOrders diff) {
        System.out.println(diff);
        System.out.println("Best ask: " + this.mAsks.getMinPrice());
        System.out.println("Best bid: " + this.mBids.getMaxPrice());
    }

    public void mergeOrders(BitsoStreamDiffOrders bitsoStreamDiffOrders) {
        BitsoWebSocketPublicOrder[] orders;
        int streamSequenceNumber = bitsoStreamDiffOrders.getSequenceNumber();
        for (BitsoWebSocketPublicOrder bitsoWebSocketPublicOrder : orders = bitsoStreamDiffOrders.getPayload()) {
            Operation streamUpdateOperation = bitsoWebSocketPublicOrder.getSide() == BitsoOrder.SIDE.BUY ? this.mBids : this.mAsks;
            BigDecimal currentPrice = bitsoWebSocketPublicOrder.getRate();
            BigDecimal currentAmount = bitsoWebSocketPublicOrder.getAmount();
            String currentOrderId = bitsoWebSocketPublicOrder.getOrderId();
            if (currentAmount.compareTo(new BigDecimal("0")) == 0) {
                streamUpdateOperation.removeOrder(currentOrderId);
                return;
            }
            OrderUpdate orderUpdate = new OrderUpdate(currentOrderId, currentPrice, currentAmount, streamSequenceNumber);
            streamUpdateOperation.manageOrder(currentOrderId, orderUpdate);
        }
    }

    public void getInitialOrderBook() {
        if (this.mBitso == null) {
            this.mBitso = new Bitso("", "", 0, Boolean.TRUE, Boolean.TRUE);
        }
        this.mLiveOrderBook = this.mBitso.getOrderBook(BitsoBook.BTC_MXN, Boolean.FALSE);
        this.mCurrentSequenceNumber = this.mLiveOrderBook.sequence;
        this.mOrderBookObtained = Boolean.TRUE;
        for (BitsoOrderBook.PulicOrder publicOrder : this.mLiveOrderBook.asks) {
            this.mAsks.manageOrder(publicOrder.mOrderId, new OrderUpdate(publicOrder.mOrderId, publicOrder.mPrice, publicOrder.mAmount, this.mCurrentSequenceNumber));
        }
        for (BitsoOrderBook.PulicOrder publicOrder : this.mLiveOrderBook.bids) {
            this.mBids.manageOrder(publicOrder.mOrderId, new OrderUpdate(publicOrder.mOrderId, publicOrder.mPrice, publicOrder.mAmount, this.mCurrentSequenceNumber));
        }
        this.mAsks.updateMaxMin(this.mCurrentSequenceNumber);
        this.mBids.updateMaxMin(this.mCurrentSequenceNumber);
        System.out.println("Best ask: " + this.mAsks.getMinPrice());
        System.out.println("Best bid: " + this.mBids.getMaxPrice());
    }

    public static void main(String[] args) throws SSLException, URISyntaxException, InterruptedException {
        BitsoChannels[] bitsoChannels = new BitsoChannels[]{BitsoChannels.DIFF_ORDERS};
        BitsoWebSocket bitsoWebSocket = new BitsoWebSocket();
        BitsoWebSocketExample bitsoWebSocketExample = new BitsoWebSocketExample();
        bitsoWebSocket.addObserver(bitsoWebSocketExample);
        bitsoWebSocket.openConnection();
        for (BitsoChannels bitsoChannel : bitsoChannels) {
            bitsoWebSocket.subscribeBitsoChannel(bitsoChannel.toString());
        }
        bitsoWebSocketExample.getInitialOrderBook();
        Thread.sleep(50000L);
        bitsoWebSocket.closeConnection();
    }

    public class OrderUpdate {
        private String mOrderId;
        private BigDecimal mPrice;
        private BigDecimal mAmount;
        private int mSequence;

        public OrderUpdate(String orderId, BigDecimal price, BigDecimal amount, int sequence) {
            this.mOrderId = orderId;
            this.mPrice = price;
            this.mAmount = amount;
            this.mSequence = sequence;
        }

        public OrderUpdate(String orderId, BigDecimal price, BigDecimal amount) {
            this.mOrderId = orderId;
            this.mPrice = price;
            this.mAmount = amount;
            this.mSequence = -1;
        }

        public int getSequence() {
            return this.mSequence;
        }

        public BigDecimal getPrice() {
            return this.mPrice;
        }

        public BigDecimal getAmount() {
            return this.mAmount;
        }

        public String getOrderId() {
            return this.mOrderId;
        }
    }

    public class Operation {
        private HashMap<String, OrderUpdate> mOrderUpdatesMap = new HashMap();
        private BigDecimal mMinPrice = new BigDecimal(0);
        private BigDecimal mMaxPrice = new BigDecimal(0);

        public void manageOrder(String orderId, OrderUpdate orderUpdate) {
            this.mOrderUpdatesMap.put(orderId, orderUpdate);
            this.updateMaxMin();
        }

        public void removeOrder(String orderId) {
            if (this.mOrderUpdatesMap.containsKey(orderId)) {
                BigDecimal price = this.mOrderUpdatesMap.get(orderId).getPrice();
                this.mOrderUpdatesMap.remove(orderId);
                if (this.mMinPrice.compareTo(price) == 0 || this.mMaxPrice.compareTo(price) == 0) {
                    this.updateMaxMin();
                }
            }
        }

        public boolean orderExists(String orderId) {
            return this.mOrderUpdatesMap.containsKey(orderId);
        }

        public void updateMaxMin() {
            ArrayList<BigDecimal> publicOrders = this.getSortedOrders();
            if (publicOrders.size() > 0) {
                this.mMinPrice = publicOrders.get(0);
                this.mMaxPrice = publicOrders.get(publicOrders.size() - 1);
            }
        }

        public void updateMaxMin(int sequence) {
            ArrayList<BigDecimal> publicOrders = this.getSortedOrders(sequence);
            if (publicOrders.size() > 0) {
                this.mMinPrice = publicOrders.get(0);
                this.mMaxPrice = publicOrders.get(publicOrders.size() - 1);
            }
        }

        public ArrayList<BigDecimal> getSortedOrders() {
            ArrayList<BigDecimal> prices = new ArrayList<BigDecimal>();
            for (Map.Entry<String, OrderUpdate> entry : this.mOrderUpdatesMap.entrySet()) {
                prices.add(entry.getValue().getPrice());
            }
            Collections.sort(prices);
            return prices;
        }

        public ArrayList<BigDecimal> getSortedOrders(int sequence) {
            ArrayList<BigDecimal> prices = new ArrayList<BigDecimal>();
            ArrayList<String> removableOrders = new ArrayList<String>();
            for (Map.Entry<String, OrderUpdate> entry : this.mOrderUpdatesMap.entrySet()) {
                if (entry.getValue().getSequence() > sequence) {
                    prices.add(entry.getValue().getPrice());
                    continue;
                }
                removableOrders.add(entry.getKey());
            }
            for (String orderId : removableOrders) {
                this.mOrderUpdatesMap.remove(orderId);
            }
            Collections.sort(prices);
            return prices;
        }

        public BigDecimal getMinPrice() {
            return this.mMinPrice;
        }

        public BigDecimal getMaxPrice() {
            return this.mMaxPrice;
        }
    }
}

