/*
 * Decompiled with CFR 0.152.
 */
package com.bitso.websockets;

import com.bitso.websockets.BitsoStreamUpdate;
import com.bitso.websockets.BitsoWebSocketPublicOrder;
import org.json.JSONArray;
import org.json.JSONObject;

public class BitsoStreamOrders
extends BitsoStreamUpdate {
    protected BitsoWebSocketPublicOrder[] mBids;
    protected BitsoWebSocketPublicOrder[] mAsks;

    public BitsoStreamOrders(JSONObject jsonObject) {
        super(jsonObject);
        this.processPayload(jsonObject.getJSONObject("payload"));
    }

    public BitsoWebSocketPublicOrder[] getmBids() {
        return this.mBids;
    }

    public BitsoWebSocketPublicOrder[] getmAsks() {
        return this.mAsks;
    }

    private void processPayload(JSONObject jsonObject) {
        JSONArray jsonArrayBids = jsonObject.getJSONArray("bids");
        int totalBids = jsonArrayBids.length();
        this.mBids = new BitsoWebSocketPublicOrder[totalBids];
        this.processBids(jsonArrayBids, totalBids);
        JSONArray jsonArrayAsks = jsonObject.getJSONArray("asks");
        int totalAsks = jsonArrayAsks.length();
        this.mAsks = new BitsoWebSocketPublicOrder[totalAsks];
        this.processAsks(jsonArrayAsks, totalAsks);
    }

    private void processBids(JSONArray jsonArray, int totalElements) {
        for (int i = 0; i < totalElements; ++i) {
            this.mBids[i] = new BitsoWebSocketPublicOrder(jsonArray.getJSONObject(i));
        }
    }

    private void processAsks(JSONArray jsonArray, int totalElements) {
        for (int i = 0; i < totalElements; ++i) {
            this.mAsks[i] = new BitsoWebSocketPublicOrder(jsonArray.getJSONObject(i));
        }
    }

    public boolean attributesNotNull() {
        return this.bitsoChannel != null && this.bitsoBook != null && this.payloadNotNull();
    }

    protected boolean payloadNotNull() {
        for (BitsoWebSocketPublicOrder diffPayload : this.mBids) {
            if (diffPayload.getOrderDate() != null && diffPayload.getRate() != null && diffPayload.getSide() != null && diffPayload.getAmount() != null && diffPayload.getValue() != null) continue;
            return false;
        }
        for (BitsoWebSocketPublicOrder diffPayload : this.mAsks) {
            if (diffPayload.getOrderDate() != null && diffPayload.getRate() != null && diffPayload.getSide() != null && diffPayload.getAmount() != null && diffPayload.getValue() != null) continue;
            return false;
        }
        return true;
    }
}

