/*
 * Decompiled with CFR 0.152.
 */
package com.bitso.websockets;

import com.bitso.exceptions.BitsoWebSocketExeption;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.CharsetUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Observable;
import javax.net.ssl.SSLException;

public class BitsoWebSocket
extends Observable {
    private final String URL = "wss://ws.bitso.com";
    private final int PORT = 443;
    private URI mUri = new URI("wss://ws.bitso.com");
    private SslContext mSslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
    private Channel mChannel;
    private EventLoopGroup mGroup = new NioEventLoopGroup();
    private String mMessageReceived = "";
    private Boolean mConnected = Boolean.FALSE;

    public void setConnected(Boolean connected) {
        this.mConnected = connected;
        this.setChanged();
        this.notifyObservers(this.mConnected);
    }

    public void setMessageReceived(String messageReceived) {
        this.mMessageReceived = messageReceived;
        this.setChanged();
        this.notifyObservers(this.mMessageReceived);
    }

    public void openConnection() throws InterruptedException {
        Bootstrap bootstrap = new Bootstrap();
        final WebSocketClientHandler handler = new WebSocketClientHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)this.mUri, (WebSocketVersion)WebSocketVersion.V08, null, (boolean)false, (HttpHeaders)new DefaultHttpHeaders()));
        ((Bootstrap)((Bootstrap)bootstrap.group(this.mGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel socketChannel) {
                ChannelPipeline channelPipeline = socketChannel.pipeline();
                channelPipeline.addLast(new ChannelHandler[]{BitsoWebSocket.this.mSslContext.newHandler(socketChannel.alloc(), BitsoWebSocket.this.mUri.getHost(), 443)});
                channelPipeline.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), handler});
            }
        });
        this.mChannel = bootstrap.connect(this.mUri.getHost(), 443).sync().channel();
        handler.handshakeFuture().sync();
        this.setConnected(Boolean.TRUE);
    }

    public void subscribeBitsoChannel(String channel) {
        if (!this.mConnected.booleanValue()) {
            String message = "Subscription to any channel is not possible while web socket is not connected";
            throw new BitsoWebSocketExeption(message);
        }
        String frameMessage = "{ \"action\": \"subscribe\", \"book\": \"btc_mxn\", \"type\": \"" + channel + "\" }";
        this.mChannel.writeAndFlush((Object)new TextWebSocketFrame(frameMessage));
    }

    public void closeConnection() throws InterruptedException {
        this.mChannel.writeAndFlush((Object)new CloseWebSocketFrame());
        this.mChannel.closeFuture().sync();
        this.mGroup.shutdownGracefully();
    }

    public class WebSocketClientHandler
    extends ChannelInboundHandlerAdapter {
        private final WebSocketClientHandshaker mHandshaker;
        private ChannelPromise mHandshakeFuture;

        public WebSocketClientHandler(WebSocketClientHandshaker handshaker) {
            this.mHandshaker = handshaker;
        }

        public ChannelFuture handshakeFuture() {
            return this.mHandshakeFuture;
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            this.mHandshakeFuture = ctx.newPromise();
        }

        public void channelActive(ChannelHandlerContext ctx) {
            this.mHandshaker.handshake(ctx.channel());
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            Channel channel = ctx.channel();
            if (!this.mHandshaker.isHandshakeComplete()) {
                this.mHandshaker.finishHandshake(channel, (FullHttpResponse)msg);
                this.mHandshakeFuture.setSuccess();
                return;
            }
            if (msg instanceof FullHttpResponse) {
                FullHttpResponse response = (FullHttpResponse)msg;
                throw new Exception("Unexpected FullHttpResponse (getStatus=" + response.getStatus() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ')');
            }
            WebSocketFrame frame = (WebSocketFrame)msg;
            if (frame instanceof TextWebSocketFrame) {
                TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
                BitsoWebSocket.this.setMessageReceived(textFrame.text());
            }
            if (frame instanceof CloseWebSocketFrame) {
                BitsoWebSocket.this.setConnected(Boolean.FALSE);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            cause.printStackTrace();
            if (!this.mHandshakeFuture.isDone()) {
                this.mHandshakeFuture.setFailure(cause);
            }
            ctx.close();
        }
    }
}

