/*
 * Decompiled with CFR 0.152.
 */
package com.bitso.websockets;

import com.bitso.BitsoOrder;
import com.bitso.helpers.Helpers;
import java.math.BigDecimal;
import java.util.Date;
import org.json.JSONObject;

public class BitsoWebSocketPublicOrder {
    private Date mOrderDate;
    private BigDecimal mRate;
    private BitsoOrder.SIDE mSide;
    private BigDecimal mAmount;
    private BigDecimal mValue;
    private String mOrderId;

    public BitsoWebSocketPublicOrder(JSONObject jsonObject) {
        this.mOrderDate = new Date(jsonObject.getLong("d") * 1000L);
        this.mRate = new BigDecimal(String.valueOf(jsonObject.getDouble("r")));
        BitsoOrder.SIDE sIDE = this.mSide = Helpers.getInt(jsonObject, "t") == 1 ? BitsoOrder.SIDE.SELL : BitsoOrder.SIDE.BUY;
        if (jsonObject.has("a") && jsonObject.has("v")) {
            this.mAmount = new BigDecimal(String.valueOf(jsonObject.getDouble("a")));
            this.mValue = new BigDecimal(String.valueOf(jsonObject.getDouble("v")));
        } else {
            this.mAmount = new BigDecimal("0");
            this.mValue = new BigDecimal("0");
        }
        if (jsonObject.has("o")) {
            this.mOrderId = Helpers.getString(jsonObject, "o");
        }
    }

    public Date getOrderDate() {
        return this.mOrderDate;
    }

    public BigDecimal getRate() {
        return this.mRate;
    }

    public BitsoOrder.SIDE getSide() {
        return this.mSide;
    }

    public BigDecimal getAmount() {
        return this.mAmount;
    }

    public BigDecimal getValue() {
        return this.mValue;
    }

    public String getOrderId() {
        return this.mOrderId;
    }

    public String toString() {
        return "Rate:" + this.mRate + ", Side:" + (Object)((Object)this.mSide) + ", Amount:" + this.mAmount + ", Value:" + this.mValue;
    }
}

