/*
 * Copyright 2023 Squircle CE contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.blacksquircle.ui.language.cpp.lexer;

import org.jetbrains.annotations.NotNull;

@SuppressWarnings("all")

/**
 * This class is a scanner generated by
 * <a href="http://www.jflex.de/">JFlex</a> 1.8.2
 * from the specification file <tt>cpp.flex</tt>
 */
public class CppLexer {

  /** This character denotes the end of file. */
  public static final int YYEOF = -1;

  /** Initial size of the lookahead buffer. */
  private static final int ZZ_BUFFERSIZE = 16384;

  // Lexical states.
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0, 0
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\1\u0100\1\u0200\1\u0300\1\u0400\1\u0500\1\u0600\1\u0700"+
    "\1\u0800\1\u0900\1\u0a00\1\u0b00\1\u0c00\1\u0d00\1\u0e00\1\u0f00"+
    "\1\u1000\1\u0100\1\u1100\1\u1200\1\u1300\1\u0100\1\u1400\1\u1500"+
    "\1\u1600\1\u1700\1\u1800\1\u1900\1\u1a00\1\u1b00\1\u0100\1\u1c00"+
    "\1\u1d00\1\u1e00\12\u1f00\1\u2000\1\u2100\1\u2200\1\u1f00\1\u2300"+
    "\1\u2400\2\u1f00\31\u0100\1\u2500\121\u0100\1\u2600\4\u0100\1\u2700"+
    "\1\u0100\1\u2800\1\u2900\1\u2a00\1\u2b00\1\u2c00\1\u2d00\53\u0100"+
    "\1\u2e00\10\u2f00\31\u1f00\1\u0100\1\u3000\1\u3100\1\u0100\1\u3200"+
    "\1\u3300\1\u3400\1\u3500\1\u3600\1\u3700\1\u3800\1\u3900\3\u1f00"+
    "\1\u3a00\1\u3b00\1\u3c00\1\u3d00\1\u3e00\3\u1f00\1\u3f00\1\u4000"+
    "\4\u1f00\1\u4100\11\u1f00\3\u0100\1\u4200\1\u4300\13\u1f00\4\u0100"+
    "\1\u4400\63\u1f00\2\u0100\1\u4500\4\u1f00\1\u4600\100\u1f00\1\u4700"+
    "\40\u1f00\1\u4800\1\u4900\1\u1f00\1\u4a00\1\u4b00\1\u4c00\1\u4d00"+
    "\26\u1f00\1\u4e00\21\u1f00\246\u0100\1\u4f00\20\u0100\1\u5000\1\u5100"+
    "\77\u1f00\2\u0100\1\u5100\u0b05\u1f00\1\u5200\1\u5300\u02fe\u1f00";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\11\0\1\1\1\2\1\3\1\4\1\5\16\0\4\6"+
    "\1\1\1\7\1\10\1\11\1\12\1\13\1\14\1\15"+
    "\1\16\1\17\1\20\1\21\1\22\1\23\1\24\1\25"+
    "\1\26\1\27\1\30\7\31\1\32\1\33\1\34\1\35"+
    "\1\36\1\37\1\6\1\40\1\41\1\42\1\43\1\44"+
    "\1\45\2\46\1\47\2\46\1\50\1\51\1\52\1\46"+
    "\1\53\2\46\1\54\1\55\1\56\2\46\1\57\2\46"+
    "\1\60\1\61\1\62\1\63\1\64\1\6\1\65\1\66"+
    "\1\67\1\70\1\71\1\72\1\73\1\74\1\75\1\76"+
    "\1\77\1\100\1\101\1\102\1\103\1\104\1\105\1\106"+
    "\1\107\1\110\1\111\1\112\1\113\1\114\1\115\1\116"+
    "\1\117\1\120\1\121\1\122\6\0\1\123\32\0\2\6"+
    "\4\12\4\6\1\12\2\6\1\0\7\6\1\12\4\6"+
    "\1\12\5\6\27\12\1\6\37\12\1\6\u01ca\12\4\6"+
    "\14\12\16\6\5\12\7\6\1\12\1\6\1\12\21\6"+
    "\160\0\5\12\1\6\2\12\2\6\4\12\10\6\1\12"+
    "\1\6\3\12\1\6\1\12\1\6\24\12\1\6\123\12"+
    "\1\6\213\12\1\6\5\0\2\6\236\12\11\6\46\12"+
    "\2\6\1\12\7\6\47\12\7\6\1\12\1\6\55\0"+
    "\1\6\1\0\1\6\2\0\1\6\2\0\1\6\1\0"+
    "\10\6\33\12\5\6\3\12\15\6\5\0\6\6\1\12"+
    "\4\6\13\0\5\6\53\12\37\0\4\6\2\12\1\0"+
    "\143\12\1\6\1\12\10\0\1\6\6\0\2\12\2\0"+
    "\1\6\4\0\2\12\12\0\3\12\2\6\1\12\17\6"+
    "\1\0\1\12\1\0\36\12\33\0\2\6\131\12\13\0"+
    "\1\12\16\6\12\0\41\12\11\0\2\12\4\6\1\12"+
    "\5\6\26\12\4\0\1\12\11\0\1\12\3\0\1\12"+
    "\5\0\22\6\31\12\3\0\104\6\1\12\1\6\13\12"+
    "\67\6\33\0\1\6\4\0\66\12\3\0\1\12\22\0"+
    "\1\12\7\0\12\12\2\0\2\6\12\0\1\6\7\12"+
    "\1\6\7\12\1\6\3\0\1\6\10\12\2\6\2\12"+
    "\2\6\26\12\1\6\7\12\1\6\1\12\3\6\4\12"+
    "\2\6\1\0\1\12\7\0\2\6\2\0\2\6\3\0"+
    "\1\12\10\6\1\0\4\6\2\12\1\6\3\12\2\0"+
    "\2\6\12\0\4\12\7\6\1\12\5\6\3\0\1\6"+
    "\6\12\4\6\2\12\2\6\26\12\1\6\7\12\1\6"+
    "\2\12\1\6\2\12\1\6\2\12\2\6\1\0\1\6"+
    "\5\0\4\6\2\0\2\6\3\0\3\6\1\0\7\6"+
    "\4\12\1\6\1\12\7\6\14\0\3\12\1\0\13\6"+
    "\3\0\1\6\11\12\1\6\3\12\1\6\26\12\1\6"+
    "\7\12\1\6\2\12\1\6\5\12\2\6\1\0\1\12"+
    "\10\0\1\6\3\0\1\6\3\0\2\6\1\12\17\6"+
    "\2\12\2\0\2\6\12\0\1\6\1\12\17\6\3\0"+
    "\1\6\10\12\2\6\2\12\2\6\26\12\1\6\7\12"+
    "\1\6\2\12\1\6\5\12\2\6\1\0\1\12\7\0"+
    "\2\6\2\0\2\6\3\0\10\6\2\0\4\6\2\12"+
    "\1\6\3\12\2\0\2\6\12\0\1\6\1\12\20\6"+
    "\1\0\1\12\1\6\6\12\3\6\3\12\1\6\4\12"+
    "\3\6\2\12\1\6\1\12\1\6\2\12\3\6\2\12"+
    "\3\6\3\12\3\6\14\12\4\6\5\0\3\6\3\0"+
    "\1\6\4\0\2\6\1\12\6\6\1\0\16\6\12\0"+
    "\11\6\1\12\7\6\3\0\1\6\10\12\1\6\3\12"+
    "\1\6\27\12\1\6\12\12\1\6\5\12\3\6\1\12"+
    "\7\0\1\6\3\0\1\6\4\0\7\6\2\0\1\6"+
    "\2\12\6\6\2\12\2\0\2\6\12\0\22\6\2\0"+
    "\1\6\10\12\1\6\3\12\1\6\27\12\1\6\12\12"+
    "\1\6\5\12\2\6\1\0\1\12\7\0\1\6\3\0"+
    "\1\6\4\0\7\6\2\0\7\6\1\12\1\6\2\12"+
    "\2\0\2\6\12\0\1\6\2\12\17\6\2\0\1\6"+
    "\10\12\1\6\3\12\1\6\51\12\2\6\1\12\7\0"+
    "\1\6\3\0\1\6\4\0\1\12\10\6\1\0\10\6"+
    "\2\12\2\0\2\6\12\0\12\6\6\12\2\6\2\0"+
    "\1\6\22\12\3\6\30\12\1\6\11\12\1\6\1\12"+
    "\2\6\7\12\3\6\1\0\4\6\6\0\1\6\1\0"+
    "\1\6\10\0\22\6\2\0\15\6\60\12\1\0\2\12"+
    "\7\0\4\6\10\12\10\0\1\6\12\0\47\6\2\12"+
    "\1\6\1\12\2\6\2\12\1\6\1\12\2\6\1\12"+
    "\6\6\4\12\1\6\7\12\1\6\3\12\1\6\1\12"+
    "\1\6\1\12\2\6\2\12\1\6\4\12\1\0\2\12"+
    "\6\0\1\6\2\0\1\12\2\6\5\12\1\6\1\12"+
    "\1\6\6\0\2\6\12\0\2\6\4\12\40\6\1\12"+
    "\27\6\2\0\6\6\12\0\13\6\1\0\1\6\1\0"+
    "\1\6\1\0\4\6\2\0\10\12\1\6\44\12\4\6"+
    "\24\0\1\6\2\0\5\12\13\0\1\6\44\0\11\6"+
    "\1\0\71\6\53\12\24\0\1\12\12\0\6\6\6\12"+
    "\4\0\4\12\3\0\1\12\3\0\2\12\7\0\3\12"+
    "\4\0\15\12\14\0\1\12\17\0\2\6\46\12\1\6"+
    "\1\12\5\6\1\12\2\6\53\12\1\6\115\12\1\6"+
    "\4\12\2\6\7\12\1\6\1\12\1\6\4\12\2\6"+
    "\51\12\1\6\4\12\2\6\41\12\1\6\4\12\2\6"+
    "\7\12\1\6\1\12\1\6\4\12\2\6\17\12\1\6"+
    "\71\12\1\6\4\12\2\6\103\12\2\6\3\0\40\6"+
    "\20\12\20\6\125\12\14\6\u016c\12\2\6\21\12\1\6"+
    "\32\12\5\6\113\12\3\6\3\12\17\6\15\12\1\6"+
    "\4\12\3\0\13\6\22\12\3\0\13\6\22\12\2\0"+
    "\14\6\15\12\1\6\3\12\1\6\2\0\14\6\64\12"+
    "\40\0\3\6\1\12\3\6\2\12\1\0\2\6\12\0"+
    "\41\6\3\0\2\6\12\0\6\6\130\12\10\6\51\12"+
    "\1\0\1\12\5\6\106\12\12\6\35\12\3\6\14\0"+
    "\4\6\14\0\12\6\12\0\36\12\2\6\5\12\13\6"+
    "\54\12\4\6\21\0\7\12\2\0\6\6\12\0\46\6"+
    "\27\12\5\0\4\6\65\12\12\0\1\6\35\0\2\6"+
    "\13\0\6\6\12\0\15\6\1\12\130\6\5\0\57\12"+
    "\21\0\7\12\4\6\12\0\21\6\11\0\14\6\3\0"+
    "\36\12\15\0\2\12\12\0\54\12\16\0\14\6\44\12"+
    "\24\0\10\6\12\0\3\6\3\12\12\0\44\12\122\6"+
    "\3\0\1\6\25\0\4\12\1\0\4\12\3\0\2\12"+
    "\11\6\300\12\47\0\25\6\4\0\26\12\2\6\6\12"+
    "\2\6\46\12\2\6\6\12\2\6\10\12\1\6\1\12"+
    "\1\6\1\12\1\6\1\12\1\6\37\12\2\6\65\12"+
    "\1\6\7\12\1\6\1\12\3\6\3\12\1\6\7\12"+
    "\3\6\4\12\2\6\6\12\4\6\15\12\5\6\3\12"+
    "\1\6\7\12\16\6\5\0\30\6\2\3\5\0\20\6"+
    "\2\12\23\6\1\12\13\6\5\0\5\6\6\0\1\6"+
    "\1\12\15\6\1\12\20\6\15\12\3\6\33\12\25\6"+
    "\15\0\4\6\1\0\3\6\14\0\21\6\1\12\4\6"+
    "\1\12\2\6\12\12\1\6\1\12\3\6\5\12\6\6"+
    "\1\12\1\6\1\12\1\6\1\12\1\6\4\12\1\6"+
    "\13\12\2\6\4\12\5\6\5\12\4\6\1\12\21\6"+
    "\51\12\u0177\6\57\12\1\6\57\12\1\6\205\12\6\6"+
    "\4\12\3\0\2\12\14\6\46\12\1\6\1\12\5\6"+
    "\1\12\2\6\70\12\7\6\1\12\17\6\1\0\27\12"+
    "\11\6\7\12\1\6\7\12\1\6\7\12\1\6\7\12"+
    "\1\6\7\12\1\6\7\12\1\6\7\12\1\6\7\12"+
    "\1\6\40\0\57\6\1\12\325\6\3\12\31\6\11\12"+
    "\6\0\1\6\5\12\2\6\5\12\4\6\126\12\2\6"+
    "\2\0\2\6\3\12\1\6\132\12\1\6\4\12\5\6"+
    "\51\12\3\6\136\12\21\6\33\12\65\6\306\12\112\6"+
    "\315\12\63\6\215\12\103\6\56\12\2\6\15\12\3\6"+
    "\20\12\12\0\2\12\24\6\57\12\1\0\4\6\12\0"+
    "\1\6\31\12\7\6\1\0\120\12\2\0\45\6\11\12"+
    "\2\6\147\12\2\6\4\12\1\6\4\12\14\6\13\12"+
    "\115\6\12\12\1\0\3\12\1\0\4\12\1\0\27\12"+
    "\5\0\20\6\1\12\7\6\64\12\14\6\2\0\62\12"+
    "\21\0\13\6\12\0\6\6\22\0\6\12\3\6\1\12"+
    "\4\6\12\0\34\12\10\0\2\6\27\12\15\0\14\6"+
    "\35\12\3\6\4\0\57\12\16\0\16\6\1\12\12\0"+
    "\46\6\51\12\16\0\11\6\3\12\1\0\10\12\2\0"+
    "\2\6\12\0\6\6\27\12\3\6\1\12\1\0\4\6"+
    "\60\12\1\0\1\12\3\0\2\12\2\0\5\12\2\0"+
    "\1\12\1\0\1\12\30\6\3\12\2\6\13\12\5\0"+
    "\2\6\3\12\2\0\12\6\6\12\2\6\6\12\2\6"+
    "\6\12\11\6\7\12\1\6\7\12\221\6\43\12\10\0"+
    "\1\6\2\0\2\6\12\0\6\6\244\12\14\6\27\12"+
    "\4\6\61\12\4\6\u0100\3\156\12\2\6\152\12\46\6"+
    "\7\12\14\6\5\12\5\6\1\12\1\0\12\12\1\6"+
    "\15\12\1\6\5\12\1\6\1\12\1\6\2\12\1\6"+
    "\2\12\1\6\154\12\41\6\153\12\22\6\100\12\2\6"+
    "\66\12\50\6\15\12\3\6\20\0\20\6\7\0\14\6"+
    "\2\12\30\6\3\12\31\6\1\12\6\6\5\12\1\6"+
    "\207\12\2\6\1\0\4\6\1\12\13\6\12\0\7\6"+
    "\32\12\4\6\1\12\1\6\32\12\13\6\131\12\3\6"+
    "\6\12\2\6\6\12\2\6\6\12\2\6\3\12\3\6"+
    "\2\12\3\6\2\12\22\6\3\0\4\6\14\12\1\6"+
    "\32\12\1\6\23\12\1\6\2\12\1\6\17\12\2\6"+
    "\16\12\42\6\173\12\105\6\65\12\210\6\1\0\202\6"+
    "\35\12\3\6\61\12\57\6\37\12\21\6\33\12\65\6"+
    "\36\12\2\6\44\12\4\6\10\12\1\6\5\12\52\6"+
    "\236\12\2\6\12\0\126\6\6\12\2\6\1\12\1\6"+
    "\54\12\1\6\2\12\3\6\1\12\2\6\27\12\252\6"+
    "\26\12\12\6\32\12\106\6\70\12\6\6\2\12\100\6"+
    "\1\12\3\0\1\6\2\0\5\6\4\0\4\12\1\6"+
    "\3\12\1\6\33\12\4\6\3\0\4\6\1\0\40\6"+
    "\35\12\203\6\66\12\12\6\26\12\12\6\23\12\215\6"+
    "\111\12\267\6\3\0\65\12\17\0\37\6\12\0\20\6"+
    "\3\0\55\12\13\0\2\6\1\0\22\6\31\12\7\6"+
    "\12\0\6\6\3\0\44\12\16\0\1\6\12\0\100\6"+
    "\3\0\60\12\16\0\4\12\13\6\12\0\246\6\53\12"+
    "\15\0\10\6\12\0\66\6\157\12\221\6\143\12\235\6"+
    "\57\12\321\6\71\12\307\6\105\12\13\6\1\12\56\0"+
    "\20\6\4\0\15\12\140\6\2\12\u0163\6\5\0\3\6"+
    "\26\0\2\6\7\0\36\6\4\0\224\6\3\0\273\6"+
    "\125\12\1\6\107\12\1\6\2\12\2\6\1\12\2\6"+
    "\2\12\2\6\4\12\1\6\14\12\1\6\1\12\1\6"+
    "\7\12\1\6\101\12\1\6\4\12\2\6\10\12\1\6"+
    "\7\12\1\6\34\12\1\6\4\12\1\6\5\12\1\6"+
    "\1\12\3\6\7\12\1\6\u0154\12\2\6\31\12\1\6"+
    "\31\12\1\6\37\12\1\6\31\12\1\6\37\12\1\6"+
    "\31\12\1\6\37\12\1\6\31\12\1\6\37\12\1\6"+
    "\31\12\1\6\10\12\2\6\62\0\4\12\1\6\33\12"+
    "\1\6\2\12\1\6\1\12\2\6\1\12\1\6\12\12"+
    "\1\6\4\12\1\6\1\12\1\6\1\12\6\6\1\12"+
    "\4\6\1\12\1\6\1\12\1\6\1\12\1\6\3\12"+
    "\1\6\2\12\1\6\1\12\2\6\1\12\1\6\1\12"+
    "\1\6\1\12\1\6\1\12\1\6\1\12\1\6\2\12"+
    "\1\6\1\12\2\6\4\12\1\6\7\12\1\6\4\12"+
    "\1\6\4\12\1\6\1\12\1\6\12\12\1\6\21\12"+
    "\5\6\3\12\1\6\5\12\1\6\21\12\104\6\327\12"+
    "\51\6\65\12\13\6\336\12\343\6\1\0\36\6\140\0"+
    "\200\6\360\0\20\6";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[21504];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\2\2\1\3\1\4\1\1\1\5\1\6"+
    "\1\7\1\10\1\11\1\12\1\13\1\14\1\15\1\16"+
    "\1\1\1\17\2\20\1\21\1\22\1\23\1\24\1\25"+
    "\1\26\1\5\1\27\1\30\1\31\25\5\1\32\1\33"+
    "\1\34\1\35\1\0\1\36\1\4\3\0\1\37\1\40"+
    "\1\41\1\42\1\10\1\0\1\43\1\44\1\45\1\46"+
    "\1\47\1\50\1\51\1\52\1\53\1\20\2\50\1\54"+
    "\1\55\1\20\1\56\1\57\1\60\1\61\1\62\1\0"+
    "\1\5\1\63\22\5\1\64\25\5\1\65\63\5\1\66"+
    "\1\67\2\4\2\10\1\0\1\50\1\0\1\20\1\70"+
    "\1\71\1\72\6\5\1\73\24\5\1\73\3\5\1\73"+
    "\6\5\1\73\12\5\1\74\12\5\1\75\14\5\1\73"+
    "\6\5\1\76\36\5\1\77\16\5\1\51\1\0\1\100"+
    "\5\5\1\73\1\5\1\101\1\102\4\5\1\103\1\5"+
    "\1\104\12\5\1\105\1\106\20\5\1\73\2\5\1\107"+
    "\12\5\1\73\2\5\1\110\44\5\1\111\3\5\1\112"+
    "\10\5\1\113\14\5\1\114\1\5\1\115\1\116\1\5"+
    "\1\117\3\5\1\120\4\5\1\121\2\5\1\122\33\5"+
    "\1\123\16\5\1\124\5\5\1\125\1\5\1\126\11\5"+
    "\1\127\11\5\1\130\1\131\2\5\1\132\1\5\1\133"+
    "\10\5\1\134\2\5\1\135\1\5\1\136\1\137\1\140"+
    "\1\141\1\142\1\143\2\5\1\144\15\5\1\145\3\5"+
    "\1\146\2\5\1\147\5\5\1\150\2\5\1\151\1\5"+
    "\1\152\1\153\1\154\1\155\1\156\1\157\1\5\1\160"+
    "\1\5\1\161\1\5\1\162\1\5\1\163\2\5\1\164"+
    "\1\165\1\166\1\167\2\5\1\170\1\171\2\5\1\172"+
    "\5\5\1\173\1\174\4\5\1\175";

  private static int [] zzUnpackAction() {
    int [] result = new int[636];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\124\0\250\0\374\0\u0150\0\u01a4\0\u01f8\0\u024c"+
    "\0\u02a0\0\u02f4\0\u0348\0\124\0\124\0\u039c\0\u03f0\0\124"+
    "\0\u0444\0\u0498\0\u04ec\0\u0540\0\u0594\0\124\0\124\0\u05e8"+
    "\0\u063c\0\u0690\0\u06e4\0\u0738\0\124\0\124\0\u078c\0\u07e0"+
    "\0\u0834\0\u0888\0\u08dc\0\u0930\0\u0984\0\u09d8\0\u0a2c\0\u0a80"+
    "\0\u0ad4\0\u0b28\0\u0b7c\0\u0bd0\0\u0c24\0\u0c78\0\u0ccc\0\u0d20"+
    "\0\u0d74\0\u0dc8\0\u0e1c\0\u0e70\0\124\0\u0ec4\0\124\0\124"+
    "\0\u01f8\0\124\0\124\0\u0f18\0\u0f6c\0\u0fc0\0\u1014\0\124"+
    "\0\124\0\124\0\124\0\u1068\0\124\0\124\0\124\0\124"+
    "\0\124\0\u10bc\0\u1110\0\u1164\0\124\0\u11b8\0\124\0\u120c"+
    "\0\124\0\124\0\u1260\0\u12b4\0\124\0\124\0\124\0\u1308"+
    "\0\u135c\0\u13b0\0\124\0\u1404\0\u1458\0\u14ac\0\u1500\0\u1554"+
    "\0\u15a8\0\u15fc\0\u1650\0\u16a4\0\u16f8\0\u174c\0\u17a0\0\u17f4"+
    "\0\u1848\0\u189c\0\u18f0\0\u1944\0\u1998\0\u19ec\0\u1a40\0\u1a94"+
    "\0\u1ae8\0\u1b3c\0\u1b90\0\u1be4\0\u1c38\0\u1c8c\0\u1ce0\0\u1d34"+
    "\0\u1d88\0\u1ddc\0\u1e30\0\u1e84\0\u1ed8\0\u1f2c\0\u1f80\0\u1fd4"+
    "\0\u2028\0\u207c\0\u20d0\0\u024c\0\u2124\0\u2178\0\u21cc\0\u2220"+
    "\0\u2274\0\u22c8\0\u231c\0\u2370\0\u23c4\0\u2418\0\u246c\0\u24c0"+
    "\0\u2514\0\u2568\0\u25bc\0\u2610\0\u2664\0\u26b8\0\u270c\0\u2760"+
    "\0\u27b4\0\u2808\0\u285c\0\u28b0\0\u2904\0\u2958\0\u29ac\0\u2a00"+
    "\0\u2a54\0\u2aa8\0\u2afc\0\u2b50\0\u2ba4\0\u2bf8\0\u2c4c\0\u2ca0"+
    "\0\u2cf4\0\u2d48\0\u2d9c\0\u2df0\0\u2e44\0\u2e98\0\u2eec\0\u2f40"+
    "\0\u2f94\0\u2fe8\0\u303c\0\u3090\0\u30e4\0\u3138\0\u318c\0\124"+
    "\0\124\0\u31e0\0\u3234\0\u3288\0\u32dc\0\u3330\0\u3384\0\u33d8"+
    "\0\u342c\0\124\0\124\0\124\0\u3480\0\u34d4\0\u3528\0\u357c"+
    "\0\u35d0\0\u3624\0\u024c\0\u3678\0\u36cc\0\u3720\0\u3774\0\u37c8"+
    "\0\u381c\0\u3870\0\u38c4\0\u3918\0\u396c\0\u39c0\0\u3a14\0\u3a68"+
    "\0\u3abc\0\u3b10\0\u3b64\0\u3bb8\0\u3c0c\0\u3c60\0\u3cb4\0\u3d08"+
    "\0\u3d5c\0\u3db0\0\u3e04\0\u3e58\0\u3eac\0\u3f00\0\u3f54\0\u3fa8"+
    "\0\u3ffc\0\u4050\0\u40a4\0\u40f8\0\u414c\0\u41a0\0\u41f4\0\u4248"+
    "\0\u429c\0\u42f0\0\u4344\0\u4398\0\u43ec\0\u024c\0\u4440\0\u4494"+
    "\0\u44e8\0\u453c\0\u4590\0\u45e4\0\u4638\0\u468c\0\u46e0\0\u4734"+
    "\0\u024c\0\u4788\0\u47dc\0\u4830\0\u4884\0\u48d8\0\u492c\0\u4980"+
    "\0\u49d4\0\u4a28\0\u4a7c\0\u4ad0\0\u4b24\0\u4b78\0\u4bcc\0\u4c20"+
    "\0\u4c74\0\u4cc8\0\u4d1c\0\u4d70\0\u024c\0\u4dc4\0\u4e18\0\u4e6c"+
    "\0\u4ec0\0\u4f14\0\u4f68\0\u4fbc\0\u5010\0\u5064\0\u50b8\0\u510c"+
    "\0\u5160\0\u51b4\0\u5208\0\u525c\0\u52b0\0\u5304\0\u5358\0\u53ac"+
    "\0\u5400\0\u5454\0\u54a8\0\u54fc\0\u5550\0\u55a4\0\u55f8\0\u564c"+
    "\0\u56a0\0\u56f4\0\u5748\0\u024c\0\u579c\0\u57f0\0\u5844\0\u5898"+
    "\0\u58ec\0\u5940\0\u5994\0\u59e8\0\u5a3c\0\u5a90\0\u5ae4\0\u5b38"+
    "\0\u5b8c\0\u5be0\0\124\0\u5c34\0\u024c\0\u5c88\0\u5cdc\0\u5d30"+
    "\0\u5d84\0\u5dd8\0\u5e2c\0\u5e80\0\u024c\0\u024c\0\u5ed4\0\u5f28"+
    "\0\u5f7c\0\u5fd0\0\u024c\0\u6024\0\u024c\0\u6078\0\u60cc\0\u6120"+
    "\0\u6174\0\u61c8\0\u621c\0\u6270\0\u62c4\0\u6318\0\u636c\0\u024c"+
    "\0\u024c\0\u63c0\0\u6414\0\u6468\0\u64bc\0\u6510\0\u6564\0\u65b8"+
    "\0\u660c\0\u6660\0\u66b4\0\u6708\0\u675c\0\u67b0\0\u6804\0\u6858"+
    "\0\u68ac\0\u6900\0\u6954\0\u69a8\0\u024c\0\u69fc\0\u6a50\0\u6aa4"+
    "\0\u6af8\0\u6b4c\0\u6ba0\0\u6bf4\0\u6c48\0\u6c9c\0\u6cf0\0\u6d44"+
    "\0\u6d98\0\u6dec\0\u6e40\0\u6e94\0\u6ee8\0\u6f3c\0\u6f90\0\u6fe4"+
    "\0\u7038\0\u708c\0\u70e0\0\u7134\0\u7188\0\u71dc\0\u7230\0\u7284"+
    "\0\u72d8\0\u732c\0\u7380\0\u73d4\0\u7428\0\u747c\0\u74d0\0\u7524"+
    "\0\u7578\0\u75cc\0\u7620\0\u7674\0\u76c8\0\u771c\0\u7770\0\u77c4"+
    "\0\u7818\0\u786c\0\u78c0\0\u7914\0\u7968\0\u79bc\0\u7a10\0\u024c"+
    "\0\u7a64\0\u7ab8\0\u7b0c\0\u024c\0\u7b60\0\u7bb4\0\u7c08\0\u7c5c"+
    "\0\u7cb0\0\u7d04\0\u7d58\0\u7dac\0\u024c\0\u7e00\0\u7e54\0\u7ea8"+
    "\0\u7efc\0\u7f50\0\u7fa4\0\u7ff8\0\u804c\0\u80a0\0\u80f4\0\u8148"+
    "\0\u819c\0\u024c\0\u81f0\0\u024c\0\u024c\0\u8244\0\u8298\0\u82ec"+
    "\0\u8340\0\u8394\0\u024c\0\u83e8\0\u843c\0\u8490\0\u84e4\0\u024c"+
    "\0\u3d08\0\u8538\0\u024c\0\u858c\0\u85e0\0\u8634\0\u8688\0\u86dc"+
    "\0\u8730\0\u8784\0\u87d8\0\u882c\0\u8880\0\u88d4\0\u8928\0\u897c"+
    "\0\u89d0\0\u8a24\0\u8a78\0\u8acc\0\u8b20\0\u8b74\0\u8bc8\0\u8c1c"+
    "\0\u8c70\0\u8cc4\0\u8d18\0\u8d6c\0\u8dc0\0\u8e14\0\u024c\0\u8e68"+
    "\0\u8ebc\0\u8f10\0\u8f64\0\u8fb8\0\u900c\0\u9060\0\u90b4\0\u9108"+
    "\0\u915c\0\u91b0\0\u9204\0\u9258\0\u92ac\0\u024c\0\u9300\0\u9354"+
    "\0\u93a8\0\u93fc\0\u9450\0\u024c\0\u94a4\0\u024c\0\u94f8\0\u954c"+
    "\0\u95a0\0\u95f4\0\u9648\0\u969c\0\u96f0\0\u9744\0\u9798\0\u024c"+
    "\0\u97ec\0\u9840\0\u9894\0\u98e8\0\u993c\0\u9990\0\u99e4\0\u9a38"+
    "\0\u9a8c\0\u024c\0\u024c\0\u9ae0\0\u9b34\0\u024c\0\u9b88\0\u024c"+
    "\0\u9bdc\0\u9c30\0\u9c84\0\u9cd8\0\u9d2c\0\u9d80\0\u9dd4\0\u9e28"+
    "\0\u024c\0\u9e7c\0\u9ed0\0\u024c\0\u9f24\0\u024c\0\u024c\0\u024c"+
    "\0\u9f78\0\u024c\0\u024c\0\u9fcc\0\ua020\0\u024c\0\ua074\0\ua0c8"+
    "\0\ua11c\0\ua170\0\ua1c4\0\ua218\0\ua26c\0\ua2c0\0\ua314\0\ua368"+
    "\0\ua3bc\0\ua410\0\ua464\0\u024c\0\ua4b8\0\ua50c\0\ua560\0\u024c"+
    "\0\ua5b4\0\ua608\0\u024c\0\ua65c\0\ua6b0\0\ua704\0\ua758\0\ua7ac"+
    "\0\u024c\0\ua800\0\ua854\0\u024c\0\ua8a8\0\u024c\0\u024c\0\u024c"+
    "\0\u024c\0\u024c\0\u024c\0\ua8fc\0\u024c\0\ua950\0\u024c\0\ua9a4"+
    "\0\u024c\0\ua9f8\0\u024c\0\uaa4c\0\uaaa0\0\u024c\0\u024c\0\u024c"+
    "\0\u024c\0\uaaf4\0\uab48\0\u024c\0\u024c\0\uab9c\0\uabf0\0\u024c"+
    "\0\uac44\0\uac98\0\uacec\0\uad40\0\uad94\0\u024c\0\u024c\0\uade8"+
    "\0\uae3c\0\uae90\0\uaee4\0\u024c";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[636];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\2\3\1\2\1\3\1\4\1\2\1\5\1\6"+
    "\1\7\1\10\1\11\1\12\1\13\1\14\1\15\1\16"+
    "\1\17\1\20\1\21\1\22\1\23\1\24\3\25\1\26"+
    "\1\27\1\30\1\31\1\32\1\33\12\10\1\34\5\10"+
    "\1\35\1\2\1\36\1\37\1\40\1\41\1\42\1\43"+
    "\1\44\1\45\1\46\1\47\1\10\1\50\2\10\1\51"+
    "\1\52\1\53\1\54\1\55\1\56\1\57\1\60\1\61"+
    "\1\62\1\63\1\64\3\10\1\65\1\66\1\67\1\70"+
    "\1\2\135\0\1\71\114\0\1\3\6\0\1\71\147\0"+
    "\1\72\66\0\2\6\1\0\2\6\1\0\2\6\1\73"+
    "\50\6\1\74\42\6\1\0\2\75\1\0\1\75\1\76"+
    "\32\0\20\77\5\0\32\77\5\0\1\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\33\10\4\0\1\10"+
    "\35\0\1\100\102\0\1\101\20\0\1\102\66\0\2\13"+
    "\1\0\2\13\1\0\7\13\1\103\43\13\1\104\42\13"+
    "\35\0\1\105\107\0\1\106\13\0\1\107\111\0\1\110"+
    "\11\0\1\111\114\0\4\112\112\0\1\113\4\0\1\114"+
    "\7\0\1\115\112\0\1\112\1\0\4\25\7\0\1\116"+
    "\1\0\1\117\1\120\1\121\2\0\1\122\6\0\1\123"+
    "\4\0\1\25\1\0\1\116\1\0\1\117\1\120\1\121"+
    "\5\0\1\122\13\0\1\123\33\0\1\112\1\0\4\25"+
    "\11\0\1\117\1\120\1\121\2\0\1\122\13\0\1\25"+
    "\3\0\1\117\1\120\1\121\5\0\1\122\57\0\1\124"+
    "\1\125\123\0\1\126\123\0\1\127\1\130\124\0\1\131"+
    "\64\0\1\10\11\0\1\10\13\0\4\10\6\0\16\10"+
    "\1\132\1\10\4\0\33\10\4\0\1\10\35\0\1\133"+
    "\66\0\1\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\1\134\32\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\2\10\1\135\1\136\17\10"+
    "\1\137\1\140\1\141\5\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\17\10\1\142\2\10"+
    "\1\143\1\144\1\145\6\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\1\10\1\146\3\10"+
    "\1\147\2\10\1\150\3\10\1\151\2\10\1\152\4\10"+
    "\1\153\6\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\5\10\1\154\3\10\1\155\5\10"+
    "\1\156\11\10\1\157\1\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\14\10\1\160\1\10"+
    "\1\161\3\10\1\162\5\10\1\163\2\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\1\10"+
    "\1\164\1\10\1\165\1\10\1\166\1\167\1\170\4\10"+
    "\1\171\1\172\1\10\1\173\1\174\1\10\1\175\1\176"+
    "\1\177\2\10\1\200\3\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\5\10\1\201\7\10"+
    "\1\202\1\10\1\203\13\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\6\10\1\204\7\10"+
    "\1\205\4\10\1\206\7\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\1\10\1\207\2\10"+
    "\1\210\12\10\1\211\13\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\1\10\1\212\1\213"+
    "\2\10\1\214\5\10\1\202\3\10\1\215\5\10\1\216"+
    "\5\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\1\10\1\217\3\10\1\220\17\10\1\221"+
    "\5\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\6\10\1\222\11\10\1\223\12\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\5\10\1\224\11\10\1\225\2\10\1\226\2\10\1\227"+
    "\5\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\23\10\1\230\7\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\1\10\1\231"+
    "\3\10\1\232\25\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\3\10\1\233\1\10\1\234"+
    "\2\10\1\235\1\236\6\10\1\237\1\240\1\241\1\242"+
    "\1\243\2\10\1\244\1\10\1\245\1\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\1\10"+
    "\1\246\3\10\1\247\2\10\1\250\1\251\3\10\1\252"+
    "\1\10\1\253\2\10\1\254\6\10\1\255\1\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\16\10\1\256\4\10\1\257\7\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\1\10\1\260"+
    "\4\10\1\261\2\10\1\262\5\10\1\263\1\237\2\10"+
    "\1\261\3\10\1\264\3\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\3\10\1\265\4\10"+
    "\1\266\4\10\1\267\2\10\1\237\2\10\1\242\7\10"+
    "\4\0\1\10\35\0\1\270\62\0\1\271\3\0\1\6"+
    "\1\272\2\6\1\272\1\273\116\6\40\0\20\77\5\0"+
    "\32\77\7\0\1\75\35\0\20\77\5\0\32\77\5\0"+
    "\2\77\1\0\121\77\1\13\1\274\2\13\1\274\1\275"+
    "\116\13\26\0\4\112\11\0\1\117\1\120\1\121\16\0"+
    "\1\112\3\0\1\117\1\120\1\121\31\0\20\113\1\276"+
    "\103\113\2\114\4\0\115\114\27\0\4\116\16\0\1\122"+
    "\13\0\1\116\13\0\1\122\44\0\1\277\1\0\1\277"+
    "\2\0\4\277\11\0\1\117\1\0\1\121\16\0\1\277"+
    "\3\0\1\117\1\0\1\121\55\0\1\300\1\0\4\301"+
    "\6\0\6\301\2\0\1\122\13\0\7\301\5\0\1\122"+
    "\60\0\1\302\123\0\1\303\75\0\1\304\5\0\3\304"+
    "\3\0\1\304\1\0\1\304\6\0\3\304\65\0\1\10"+
    "\11\0\1\10\13\0\4\10\6\0\10\10\1\305\7\10"+
    "\4\0\33\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\3\10\1\306\1\10\1\307\2\10\1\310\3\10"+
    "\1\311\1\312\2\10\4\0\33\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\17\10\1\240"+
    "\3\10\1\313\7\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\17\10\1\314\13\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\3\10\1\202\5\10\1\315\11\10\1\316\7\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\1\10\1\317\3\10\1\320\11\10\1\321\13\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\24\10\1\322\6\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\17\10\1\323\13\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\5\10\1\324\25\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\5\10\1\325\25\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\17\10\1\326\13\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\14\10\1\327\6\10\1\330"+
    "\1\331\6\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\11\10\1\332\21\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\1\10"+
    "\1\333\31\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\1\10\1\334\3\10\1\335\11\10"+
    "\1\336\13\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\16\10\1\337\4\10\1\340\7\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\11\10\1\251\21\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\6\10\1\341\5\10"+
    "\1\342\16\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\6\10\1\343\17\10\1\344\4\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\25\10\1\345\5\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\16\10\1\346\14\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\23\10\1\347\7\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\25\10\1\350\5\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\22\10\1\351\10\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\11\10\1\352\6\10"+
    "\1\353\3\10\1\354\6\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\2\10\1\314\11\10"+
    "\1\355\16\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\14\10\1\356\16\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\17\10"+
    "\1\357\2\10\1\360\10\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\14\10\1\361\16\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\5\10\1\362\25\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\17\10\1\363\13\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\17\10\1\364\13\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\20\10\1\365\1\10"+
    "\1\366\10\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\22\10\1\367\2\10\1\370\5\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\5\10\1\371\3\10\1\372\21\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\3\10"+
    "\1\233\1\10\1\373\25\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\5\10\1\374\25\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\20\10\1\237\1\10\1\375\1\242\7\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\24\10\1\376\6\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\24\10\1\153\6\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\24\10\1\377\6\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\14\10\1\u0100\7\10\1\u0101"+
    "\6\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\1\10\1\u0102\1\10\1\u0103\1\u0104\2\10"+
    "\1\u0105\4\10\1\u0106\3\10\1\u0107\2\10\1\u0108\1\10"+
    "\1\u0109\2\10\1\u010a\2\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\2\10\1\314\30\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\5\10\1\u010b\3\10\1\u010c\21\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\3\10"+
    "\1\u010d\3\10\1\u010e\6\10\1\u010f\14\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\14\10"+
    "\1\327\16\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\14\10\1\365\5\10\1\u0110\1\u0111"+
    "\1\145\6\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\15\10\1\u0112\15\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\4\10"+
    "\1\357\26\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\24\10\1\u0113\6\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\15\10"+
    "\1\u0114\15\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\27\10\1\u0115\3\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\14\10"+
    "\1\u0116\16\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\6\10\1\u0117\24\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\5\10"+
    "\1\u0118\25\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\22\10\1\360\10\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\27\10"+
    "\1\313\3\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\11\10\1\u0119\5\10\1\u011a\13\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\2\10\1\u011b\21\10\1\u011c\6\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\17\10"+
    "\1\240\13\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\11\10\1\u011d\4\10\1\364\14\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\1\10\1\212\5\10\1\u011e\1\10\1\u011f\3\10"+
    "\1\u0120\1\u0121\5\10\1\u0122\2\10\1\u0123\3\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\1\10\1\u0124\31\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\24\10\1\u0125\6\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\17\10\1\u0126\13\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\7\10\1\u0127\6\10\1\340"+
    "\13\10\1\u0128\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\22\10\1\367\10\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\22\10"+
    "\1\352\10\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\1\10\1\u0129\31\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\3\10"+
    "\1\233\27\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\1\10\1\u012a\20\10\1\u012b\10\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\11\10\1\u012c\6\10\1\237\2\10\1\242\7\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\23\10\1\u012d\7\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\16\10\1\340\14\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\15\10\1\u012e\15\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\11\10\1\u012f\10\10"+
    "\1\u0130\10\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\15\10\1\u0131\15\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\20\10"+
    "\1\u0132\12\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\14\10\1\u0106\10\10\1\u0109\5\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\25\10\1\u0133\3\10\1\u0134\1\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\20\10"+
    "\1\u0135\12\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\7\10\1\u0136\1\10\1\u0137\11\10"+
    "\1\u0138\7\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\11\10\1\u0139\21\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\1\u013a"+
    "\32\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\20\10\1\237\6\10\1\264\3\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\22\10\1\u013b\10\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\11\10\1\u013c\2\10\1\u013d"+
    "\16\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\20\10\1\237\12\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\10\10\1\u013e"+
    "\11\10\1\u013f\1\u0140\1\u0141\6\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\11\10\1\u0142"+
    "\21\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\5\10\1\214\25\10\4\0\1\10\1\6"+
    "\1\272\2\6\1\272\1\273\2\6\1\73\50\6\1\74"+
    "\47\6\1\0\2\6\1\73\50\6\1\74\42\6\1\13"+
    "\1\274\2\13\1\274\1\275\7\13\1\103\43\13\1\104"+
    "\47\13\1\0\7\13\1\103\43\13\1\104\42\13\20\113"+
    "\1\276\4\113\1\u0143\76\113\26\0\4\277\11\0\1\117"+
    "\1\0\1\121\16\0\1\277\3\0\1\117\1\0\1\121"+
    "\57\0\4\u0144\6\0\6\u0144\16\0\7\u0144\55\0\1\u0144"+
    "\1\0\4\301\6\0\6\301\2\0\1\122\2\0\1\120"+
    "\10\0\7\301\5\0\1\122\3\0\1\120\17\0\1\10"+
    "\11\0\1\10\13\0\4\10\6\0\10\10\1\u0145\7\10"+
    "\4\0\33\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\1\u0146\17\10\4\0\33\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\7\10\1\u0147\10\10\4\0"+
    "\33\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\7\10\1\u0148\10\10\4\0\33\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\15\10\1\u0149\2\10\4\0"+
    "\33\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\7\10\1\u014a\10\10\4\0\33\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\23\10\1\313"+
    "\7\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\16\10\1\313\14\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\5\10\1\240"+
    "\25\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\16\10\1\u014b\14\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\30\10\1\u014c"+
    "\2\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\6\10\1\313\2\10\1\313\2\10\1\313"+
    "\16\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\17\10\1\u014d\13\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\14\10\1\u014e"+
    "\16\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\1\10\1\u014f\31\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\1\10\1\u0150"+
    "\31\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\27\10\1\u0151\3\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\14\10\1\u0152"+
    "\16\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\5\10\1\u0153\25\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\3\10\1\u0154"+
    "\27\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\14\10\1\313\16\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\22\10\1\u0155"+
    "\10\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\23\10\1\u0156\7\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\1\10\1\u0157"+
    "\31\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\3\10\1\u0158\27\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\23\10\1\u0159"+
    "\1\u015a\6\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\10\10\1\313\22\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\1\10"+
    "\1\u015b\31\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\5\10\1\u015c\25\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\6\10"+
    "\1\202\24\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\1\u015d\32\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\2\10\1\u015e"+
    "\30\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\1\10\1\u015f\31\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\5\10\1\u0160"+
    "\25\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\15\10\1\u0161\15\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\16\10\1\u0162"+
    "\14\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\24\10\1\313\6\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\14\10\1\u0163"+
    "\16\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\5\10\1\u0164\25\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\23\10\1\u0165"+
    "\7\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\17\10\1\u011d\13\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\6\10\1\313"+
    "\24\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\22\10\1\u0166\10\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\25\10\1\u0167"+
    "\5\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\24\10\1\u0168\6\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\1\10\1\u0169"+
    "\15\10\1\u016a\13\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\4\10\1\313\26\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\5\10\1\315\25\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\11\10\1\u016b\21\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\24\10\1\u016c\6\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\1\10\1\364\3\10\1\313"+
    "\11\10\1\u016d\10\10\1\u016e\2\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\5\10\1\u016f"+
    "\25\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\5\10\1\u0158\16\10\1\u0170\6\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\14\10\1\332\16\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\11\10\1\u0171\21\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\3\10\1\u0172\1\10\1\u0173\15\10\1\313\3\10\1\u0174"+
    "\3\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\17\10\1\u0175\13\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\11\10\1\u0176"+
    "\21\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\14\10\1\u0177\16\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\16\10\1\u0178"+
    "\14\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\11\10\1\u0179\21\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\22\10\1\u017a"+
    "\10\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\17\10\1\u017b\13\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\22\10\1\u017c"+
    "\2\10\1\u017d\5\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\20\10\1\u017e\12\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\20\10\1\u017f\12\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\4\10\1\u0104\26\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\30\10\1\u016e\2\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\26\10\1\u0180\4\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\1\10\1\u0181\31\10\4\0\2\10\11\0\1\10\13\0"+
    "\1\10\1\u0182\2\10\6\0\20\10\4\0\33\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\7\10\1\u0183\23\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\14\10\1\365\7\10\1\145"+
    "\6\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\11\10\1\u0184\10\10\1\u0185\1\10\1\u0186"+
    "\6\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\3\10\1\u0187\11\10\1\u0120\5\10\1\u0188"+
    "\7\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\1\10\1\u0189\31\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\5\10\1\u018a"+
    "\25\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\14\10\1\u0145\16\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\23\10\1\u018b"+
    "\7\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\22\10\1\u018c\10\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\16\10\1\u018d"+
    "\7\10\1\u018e\4\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\24\10\1\u018f\6\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\14\10\1\u0190\16\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\3\10\1\u0172\17\10\1\313"+
    "\3\10\1\u0174\3\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\23\10\1\u0131\7\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\11\10\1\u0191\21\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\16\10\1\u0192\14\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\17\10\1\u0193\13\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\1\10\1\251\31\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\25\10\1\u0194\5\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\11\10\1\u0129\21\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\16\10\1\357\14\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\2\10\1\u0195\7\10\1\u0196"+
    "\1\10\1\u0197\11\10\1\u0198\4\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\22\10\1\u0199"+
    "\10\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\16\10\1\u019a\14\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\5\10\1\u019b"+
    "\25\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\16\10\1\364\14\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\24\10\1\u019c"+
    "\6\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\3\10\1\u019d\1\10\1\224\1\202\5\10"+
    "\1\365\1\10\1\u019e\1\10\1\u019f\1\10\1\u01a0\1\u01a1"+
    "\1\u01a2\1\u01a3\2\10\1\u01a4\2\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\24\10\1\u01a5"+
    "\6\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\24\10\1\u01a6\6\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\20\10\1\u01a7"+
    "\12\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\23\10\1\u01a8\7\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\17\10\1\u01a9"+
    "\13\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\5\10\1\313\25\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\6\10\1\u01aa"+
    "\7\10\1\u01ab\14\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\5\10\1\u01ac\25\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\5\10\1\u01ad\25\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\5\10\1\u01ae\25\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\17\10\1\u01af\13\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\11\10\1\u01b0\21\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\16\10\1\u01b1\14\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\1\10\1\u01b2\3\10\1\u0129"+
    "\15\10\1\u01b3\7\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\24\10\1\u01b4\6\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\4\10\1\u01b5\26\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\1\10\1\u01b6\31\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\1\10\1\u01b7\31\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\24\10\1\u01b8\6\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\3\10\1\u019d\2\10\1\202\5\10\1\365\1\10\1\u019e"+
    "\1\10\1\u019f\1\10\1\u01b9\1\u01a1\1\u01ba\3\10\1\u01a4"+
    "\2\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\17\10\1\u01bb\13\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\14\10\1\u01bc"+
    "\16\10\4\0\1\10\26\0\4\u0144\6\0\6\u0144\5\0"+
    "\1\120\10\0\7\u0144\11\0\1\120\17\0\1\10\11\0"+
    "\1\10\13\0\4\10\6\0\15\10\1\u01bd\2\10\4\0"+
    "\33\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\10\10\1\u01be\7\10\4\0\33\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\12\10\1\u01bf\5\10\4\0"+
    "\33\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\3\10\1\u01c0\14\10\4\0\33\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\11\10\1\u01c1\6\10\4\0"+
    "\33\10\4\0\2\10\11\0\1\10\13\0\2\10\1\313"+
    "\1\10\6\0\20\10\4\0\33\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\11\10\1\352"+
    "\21\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\13\10\1\u01c2\17\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\22\10\1\u01c3"+
    "\10\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\3\10\1\313\27\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\17\10\1\u0151"+
    "\13\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\10\10\1\u01c4\22\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\23\10\1\u01c5"+
    "\7\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\22\10\1\u01c6\10\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\13\10\1\313"+
    "\17\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\24\10\1\u01c7\6\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\11\10\1\u01c8"+
    "\21\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\25\10\1\u01c9\5\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\24\10\1\u01ca"+
    "\6\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\24\10\1\u01cb\6\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\14\10\1\u01cc"+
    "\16\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\15\10\1\u01cd\15\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\17\10\1\313"+
    "\13\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\11\10\1\u01ce\21\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\22\10\1\u01cf"+
    "\10\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\5\10\1\u01d0\25\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\17\10\1\u016a"+
    "\13\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\23\10\1\u01d1\7\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\3\10\1\313"+
    "\14\10\1\136\2\10\1\313\3\10\1\u01d2\3\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\24\10\1\u01d3\6\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\22\10\1\313\10\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\16\10\1\u018d\14\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\3\10\1\313\17\10\1\313"+
    "\3\10\1\u01d2\3\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\20\10\1\365\12\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\20\10\1\313\12\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\16\10\1\u01d4\14\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\20\10\1\136\12\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\24\10\1\u0131\6\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\10\10\1\u01d5\22\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\16\10\1\u01d6\14\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\3\10\1\u0172\27\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\16\10\1\u01d7\14\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\16\10\1\u01d8\1\10\1\u01d9\12\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\24\10\1\u01da"+
    "\6\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\7\10\1\u014c\23\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\1\10\1\u01db"+
    "\31\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\27\10\1\u01dc\3\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\11\10\1\u01dd"+
    "\21\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\16\10\1\u01de\14\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\1\10\1\u01df"+
    "\31\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\20\10\1\u01dc\12\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\1\u01e0\32\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\14\10\1\u01e1\16\10\4\0\2\10\11\0\1\10"+
    "\13\0\1\313\3\10\6\0\20\10\4\0\33\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\12\10\1\u0196\20\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\16\10\1\u014c\14\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\24\10\1\u0186\6\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\17\10\1\u01e2\13\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\10\10\1\u016a\4\10\1\u016e\2\10\1\u01e3\12\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\5\10\1\352\25\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\2\10\1\u01e4\30\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\23\10\1\u01e5\7\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\5\10\1\u01e6\25\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\1\10\1\u01e7\31\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\24\10\1\357\6\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\1\10\1\u01e8\31\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\5\10\1\u01e9\25\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\11\10\1\u01ea\21\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\23\10\1\u01eb\7\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\24\10\1\u01ec\6\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\26\10\1\u0131\4\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\22\10\1\u01ed\10\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\25\10\1\357\5\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\15\10\1\u016e\15\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\17\10\1\u01ee\13\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\2\10\1\u0195\30\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\24\10\1\u01ef\6\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\1\10\1\332\3\10\1\u01f0\25\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\1\u01f1\16\10"+
    "\1\u01f2\13\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\11\10\1\u01f3\21\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\1\10"+
    "\1\352\6\10\1\u016a\4\10\1\u016e\1\10\1\374\1\u01e3"+
    "\2\10\1\u01f4\7\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\3\10\1\u01f5\27\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\2\10\1\u01f6\30\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\3\10\1\u01f7\27\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\20\10\1\315\3\10\1\u016a\6\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\17\10\1\u01f8"+
    "\13\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\3\10\1\u01f9\27\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\6\10\1\u01fa"+
    "\24\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\3\10\1\u01fb\27\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\5\10\1\u01fc"+
    "\25\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\14\10\1\u01fd\16\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\27\10\1\u01fe"+
    "\3\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\11\10\1\u01ff\21\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\1\10\1\u01fc"+
    "\31\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\4\10\1\u0200\4\10\1\u0201\4\10\1\u0202"+
    "\14\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\24\10\1\u0203\6\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\16\10\1\u0204"+
    "\14\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\7\10\1\u0205\23\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\7\10\1\u0206"+
    "\23\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\22\10\1\u0207\10\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\24\10\1\u0208"+
    "\6\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\25\10\1\u0209\5\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\24\10\1\u020a"+
    "\6\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\22\10\1\u020b\10\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\17\10\1\u020c"+
    "\13\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\3\10\1\u01f7\20\10\1\u020d\6\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\17\10\1\u020e\13\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\2\10\1\313\12\10\1\u020f"+
    "\15\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\5\10\1\u0210\25\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\4\10\1\u0211\13\10\4\0"+
    "\33\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\4\10\1\u0212\13\10\4\0\33\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\4\10\1\u0213\13\10\4\0"+
    "\33\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\2\10\1\u0214\15\10\4\0\33\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\4\10\1\u0215\13\10\4\0"+
    "\33\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\3\10\1\u01d1\27\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\5\10\1\u0216"+
    "\25\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\1\u0217\32\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\16\10\1\u0218\14\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\14\10\1\u0219\16\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\5\10\1\u021a\25\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\5\10\1\u021b\25\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\11\10\1\u021c\21\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\3\10\1\u021d\27\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\16\10\1\u021e\14\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\3\10\1\313\17\10\1\313\7\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\4\10"+
    "\1\366\26\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\1\10\1\u016a\31\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\26\10"+
    "\1\313\4\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\5\10\1\204\25\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\25\10"+
    "\1\u01fc\5\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\10\10\1\u021f\22\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\22\10"+
    "\1\332\10\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\20\10\1\u01d1\12\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\5\10"+
    "\1\u016a\25\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\16\10\1\352\14\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\3\10"+
    "\1\352\27\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\3\10\1\u0131\27\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\24\10"+
    "\1\u0220\6\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\5\10\1\u0221\16\10\1\153\6\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\27\10\1\u0222\3\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\31\10\1\313\1\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\14\10\1\u0223\16\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\20\10\1\u0224\12\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\24\10\1\u0225\6\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\24\10\1\u0226\6\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\24\10\1\u0227\6\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\3\10\1\u0228\27\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\3\10\1\u0229\27\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\24\10\1\u022a\6\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\5\10\1\u022b\25\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\16\10\1\u022c\14\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\3\10\1\u022d\27\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\4\10\1\u022e\26\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\24\10\1\u022f\6\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\6\10\1\u0230\24\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\3\10\1\u0231\27\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\20\10\1\315\12\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\1\10\1\352\13\10\1\u016e\2\10\1\u01e3\12\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\22\10\1\u0158\10\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\10\10\1\u016a\22\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\4\10\1\313\6\10\2\313\10\10\1\332\5\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\24\10\1\u0232\6\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\22\10\1\u01fc\10\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\10\10\1\u0233\22\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\15\10\1\313\15\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\1\10\1\u0234\31\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\14\10\1\u0131\16\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\5\10\1\u0235\25\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\4\10\1\u0236\26\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\1\10\1\u0237\31\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\3\10\1\313\23\10"+
    "\1\u0151\3\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\16\10\1\u0238\14\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\7\10"+
    "\1\313\23\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\1\10\1\240\31\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\1\10"+
    "\1\u0239\31\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\11\10\1\u023a\21\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\1\u023b"+
    "\32\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\15\10\1\u020f\15\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\17\10\1\u023c"+
    "\13\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\4\10\1\313\6\10\2\313\1\207\7\10"+
    "\1\332\5\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\2\10\1\313\30\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\1\u023d"+
    "\32\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\1\u023e\32\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\1\u023f\32\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\1\u0240\32\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\1\u0241\32\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\22\10\1\u016a"+
    "\10\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\3\10\1\u0242\27\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\25\10\1\u0243"+
    "\5\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\24\10\1\u0244\6\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\3\10\1\u0245"+
    "\27\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\11\10\1\u0246\21\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\1\10\1\313"+
    "\31\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\3\10\1\u0247\27\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\3\10\1\314"+
    "\27\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\5\10\1\u0248\25\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\1\10\1\u0249"+
    "\31\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\17\10\1\357\13\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\17\10\1\u024a"+
    "\13\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\5\10\1\u024b\25\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\24\10\1\u024c"+
    "\6\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\5\10\1\u024d\25\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\22\10\1\u024e"+
    "\10\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\1\10\1\u01ff\31\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\1\u024f\32\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\24\10\1\u0250\6\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\6\10\1\u0251\24\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\15\10\1\u0252\15\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\5\10\1\u0253\25\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\14\10\1\u0254\16\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\14\10\1\u0255\16\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\24\10\1\u0256\6\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\15\10\1\207\15\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\20\10"+
    "\4\0\1\u0257\32\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\1\u0258\32\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\1\u0259"+
    "\32\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\1\u025a\32\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\20\10\4\0\1\u025b\32\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\1\10\1\u025c\31\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\20\10\4\0\5\10\1\u025d\25\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\20\10\4\0"+
    "\1\u025e\32\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\24\10\1\u025f\6\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\17\10"+
    "\1\u0173\13\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\3\10\1\u0260\27\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\22\10"+
    "\1\u0261\10\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\5\10\1\u0262\25\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\22\10"+
    "\1\u0263\10\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\20\10\1\u0264\12\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\3\10"+
    "\1\u0265\27\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\5\10\1\u0266\25\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\5\10"+
    "\1\u0267\25\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\4\10\1\u0268\26\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\5\10"+
    "\1\u0269\25\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\23\10\1\u026a\7\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\3\10"+
    "\1\u026b\27\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\5\10\1\u026c\25\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\4\10"+
    "\1\u026d\26\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\22\10\1\u026e\10\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\1\10"+
    "\1\u026f\31\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\24\10\1\u0270\6\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\1\10"+
    "\1\u0271\31\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\5\10\1\u0272\25\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\23\10"+
    "\1\u0273\7\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\23\10\1\u0274\7\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\24\10"+
    "\1\u0275\6\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\24\10\1\u0276\6\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\20\10\4\0\24\10"+
    "\1\u0277\6\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\20\10\4\0\1\u0278\32\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\3\10\1\u0279"+
    "\27\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\1\10\1\u027a\31\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\20\10\4\0\23\10\1\u027b"+
    "\7\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\20\10\4\0\24\10\1\u027c\6\10\4\0\1\10";

  private static int [] zzUnpackTrans() {
    int [] result = new int[44856];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** Error code for "Unknown internal scanner error". */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  /** Error code for "could not match input". */
  private static final int ZZ_NO_MATCH = 1;
  /** Error code for "pushback value was too large". */
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /**
   * Error messages for {@link #ZZ_UNKNOWN_ERROR}, {@link #ZZ_NO_MATCH}, and
   * {@link #ZZ_PUSHBACK_2BIG} respectively.
   */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\1\11\11\1\2\11\2\1\1\11\5\1\2\11"+
    "\5\1\2\11\26\1\1\11\1\1\2\11\1\0\2\11"+
    "\3\0\1\1\4\11\1\0\5\11\3\1\1\11\1\1"+
    "\1\11\1\1\2\11\2\1\3\11\1\1\1\0\1\1"+
    "\1\11\134\1\2\11\4\1\1\0\1\1\1\0\1\1"+
    "\3\11\176\1\1\11\1\0\u0138\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[636];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** Input device. */
  private java.io.Reader zzReader;

  /** Current state of the DFA. */
  private int zzState;

  /** Current lexical state. */
  private int zzLexicalState = YYINITIAL;

  /**
   * This buffer contains the current text to be matched and is the source of the {@link #yytext()}
   * string.
   */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** Text position at the last accepting state. */
  private int zzMarkedPos;

  /** Current text position in the buffer. */
  private int zzCurrentPos;

  /** Marks the beginning of the {@link #yytext()} string in the buffer. */
  private int zzStartRead;

  /** Marks the last character in the buffer, that has been read from input. */
  private int zzEndRead;

  /**
   * Whether the scanner is at the end of file.
   * @see #yyatEOF
   */
  private boolean zzAtEOF;

  /**
   * The number of occupied positions in {@link #zzBuffer} beyond {@link #zzEndRead}.
   *
   * <p>When a lead/high surrogate has been read from the input stream into the final
   * {@link #zzBuffer} position, this will have a value of 1; otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /** Number of newlines encountered up to the start of the matched text. */
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  private int yycolumn;

  /** Number of characters up to the start of the matched text. */
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  @SuppressWarnings("unused")
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  @SuppressWarnings("unused")
  private boolean zzEOFDone;

  /* user code: */
  public final int getTokenStart() {
      return (int) yychar;
  }

  public final int getTokenEnd() {
      return getTokenStart() + yylength();
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public CppLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  /**
   * Refills the input buffer.
   *
   * @return {@code false} iff there was new input.
   * @exception java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead - zzStartRead);

      /* translate stored positions */
      zzEndRead -= zzStartRead;
      zzCurrentPos -= zzStartRead;
      zzMarkedPos -= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length * 2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException(
          "Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
        if (numRead == requested) { // We requested too few chars to encode a full Unicode character
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        } else {                    // There is room in the buffer for at least one more char
          int c = zzReader.read();  // Expecting to read a paired low surrogate char
          if (c == -1) {
            return true;
          } else {
            zzBuffer[zzEndRead++] = (char)c;
          }
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }


  /**
   * Closes the input reader.
   *
   * @throws java.io.IOException if the reader could not be closed.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true; // indicate end of file
    zzEndRead = zzStartRead; // invalidate buffer

    if (zzReader != null) {
      zzReader.close();
    }
  }


  /**
   * Resets the scanner to read from a new input stream.
   *
   * <p>Does not close the old reader.
   *
   * <p>All internal variables are reset, the old input stream <b>cannot</b> be reused (internal
   * buffer is discarded and lost). Lexical state is set to {@code ZZ_INITIAL}.
   *
   * <p>Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader The new input stream.
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzEOFDone = false;
    yyResetPosition();
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE) {
      zzBuffer = new char[ZZ_BUFFERSIZE];
    }
  }

  /**
   * Resets the input position.
   */
  private final void yyResetPosition() {
      zzAtBOL  = true;
      zzAtEOF  = false;
      zzCurrentPos = 0;
      zzMarkedPos = 0;
      zzStartRead = 0;
      zzEndRead = 0;
      zzFinalHighSurrogate = 0;
      yyline = 0;
      yycolumn = 0;
      yychar = 0L;
  }


  /**
   * Returns whether the scanner has reached the end of the reader it reads from.
   *
   * @return whether the scanner has reached EOF.
   */
  public final boolean yyatEOF() {
    return zzAtEOF;
  }


  /**
   * Returns the current lexical state.
   *
   * @return the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state.
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   *
   * @return the matched text.
   */
  public final String yytext() {
    return new String(zzBuffer, zzStartRead, zzMarkedPos-zzStartRead);
  }


  /**
   * Returns the character at the given position from the matched text.
   *
   * <p>It is equivalent to {@code yytext().charAt(pos)}, but faster.
   *
   * @param position the position of the character to fetch. A value from 0 to {@code yylength()-1}.
   *
   * @return the character at {@code position}.
   */
  public final char yycharat(int position) {
    return zzBuffer[zzStartRead + position];
  }


  /**
   * How many characters were matched.
   *
   * @return the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * <p>In a well-formed scanner (no or only correct usage of {@code yypushback(int)} and a
   * match-all fallback rule) this method will only be called with things that
   * "Can't Possibly Happen".
   *
   * <p>If this method is called, something is seriously wrong (e.g. a JFlex bug producing a faulty
   * scanner etc.).
   *
   * <p>Usual syntax/scanner level error handling should be done in error fallback rules.
   *
   * @param errorCode the code of the error message to display.
   */
  private static void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    } catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * <p>They will be read again by then next call of the scanning method.
   *
   * @param number the number of characters to be read again. This number must not be greater than
   *     {@link #yylength()}.
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }




  /**
   * Resumes scanning until the next regular expression is matched, the end of input is encountered
   * or an I/O-Error occurs.
   *
   * @return the next token.
   * @exception java.io.IOException if any I/O-Error occurs.
   */
  @NotNull
  public CppToken advance() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char[] zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':  // fall through
        case '\u000C':  // fall through
        case '\u0085':  // fall through
        case '\u2028':  // fall through
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn += zzCharCount;
        }
      }

      if (zzR) {
        // peek one character ahead if it is
        // (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof)
            zzPeek = false;
          else
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
              {
                return CppToken.EOF;
              }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { return CppToken.BAD_CHARACTER;
            }
            // fall through
          case 126: break;
          case 2:
            { return CppToken.WHITESPACE;
            }
            // fall through
          case 127: break;
          case 3:
            { return CppToken.NOT;
            }
            // fall through
          case 128: break;
          case 4:
            { return CppToken.DOUBLE_QUOTED_STRING;
            }
            // fall through
          case 129: break;
          case 5:
            { return CppToken.IDENTIFIER;
            }
            // fall through
          case 130: break;
          case 6:
            { return CppToken.MOD;
            }
            // fall through
          case 131: break;
          case 7:
            { return CppToken.AND;
            }
            // fall through
          case 132: break;
          case 8:
            { return CppToken.SINGLE_QUOTED_STRING;
            }
            // fall through
          case 133: break;
          case 9:
            { return CppToken.LPAREN;
            }
            // fall through
          case 134: break;
          case 10:
            { return CppToken.RPAREN;
            }
            // fall through
          case 135: break;
          case 11:
            { return CppToken.MULT;
            }
            // fall through
          case 136: break;
          case 12:
            { return CppToken.PLUS;
            }
            // fall through
          case 137: break;
          case 13:
            { return CppToken.COMMA;
            }
            // fall through
          case 138: break;
          case 14:
            { return CppToken.MINUS;
            }
            // fall through
          case 139: break;
          case 15:
            { return CppToken.DIV;
            }
            // fall through
          case 140: break;
          case 16:
            { return CppToken.INTEGER_LITERAL;
            }
            // fall through
          case 141: break;
          case 17:
            { return CppToken.COLON;
            }
            // fall through
          case 142: break;
          case 18:
            { return CppToken.SEMICOLON;
            }
            // fall through
          case 143: break;
          case 19:
            { return CppToken.LT;
            }
            // fall through
          case 144: break;
          case 20:
            { return CppToken.EQ;
            }
            // fall through
          case 145: break;
          case 21:
            { return CppToken.GT;
            }
            // fall through
          case 146: break;
          case 22:
            { return CppToken.QUEST;
            }
            // fall through
          case 147: break;
          case 23:
            { return CppToken.LBRACK;
            }
            // fall through
          case 148: break;
          case 24:
            { return CppToken.RBRACK;
            }
            // fall through
          case 149: break;
          case 25:
            { return CppToken.XOR;
            }
            // fall through
          case 150: break;
          case 26:
            { return CppToken.LBRACE;
            }
            // fall through
          case 151: break;
          case 27:
            { return CppToken.OR;
            }
            // fall through
          case 152: break;
          case 28:
            { return CppToken.RBRACE;
            }
            // fall through
          case 153: break;
          case 29:
            { return CppToken.TILDA;
            }
            // fall through
          case 154: break;
          case 30:
            { return CppToken.NOTEQ;
            }
            // fall through
          case 155: break;
          case 31:
            { return CppToken.PREPROCESSOR;
            }
            // fall through
          case 156: break;
          case 32:
            { return CppToken.MODEQ;
            }
            // fall through
          case 157: break;
          case 33:
            { return CppToken.ANDAND;
            }
            // fall through
          case 158: break;
          case 34:
            { return CppToken.ANDEQ;
            }
            // fall through
          case 159: break;
          case 35:
            { return CppToken.MULTEQ;
            }
            // fall through
          case 160: break;
          case 36:
            { return CppToken.PLUSPLUS;
            }
            // fall through
          case 161: break;
          case 37:
            { return CppToken.PLUSEQ;
            }
            // fall through
          case 162: break;
          case 38:
            { return CppToken.MINUSMINUS;
            }
            // fall through
          case 163: break;
          case 39:
            { return CppToken.MINUSEQ;
            }
            // fall through
          case 164: break;
          case 40:
            { return CppToken.DOUBLE_LITERAL;
            }
            // fall through
          case 165: break;
          case 41:
            { return CppToken.BLOCK_COMMENT;
            }
            // fall through
          case 166: break;
          case 42:
            { return CppToken.LINE_COMMENT;
            }
            // fall through
          case 167: break;
          case 43:
            { return CppToken.DIVEQ;
            }
            // fall through
          case 168: break;
          case 44:
            { return CppToken.FLOAT_LITERAL;
            }
            // fall through
          case 169: break;
          case 45:
            { return CppToken.LONG_LITERAL;
            }
            // fall through
          case 170: break;
          case 46:
            { return CppToken.LTLT;
            }
            // fall through
          case 171: break;
          case 47:
            { return CppToken.LTEQ;
            }
            // fall through
          case 172: break;
          case 48:
            { return CppToken.EQEQ;
            }
            // fall through
          case 173: break;
          case 49:
            { return CppToken.GTEQ;
            }
            // fall through
          case 174: break;
          case 50:
            { return CppToken.GTGT;
            }
            // fall through
          case 175: break;
          case 51:
            { return CppToken.XOREQ;
            }
            // fall through
          case 176: break;
          case 52:
            { return CppToken.DO;
            }
            // fall through
          case 177: break;
          case 53:
            { return CppToken.IF;
            }
            // fall through
          case 178: break;
          case 54:
            { return CppToken.OREQ;
            }
            // fall through
          case 179: break;
          case 55:
            { return CppToken.OROR;
            }
            // fall through
          case 180: break;
          case 56:
            { return CppToken.LTLTEQ;
            }
            // fall through
          case 181: break;
          case 57:
            { return CppToken.GTGTEQ;
            }
            // fall through
          case 182: break;
          case 58:
            { return CppToken.TRIGRAPH;
            }
            // fall through
          case 183: break;
          case 59:
            { return CppToken.FUNCTION;
            }
            // fall through
          case 184: break;
          case 60:
            { return CppToken.FOR;
            }
            // fall through
          case 185: break;
          case 61:
            { return CppToken.INT;
            }
            // fall through
          case 186: break;
          case 62:
            { return CppToken.NEW;
            }
            // fall through
          case 187: break;
          case 63:
            { return CppToken.TRY;
            }
            // fall through
          case 188: break;
          case 64:
            { return CppToken.NULL;
            }
            // fall through
          case 189: break;
          case 65:
            { return CppToken.AUTO;
            }
            // fall through
          case 190: break;
          case 66:
            { return CppToken.BOOL;
            }
            // fall through
          case 191: break;
          case 67:
            { return CppToken.CASE;
            }
            // fall through
          case 192: break;
          case 68:
            { return CppToken.CHAR;
            }
            // fall through
          case 193: break;
          case 69:
            { return CppToken.ELSE;
            }
            // fall through
          case 194: break;
          case 70:
            { return CppToken.ENUM;
            }
            // fall through
          case 195: break;
          case 71:
            { return CppToken.GOTO;
            }
            // fall through
          case 196: break;
          case 72:
            { return CppToken.LONG;
            }
            // fall through
          case 197: break;
          case 73:
            { return CppToken.THIS;
            }
            // fall through
          case 198: break;
          case 74:
            { return CppToken.TRUE;
            }
            // fall through
          case 199: break;
          case 75:
            { return CppToken.VOID;
            }
            // fall through
          case 200: break;
          case 76:
            { return CppToken.BREAK;
            }
            // fall through
          case 201: break;
          case 77:
            { return CppToken.CATCH;
            }
            // fall through
          case 202: break;
          case 78:
            { return CppToken.CLASS;
            }
            // fall through
          case 203: break;
          case 79:
            { return CppToken.CONST;
            }
            // fall through
          case 204: break;
          case 80:
            { return CppToken.DIV_T;
            }
            // fall through
          case 205: break;
          case 81:
            { return CppToken.FALSE;
            }
            // fall through
          case 206: break;
          case 82:
            { return CppToken.FLOAT;
            }
            // fall through
          case 207: break;
          case 83:
            { return CppToken.SHORT;
            }
            // fall through
          case 208: break;
          case 84:
            { return CppToken.THROW;
            }
            // fall through
          case 209: break;
          case 85:
            { return CppToken.UNION;
            }
            // fall through
          case 210: break;
          case 86:
            { return CppToken.USING;
            }
            // fall through
          case 211: break;
          case 87:
            { return CppToken.WHILE;
            }
            // fall through
          case 212: break;
          case 88:
            { return CppToken.DELETE;
            }
            // fall through
          case 213: break;
          case 89:
            { return CppToken.DOUBLE;
            }
            // fall through
          case 214: break;
          case 90:
            { return CppToken.EXTERN;
            }
            // fall through
          case 215: break;
          case 91:
            { return CppToken.LDIV_T;
            }
            // fall through
          case 216: break;
          case 92:
            { return CppToken.PUBLIC;
            }
            // fall through
          case 217: break;
          case 93:
            { return CppToken.RETURN;
            }
            // fall through
          case 218: break;
          case 94:
            { return CppToken.SIGNED;
            }
            // fall through
          case 219: break;
          case 95:
            { return CppToken.SIZE_T;
            }
            // fall through
          case 220: break;
          case 96:
            { return CppToken.SIZEOF;
            }
            // fall through
          case 221: break;
          case 97:
            { return CppToken.STATIC;
            }
            // fall through
          case 222: break;
          case 98:
            { return CppToken.STRUCT;
            }
            // fall through
          case 223: break;
          case 99:
            { return CppToken.SWITCH;
            }
            // fall through
          case 224: break;
          case 100:
            { return CppToken.TYPEID;
            }
            // fall through
          case 225: break;
          case 101:
            { return CppToken.DEFAULT;
            }
            // fall through
          case 226: break;
          case 102:
            { return CppToken.MUTABLE;
            }
            // fall through
          case 227: break;
          case 103:
            { return CppToken.PRIVATE;
            }
            // fall through
          case 228: break;
          case 104:
            { return CppToken.TYPEDEF;
            }
            // fall through
          case 229: break;
          case 105:
            { return CppToken.VIRTUAL;
            }
            // fall through
          case 230: break;
          case 106:
            { return CppToken.WCHAR_T;
            }
            // fall through
          case 231: break;
          case 107:
            { return CppToken.__DATE__;
            }
            // fall through
          case 232: break;
          case 108:
            { return CppToken.__FILE__;
            }
            // fall through
          case 233: break;
          case 109:
            { return CppToken.__LINE__;
            }
            // fall through
          case 234: break;
          case 110:
            { return CppToken.__STDC__;
            }
            // fall through
          case 235: break;
          case 111:
            { return CppToken.__TIME__;
            }
            // fall through
          case 236: break;
          case 112:
            { return CppToken.CONTINUE;
            }
            // fall through
          case 237: break;
          case 113:
            { return CppToken.EXPLICIT;
            }
            // fall through
          case 238: break;
          case 114:
            { return CppToken.OPERATOR;
            }
            // fall through
          case 239: break;
          case 115:
            { return CppToken.REGISTER;
            }
            // fall through
          case 240: break;
          case 116:
            { return CppToken.TEMPLATE;
            }
            // fall through
          case 241: break;
          case 117:
            { return CppToken.TYPENAME;
            }
            // fall through
          case 242: break;
          case 118:
            { return CppToken.UNSIGNED;
            }
            // fall through
          case 243: break;
          case 119:
            { return CppToken.VOLATILE;
            }
            // fall through
          case 244: break;
          case 120:
            { return CppToken.NAMESPACE;
            }
            // fall through
          case 245: break;
          case 121:
            { return CppToken.PROTECTED;
            }
            // fall through
          case 246: break;
          case 122:
            { return CppToken.CONST_CAST;
            }
            // fall through
          case 247: break;
          case 123:
            { return CppToken.STATIC_CAST;
            }
            // fall through
          case 248: break;
          case 124:
            { return CppToken.DYNAMIC_CAST;
            }
            // fall through
          case 249: break;
          case 125:
            { return CppToken.REINTERPRET_CAST;
            }
            // fall through
          case 250: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
