/*
 * Copyright 2021 Squircle IDE contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.blacksquircle.ui.language.java.lexer;

import org.jetbrains.annotations.NotNull;

@SuppressWarnings("all")

/**
 * This class is a scanner generated by
 * <a href="http://www.jflex.de/">JFlex</a> 1.8.2
 * from the specification file <tt>java.flex</tt>
 */
public class JavaLexer {

  /** This character denotes the end of file. */
  public static final int YYEOF = -1;

  /** Initial size of the lookahead buffer. */
  private static final int ZZ_BUFFERSIZE = 16384;

  // Lexical states.
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0, 0
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\1\u0100\1\u0200\1\u0300\1\u0400\1\u0500\1\u0600\1\u0700"+
    "\1\u0800\1\u0900\1\u0a00\1\u0b00\1\u0c00\1\u0d00\1\u0e00\1\u0f00"+
    "\1\u1000\1\u0100\1\u1100\1\u1200\1\u1300\1\u0100\1\u1400\1\u1500"+
    "\1\u1600\1\u1700\1\u1800\1\u1900\1\u1a00\1\u1b00\1\u0100\1\u1c00"+
    "\1\u1d00\1\u1e00\12\u1f00\1\u2000\1\u2100\1\u2200\1\u1f00\1\u2300"+
    "\1\u2400\2\u1f00\31\u0100\1\u2500\121\u0100\1\u2600\4\u0100\1\u2700"+
    "\1\u0100\1\u2800\1\u2900\1\u2a00\1\u2b00\1\u2c00\1\u2d00\53\u0100"+
    "\1\u2e00\10\u2f00\31\u1f00\1\u0100\1\u3000\1\u3100\1\u0100\1\u3200"+
    "\1\u3300\1\u3400\1\u3500\1\u3600\1\u3700\1\u3800\1\u3900\3\u1f00"+
    "\1\u3a00\1\u3b00\1\u3c00\1\u3d00\1\u3e00\3\u1f00\1\u3f00\1\u4000"+
    "\4\u1f00\1\u4100\11\u1f00\3\u0100\1\u4200\1\u4300\13\u1f00\4\u0100"+
    "\1\u4400\63\u1f00\2\u0100\1\u4500\4\u1f00\1\u4600\100\u1f00\1\u4700"+
    "\40\u1f00\1\u4800\1\u4900\1\u1f00\1\u4a00\1\u4b00\1\u4c00\1\u4d00"+
    "\26\u1f00\1\u4e00\21\u1f00\246\u0100\1\u4f00\20\u0100\1\u5000\1\u5100"+
    "\77\u1f00\2\u0100\1\u5100\u0b05\u1f00\1\u5200\1\u5300\u02fe\u1f00";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\11\0\1\1\1\2\1\3\1\4\1\5\16\0\4\6"+
    "\1\1\1\7\1\10\1\6\1\11\1\12\1\13\1\14"+
    "\1\15\1\16\1\17\1\20\1\21\1\22\1\23\1\24"+
    "\1\25\11\26\1\27\1\30\1\31\1\32\1\33\1\34"+
    "\1\35\1\36\1\37\1\36\1\40\1\41\1\42\5\43"+
    "\1\44\3\43\1\45\7\43\1\46\2\43\1\47\1\50"+
    "\1\51\1\52\1\53\1\6\1\54\1\55\1\56\1\57"+
    "\1\60\1\61\1\62\1\63\1\64\1\43\1\65\1\66"+
    "\1\67\1\70\1\71\1\72\1\43\1\73\1\74\1\75"+
    "\1\76\1\77\1\100\1\101\1\102\1\103\1\104\1\105"+
    "\1\106\1\107\6\0\1\110\32\0\2\6\4\11\4\6"+
    "\1\11\2\6\1\0\7\6\1\11\4\6\1\11\5\6"+
    "\27\11\1\6\37\11\1\6\u01ca\11\4\6\14\11\16\6"+
    "\5\11\7\6\1\11\1\6\1\11\21\6\160\0\5\11"+
    "\1\6\2\11\2\6\4\11\10\6\1\11\1\6\3\11"+
    "\1\6\1\11\1\6\24\11\1\6\123\11\1\6\213\11"+
    "\1\6\5\0\2\6\236\11\11\6\46\11\2\6\1\11"+
    "\7\6\47\11\7\6\1\11\1\6\55\0\1\6\1\0"+
    "\1\6\2\0\1\6\2\0\1\6\1\0\10\6\33\11"+
    "\5\6\3\11\15\6\5\0\6\6\1\11\4\6\13\0"+
    "\5\6\53\11\37\0\4\6\2\11\1\0\143\11\1\6"+
    "\1\11\10\0\1\6\6\0\2\11\2\0\1\6\4\0"+
    "\2\11\12\0\3\11\2\6\1\11\17\6\1\0\1\11"+
    "\1\0\36\11\33\0\2\6\131\11\13\0\1\11\16\6"+
    "\12\0\41\11\11\0\2\11\4\6\1\11\5\6\26\11"+
    "\4\0\1\11\11\0\1\11\3\0\1\11\5\0\22\6"+
    "\31\11\3\0\104\6\1\11\1\6\13\11\67\6\33\0"+
    "\1\6\4\0\66\11\3\0\1\11\22\0\1\11\7\0"+
    "\12\11\2\0\2\6\12\0\1\6\7\11\1\6\7\11"+
    "\1\6\3\0\1\6\10\11\2\6\2\11\2\6\26\11"+
    "\1\6\7\11\1\6\1\11\3\6\4\11\2\6\1\0"+
    "\1\11\7\0\2\6\2\0\2\6\3\0\1\11\10\6"+
    "\1\0\4\6\2\11\1\6\3\11\2\0\2\6\12\0"+
    "\4\11\7\6\1\11\5\6\3\0\1\6\6\11\4\6"+
    "\2\11\2\6\26\11\1\6\7\11\1\6\2\11\1\6"+
    "\2\11\1\6\2\11\2\6\1\0\1\6\5\0\4\6"+
    "\2\0\2\6\3\0\3\6\1\0\7\6\4\11\1\6"+
    "\1\11\7\6\14\0\3\11\1\0\13\6\3\0\1\6"+
    "\11\11\1\6\3\11\1\6\26\11\1\6\7\11\1\6"+
    "\2\11\1\6\5\11\2\6\1\0\1\11\10\0\1\6"+
    "\3\0\1\6\3\0\2\6\1\11\17\6\2\11\2\0"+
    "\2\6\12\0\1\6\1\11\17\6\3\0\1\6\10\11"+
    "\2\6\2\11\2\6\26\11\1\6\7\11\1\6\2\11"+
    "\1\6\5\11\2\6\1\0\1\11\7\0\2\6\2\0"+
    "\2\6\3\0\10\6\2\0\4\6\2\11\1\6\3\11"+
    "\2\0\2\6\12\0\1\6\1\11\20\6\1\0\1\11"+
    "\1\6\6\11\3\6\3\11\1\6\4\11\3\6\2\11"+
    "\1\6\1\11\1\6\2\11\3\6\2\11\3\6\3\11"+
    "\3\6\14\11\4\6\5\0\3\6\3\0\1\6\4\0"+
    "\2\6\1\11\6\6\1\0\16\6\12\0\11\6\1\11"+
    "\7\6\3\0\1\6\10\11\1\6\3\11\1\6\27\11"+
    "\1\6\12\11\1\6\5\11\3\6\1\11\7\0\1\6"+
    "\3\0\1\6\4\0\7\6\2\0\1\6\2\11\6\6"+
    "\2\11\2\0\2\6\12\0\22\6\2\0\1\6\10\11"+
    "\1\6\3\11\1\6\27\11\1\6\12\11\1\6\5\11"+
    "\2\6\1\0\1\11\7\0\1\6\3\0\1\6\4\0"+
    "\7\6\2\0\7\6\1\11\1\6\2\11\2\0\2\6"+
    "\12\0\1\6\2\11\17\6\2\0\1\6\10\11\1\6"+
    "\3\11\1\6\51\11\2\6\1\11\7\0\1\6\3\0"+
    "\1\6\4\0\1\11\10\6\1\0\10\6\2\11\2\0"+
    "\2\6\12\0\12\6\6\11\2\6\2\0\1\6\22\11"+
    "\3\6\30\11\1\6\11\11\1\6\1\11\2\6\7\11"+
    "\3\6\1\0\4\6\6\0\1\6\1\0\1\6\10\0"+
    "\22\6\2\0\15\6\60\11\1\0\2\11\7\0\4\6"+
    "\10\11\10\0\1\6\12\0\47\6\2\11\1\6\1\11"+
    "\2\6\2\11\1\6\1\11\2\6\1\11\6\6\4\11"+
    "\1\6\7\11\1\6\3\11\1\6\1\11\1\6\1\11"+
    "\2\6\2\11\1\6\4\11\1\0\2\11\6\0\1\6"+
    "\2\0\1\11\2\6\5\11\1\6\1\11\1\6\6\0"+
    "\2\6\12\0\2\6\4\11\40\6\1\11\27\6\2\0"+
    "\6\6\12\0\13\6\1\0\1\6\1\0\1\6\1\0"+
    "\4\6\2\0\10\11\1\6\44\11\4\6\24\0\1\6"+
    "\2\0\5\11\13\0\1\6\44\0\11\6\1\0\71\6"+
    "\53\11\24\0\1\11\12\0\6\6\6\11\4\0\4\11"+
    "\3\0\1\11\3\0\2\11\7\0\3\11\4\0\15\11"+
    "\14\0\1\11\17\0\2\6\46\11\1\6\1\11\5\6"+
    "\1\11\2\6\53\11\1\6\115\11\1\6\4\11\2\6"+
    "\7\11\1\6\1\11\1\6\4\11\2\6\51\11\1\6"+
    "\4\11\2\6\41\11\1\6\4\11\2\6\7\11\1\6"+
    "\1\11\1\6\4\11\2\6\17\11\1\6\71\11\1\6"+
    "\4\11\2\6\103\11\2\6\3\0\40\6\20\11\20\6"+
    "\125\11\14\6\u016c\11\2\6\21\11\1\6\32\11\5\6"+
    "\113\11\3\6\3\11\17\6\15\11\1\6\4\11\3\0"+
    "\13\6\22\11\3\0\13\6\22\11\2\0\14\6\15\11"+
    "\1\6\3\11\1\6\2\0\14\6\64\11\40\0\3\6"+
    "\1\11\3\6\2\11\1\0\2\6\12\0\41\6\3\0"+
    "\2\6\12\0\6\6\130\11\10\6\51\11\1\0\1\11"+
    "\5\6\106\11\12\6\35\11\3\6\14\0\4\6\14\0"+
    "\12\6\12\0\36\11\2\6\5\11\13\6\54\11\4\6"+
    "\21\0\7\11\2\0\6\6\12\0\46\6\27\11\5\0"+
    "\4\6\65\11\12\0\1\6\35\0\2\6\13\0\6\6"+
    "\12\0\15\6\1\11\130\6\5\0\57\11\21\0\7\11"+
    "\4\6\12\0\21\6\11\0\14\6\3\0\36\11\15\0"+
    "\2\11\12\0\54\11\16\0\14\6\44\11\24\0\10\6"+
    "\12\0\3\6\3\11\12\0\44\11\122\6\3\0\1\6"+
    "\25\0\4\11\1\0\4\11\3\0\2\11\11\6\300\11"+
    "\47\0\25\6\4\0\26\11\2\6\6\11\2\6\46\11"+
    "\2\6\6\11\2\6\10\11\1\6\1\11\1\6\1\11"+
    "\1\6\1\11\1\6\37\11\2\6\65\11\1\6\7\11"+
    "\1\6\1\11\3\6\3\11\1\6\7\11\3\6\4\11"+
    "\2\6\6\11\4\6\15\11\5\6\3\11\1\6\7\11"+
    "\16\6\5\0\30\6\2\3\5\0\20\6\2\11\23\6"+
    "\1\11\13\6\5\0\5\6\6\0\1\6\1\11\15\6"+
    "\1\11\20\6\15\11\3\6\33\11\25\6\15\0\4\6"+
    "\1\0\3\6\14\0\21\6\1\11\4\6\1\11\2\6"+
    "\12\11\1\6\1\11\3\6\5\11\6\6\1\11\1\6"+
    "\1\11\1\6\1\11\1\6\4\11\1\6\13\11\2\6"+
    "\4\11\5\6\5\11\4\6\1\11\21\6\51\11\u0177\6"+
    "\57\11\1\6\57\11\1\6\205\11\6\6\4\11\3\0"+
    "\2\11\14\6\46\11\1\6\1\11\5\6\1\11\2\6"+
    "\70\11\7\6\1\11\17\6\1\0\27\11\11\6\7\11"+
    "\1\6\7\11\1\6\7\11\1\6\7\11\1\6\7\11"+
    "\1\6\7\11\1\6\7\11\1\6\7\11\1\6\40\0"+
    "\57\6\1\11\325\6\3\11\31\6\11\11\6\0\1\6"+
    "\5\11\2\6\5\11\4\6\126\11\2\6\2\0\2\6"+
    "\3\11\1\6\132\11\1\6\4\11\5\6\51\11\3\6"+
    "\136\11\21\6\33\11\65\6\306\11\112\6\315\11\63\6"+
    "\215\11\103\6\56\11\2\6\15\11\3\6\20\11\12\0"+
    "\2\11\24\6\57\11\1\0\4\6\12\0\1\6\31\11"+
    "\7\6\1\0\120\11\2\0\45\6\11\11\2\6\147\11"+
    "\2\6\4\11\1\6\4\11\14\6\13\11\115\6\12\11"+
    "\1\0\3\11\1\0\4\11\1\0\27\11\5\0\20\6"+
    "\1\11\7\6\64\11\14\6\2\0\62\11\21\0\13\6"+
    "\12\0\6\6\22\0\6\11\3\6\1\11\4\6\12\0"+
    "\34\11\10\0\2\6\27\11\15\0\14\6\35\11\3\6"+
    "\4\0\57\11\16\0\16\6\1\11\12\0\46\6\51\11"+
    "\16\0\11\6\3\11\1\0\10\11\2\0\2\6\12\0"+
    "\6\6\27\11\3\6\1\11\1\0\4\6\60\11\1\0"+
    "\1\11\3\0\2\11\2\0\5\11\2\0\1\11\1\0"+
    "\1\11\30\6\3\11\2\6\13\11\5\0\2\6\3\11"+
    "\2\0\12\6\6\11\2\6\6\11\2\6\6\11\11\6"+
    "\7\11\1\6\7\11\221\6\43\11\10\0\1\6\2\0"+
    "\2\6\12\0\6\6\244\11\14\6\27\11\4\6\61\11"+
    "\4\6\u0100\3\156\11\2\6\152\11\46\6\7\11\14\6"+
    "\5\11\5\6\1\11\1\0\12\11\1\6\15\11\1\6"+
    "\5\11\1\6\1\11\1\6\2\11\1\6\2\11\1\6"+
    "\154\11\41\6\153\11\22\6\100\11\2\6\66\11\50\6"+
    "\15\11\3\6\20\0\20\6\7\0\14\6\2\11\30\6"+
    "\3\11\31\6\1\11\6\6\5\11\1\6\207\11\2\6"+
    "\1\0\4\6\1\11\13\6\12\0\7\6\32\11\4\6"+
    "\1\11\1\6\32\11\13\6\131\11\3\6\6\11\2\6"+
    "\6\11\2\6\6\11\2\6\3\11\3\6\2\11\3\6"+
    "\2\11\22\6\3\0\4\6\14\11\1\6\32\11\1\6"+
    "\23\11\1\6\2\11\1\6\17\11\2\6\16\11\42\6"+
    "\173\11\105\6\65\11\210\6\1\0\202\6\35\11\3\6"+
    "\61\11\57\6\37\11\21\6\33\11\65\6\36\11\2\6"+
    "\44\11\4\6\10\11\1\6\5\11\52\6\236\11\2\6"+
    "\12\0\126\6\6\11\2\6\1\11\1\6\54\11\1\6"+
    "\2\11\3\6\1\11\2\6\27\11\252\6\26\11\12\6"+
    "\32\11\106\6\70\11\6\6\2\11\100\6\1\11\3\0"+
    "\1\6\2\0\5\6\4\0\4\11\1\6\3\11\1\6"+
    "\33\11\4\6\3\0\4\6\1\0\40\6\35\11\203\6"+
    "\66\11\12\6\26\11\12\6\23\11\215\6\111\11\267\6"+
    "\3\0\65\11\17\0\37\6\12\0\20\6\3\0\55\11"+
    "\13\0\2\6\1\0\22\6\31\11\7\6\12\0\6\6"+
    "\3\0\44\11\16\0\1\6\12\0\100\6\3\0\60\11"+
    "\16\0\4\11\13\6\12\0\246\6\53\11\15\0\10\6"+
    "\12\0\66\6\157\11\221\6\143\11\235\6\57\11\321\6"+
    "\71\11\307\6\105\11\13\6\1\11\56\0\20\6\4\0"+
    "\15\11\140\6\2\11\u0163\6\5\0\3\6\26\0\2\6"+
    "\7\0\36\6\4\0\224\6\3\0\273\6\125\11\1\6"+
    "\107\11\1\6\2\11\2\6\1\11\2\6\2\11\2\6"+
    "\4\11\1\6\14\11\1\6\1\11\1\6\7\11\1\6"+
    "\101\11\1\6\4\11\2\6\10\11\1\6\7\11\1\6"+
    "\34\11\1\6\4\11\1\6\5\11\1\6\1\11\3\6"+
    "\7\11\1\6\u0154\11\2\6\31\11\1\6\31\11\1\6"+
    "\37\11\1\6\31\11\1\6\37\11\1\6\31\11\1\6"+
    "\37\11\1\6\31\11\1\6\37\11\1\6\31\11\1\6"+
    "\10\11\2\6\62\0\4\11\1\6\33\11\1\6\2\11"+
    "\1\6\1\11\2\6\1\11\1\6\12\11\1\6\4\11"+
    "\1\6\1\11\1\6\1\11\6\6\1\11\4\6\1\11"+
    "\1\6\1\11\1\6\1\11\1\6\3\11\1\6\2\11"+
    "\1\6\1\11\2\6\1\11\1\6\1\11\1\6\1\11"+
    "\1\6\1\11\1\6\1\11\1\6\2\11\1\6\1\11"+
    "\2\6\4\11\1\6\7\11\1\6\4\11\1\6\4\11"+
    "\1\6\1\11\1\6\12\11\1\6\21\11\5\6\3\11"+
    "\1\6\5\11\1\6\21\11\104\6\327\11\51\6\65\11"+
    "\13\6\336\11\343\6\1\0\36\6\140\0\200\6\360\0"+
    "\20\6";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[21504];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\2\2\1\3\1\4\1\5\1\6\1\7"+
    "\1\10\1\11\1\12\1\13\1\14\1\15\1\16\1\17"+
    "\1\20\2\21\1\22\1\23\1\24\1\25\1\26\1\27"+
    "\1\1\1\30\1\31\1\32\20\5\1\33\1\34\1\35"+
    "\1\36\1\0\1\37\1\4\1\0\1\40\1\41\1\42"+
    "\1\10\1\0\1\43\1\44\1\45\1\46\1\47\1\50"+
    "\1\0\1\51\1\52\1\53\1\54\1\21\2\51\1\55"+
    "\1\56\1\21\1\57\1\60\1\61\1\62\1\63\1\64"+
    "\1\65\1\66\12\5\1\67\10\5\1\70\23\5\1\71"+
    "\1\72\2\4\2\10\1\73\1\0\1\51\1\0\1\21"+
    "\1\74\1\75\1\76\22\5\1\77\3\5\1\100\2\5"+
    "\1\101\20\5\1\102\3\5\1\52\1\0\4\5\1\103"+
    "\1\104\1\5\1\105\5\5\1\106\1\107\4\5\1\110"+
    "\4\5\1\111\1\5\1\112\13\5\1\113\2\5\1\114"+
    "\1\115\5\5\1\116\1\117\1\120\1\121\4\5\1\122"+
    "\1\123\1\124\12\5\1\125\2\5\1\126\2\5\1\127"+
    "\2\5\1\130\1\5\1\131\3\5\1\132\3\5\1\133"+
    "\2\5\1\134\3\5\1\135\1\136\1\137\1\5\1\140"+
    "\1\5\1\141\3\5\1\142\1\5\1\143\1\144\1\145"+
    "\3\5\1\146\1\147\5\5\1\150\1\151\4\5\1\152"+
    "\2\5\1\153\2\5\1\154\1\155\1\5\1\156\1\157"+
    "\1\160\2\5\1\161";

  private static int [] zzUnpackAction() {
    int [] result = new int[326];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\111\0\222\0\333\0\u0124\0\u016d\0\u01b6\0\u01ff"+
    "\0\u0248\0\u0291\0\111\0\111\0\u02da\0\u0323\0\111\0\u036c"+
    "\0\u03b5\0\u03fe\0\u0447\0\u0490\0\u04d9\0\111\0\u0522\0\u056b"+
    "\0\u05b4\0\111\0\u05fd\0\111\0\111\0\u0646\0\u068f\0\u06d8"+
    "\0\u0721\0\u076a\0\u07b3\0\u07fc\0\u0845\0\u088e\0\u08d7\0\u0920"+
    "\0\u0969\0\u09b2\0\u09fb\0\u0a44\0\u0a8d\0\u0ad6\0\111\0\u0b1f"+
    "\0\111\0\111\0\u05fd\0\111\0\111\0\u0b68\0\111\0\111"+
    "\0\111\0\111\0\u0bb1\0\111\0\111\0\111\0\111\0\111"+
    "\0\111\0\u0bfa\0\u0c43\0\u0c8c\0\u0cd5\0\111\0\u0d1e\0\111"+
    "\0\u0d67\0\111\0\111\0\u0db0\0\111\0\u0df9\0\111\0\111"+
    "\0\111\0\u0e42\0\u0e8b\0\111\0\u0ed4\0\u0f1d\0\u0f66\0\u0faf"+
    "\0\u0ff8\0\u1041\0\u108a\0\u10d3\0\u111c\0\u1165\0\u11ae\0\u11f7"+
    "\0\u1240\0\u1289\0\u12d2\0\u131b\0\u1364\0\u13ad\0\u13f6\0\u01b6"+
    "\0\u143f\0\u1488\0\u14d1\0\u151a\0\u1563\0\u15ac\0\u15f5\0\u163e"+
    "\0\u1687\0\u16d0\0\u1719\0\u1762\0\u17ab\0\u17f4\0\u183d\0\u1886"+
    "\0\u18cf\0\u1918\0\u1961\0\111\0\111\0\u19aa\0\u19f3\0\u1a3c"+
    "\0\u1a85\0\111\0\u1ace\0\u1b17\0\u1b60\0\u1ba9\0\111\0\111"+
    "\0\111\0\u1bf2\0\u1c3b\0\u1c84\0\u1ccd\0\u1d16\0\u1d5f\0\u1da8"+
    "\0\u1df1\0\u1e3a\0\u1e83\0\u1ecc\0\u1f15\0\u1f5e\0\u1fa7\0\u1ff0"+
    "\0\u2039\0\u2082\0\u20cb\0\u01b6\0\u2114\0\u215d\0\u21a6\0\u21ef"+
    "\0\u2238\0\u2281\0\u01b6\0\u22ca\0\u2313\0\u235c\0\u23a5\0\u23ee"+
    "\0\u2437\0\u2480\0\u24c9\0\u2512\0\u255b\0\u25a4\0\u25ed\0\u2636"+
    "\0\u267f\0\u26c8\0\u2711\0\u01b6\0\u275a\0\u27a3\0\u27ec\0\111"+
    "\0\u2835\0\u287e\0\u28c7\0\u2910\0\u2959\0\u01b6\0\u01b6\0\u29a2"+
    "\0\u01b6\0\u29eb\0\u2a34\0\u2a7d\0\u2ac6\0\u2b0f\0\u01b6\0\u01b6"+
    "\0\u2b58\0\u2ba1\0\u2bea\0\u2c33\0\u01b6\0\u2c7c\0\u2cc5\0\u2d0e"+
    "\0\u2d57\0\u01b6\0\u2da0\0\u01b6\0\u2de9\0\u2e32\0\u2e7b\0\u2ec4"+
    "\0\u2f0d\0\u2f56\0\u2f9f\0\u2fe8\0\u3031\0\u307a\0\u30c3\0\u01b6"+
    "\0\u310c\0\u3155\0\u01b6\0\u01b6\0\u319e\0\u31e7\0\u3230\0\u3279"+
    "\0\u32c2\0\u01b6\0\u01b6\0\u01b6\0\u01b6\0\u330b\0\u3354\0\u339d"+
    "\0\u33e6\0\u01b6\0\u342f\0\u01b6\0\u3478\0\u34c1\0\u350a\0\u3553"+
    "\0\u359c\0\u35e5\0\u362e\0\u3677\0\u36c0\0\u3709\0\u01b6\0\u3752"+
    "\0\u379b\0\u01b6\0\u37e4\0\u382d\0\u3876\0\u38bf\0\u3908\0\u01b6"+
    "\0\u3951\0\u01b6\0\u399a\0\u39e3\0\u3a2c\0\u01b6\0\u3a75\0\u3abe"+
    "\0\u3b07\0\u01b6\0\u3b50\0\u3b99\0\u01b6\0\u3be2\0\u3c2b\0\u3c74"+
    "\0\u01b6\0\u01b6\0\u01b6\0\u3cbd\0\u01b6\0\u3d06\0\u01b6\0\u3d4f"+
    "\0\u3d98\0\u3de1\0\u01b6\0\u3e2a\0\u01b6\0\u01b6\0\u01b6\0\u3e73"+
    "\0\u3ebc\0\u3f05\0\u01b6\0\u01b6\0\u3f4e\0\u3f97\0\u3fe0\0\u4029"+
    "\0\u4072\0\u01b6\0\u01b6\0\u40bb\0\u4104\0\u414d\0\u4196\0\u01b6"+
    "\0\u41df\0\u4228\0\u01b6\0\u4271\0\u42ba\0\u01b6\0\u01b6\0\u4303"+
    "\0\u01b6\0\u01b6\0\u01b6\0\u434c\0\u4395\0\u01b6";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[326];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\2\3\1\2\1\3\1\4\1\2\1\5\1\6"+
    "\1\7\1\10\1\11\1\12\1\13\1\14\1\15\1\16"+
    "\1\17\1\20\1\21\1\22\1\23\1\24\1\25\1\26"+
    "\1\27\1\30\1\31\1\32\1\33\11\7\1\34\1\2"+
    "\1\35\1\36\1\7\1\37\1\40\1\41\1\42\1\43"+
    "\1\44\1\45\1\7\1\46\1\7\1\47\1\7\1\50"+
    "\1\7\1\51\1\52\1\53\1\54\1\7\1\55\1\56"+
    "\3\7\1\57\1\60\1\61\1\62\1\2\146\0\1\63"+
    "\55\0\1\3\32\0\1\63\105\0\1\64\56\0\2\6"+
    "\1\0\2\6\1\0\2\6\1\65\37\6\1\66\40\6"+
    "\1\7\10\0\1\7\13\0\2\7\7\0\11\7\4\0"+
    "\31\7\4\0\1\7\32\0\1\67\71\0\1\70\16\0"+
    "\1\71\56\0\2\12\1\0\2\12\1\0\6\12\1\72"+
    "\33\12\1\73\40\12\32\0\1\74\76\0\1\75\11\0"+
    "\1\76\100\0\1\77\7\0\1\100\1\101\100\0\1\102"+
    "\1\0\2\103\101\0\1\104\4\0\1\105\5\0\1\106"+
    "\101\0\1\103\1\0\2\24\10\0\1\107\1\110\1\111"+
    "\1\112\1\0\1\113\1\0\1\114\4\0\1\24\1\0"+
    "\1\107\1\0\1\110\1\111\1\112\4\0\1\113\12\0"+
    "\1\114\32\0\1\103\1\0\2\24\11\0\1\110\1\111"+
    "\1\112\1\0\1\113\6\0\1\24\3\0\1\110\1\111"+
    "\1\112\4\0\1\113\51\0\1\115\112\0\1\116\1\117"+
    "\110\0\1\120\110\0\1\121\1\122\113\0\11\123\5\0"+
    "\30\123\37\0\1\124\56\0\1\7\10\0\1\7\13\0"+
    "\2\7\7\0\11\7\4\0\2\7\1\125\16\7\1\126"+
    "\7\7\4\0\2\7\10\0\1\7\13\0\2\7\7\0"+
    "\11\7\4\0\16\7\1\127\1\7\1\130\6\7\1\131"+
    "\1\7\4\0\2\7\10\0\1\7\13\0\2\7\7\0"+
    "\11\7\4\0\1\7\1\132\6\7\1\133\2\7\1\134"+
    "\2\7\1\135\12\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\7\0\11\7\4\0\5\7\1\136\10\7\1\137"+
    "\12\7\4\0\2\7\10\0\1\7\13\0\2\7\7\0"+
    "\11\7\4\0\13\7\1\140\1\7\1\141\10\7\1\142"+
    "\2\7\4\0\2\7\10\0\1\7\13\0\2\7\7\0"+
    "\11\7\4\0\1\7\1\143\7\7\1\144\1\7\1\145"+
    "\2\7\1\146\12\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\7\0\11\7\4\0\16\7\1\147\12\7\4\0"+
    "\2\7\10\0\1\7\13\0\2\7\7\0\11\7\4\0"+
    "\6\7\1\150\5\7\1\151\1\152\13\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\7\0\11\7\4\0\16\7"+
    "\1\153\12\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\7\0\11\7\4\0\1\7\1\154\3\7\1\155\15\7"+
    "\1\156\5\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\7\0\11\7\4\0\1\7\1\157\16\7\1\160\2\7"+
    "\1\161\5\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\7\0\11\7\4\0\5\7\1\162\23\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\7\0\11\7\4\0\10\7"+
    "\1\163\11\7\1\164\1\165\1\7\1\166\1\7\1\167"+
    "\1\7\4\0\2\7\10\0\1\7\13\0\2\7\7\0"+
    "\11\7\4\0\10\7\1\170\7\7\1\171\10\7\4\0"+
    "\2\7\10\0\1\7\13\0\2\7\7\0\11\7\4\0"+
    "\16\7\1\172\12\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\7\0\11\7\4\0\10\7\1\173\20\7\4\0"+
    "\1\7\32\0\1\174\52\0\1\175\3\0\1\6\1\176"+
    "\2\6\1\176\1\177\103\6\1\12\1\200\2\12\1\200"+
    "\1\201\103\12\23\0\1\202\112\0\2\103\11\0\1\110"+
    "\1\111\1\112\10\0\1\103\3\0\1\110\1\111\1\112"+
    "\27\0\17\104\1\203\71\104\2\105\4\0\102\105\26\0"+
    "\2\107\15\0\1\113\6\0\1\107\12\0\1\113\42\0"+
    "\1\204\1\0\1\204\2\0\2\204\11\0\1\110\1\0"+
    "\1\112\10\0\1\204\3\0\1\110\1\0\1\112\52\0"+
    "\1\205\1\0\2\206\7\0\5\206\1\0\1\113\6\0"+
    "\7\206\4\0\1\113\54\0\1\207\110\0\1\210\1\211"+
    "\55\0\2\123\1\0\2\123\1\0\7\123\2\0\72\123"+
    "\1\7\10\0\1\7\13\0\2\7\7\0\11\7\4\0"+
    "\21\7\1\212\7\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\7\0\11\7\4\0\21\7\1\213\7\7\4\0"+
    "\2\7\10\0\1\7\13\0\2\7\7\0\11\7\4\0"+
    "\16\7\1\214\12\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\7\0\11\7\4\0\5\7\1\215\23\7\4\0"+
    "\2\7\10\0\1\7\13\0\2\7\7\0\11\7\4\0"+
    "\22\7\1\216\6\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\7\0\11\7\4\0\21\7\1\217\1\220\6\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\1\7\1\221\27\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\1\7\1\222\27\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\15\7\1\223\13\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\6\7\1\224\22\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\23\7\1\225\5\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\21\7\1\226\7\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\23\7\1\227\5\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\22\7\1\230\6\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\13\7\1\231\15\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\15\7\1\232\13\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\16\7\1\233\12\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\20\7\1\234\10\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\22\7\1\235\6\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\17\7\1\236\11\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\21\7\1\237\1\240\6\7\4\0\2\7\10\0"+
    "\1\7\13\0\2\7\7\0\11\7\4\0\15\7\1\241"+
    "\13\7\4\0\2\7\10\0\1\7\13\0\2\7\7\0"+
    "\11\7\4\0\22\7\1\242\6\7\4\0\2\7\10\0"+
    "\1\7\13\0\2\7\7\0\11\7\4\0\25\7\1\243"+
    "\3\7\4\0\2\7\10\0\1\7\13\0\2\7\7\0"+
    "\11\7\4\0\13\7\1\244\15\7\4\0\2\7\10\0"+
    "\1\7\13\0\2\7\7\0\11\7\4\0\3\7\1\245"+
    "\25\7\4\0\2\7\10\0\1\7\13\0\2\7\7\0"+
    "\11\7\4\0\11\7\1\246\4\7\1\247\12\7\4\0"+
    "\2\7\10\0\1\7\13\0\2\7\7\0\11\7\4\0"+
    "\2\7\1\250\26\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\7\0\11\7\4\0\22\7\1\251\6\7\4\0"+
    "\2\7\10\0\1\7\13\0\2\7\7\0\11\7\4\0"+
    "\16\7\1\252\12\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\7\0\11\7\4\0\1\7\1\253\16\7\1\254"+
    "\10\7\4\0\2\7\10\0\1\7\13\0\2\7\7\0"+
    "\11\7\4\0\17\7\1\255\11\7\4\0\2\7\10\0"+
    "\1\7\13\0\2\7\7\0\11\7\4\0\11\7\1\256"+
    "\17\7\4\0\2\7\10\0\1\7\13\0\2\7\7\0"+
    "\11\7\4\0\15\7\1\257\13\7\4\0\2\7\10\0"+
    "\1\7\13\0\2\7\7\0\11\7\4\0\11\7\1\260"+
    "\6\7\1\261\10\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\7\0\11\7\4\0\1\7\1\262\21\7\1\263"+
    "\3\7\1\264\1\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\7\0\11\7\4\0\11\7\1\265\1\7\1\266"+
    "\15\7\4\0\2\7\10\0\1\7\13\0\2\7\7\0"+
    "\11\7\4\0\11\7\1\267\17\7\4\0\1\7\1\6"+
    "\1\176\2\6\1\176\1\177\2\6\1\65\37\6\1\66"+
    "\45\6\1\0\2\6\1\65\37\6\1\66\40\6\1\12"+
    "\1\200\2\12\1\200\1\201\6\12\1\72\33\12\1\73"+
    "\45\12\1\0\6\12\1\72\33\12\1\73\40\12\17\104"+
    "\1\203\4\104\1\270\64\104\25\0\2\204\11\0\1\110"+
    "\1\0\1\112\10\0\1\204\3\0\1\110\1\0\1\112"+
    "\54\0\2\271\7\0\5\271\10\0\7\271\52\0\1\271"+
    "\1\0\2\206\7\0\5\206\1\0\1\113\1\111\5\0"+
    "\7\206\4\0\1\113\3\0\1\111\16\0\1\7\10\0"+
    "\1\7\13\0\2\7\7\0\11\7\4\0\22\7\1\272"+
    "\6\7\4\0\2\7\10\0\1\7\13\0\2\7\7\0"+
    "\11\7\4\0\5\7\1\273\23\7\4\0\2\7\10\0"+
    "\1\7\13\0\2\7\7\0\11\7\4\0\13\7\1\274"+
    "\15\7\4\0\2\7\10\0\1\7\13\0\2\7\7\0"+
    "\11\7\4\0\1\7\1\275\27\7\4\0\2\7\10\0"+
    "\1\7\13\0\2\7\7\0\11\7\4\0\5\7\1\276"+
    "\23\7\4\0\2\7\10\0\1\7\13\0\2\7\7\0"+
    "\11\7\4\0\5\7\1\277\23\7\4\0\2\7\10\0"+
    "\1\7\13\0\2\7\7\0\11\7\4\0\3\7\1\300"+
    "\25\7\4\0\2\7\10\0\1\7\13\0\2\7\7\0"+
    "\11\7\4\0\20\7\1\301\10\7\4\0\2\7\10\0"+
    "\1\7\13\0\2\7\7\0\11\7\4\0\21\7\1\302"+
    "\7\7\4\0\2\7\10\0\1\7\13\0\2\7\7\0"+
    "\11\7\4\0\21\7\1\303\1\304\6\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\7\0\11\7\4\0\1\7"+
    "\1\305\27\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\7\0\11\7\4\0\2\7\1\306\26\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\7\0\11\7\4\0\5\7"+
    "\1\307\23\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\7\0\11\7\4\0\14\7\1\310\14\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\7\0\11\7\4\0\5\7"+
    "\1\311\23\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\7\0\11\7\4\0\21\7\1\312\7\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\7\0\11\7\4\0\1\7"+
    "\1\313\27\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\7\0\11\7\4\0\1\7\1\314\27\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\7\0\11\7\4\0\16\7"+
    "\1\315\12\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\7\0\11\7\4\0\13\7\1\316\2\7\1\317\12\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\22\7\1\320\6\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\5\7\1\321\23\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\7\7\1\322\21\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\11\7\1\323\17\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\13\7\1\324\15\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\12\7\1\325\16\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\24\7\1\326\4\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\22\7\1\327\6\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\13\7\1\330\15\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\23\7\1\331\5\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\20\7\1\332\10\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\22\7\1\333\6\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\11\7\1\334\17\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\5\7\1\335\23\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\22\7\1\336\6\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\3\7\1\337\25\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\21\7\1\340\7\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\16\7\1\341\12\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\15\7\1\342\13\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\5\7\1\343\23\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\4\7\1\344\24\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\1\7\1\345\27\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\13\7\1\346\15\7\4\0\1\7\25\0\2\271"+
    "\7\0\5\271\2\0\1\111\5\0\7\271\10\0\1\111"+
    "\16\0\1\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\20\7\1\347\10\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\20\7\1\350\10\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\5\7\1\351\23\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\12\7\1\352\16\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\10\7\1\353\20\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\21\7\1\354\7\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\22\7\1\355\6\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\11\7\1\356\17\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\23\7\1\357\5\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\13\7\1\360\15\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\15\7\1\361\13\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\5\7\1\362\23\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\13\7\1\363\15\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\22\7\1\364\6\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\5\7\1\365\23\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\20\7\1\366\10\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\1\7\1\367\27\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\20\7\1\370\10\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\24\7\1\371\4\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\1\7\1\372\27\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\1\7\1\373\27\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\5\7\1\374\23\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\11\7\1\375\17\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\20\7\1\376\10\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\22\7\1\377\6\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\11\7\1\u0100\17\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\3\7\1\u0101\25\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\20\7\1\u0102\10\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\3\7\1\u0103\25\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\10\7\1\u0104\20\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\25\7\1\u0105\3\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\21\7\1\u0106\7\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\22\7\1\u0107\6\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\5\7\1\u0108\23\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\1\7\1\u0109\27\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\22\7\1\u010a\6\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\1\7\1\u010b\27\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\15\7\1\u010c\13\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\13\7\1\u010d\15\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\5\7\1\u010e\23\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\4\7\1\u010f\24\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\13\7\1\u0110\15\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\14\7\1\u0111\14\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\22\7\1\u0112\6\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\15\7\1\u0113\13\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\6\7\1\u0114\22\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\5\7\1\u0115\23\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\7\7\1\u0116\21\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\22\7\1\u0117\6\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\3\7\1\u0118\25\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\3\7\1\u0119\25\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\15\7\1\u011a\13\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\3\7\1\u011b\25\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\22\7\1\u011c\6\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\10\7\1\u011d\20\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\20\7\1\u011e\10\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\21\7\1\u011f\7\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\11\7\1\u0120\17\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\11\7\1\u0121\17\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\3\7\1\u0122\25\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\15\7\1\u0123\13\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\23\7\1\u0124\5\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\22\7\1\u0125\6\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\21\7\1\u0126\7\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\27\7\1\u0127\1\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\5\7\1\u0128\23\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\3\7\1\u0129\25\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\1\7\1\u012a\27\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\5\7\1\u012b\23\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\5\7\1\u012c\23\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\22\7\1\u012d\6\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\6\7\1\u012e\22\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\16\7\1\u012f\12\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\5\7\1\u0130\23\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\13\7\1\u0131\15\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\22\7\1\u0132\6\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\5\7\1\u0133\23\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\15\7\1\u0134\13\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\5\7\1\u0135\23\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\3\7\1\u0136\25\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\5\7\1\u0137\23\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\17\7\1\u0138\11\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\15\7\1\u0139\13\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\15\7\1\u013a\13\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\5\7\1\u013b\23\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\22\7\1\u013c\6\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\16\7\1\u013d\12\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\5\7\1\u013e\23\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\4\7\1\u013f\24\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\11\7\1\u0140\17\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\22\7\1\u0141\6\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\21\7\1\u0142\7\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\7\0\11\7"+
    "\4\0\6\7\1\u0143\22\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\7\0\11\7\4\0\30\7\1\u0144\4\0"+
    "\2\7\10\0\1\7\13\0\2\7\7\0\11\7\4\0"+
    "\5\7\1\u0145\23\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\7\0\11\7\4\0\4\7\1\u0146\24\7\4\0"+
    "\1\7";

  private static int [] zzUnpackTrans() {
    int [] result = new int[17374];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** Error code for "Unknown internal scanner error". */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  /** Error code for "could not match input". */
  private static final int ZZ_NO_MATCH = 1;
  /** Error code for "pushback value was too large". */
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /**
   * Error messages for {@link #ZZ_UNKNOWN_ERROR}, {@link #ZZ_NO_MATCH}, and
   * {@link #ZZ_PUSHBACK_2BIG} respectively.
   */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\1\11\10\1\2\11\2\1\1\11\6\1\1\11"+
    "\3\1\1\11\1\1\2\11\21\1\1\11\1\1\2\11"+
    "\1\0\2\11\1\0\4\11\1\0\6\11\1\0\3\1"+
    "\1\11\1\1\1\11\1\1\2\11\1\1\1\11\1\1"+
    "\3\11\2\1\1\11\47\1\2\11\4\1\1\11\1\0"+
    "\1\1\1\0\1\1\3\11\56\1\1\11\1\0\215\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[326];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** Input device. */
  private java.io.Reader zzReader;

  /** Current state of the DFA. */
  private int zzState;

  /** Current lexical state. */
  private int zzLexicalState = YYINITIAL;

  /**
   * This buffer contains the current text to be matched and is the source of the {@link #yytext()}
   * string.
   */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** Text position at the last accepting state. */
  private int zzMarkedPos;

  /** Current text position in the buffer. */
  private int zzCurrentPos;

  /** Marks the beginning of the {@link #yytext()} string in the buffer. */
  private int zzStartRead;

  /** Marks the last character in the buffer, that has been read from input. */
  private int zzEndRead;

  /**
   * Whether the scanner is at the end of file.
   * @see #yyatEOF
   */
  private boolean zzAtEOF;

  /**
   * The number of occupied positions in {@link #zzBuffer} beyond {@link #zzEndRead}.
   *
   * <p>When a lead/high surrogate has been read from the input stream into the final
   * {@link #zzBuffer} position, this will have a value of 1; otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /** Number of newlines encountered up to the start of the matched text. */
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  private int yycolumn;

  /** Number of characters up to the start of the matched text. */
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  @SuppressWarnings("unused")
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  @SuppressWarnings("unused")
  private boolean zzEOFDone;

  /* user code: */
  public final int getTokenStart() {
      return (int) yychar;
  }

  public final int getTokenEnd() {
      return getTokenStart() + yylength();
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public JavaLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  /**
   * Refills the input buffer.
   *
   * @return {@code false} iff there was new input.
   * @exception java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead - zzStartRead);

      /* translate stored positions */
      zzEndRead -= zzStartRead;
      zzCurrentPos -= zzStartRead;
      zzMarkedPos -= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length * 2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException(
          "Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
        if (numRead == requested) { // We requested too few chars to encode a full Unicode character
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        } else {                    // There is room in the buffer for at least one more char
          int c = zzReader.read();  // Expecting to read a paired low surrogate char
          if (c == -1) {
            return true;
          } else {
            zzBuffer[zzEndRead++] = (char)c;
          }
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }


  /**
   * Closes the input reader.
   *
   * @throws java.io.IOException if the reader could not be closed.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true; // indicate end of file
    zzEndRead = zzStartRead; // invalidate buffer

    if (zzReader != null) {
      zzReader.close();
    }
  }


  /**
   * Resets the scanner to read from a new input stream.
   *
   * <p>Does not close the old reader.
   *
   * <p>All internal variables are reset, the old input stream <b>cannot</b> be reused (internal
   * buffer is discarded and lost). Lexical state is set to {@code ZZ_INITIAL}.
   *
   * <p>Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader The new input stream.
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzEOFDone = false;
    yyResetPosition();
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE) {
      zzBuffer = new char[ZZ_BUFFERSIZE];
    }
  }

  /**
   * Resets the input position.
   */
  private final void yyResetPosition() {
      zzAtBOL  = true;
      zzAtEOF  = false;
      zzCurrentPos = 0;
      zzMarkedPos = 0;
      zzStartRead = 0;
      zzEndRead = 0;
      zzFinalHighSurrogate = 0;
      yyline = 0;
      yycolumn = 0;
      yychar = 0L;
  }


  /**
   * Returns whether the scanner has reached the end of the reader it reads from.
   *
   * @return whether the scanner has reached EOF.
   */
  public final boolean yyatEOF() {
    return zzAtEOF;
  }


  /**
   * Returns the current lexical state.
   *
   * @return the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state.
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   *
   * @return the matched text.
   */
  public final String yytext() {
    return new String(zzBuffer, zzStartRead, zzMarkedPos-zzStartRead);
  }


  /**
   * Returns the character at the given position from the matched text.
   *
   * <p>It is equivalent to {@code yytext().charAt(pos)}, but faster.
   *
   * @param position the position of the character to fetch. A value from 0 to {@code yylength()-1}.
   *
   * @return the character at {@code position}.
   */
  public final char yycharat(int position) {
    return zzBuffer[zzStartRead + position];
  }


  /**
   * How many characters were matched.
   *
   * @return the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * <p>In a well-formed scanner (no or only correct usage of {@code yypushback(int)} and a
   * match-all fallback rule) this method will only be called with things that
   * "Can't Possibly Happen".
   *
   * <p>If this method is called, something is seriously wrong (e.g. a JFlex bug producing a faulty
   * scanner etc.).
   *
   * <p>Usual syntax/scanner level error handling should be done in error fallback rules.
   *
   * @param errorCode the code of the error message to display.
   */
  private static void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    } catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * <p>They will be read again by then next call of the scanning method.
   *
   * @param number the number of characters to be read again. This number must not be greater than
   *     {@link #yylength()}.
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }




  /**
   * Resumes scanning until the next regular expression is matched, the end of input is encountered
   * or an I/O-Error occurs.
   *
   * @return the next token.
   * @exception java.io.IOException if any I/O-Error occurs.
   */
  @NotNull
  public JavaToken advance() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char[] zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':  // fall through
        case '\u000C':  // fall through
        case '\u0085':  // fall through
        case '\u2028':  // fall through
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn += zzCharCount;
        }
      }

      if (zzR) {
        // peek one character ahead if it is
        // (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof)
            zzPeek = false;
          else
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
              {
                return JavaToken.EOF;
              }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { return JavaToken.BAD_CHARACTER;
            }
            // fall through
          case 114: break;
          case 2:
            { return JavaToken.WHITESPACE;
            }
            // fall through
          case 115: break;
          case 3:
            { return JavaToken.NOT;
            }
            // fall through
          case 116: break;
          case 4:
            { return JavaToken.DOUBLE_QUOTED_STRING;
            }
            // fall through
          case 117: break;
          case 5:
            { return JavaToken.IDENTIFIER;
            }
            // fall through
          case 118: break;
          case 6:
            { return JavaToken.MOD;
            }
            // fall through
          case 119: break;
          case 7:
            { return JavaToken.AND;
            }
            // fall through
          case 120: break;
          case 8:
            { return JavaToken.SINGLE_QUOTED_STRING;
            }
            // fall through
          case 121: break;
          case 9:
            { return JavaToken.LPAREN;
            }
            // fall through
          case 122: break;
          case 10:
            { return JavaToken.RPAREN;
            }
            // fall through
          case 123: break;
          case 11:
            { return JavaToken.MULT;
            }
            // fall through
          case 124: break;
          case 12:
            { return JavaToken.PLUS;
            }
            // fall through
          case 125: break;
          case 13:
            { return JavaToken.COMMA;
            }
            // fall through
          case 126: break;
          case 14:
            { return JavaToken.MINUS;
            }
            // fall through
          case 127: break;
          case 15:
            { return JavaToken.DOT;
            }
            // fall through
          case 128: break;
          case 16:
            { return JavaToken.DIV;
            }
            // fall through
          case 129: break;
          case 17:
            { return JavaToken.INTEGER_LITERAL;
            }
            // fall through
          case 130: break;
          case 18:
            { return JavaToken.COLON;
            }
            // fall through
          case 131: break;
          case 19:
            { return JavaToken.SEMICOLON;
            }
            // fall through
          case 132: break;
          case 20:
            { return JavaToken.LT;
            }
            // fall through
          case 133: break;
          case 21:
            { return JavaToken.EQ;
            }
            // fall through
          case 134: break;
          case 22:
            { return JavaToken.GT;
            }
            // fall through
          case 135: break;
          case 23:
            { return JavaToken.QUEST;
            }
            // fall through
          case 136: break;
          case 24:
            { return JavaToken.LBRACK;
            }
            // fall through
          case 137: break;
          case 25:
            { return JavaToken.RBRACK;
            }
            // fall through
          case 138: break;
          case 26:
            { return JavaToken.XOR;
            }
            // fall through
          case 139: break;
          case 27:
            { return JavaToken.LBRACE;
            }
            // fall through
          case 140: break;
          case 28:
            { return JavaToken.OR;
            }
            // fall through
          case 141: break;
          case 29:
            { return JavaToken.RBRACE;
            }
            // fall through
          case 142: break;
          case 30:
            { return JavaToken.TILDE;
            }
            // fall through
          case 143: break;
          case 31:
            { return JavaToken.NOTEQ;
            }
            // fall through
          case 144: break;
          case 32:
            { return JavaToken.MODEQ;
            }
            // fall through
          case 145: break;
          case 33:
            { return JavaToken.ANDAND;
            }
            // fall through
          case 146: break;
          case 34:
            { return JavaToken.ANDEQ;
            }
            // fall through
          case 147: break;
          case 35:
            { return JavaToken.MULTEQ;
            }
            // fall through
          case 148: break;
          case 36:
            { return JavaToken.PLUSPLUS;
            }
            // fall through
          case 149: break;
          case 37:
            { return JavaToken.PLUSEQ;
            }
            // fall through
          case 150: break;
          case 38:
            { return JavaToken.MINUSMINUS;
            }
            // fall through
          case 151: break;
          case 39:
            { return JavaToken.MINUSEQ;
            }
            // fall through
          case 152: break;
          case 40:
            { return JavaToken.ARROW;
            }
            // fall through
          case 153: break;
          case 41:
            { return JavaToken.DOUBLE_LITERAL;
            }
            // fall through
          case 154: break;
          case 42:
            { return JavaToken.BLOCK_COMMENT;
            }
            // fall through
          case 155: break;
          case 43:
            { return JavaToken.LINE_COMMENT;
            }
            // fall through
          case 156: break;
          case 44:
            { return JavaToken.DIVEQ;
            }
            // fall through
          case 157: break;
          case 45:
            { return JavaToken.FLOAT_LITERAL;
            }
            // fall through
          case 158: break;
          case 46:
            { return JavaToken.LONG_LITERAL;
            }
            // fall through
          case 159: break;
          case 47:
            { return JavaToken.DOUBLE_COLON;
            }
            // fall through
          case 160: break;
          case 48:
            { return JavaToken.LTLT;
            }
            // fall through
          case 161: break;
          case 49:
            { return JavaToken.LTEQ;
            }
            // fall through
          case 162: break;
          case 50:
            { return JavaToken.EQEQ;
            }
            // fall through
          case 163: break;
          case 51:
            { return JavaToken.GTEQ;
            }
            // fall through
          case 164: break;
          case 52:
            { return JavaToken.GTGT;
            }
            // fall through
          case 165: break;
          case 53:
            { return JavaToken.ANNOTATION;
            }
            // fall through
          case 166: break;
          case 54:
            { return JavaToken.XOREQ;
            }
            // fall through
          case 167: break;
          case 55:
            { return JavaToken.DO;
            }
            // fall through
          case 168: break;
          case 56:
            { return JavaToken.IF;
            }
            // fall through
          case 169: break;
          case 57:
            { return JavaToken.OREQ;
            }
            // fall through
          case 170: break;
          case 58:
            { return JavaToken.OROR;
            }
            // fall through
          case 171: break;
          case 59:
            { return JavaToken.ELLIPSIS;
            }
            // fall through
          case 172: break;
          case 60:
            { return JavaToken.LTLTEQ;
            }
            // fall through
          case 173: break;
          case 61:
            { return JavaToken.GTGTEQ;
            }
            // fall through
          case 174: break;
          case 62:
            { return JavaToken.GTGTGT;
            }
            // fall through
          case 175: break;
          case 63:
            { return JavaToken.FOR;
            }
            // fall through
          case 176: break;
          case 64:
            { return JavaToken.INT;
            }
            // fall through
          case 177: break;
          case 65:
            { return JavaToken.NEW;
            }
            // fall through
          case 178: break;
          case 66:
            { return JavaToken.TRY;
            }
            // fall through
          case 179: break;
          case 67:
            { return JavaToken.BYTE;
            }
            // fall through
          case 180: break;
          case 68:
            { return JavaToken.CASE;
            }
            // fall through
          case 181: break;
          case 69:
            { return JavaToken.CHAR;
            }
            // fall through
          case 182: break;
          case 70:
            { return JavaToken.ELSE;
            }
            // fall through
          case 183: break;
          case 71:
            { return JavaToken.ENUM;
            }
            // fall through
          case 184: break;
          case 72:
            { return JavaToken.GOTO;
            }
            // fall through
          case 185: break;
          case 73:
            { return JavaToken.LONG;
            }
            // fall through
          case 186: break;
          case 74:
            { return JavaToken.NULL;
            }
            // fall through
          case 187: break;
          case 75:
            { return JavaToken.THIS;
            }
            // fall through
          case 188: break;
          case 76:
            { return JavaToken.TRUE;
            }
            // fall through
          case 189: break;
          case 77:
            { return JavaToken.VOID;
            }
            // fall through
          case 190: break;
          case 78:
            { return JavaToken.BREAK;
            }
            // fall through
          case 191: break;
          case 79:
            { return JavaToken.CATCH;
            }
            // fall through
          case 192: break;
          case 80:
            { return JavaToken.CLASS;
            }
            // fall through
          case 193: break;
          case 81:
            { return JavaToken.CONST;
            }
            // fall through
          case 194: break;
          case 82:
            { return JavaToken.FALSE;
            }
            // fall through
          case 195: break;
          case 83:
            { return JavaToken.FINAL;
            }
            // fall through
          case 196: break;
          case 84:
            { return JavaToken.FLOAT;
            }
            // fall through
          case 197: break;
          case 85:
            { return JavaToken.SHORT;
            }
            // fall through
          case 198: break;
          case 86:
            { return JavaToken.SUPER;
            }
            // fall through
          case 199: break;
          case 87:
            { return JavaToken.THROW;
            }
            // fall through
          case 200: break;
          case 88:
            { return JavaToken.WHILE;
            }
            // fall through
          case 201: break;
          case 89:
            { return JavaToken.ASSERT;
            }
            // fall through
          case 202: break;
          case 90:
            { return JavaToken.DOUBLE;
            }
            // fall through
          case 203: break;
          case 91:
            { return JavaToken.IMPORT;
            }
            // fall through
          case 204: break;
          case 92:
            { return JavaToken.NATIVE;
            }
            // fall through
          case 205: break;
          case 93:
            { return JavaToken.PUBLIC;
            }
            // fall through
          case 206: break;
          case 94:
            { return JavaToken.RETURN;
            }
            // fall through
          case 207: break;
          case 95:
            { return JavaToken.STATIC;
            }
            // fall through
          case 208: break;
          case 96:
            { return JavaToken.SWITCH;
            }
            // fall through
          case 209: break;
          case 97:
            { return JavaToken.THROWS;
            }
            // fall through
          case 210: break;
          case 98:
            { return JavaToken.BOOLEAN;
            }
            // fall through
          case 211: break;
          case 99:
            { return JavaToken.DEFAULT;
            }
            // fall through
          case 212: break;
          case 100:
            { return JavaToken.EXTENDS;
            }
            // fall through
          case 213: break;
          case 101:
            { return JavaToken.FINALLY;
            }
            // fall through
          case 214: break;
          case 102:
            { return JavaToken.PACKAGE;
            }
            // fall through
          case 215: break;
          case 103:
            { return JavaToken.PRIVATE;
            }
            // fall through
          case 216: break;
          case 104:
            { return JavaToken.ABSTRACT;
            }
            // fall through
          case 217: break;
          case 105:
            { return JavaToken.CONTINUE;
            }
            // fall through
          case 218: break;
          case 106:
            { return JavaToken.STRICTFP;
            }
            // fall through
          case 219: break;
          case 107:
            { return JavaToken.VOLATILE;
            }
            // fall through
          case 220: break;
          case 108:
            { return JavaToken.INTERFACE;
            }
            // fall through
          case 221: break;
          case 109:
            { return JavaToken.PROTECTED;
            }
            // fall through
          case 222: break;
          case 110:
            { return JavaToken.TRANSIENT;
            }
            // fall through
          case 223: break;
          case 111:
            { return JavaToken.IMPLEMENTS;
            }
            // fall through
          case 224: break;
          case 112:
            { return JavaToken.INSTANCEOF;
            }
            // fall through
          case 225: break;
          case 113:
            { return JavaToken.SYNCHRONIZED;
            }
            // fall through
          case 226: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
