/*
 * Copyright 2021 Brackeys IDE contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.brackeys.ui.language.javascript.lexer;

import org.jetbrains.annotations.NotNull;

@SuppressWarnings("all")

/**
 * This class is a scanner generated by
 * <a href="http://www.jflex.de/">JFlex</a> 1.8.2
 * from the specification file <tt>javascript.flex</tt>
 */
public class JavaScriptLexer {

  /** This character denotes the end of file. */
  public static final int YYEOF = -1;

  /** Initial size of the lookahead buffer. */
  private static final int ZZ_BUFFERSIZE = 16384;

  // Lexical states.
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0, 0
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\1\u0100\1\u0200\1\u0300\1\u0400\1\u0500\1\u0600\1\u0700"+
    "\1\u0800\1\u0900\1\u0a00\1\u0b00\1\u0c00\1\u0d00\1\u0e00\1\u0f00"+
    "\1\u1000\1\u0100\1\u1100\1\u1200\1\u1300\1\u0100\1\u1400\1\u1500"+
    "\1\u1600\1\u1700\1\u1800\1\u1900\1\u1a00\1\u1b00\1\u0100\1\u1c00"+
    "\1\u1d00\1\u1e00\12\u1f00\1\u2000\1\u2100\1\u2200\1\u1f00\1\u2300"+
    "\1\u2400\2\u1f00\31\u0100\1\u2500\121\u0100\1\u2600\4\u0100\1\u2700"+
    "\1\u0100\1\u2800\1\u2900\1\u2a00\1\u2b00\1\u2c00\1\u2d00\53\u0100"+
    "\1\u2e00\10\u2f00\31\u1f00\1\u0100\1\u3000\1\u3100\1\u0100\1\u3200"+
    "\1\u3300\1\u3400\1\u3500\1\u3600\1\u3700\1\u3800\1\u3900\3\u1f00"+
    "\1\u3a00\1\u3b00\1\u3c00\1\u3d00\1\u3e00\3\u1f00\1\u3f00\1\u4000"+
    "\4\u1f00\1\u4100\11\u1f00\3\u0100\1\u4200\1\u4300\13\u1f00\4\u0100"+
    "\1\u4400\63\u1f00\2\u0100\1\u4500\4\u1f00\1\u4600\100\u1f00\1\u4700"+
    "\40\u1f00\1\u4800\1\u4900\1\u1f00\1\u4a00\1\u4b00\1\u4c00\1\u4d00"+
    "\26\u1f00\1\u4e00\21\u1f00\246\u0100\1\u4f00\20\u0100\1\u5000\1\u5100"+
    "\77\u1f00\2\u0100\1\u5100\u0b05\u1f00\1\u5200\1\u5300\u02fe\u1f00";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\11\0\1\1\1\2\1\3\1\4\1\5\16\0\4\6"+
    "\1\1\1\7\1\10\1\6\1\11\1\12\1\13\1\14"+
    "\1\15\1\16\1\17\1\20\1\21\1\22\1\23\1\24"+
    "\1\25\11\26\1\27\1\30\1\31\1\32\1\33\1\34"+
    "\1\6\1\35\1\36\1\35\1\37\1\40\1\41\5\11"+
    "\1\42\1\11\1\43\1\11\1\44\7\11\1\45\2\11"+
    "\1\46\1\47\1\50\1\51\1\52\1\6\1\53\1\54"+
    "\1\55\1\56\1\57\1\60\1\61\1\62\1\63\1\11"+
    "\1\64\1\65\1\66\1\67\1\70\1\71\1\11\1\72"+
    "\1\73\1\74\1\75\1\76\1\77\1\100\1\101\1\102"+
    "\1\103\1\104\1\105\1\106\6\0\1\107\32\0\2\6"+
    "\4\11\4\6\1\11\2\6\1\0\7\6\1\11\4\6"+
    "\1\11\5\6\27\11\1\6\37\11\1\6\u01ca\11\4\6"+
    "\14\11\16\6\5\11\7\6\1\11\1\6\1\11\21\6"+
    "\160\0\5\11\1\6\2\11\2\6\4\11\10\6\1\11"+
    "\1\6\3\11\1\6\1\11\1\6\24\11\1\6\123\11"+
    "\1\6\213\11\1\6\5\0\2\6\236\11\11\6\46\11"+
    "\2\6\1\11\7\6\47\11\7\6\1\11\1\6\55\0"+
    "\1\6\1\0\1\6\2\0\1\6\2\0\1\6\1\0"+
    "\10\6\33\11\5\6\3\11\15\6\5\0\6\6\1\11"+
    "\4\6\13\0\5\6\53\11\37\0\4\6\2\11\1\0"+
    "\143\11\1\6\1\11\10\0\1\6\6\0\2\11\2\0"+
    "\1\6\4\0\2\11\12\0\3\11\2\6\1\11\17\6"+
    "\1\0\1\11\1\0\36\11\33\0\2\6\131\11\13\0"+
    "\1\11\16\6\12\0\41\11\11\0\2\11\4\6\1\11"+
    "\5\6\26\11\4\0\1\11\11\0\1\11\3\0\1\11"+
    "\5\0\22\6\31\11\3\0\104\6\1\11\1\6\13\11"+
    "\67\6\33\0\1\6\4\0\66\11\3\0\1\11\22\0"+
    "\1\11\7\0\12\11\2\0\2\6\12\0\1\6\7\11"+
    "\1\6\7\11\1\6\3\0\1\6\10\11\2\6\2\11"+
    "\2\6\26\11\1\6\7\11\1\6\1\11\3\6\4\11"+
    "\2\6\1\0\1\11\7\0\2\6\2\0\2\6\3\0"+
    "\1\11\10\6\1\0\4\6\2\11\1\6\3\11\2\0"+
    "\2\6\12\0\4\11\7\6\1\11\5\6\3\0\1\6"+
    "\6\11\4\6\2\11\2\6\26\11\1\6\7\11\1\6"+
    "\2\11\1\6\2\11\1\6\2\11\2\6\1\0\1\6"+
    "\5\0\4\6\2\0\2\6\3\0\3\6\1\0\7\6"+
    "\4\11\1\6\1\11\7\6\14\0\3\11\1\0\13\6"+
    "\3\0\1\6\11\11\1\6\3\11\1\6\26\11\1\6"+
    "\7\11\1\6\2\11\1\6\5\11\2\6\1\0\1\11"+
    "\10\0\1\6\3\0\1\6\3\0\2\6\1\11\17\6"+
    "\2\11\2\0\2\6\12\0\1\6\1\11\17\6\3\0"+
    "\1\6\10\11\2\6\2\11\2\6\26\11\1\6\7\11"+
    "\1\6\2\11\1\6\5\11\2\6\1\0\1\11\7\0"+
    "\2\6\2\0\2\6\3\0\10\6\2\0\4\6\2\11"+
    "\1\6\3\11\2\0\2\6\12\0\1\6\1\11\20\6"+
    "\1\0\1\11\1\6\6\11\3\6\3\11\1\6\4\11"+
    "\3\6\2\11\1\6\1\11\1\6\2\11\3\6\2\11"+
    "\3\6\3\11\3\6\14\11\4\6\5\0\3\6\3\0"+
    "\1\6\4\0\2\6\1\11\6\6\1\0\16\6\12\0"+
    "\11\6\1\11\7\6\3\0\1\6\10\11\1\6\3\11"+
    "\1\6\27\11\1\6\12\11\1\6\5\11\3\6\1\11"+
    "\7\0\1\6\3\0\1\6\4\0\7\6\2\0\1\6"+
    "\2\11\6\6\2\11\2\0\2\6\12\0\22\6\2\0"+
    "\1\6\10\11\1\6\3\11\1\6\27\11\1\6\12\11"+
    "\1\6\5\11\2\6\1\0\1\11\7\0\1\6\3\0"+
    "\1\6\4\0\7\6\2\0\7\6\1\11\1\6\2\11"+
    "\2\0\2\6\12\0\1\6\2\11\17\6\2\0\1\6"+
    "\10\11\1\6\3\11\1\6\51\11\2\6\1\11\7\0"+
    "\1\6\3\0\1\6\4\0\1\11\10\6\1\0\10\6"+
    "\2\11\2\0\2\6\12\0\12\6\6\11\2\6\2\0"+
    "\1\6\22\11\3\6\30\11\1\6\11\11\1\6\1\11"+
    "\2\6\7\11\3\6\1\0\4\6\6\0\1\6\1\0"+
    "\1\6\10\0\22\6\2\0\15\6\60\11\1\0\2\11"+
    "\7\0\4\6\10\11\10\0\1\6\12\0\47\6\2\11"+
    "\1\6\1\11\2\6\2\11\1\6\1\11\2\6\1\11"+
    "\6\6\4\11\1\6\7\11\1\6\3\11\1\6\1\11"+
    "\1\6\1\11\2\6\2\11\1\6\4\11\1\0\2\11"+
    "\6\0\1\6\2\0\1\11\2\6\5\11\1\6\1\11"+
    "\1\6\6\0\2\6\12\0\2\6\4\11\40\6\1\11"+
    "\27\6\2\0\6\6\12\0\13\6\1\0\1\6\1\0"+
    "\1\6\1\0\4\6\2\0\10\11\1\6\44\11\4\6"+
    "\24\0\1\6\2\0\5\11\13\0\1\6\44\0\11\6"+
    "\1\0\71\6\53\11\24\0\1\11\12\0\6\6\6\11"+
    "\4\0\4\11\3\0\1\11\3\0\2\11\7\0\3\11"+
    "\4\0\15\11\14\0\1\11\17\0\2\6\46\11\1\6"+
    "\1\11\5\6\1\11\2\6\53\11\1\6\115\11\1\6"+
    "\4\11\2\6\7\11\1\6\1\11\1\6\4\11\2\6"+
    "\51\11\1\6\4\11\2\6\41\11\1\6\4\11\2\6"+
    "\7\11\1\6\1\11\1\6\4\11\2\6\17\11\1\6"+
    "\71\11\1\6\4\11\2\6\103\11\2\6\3\0\40\6"+
    "\20\11\20\6\125\11\14\6\u016c\11\2\6\21\11\1\6"+
    "\32\11\5\6\113\11\3\6\3\11\17\6\15\11\1\6"+
    "\4\11\3\0\13\6\22\11\3\0\13\6\22\11\2\0"+
    "\14\6\15\11\1\6\3\11\1\6\2\0\14\6\64\11"+
    "\40\0\3\6\1\11\3\6\2\11\1\0\2\6\12\0"+
    "\41\6\3\0\2\6\12\0\6\6\130\11\10\6\51\11"+
    "\1\0\1\11\5\6\106\11\12\6\35\11\3\6\14\0"+
    "\4\6\14\0\12\6\12\0\36\11\2\6\5\11\13\6"+
    "\54\11\4\6\21\0\7\11\2\0\6\6\12\0\46\6"+
    "\27\11\5\0\4\6\65\11\12\0\1\6\35\0\2\6"+
    "\13\0\6\6\12\0\15\6\1\11\130\6\5\0\57\11"+
    "\21\0\7\11\4\6\12\0\21\6\11\0\14\6\3\0"+
    "\36\11\15\0\2\11\12\0\54\11\16\0\14\6\44\11"+
    "\24\0\10\6\12\0\3\6\3\11\12\0\44\11\122\6"+
    "\3\0\1\6\25\0\4\11\1\0\4\11\3\0\2\11"+
    "\11\6\300\11\47\0\25\6\4\0\26\11\2\6\6\11"+
    "\2\6\46\11\2\6\6\11\2\6\10\11\1\6\1\11"+
    "\1\6\1\11\1\6\1\11\1\6\37\11\2\6\65\11"+
    "\1\6\7\11\1\6\1\11\3\6\3\11\1\6\7\11"+
    "\3\6\4\11\2\6\6\11\4\6\15\11\5\6\3\11"+
    "\1\6\7\11\16\6\5\0\30\6\2\3\5\0\20\6"+
    "\2\11\23\6\1\11\13\6\5\0\5\6\6\0\1\6"+
    "\1\11\15\6\1\11\20\6\15\11\3\6\33\11\25\6"+
    "\15\0\4\6\1\0\3\6\14\0\21\6\1\11\4\6"+
    "\1\11\2\6\12\11\1\6\1\11\3\6\5\11\6\6"+
    "\1\11\1\6\1\11\1\6\1\11\1\6\4\11\1\6"+
    "\13\11\2\6\4\11\5\6\5\11\4\6\1\11\21\6"+
    "\51\11\u0177\6\57\11\1\6\57\11\1\6\205\11\6\6"+
    "\4\11\3\0\2\11\14\6\46\11\1\6\1\11\5\6"+
    "\1\11\2\6\70\11\7\6\1\11\17\6\1\0\27\11"+
    "\11\6\7\11\1\6\7\11\1\6\7\11\1\6\7\11"+
    "\1\6\7\11\1\6\7\11\1\6\7\11\1\6\7\11"+
    "\1\6\40\0\57\6\1\11\325\6\3\11\31\6\11\11"+
    "\6\0\1\6\5\11\2\6\5\11\4\6\126\11\2\6"+
    "\2\0\2\6\3\11\1\6\132\11\1\6\4\11\5\6"+
    "\51\11\3\6\136\11\21\6\33\11\65\6\306\11\112\6"+
    "\315\11\63\6\215\11\103\6\56\11\2\6\15\11\3\6"+
    "\20\11\12\0\2\11\24\6\57\11\1\0\4\6\12\0"+
    "\1\6\31\11\7\6\1\0\120\11\2\0\45\6\11\11"+
    "\2\6\147\11\2\6\4\11\1\6\4\11\14\6\13\11"+
    "\115\6\12\11\1\0\3\11\1\0\4\11\1\0\27\11"+
    "\5\0\20\6\1\11\7\6\64\11\14\6\2\0\62\11"+
    "\21\0\13\6\12\0\6\6\22\0\6\11\3\6\1\11"+
    "\4\6\12\0\34\11\10\0\2\6\27\11\15\0\14\6"+
    "\35\11\3\6\4\0\57\11\16\0\16\6\1\11\12\0"+
    "\46\6\51\11\16\0\11\6\3\11\1\0\10\11\2\0"+
    "\2\6\12\0\6\6\27\11\3\6\1\11\1\0\4\6"+
    "\60\11\1\0\1\11\3\0\2\11\2\0\5\11\2\0"+
    "\1\11\1\0\1\11\30\6\3\11\2\6\13\11\5\0"+
    "\2\6\3\11\2\0\12\6\6\11\2\6\6\11\2\6"+
    "\6\11\11\6\7\11\1\6\7\11\221\6\43\11\10\0"+
    "\1\6\2\0\2\6\12\0\6\6\244\11\14\6\27\11"+
    "\4\6\61\11\4\6\u0100\3\156\11\2\6\152\11\46\6"+
    "\7\11\14\6\5\11\5\6\1\11\1\0\12\11\1\6"+
    "\15\11\1\6\5\11\1\6\1\11\1\6\2\11\1\6"+
    "\2\11\1\6\154\11\41\6\153\11\22\6\100\11\2\6"+
    "\66\11\50\6\15\11\3\6\20\0\20\6\7\0\14\6"+
    "\2\11\30\6\3\11\31\6\1\11\6\6\5\11\1\6"+
    "\207\11\2\6\1\0\4\6\1\11\13\6\12\0\7\6"+
    "\32\11\4\6\1\11\1\6\32\11\13\6\131\11\3\6"+
    "\6\11\2\6\6\11\2\6\6\11\2\6\3\11\3\6"+
    "\2\11\3\6\2\11\22\6\3\0\4\6\14\11\1\6"+
    "\32\11\1\6\23\11\1\6\2\11\1\6\17\11\2\6"+
    "\16\11\42\6\173\11\105\6\65\11\210\6\1\0\202\6"+
    "\35\11\3\6\61\11\57\6\37\11\21\6\33\11\65\6"+
    "\36\11\2\6\44\11\4\6\10\11\1\6\5\11\52\6"+
    "\236\11\2\6\12\0\126\6\6\11\2\6\1\11\1\6"+
    "\54\11\1\6\2\11\3\6\1\11\2\6\27\11\252\6"+
    "\26\11\12\6\32\11\106\6\70\11\6\6\2\11\100\6"+
    "\1\11\3\0\1\6\2\0\5\6\4\0\4\11\1\6"+
    "\3\11\1\6\33\11\4\6\3\0\4\6\1\0\40\6"+
    "\35\11\203\6\66\11\12\6\26\11\12\6\23\11\215\6"+
    "\111\11\267\6\3\0\65\11\17\0\37\6\12\0\20\6"+
    "\3\0\55\11\13\0\2\6\1\0\22\6\31\11\7\6"+
    "\12\0\6\6\3\0\44\11\16\0\1\6\12\0\100\6"+
    "\3\0\60\11\16\0\4\11\13\6\12\0\246\6\53\11"+
    "\15\0\10\6\12\0\66\6\157\11\221\6\143\11\235\6"+
    "\57\11\321\6\71\11\307\6\105\11\13\6\1\11\56\0"+
    "\20\6\4\0\15\11\140\6\2\11\u0163\6\5\0\3\6"+
    "\26\0\2\6\7\0\36\6\4\0\224\6\3\0\273\6"+
    "\125\11\1\6\107\11\1\6\2\11\2\6\1\11\2\6"+
    "\2\11\2\6\4\11\1\6\14\11\1\6\1\11\1\6"+
    "\7\11\1\6\101\11\1\6\4\11\2\6\10\11\1\6"+
    "\7\11\1\6\34\11\1\6\4\11\1\6\5\11\1\6"+
    "\1\11\3\6\7\11\1\6\u0154\11\2\6\31\11\1\6"+
    "\31\11\1\6\37\11\1\6\31\11\1\6\37\11\1\6"+
    "\31\11\1\6\37\11\1\6\31\11\1\6\37\11\1\6"+
    "\31\11\1\6\10\11\2\6\62\0\4\11\1\6\33\11"+
    "\1\6\2\11\1\6\1\11\2\6\1\11\1\6\12\11"+
    "\1\6\4\11\1\6\1\11\1\6\1\11\6\6\1\11"+
    "\4\6\1\11\1\6\1\11\1\6\1\11\1\6\3\11"+
    "\1\6\2\11\1\6\1\11\2\6\1\11\1\6\1\11"+
    "\1\6\1\11\1\6\1\11\1\6\1\11\1\6\2\11"+
    "\1\6\1\11\2\6\4\11\1\6\7\11\1\6\4\11"+
    "\1\6\4\11\1\6\1\11\1\6\12\11\1\6\21\11"+
    "\5\6\3\11\1\6\5\11\1\6\21\11\104\6\327\11"+
    "\51\6\65\11\13\6\336\11\343\6\1\0\36\6\140\0"+
    "\200\6\360\0\20\6";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[21504];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\2\2\1\3\1\4\1\5\1\6\1\7"+
    "\1\10\1\11\1\12\1\13\1\14\1\15\1\16\1\17"+
    "\1\20\2\21\1\22\1\23\1\24\1\25\1\26\1\27"+
    "\1\5\1\30\1\31\1\32\22\5\1\33\1\34\1\35"+
    "\1\36\1\37\1\4\1\0\1\40\1\41\1\42\1\10"+
    "\1\0\1\43\1\44\1\45\1\46\1\47\1\50\1\51"+
    "\1\52\1\53\1\21\2\50\1\54\1\55\1\21\1\56"+
    "\1\57\1\60\1\61\1\62\1\63\1\5\1\64\12\5"+
    "\1\65\12\5\1\66\1\5\1\67\5\5\1\70\21\5"+
    "\1\71\1\72\2\4\2\10\1\0\1\50\1\0\1\21"+
    "\1\73\1\74\1\75\1\76\25\5\1\77\5\5\1\100"+
    "\1\101\2\5\1\102\17\5\1\103\1\5\1\104\5\5"+
    "\1\51\1\0\1\105\4\5\1\106\1\107\1\5\1\110"+
    "\7\5\1\111\1\112\5\5\1\113\1\5\1\114\4\5"+
    "\1\115\1\5\1\116\12\5\1\117\2\5\1\120\1\5"+
    "\1\121\2\5\1\122\1\5\1\123\1\124\1\5\1\125"+
    "\1\126\1\127\1\130\7\5\1\131\1\132\1\133\14\5"+
    "\1\134\1\5\1\135\2\5\1\136\3\5\1\137\1\140"+
    "\4\5\1\141\1\142\1\143\4\5\1\144\2\5\1\145"+
    "\4\5\1\146\1\147\1\150\1\151\1\5\1\152\1\5"+
    "\1\153\1\5\1\154\2\5\1\155\1\156\1\157\4\5"+
    "\1\160\1\161\5\5\1\162\1\163\1\164\7\5\1\165"+
    "\2\5\1\166\1\167\1\170\1\5\1\171\1\172\1\173"+
    "\2\5\1\174";

  private static int [] zzUnpackAction() {
    int [] result = new int[362];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\110\0\110\0\220\0\330\0\u0120\0\u0168\0\u01b0"+
    "\0\u01f8\0\u0240\0\110\0\110\0\u0288\0\u02d0\0\110\0\u0318"+
    "\0\u0360\0\u03a8\0\u03f0\0\u0438\0\110\0\110\0\u0480\0\u04c8"+
    "\0\u0510\0\110\0\u0558\0\110\0\110\0\u05a0\0\u05e8\0\u0630"+
    "\0\u0678\0\u06c0\0\u0708\0\u0750\0\u0798\0\u07e0\0\u0828\0\u0870"+
    "\0\u08b8\0\u0900\0\u0948\0\u0990\0\u09d8\0\u0a20\0\u0a68\0\u0ab0"+
    "\0\110\0\u0af8\0\110\0\110\0\110\0\110\0\u0b40\0\110"+
    "\0\110\0\110\0\110\0\u0b88\0\110\0\110\0\110\0\110"+
    "\0\110\0\u0bd0\0\u0c18\0\u0c60\0\110\0\u0ca8\0\110\0\u0cf0"+
    "\0\110\0\110\0\u0d38\0\u0d80\0\110\0\110\0\110\0\110"+
    "\0\u0dc8\0\u0e10\0\110\0\u0e58\0\u0ea0\0\u0ee8\0\u0f30\0\u0f78"+
    "\0\u0fc0\0\u1008\0\u1050\0\u1098\0\u10e0\0\u1128\0\u1170\0\u11b8"+
    "\0\u1200\0\u1248\0\u1290\0\u12d8\0\u1320\0\u1368\0\u13b0\0\u13f8"+
    "\0\u0168\0\u1440\0\u1488\0\u14d0\0\u1518\0\u1560\0\u15a8\0\u15f0"+
    "\0\u0168\0\u1638\0\u1680\0\u16c8\0\u1710\0\u1758\0\u17a0\0\u17e8"+
    "\0\u1830\0\u1878\0\u18c0\0\u1908\0\u1950\0\u1998\0\u19e0\0\u1a28"+
    "\0\u1a70\0\u1ab8\0\110\0\110\0\u1b00\0\u1b48\0\u1b90\0\u1bd8"+
    "\0\u1c20\0\u1c68\0\u1cb0\0\u1cf8\0\110\0\110\0\u1d40\0\u0168"+
    "\0\u1d88\0\u1dd0\0\u1e18\0\u1e60\0\u1ea8\0\u1ef0\0\u1f38\0\u1f80"+
    "\0\u1fc8\0\u2010\0\u2058\0\u20a0\0\u20e8\0\u2130\0\u2178\0\u21c0"+
    "\0\u2208\0\u2250\0\u2298\0\u22e0\0\u2328\0\u0168\0\u2370\0\u23b8"+
    "\0\u2400\0\u2448\0\u2490\0\u24d8\0\u0168\0\u2520\0\u2568\0\u0168"+
    "\0\u25b0\0\u25f8\0\u2640\0\u2688\0\u26d0\0\u2718\0\u2760\0\u27a8"+
    "\0\u27f0\0\u2838\0\u2880\0\u28c8\0\u2910\0\u2958\0\u29a0\0\u0168"+
    "\0\u29e8\0\u0168\0\u2a30\0\u2a78\0\u2ac0\0\u2b08\0\u2b50\0\110"+
    "\0\u2b98\0\110\0\u2be0\0\u2c28\0\u2c70\0\u2cb8\0\u0168\0\u0168"+
    "\0\u2d00\0\u0168\0\u2d48\0\u2d90\0\u2dd8\0\u2e20\0\u2e68\0\u2eb0"+
    "\0\u2ef8\0\u0168\0\u0168\0\u2f40\0\u2f88\0\u2fd0\0\u3018\0\u3060"+
    "\0\u0168\0\u30a8\0\u0168\0\u30f0\0\u3138\0\u3180\0\u31c8\0\u0168"+
    "\0\u3210\0\u0168\0\u3258\0\u32a0\0\u32e8\0\u3330\0\u3378\0\u33c0"+
    "\0\u3408\0\u3450\0\u3498\0\u34e0\0\u0168\0\u3528\0\u3570\0\u0168"+
    "\0\u35b8\0\u0168\0\u3600\0\u3648\0\u0168\0\u3690\0\u0168\0\u0168"+
    "\0\u36d8\0\u0168\0\u0168\0\u0168\0\u0168\0\u3720\0\u3768\0\u37b0"+
    "\0\u37f8\0\u3840\0\u3888\0\u38d0\0\u0168\0\u3918\0\u0168\0\u3960"+
    "\0\u39a8\0\u39f0\0\u3a38\0\u3a80\0\u3ac8\0\u3b10\0\u3b58\0\u3ba0"+
    "\0\u3be8\0\u3c30\0\u3c78\0\u0168\0\u3cc0\0\u0168\0\u3d08\0\u3d50"+
    "\0\u3d98\0\u3de0\0\u3e28\0\u3e70\0\u0168\0\u0168\0\u3eb8\0\u3f00"+
    "\0\u3f48\0\u3f90\0\u0168\0\u0168\0\u0168\0\u3fd8\0\u4020\0\u4068"+
    "\0\u40b0\0\u0168\0\u40f8\0\u4140\0\u0168\0\u4188\0\u41d0\0\u4218"+
    "\0\u4260\0\u0168\0\u0168\0\u0168\0\u0168\0\u42a8\0\u0168\0\u42f0"+
    "\0\u0168\0\u4338\0\u0168\0\u4380\0\u43c8\0\u0168\0\u0168\0\u0168"+
    "\0\u4410\0\u4458\0\u44a0\0\u44e8\0\u0168\0\u0168\0\u4530\0\u4578"+
    "\0\u45c0\0\u4608\0\u4650\0\u0168\0\u0168\0\u0168\0\u4698\0\u46e0"+
    "\0\u4728\0\u4770\0\u47b8\0\u4800\0\u4848\0\u0168\0\u4890\0\u48d8"+
    "\0\u0168\0\u0168\0\u0168\0\u4920\0\u0168\0\u0168\0\u0168\0\u4968"+
    "\0\u49b0\0\u0168";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[362];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\2\3\1\2\1\3\1\4\1\2\1\5\1\6"+
    "\1\7\1\10\1\11\1\12\1\13\1\14\1\15\1\16"+
    "\1\17\1\20\1\21\1\22\1\23\1\24\1\25\1\26"+
    "\1\27\1\30\1\31\1\32\6\7\1\33\2\7\1\34"+
    "\1\2\1\35\1\36\1\7\1\37\1\40\1\41\1\42"+
    "\1\43\1\44\1\45\1\7\1\46\1\7\1\47\1\7"+
    "\1\50\1\51\1\52\1\53\1\54\1\55\1\7\1\56"+
    "\1\57\1\7\1\60\1\7\1\61\1\62\1\63\1\64"+
    "\1\2\112\0\1\3\137\0\1\65\55\0\2\6\1\0"+
    "\2\6\1\0\2\6\1\66\36\6\1\67\40\6\1\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\31\7"+
    "\4\0\1\7\32\0\1\70\70\0\1\71\16\0\1\72"+
    "\55\0\2\12\1\0\2\12\1\0\6\12\1\73\32\12"+
    "\1\74\40\12\32\0\1\75\75\0\1\76\11\0\1\77"+
    "\77\0\1\100\7\0\1\101\102\0\2\102\100\0\1\103"+
    "\4\0\1\104\5\0\1\105\100\0\1\102\1\0\2\24"+
    "\7\0\1\106\1\107\1\110\1\111\1\112\2\0\1\113"+
    "\4\0\1\24\1\0\1\106\1\0\1\107\1\110\1\111"+
    "\4\0\1\112\12\0\1\113\32\0\1\102\1\0\2\24"+
    "\10\0\1\107\1\110\1\111\1\112\7\0\1\24\3\0"+
    "\1\107\1\110\1\111\4\0\1\112\53\0\1\114\1\115"+
    "\107\0\1\116\1\117\106\0\1\120\1\121\54\0\1\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\1\7"+
    "\1\122\27\7\4\0\1\7\32\0\1\123\55\0\1\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\21\7"+
    "\1\124\3\7\1\125\3\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\16\7\1\126\1\7"+
    "\1\127\6\7\1\130\1\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\1\7\1\131\6\7"+
    "\1\132\2\7\1\133\2\7\1\134\12\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\5\7"+
    "\1\135\10\7\1\136\12\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\13\7\1\137\1\7"+
    "\1\140\10\7\1\141\2\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\1\7\1\142\7\7"+
    "\1\143\1\7\1\144\2\7\1\145\1\7\1\146\2\7"+
    "\1\147\5\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\16\7\1\150\12\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\6\7"+
    "\1\151\5\7\1\152\1\153\13\7\4\0\2\7\10\0"+
    "\1\7\13\0\2\7\6\0\11\7\4\0\5\7\1\154"+
    "\10\7\1\155\12\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\6\0\11\7\4\0\1\7\1\156\3\7\1\157"+
    "\15\7\1\160\5\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\6\0\11\7\4\0\6\7\1\161\22\7\4\0"+
    "\2\7\10\0\1\7\13\0\2\7\6\0\11\7\4\0"+
    "\1\7\1\162\16\7\1\163\2\7\1\164\5\7\4\0"+
    "\2\7\10\0\1\7\13\0\2\7\6\0\11\7\4\0"+
    "\5\7\1\165\23\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\6\0\11\7\4\0\10\7\1\166\11\7\1\167"+
    "\1\170\1\7\1\171\1\7\1\172\1\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\10\7"+
    "\1\173\7\7\1\174\6\7\1\175\1\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\1\7"+
    "\1\176\14\7\1\177\12\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\10\7\1\200\1\201"+
    "\17\7\4\0\2\7\10\0\1\7\13\0\2\7\6\0"+
    "\11\7\4\0\11\7\1\202\17\7\4\0\1\7\32\0"+
    "\1\203\51\0\1\204\3\0\1\6\1\205\2\6\1\205"+
    "\1\206\102\6\1\12\1\207\2\12\1\207\1\210\102\12"+
    "\25\0\2\102\10\0\1\107\1\110\1\111\10\0\1\102"+
    "\3\0\1\107\1\110\1\111\27\0\17\103\1\211\70\103"+
    "\2\104\4\0\101\104\26\0\2\106\13\0\1\112\7\0"+
    "\1\106\12\0\1\112\42\0\1\212\1\0\1\212\2\0"+
    "\2\212\10\0\1\107\1\0\1\111\10\0\1\212\3\0"+
    "\1\107\1\0\1\111\52\0\1\213\1\0\2\214\6\0"+
    "\5\214\1\112\7\0\7\214\4\0\1\112\54\0\1\215"+
    "\107\0\1\216\1\217\54\0\1\7\10\0\1\7\13\0"+
    "\2\7\6\0\6\7\1\220\2\7\4\0\31\7\4\0"+
    "\2\7\10\0\1\7\13\0\2\7\6\0\11\7\4\0"+
    "\27\7\1\221\1\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\6\0\11\7\4\0\1\7\1\222\27\7\4\0"+
    "\2\7\10\0\1\7\13\0\2\7\6\0\11\7\4\0"+
    "\16\7\1\223\12\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\6\0\11\7\4\0\5\7\1\224\23\7\4\0"+
    "\2\7\10\0\1\7\13\0\2\7\6\0\11\7\4\0"+
    "\22\7\1\225\6\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\6\0\11\7\4\0\21\7\1\226\1\227\6\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\1\7\1\230\27\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\1\7\1\231\27\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\15\7\1\232\13\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\2\7\1\233\3\7"+
    "\1\234\4\7\1\235\15\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\23\7\1\236\5\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\21\7\1\237\7\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\23\7\1\240\5\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\17\7\1\241\2\7\1\242\6\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\13\7"+
    "\1\243\15\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\15\7\1\244\13\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\16\7"+
    "\1\245\12\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\20\7\1\246\10\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\16\7"+
    "\1\247\12\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\15\7\1\250\13\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\22\7"+
    "\1\251\6\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\17\7\1\252\11\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\21\7"+
    "\1\253\1\254\6\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\6\0\11\7\4\0\22\7\1\255\6\7\4\0"+
    "\2\7\10\0\1\7\13\0\2\7\6\0\11\7\4\0"+
    "\15\7\1\256\13\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\6\0\11\7\4\0\22\7\1\257\6\7\4\0"+
    "\2\7\10\0\1\7\13\0\2\7\6\0\11\7\4\0"+
    "\25\7\1\260\3\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\6\0\11\7\4\0\13\7\1\261\15\7\4\0"+
    "\2\7\10\0\1\7\13\0\2\7\6\0\11\7\4\0"+
    "\3\7\1\262\25\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\6\0\11\7\4\0\11\7\1\263\4\7\1\264"+
    "\12\7\4\0\2\7\10\0\1\7\13\0\2\7\6\0"+
    "\11\7\4\0\2\7\1\265\26\7\4\0\2\7\10\0"+
    "\1\7\13\0\2\7\6\0\11\7\4\0\22\7\1\266"+
    "\6\7\4\0\2\7\10\0\1\7\13\0\2\7\6\0"+
    "\11\7\4\0\16\7\1\267\12\7\4\0\2\7\10\0"+
    "\1\7\13\0\2\7\6\0\11\7\4\0\1\7\1\270"+
    "\27\7\4\0\2\7\10\0\1\7\13\0\2\7\6\0"+
    "\11\7\4\0\17\7\1\271\11\7\4\0\2\7\10\0"+
    "\1\7\13\0\2\7\6\0\11\7\4\0\11\7\1\272"+
    "\17\7\4\0\2\7\10\0\1\7\13\0\2\7\6\0"+
    "\11\7\4\0\15\7\1\273\13\7\4\0\2\7\10\0"+
    "\1\7\13\0\2\7\6\0\11\7\4\0\11\7\1\274"+
    "\6\7\1\275\10\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\6\0\11\7\4\0\1\7\1\276\21\7\1\277"+
    "\3\7\1\300\1\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\6\0\11\7\4\0\17\7\1\301\11\7\4\0"+
    "\2\7\10\0\1\7\13\0\2\7\6\0\11\7\4\0"+
    "\20\7\1\302\10\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\6\0\11\7\4\0\11\7\1\303\1\7\1\304"+
    "\15\7\4\0\2\7\10\0\1\7\13\0\2\7\6\0"+
    "\11\7\4\0\11\7\1\305\17\7\4\0\2\7\10\0"+
    "\1\7\13\0\2\7\6\0\11\7\4\0\22\7\1\306"+
    "\6\7\4\0\2\7\10\0\1\7\13\0\2\7\6\0"+
    "\11\7\4\0\5\7\1\307\23\7\4\0\1\7\1\6"+
    "\1\205\2\6\1\205\1\206\2\6\1\66\36\6\1\67"+
    "\45\6\1\0\2\6\1\66\36\6\1\67\40\6\1\12"+
    "\1\207\2\12\1\207\1\210\6\12\1\73\32\12\1\74"+
    "\45\12\1\0\6\12\1\73\32\12\1\74\40\12\17\103"+
    "\1\211\4\103\1\310\63\103\25\0\2\212\10\0\1\107"+
    "\1\0\1\111\10\0\1\212\3\0\1\107\1\0\1\111"+
    "\54\0\2\311\6\0\5\311\10\0\7\311\52\0\1\311"+
    "\1\0\2\214\6\0\5\214\1\112\1\0\1\110\5\0"+
    "\7\214\4\0\1\112\3\0\1\110\50\0\1\312\55\0"+
    "\1\7\10\0\1\7\13\0\2\7\6\0\11\7\4\0"+
    "\15\7\1\313\13\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\6\0\11\7\4\0\11\7\1\314\17\7\4\0"+
    "\2\7\10\0\1\7\13\0\2\7\6\0\11\7\4\0"+
    "\13\7\1\315\15\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\6\0\11\7\4\0\1\7\1\316\27\7\4\0"+
    "\2\7\10\0\1\7\13\0\2\7\6\0\11\7\4\0"+
    "\5\7\1\317\23\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\6\0\11\7\4\0\5\7\1\320\23\7\4\0"+
    "\2\7\10\0\1\7\13\0\2\7\6\0\11\7\4\0"+
    "\3\7\1\321\25\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\6\0\11\7\4\0\20\7\1\322\10\7\4\0"+
    "\2\7\10\0\1\7\13\0\2\7\6\0\11\7\4\0"+
    "\21\7\1\323\7\7\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\6\0\11\7\4\0\21\7\1\324\1\325\6\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\23\7\1\326\5\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\1\7\1\327\27\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\5\7\1\330\23\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\2\7\1\331\26\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\5\7\1\332\23\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\14\7\1\333\14\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\16\7\1\334\12\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\5\7\1\335\23\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\21\7\1\336\7\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\1\7\1\337\27\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\1\7\1\340\27\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\14\7\1\341\14\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\3\7\1\342\25\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\16\7\1\343\12\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\13\7\1\344\2\7\1\345\12\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\22\7"+
    "\1\346\6\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\5\7\1\347\23\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\7\7"+
    "\1\350\21\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\11\7\1\351\17\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\13\7"+
    "\1\352\15\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\12\7\1\353\16\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\24\7"+
    "\1\354\4\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\22\7\1\355\6\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\13\7"+
    "\1\356\15\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\23\7\1\357\5\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\20\7"+
    "\1\360\10\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\22\7\1\361\6\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\5\7"+
    "\1\362\23\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\22\7\1\363\6\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\3\7"+
    "\1\364\25\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\21\7\1\365\7\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\16\7"+
    "\1\366\12\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\15\7\1\367\13\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\5\7"+
    "\1\370\23\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\5\7\1\371\23\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\4\7"+
    "\1\372\24\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\1\7\1\373\27\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\13\7"+
    "\1\374\15\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\10\7\1\375\20\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\13\7"+
    "\1\376\15\7\4\0\1\7\25\0\2\311\6\0\5\311"+
    "\2\0\1\110\5\0\7\311\10\0\1\110\16\0\1\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\3\7"+
    "\1\377\25\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\22\7\1\u0100\6\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\5\7"+
    "\1\u0101\23\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\12\7\1\u0102\16\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\10\7"+
    "\1\u0103\20\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\21\7\1\u0104\7\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\22\7"+
    "\1\u0105\6\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\11\7\1\u0106\17\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\7\7"+
    "\1\u0107\21\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\23\7\1\u0108\5\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\22\7"+
    "\1\u0109\6\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\13\7\1\u010a\15\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\20\7"+
    "\1\u010b\10\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\15\7\1\u010c\13\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\5\7"+
    "\1\u010d\23\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\13\7\1\u010e\15\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\22\7"+
    "\1\u010f\6\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\22\7\1\u0110\6\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\5\7"+
    "\1\u0111\23\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\20\7\1\u0112\10\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\1\7"+
    "\1\u0113\27\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\20\7\1\u0114\10\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\24\7"+
    "\1\u0115\4\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\1\7\1\u0116\27\7\4\0\2\7"+
    "\10\0\1\7\13\0\2\7\6\0\11\7\4\0\1\7"+
    "\1\u0117\27\7\4\0\2\7\10\0\1\7\13\0\2\7"+
    "\6\0\11\7\4\0\5\7\1\u0118\10\7\1\u0119\12\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\11\7\1\u011a\17\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\20\7\1\u011b\10\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\22\7\1\u011c\6\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\11\7\1\u011d\17\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\20\7\1\u011e\10\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\3\7\1\u011f\25\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\10\7\1\u0120\20\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\25\7\1\u0121\3\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\21\7\1\u0122\7\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\16\7\1\u0123\12\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\22\7\1\u0124\6\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\5\7\1\u0125\23\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\4\7\1\u0126\24\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\1\7\1\u0127\27\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\15\7\1\u0128\13\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\7\7\1\u0129\21\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\13\7\1\u012a\15\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\5\7\1\u012b\23\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\5\7\1\u012c\23\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\22\7\1\u012d\6\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\4\7\1\u012e\24\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\13\7\1\u012f\15\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\11\7\1\u0130\17\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\14\7\1\u0131\14\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\22\7\1\u0132\6\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\15\7\1\u0133\13\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\6\7\1\u0134\22\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\5\7\1\u0135\23\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\7\7\1\u0136\21\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\22\7\1\u0137\6\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\3\7\1\u0138\25\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\22\7\1\u0139\6\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\3\7\1\u013a\25\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\15\7\1\u013b\13\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\3\7\1\u013c\25\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\10\7\1\u013d\20\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\20\7\1\u013e\10\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\21\7\1\u013f\7\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\11\7\1\u0140\17\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\6\7\1\u0141\22\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\11\7\1\u0142\17\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\15\7\1\u0143\13\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\23\7\1\u0144\5\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\5\7\1\u0145\23\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\22\7\1\u0146\6\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\21\7\1\u0147\7\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\27\7\1\u0148\1\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\16\7\1\u0149\12\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\5\7\1\u014a\23\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\3\7\1\u014b\25\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\1\7\1\u014c\27\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\5\7\1\u014d\23\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\5\7\1\u014e\23\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\22\7\1\u014f\6\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\27\7\1\u0150\1\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\16\7\1\u0151\12\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\5\7\1\u0152\23\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\13\7\1\u0153\15\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\5\7\1\u0154\23\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\20\7\1\u0155\10\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\15\7\1\u0156\13\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\15\7\1\u0157\13\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\5\7\1\u0158\23\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\3\7\1\u0159\25\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\5\7\1\u015a\23\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\17\7\1\u015b\11\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\15\7\1\u015c\13\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\15\7\1\u015d\13\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\5\7\1\u015e\23\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\22\7\1\u015f\6\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\16\7\1\u0160\12\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\5\7\1\u0161\23\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\4\7\1\u0162\24\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\5\7\1\u0163\23\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\11\7\1\u0164\17\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\22\7\1\u0165\6\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\21\7\1\u0166\7\7\4\0\2\7\10\0\1\7"+
    "\13\0\2\7\6\0\11\7\4\0\6\7\1\u0167\22\7"+
    "\4\0\2\7\10\0\1\7\13\0\2\7\6\0\11\7"+
    "\4\0\30\7\1\u0168\4\0\2\7\10\0\1\7\13\0"+
    "\2\7\6\0\11\7\4\0\5\7\1\u0169\23\7\4\0"+
    "\2\7\10\0\1\7\13\0\2\7\6\0\11\7\4\0"+
    "\4\7\1\u016a\24\7\4\0\1\7";

  private static int [] zzUnpackTrans() {
    int [] result = new int[18936];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** Error code for "Unknown internal scanner error". */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  /** Error code for "could not match input". */
  private static final int ZZ_NO_MATCH = 1;
  /** Error code for "pushback value was too large". */
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /**
   * Error messages for {@link #ZZ_UNKNOWN_ERROR}, {@link #ZZ_NO_MATCH}, and
   * {@link #ZZ_PUSHBACK_2BIG} respectively.
   */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\2\11\7\1\2\11\2\1\1\11\5\1\2\11"+
    "\3\1\1\11\1\1\2\11\23\1\1\11\1\1\4\11"+
    "\1\0\4\11\1\0\5\11\3\1\1\11\1\1\1\11"+
    "\1\1\2\11\2\1\4\11\2\1\1\11\57\1\2\11"+
    "\4\1\1\0\1\1\1\0\1\1\2\11\71\1\1\11"+
    "\1\0\1\11\240\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[362];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** Input device. */
  private java.io.Reader zzReader;

  /** Current state of the DFA. */
  private int zzState;

  /** Current lexical state. */
  private int zzLexicalState = YYINITIAL;

  /**
   * This buffer contains the current text to be matched and is the source of the {@link #yytext()}
   * string.
   */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** Text position at the last accepting state. */
  private int zzMarkedPos;

  /** Current text position in the buffer. */
  private int zzCurrentPos;

  /** Marks the beginning of the {@link #yytext()} string in the buffer. */
  private int zzStartRead;

  /** Marks the last character in the buffer, that has been read from input. */
  private int zzEndRead;

  /**
   * Whether the scanner is at the end of file.
   * @see #yyatEOF
   */
  private boolean zzAtEOF;

  /**
   * The number of occupied positions in {@link #zzBuffer} beyond {@link #zzEndRead}.
   *
   * <p>When a lead/high surrogate has been read from the input stream into the final
   * {@link #zzBuffer} position, this will have a value of 1; otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /** Number of newlines encountered up to the start of the matched text. */
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  private int yycolumn;

  /** Number of characters up to the start of the matched text. */
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  @SuppressWarnings("unused")
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  @SuppressWarnings("unused")
  private boolean zzEOFDone;

  /* user code: */
  public final int getTokenStart() {
      return (int) yychar;
  }

  public final int getTokenEnd() {
      return getTokenStart() + yylength();
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public JavaScriptLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  /**
   * Refills the input buffer.
   *
   * @return {@code false} iff there was new input.
   * @exception java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead - zzStartRead);

      /* translate stored positions */
      zzEndRead -= zzStartRead;
      zzCurrentPos -= zzStartRead;
      zzMarkedPos -= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length * 2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException(
          "Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
        if (numRead == requested) { // We requested too few chars to encode a full Unicode character
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        } else {                    // There is room in the buffer for at least one more char
          int c = zzReader.read();  // Expecting to read a paired low surrogate char
          if (c == -1) {
            return true;
          } else {
            zzBuffer[zzEndRead++] = (char)c;
          }
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }


  /**
   * Closes the input reader.
   *
   * @throws java.io.IOException if the reader could not be closed.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true; // indicate end of file
    zzEndRead = zzStartRead; // invalidate buffer

    if (zzReader != null) {
      zzReader.close();
    }
  }


  /**
   * Resets the scanner to read from a new input stream.
   *
   * <p>Does not close the old reader.
   *
   * <p>All internal variables are reset, the old input stream <b>cannot</b> be reused (internal
   * buffer is discarded and lost). Lexical state is set to {@code ZZ_INITIAL}.
   *
   * <p>Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader The new input stream.
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzEOFDone = false;
    yyResetPosition();
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE) {
      zzBuffer = new char[ZZ_BUFFERSIZE];
    }
  }

  /**
   * Resets the input position.
   */
  private final void yyResetPosition() {
      zzAtBOL  = true;
      zzAtEOF  = false;
      zzCurrentPos = 0;
      zzMarkedPos = 0;
      zzStartRead = 0;
      zzEndRead = 0;
      zzFinalHighSurrogate = 0;
      yyline = 0;
      yycolumn = 0;
      yychar = 0L;
  }


  /**
   * Returns whether the scanner has reached the end of the reader it reads from.
   *
   * @return whether the scanner has reached EOF.
   */
  public final boolean yyatEOF() {
    return zzAtEOF;
  }


  /**
   * Returns the current lexical state.
   *
   * @return the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state.
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   *
   * @return the matched text.
   */
  public final String yytext() {
    return new String(zzBuffer, zzStartRead, zzMarkedPos-zzStartRead);
  }


  /**
   * Returns the character at the given position from the matched text.
   *
   * <p>It is equivalent to {@code yytext().charAt(pos)}, but faster.
   *
   * @param position the position of the character to fetch. A value from 0 to {@code yylength()-1}.
   *
   * @return the character at {@code position}.
   */
  public final char yycharat(int position) {
    return zzBuffer[zzStartRead + position];
  }


  /**
   * How many characters were matched.
   *
   * @return the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * <p>In a well-formed scanner (no or only correct usage of {@code yypushback(int)} and a
   * match-all fallback rule) this method will only be called with things that
   * "Can't Possibly Happen".
   *
   * <p>If this method is called, something is seriously wrong (e.g. a JFlex bug producing a faulty
   * scanner etc.).
   *
   * <p>Usual syntax/scanner level error handling should be done in error fallback rules.
   *
   * @param errorCode the code of the error message to display.
   */
  private static void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    } catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * <p>They will be read again by then next call of the scanning method.
   *
   * @param number the number of characters to be read again. This number must not be greater than
   *     {@link #yylength()}.
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }




  /**
   * Resumes scanning until the next regular expression is matched, the end of input is encountered
   * or an I/O-Error occurs.
   *
   * @return the next token.
   * @exception java.io.IOException if any I/O-Error occurs.
   */
  @NotNull
  public JavaScriptToken advance() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char[] zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':  // fall through
        case '\u000C':  // fall through
        case '\u0085':  // fall through
        case '\u2028':  // fall through
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn += zzCharCount;
        }
      }

      if (zzR) {
        // peek one character ahead if it is
        // (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof)
            zzPeek = false;
          else
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
              {
                return JavaScriptToken.EOF;
              }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { return JavaScriptToken.BAD_CHARACTER;
            }
            // fall through
          case 125: break;
          case 2:
            { return JavaScriptToken.WHITESPACE;
            }
            // fall through
          case 126: break;
          case 3:
            { return JavaScriptToken.NOT;
            }
            // fall through
          case 127: break;
          case 4:
            { return JavaScriptToken.DOUBLE_QUOTED_STRING;
            }
            // fall through
          case 128: break;
          case 5:
            { return JavaScriptToken.IDENTIFIER;
            }
            // fall through
          case 129: break;
          case 6:
            { return JavaScriptToken.MOD;
            }
            // fall through
          case 130: break;
          case 7:
            { return JavaScriptToken.AND;
            }
            // fall through
          case 131: break;
          case 8:
            { return JavaScriptToken.SINGLE_QUOTED_STRING;
            }
            // fall through
          case 132: break;
          case 9:
            { return JavaScriptToken.LPAREN;
            }
            // fall through
          case 133: break;
          case 10:
            { return JavaScriptToken.RPAREN;
            }
            // fall through
          case 134: break;
          case 11:
            { return JavaScriptToken.MULT;
            }
            // fall through
          case 135: break;
          case 12:
            { return JavaScriptToken.PLUS;
            }
            // fall through
          case 136: break;
          case 13:
            { return JavaScriptToken.COMMA;
            }
            // fall through
          case 137: break;
          case 14:
            { return JavaScriptToken.MINUS;
            }
            // fall through
          case 138: break;
          case 15:
            { return JavaScriptToken.DOT;
            }
            // fall through
          case 139: break;
          case 16:
            { return JavaScriptToken.DIV;
            }
            // fall through
          case 140: break;
          case 17:
            { return JavaScriptToken.INTEGER_LITERAL;
            }
            // fall through
          case 141: break;
          case 18:
            { return JavaScriptToken.COLON;
            }
            // fall through
          case 142: break;
          case 19:
            { return JavaScriptToken.SEMICOLON;
            }
            // fall through
          case 143: break;
          case 20:
            { return JavaScriptToken.LT;
            }
            // fall through
          case 144: break;
          case 21:
            { return JavaScriptToken.EQ;
            }
            // fall through
          case 145: break;
          case 22:
            { return JavaScriptToken.GT;
            }
            // fall through
          case 146: break;
          case 23:
            { return JavaScriptToken.QUEST;
            }
            // fall through
          case 147: break;
          case 24:
            { return JavaScriptToken.LBRACK;
            }
            // fall through
          case 148: break;
          case 25:
            { return JavaScriptToken.RBRACK;
            }
            // fall through
          case 149: break;
          case 26:
            { return JavaScriptToken.XOR;
            }
            // fall through
          case 150: break;
          case 27:
            { return JavaScriptToken.LBRACE;
            }
            // fall through
          case 151: break;
          case 28:
            { return JavaScriptToken.OR;
            }
            // fall through
          case 152: break;
          case 29:
            { return JavaScriptToken.RBRACE;
            }
            // fall through
          case 153: break;
          case 30:
            { return JavaScriptToken.TILDE;
            }
            // fall through
          case 154: break;
          case 31:
            { return JavaScriptToken.NOTEQ;
            }
            // fall through
          case 155: break;
          case 32:
            { return JavaScriptToken.MODEQ;
            }
            // fall through
          case 156: break;
          case 33:
            { return JavaScriptToken.ANDAND;
            }
            // fall through
          case 157: break;
          case 34:
            { return JavaScriptToken.ANDEQ;
            }
            // fall through
          case 158: break;
          case 35:
            { return JavaScriptToken.MULTEQ;
            }
            // fall through
          case 159: break;
          case 36:
            { return JavaScriptToken.PLUSPLUS;
            }
            // fall through
          case 160: break;
          case 37:
            { return JavaScriptToken.PLUSEQ;
            }
            // fall through
          case 161: break;
          case 38:
            { return JavaScriptToken.MINUSMINUS;
            }
            // fall through
          case 162: break;
          case 39:
            { return JavaScriptToken.MINUSEQ;
            }
            // fall through
          case 163: break;
          case 40:
            { return JavaScriptToken.DOUBLE_LITERAL;
            }
            // fall through
          case 164: break;
          case 41:
            { return JavaScriptToken.BLOCK_COMMENT;
            }
            // fall through
          case 165: break;
          case 42:
            { return JavaScriptToken.LINE_COMMENT;
            }
            // fall through
          case 166: break;
          case 43:
            { return JavaScriptToken.DIVEQ;
            }
            // fall through
          case 167: break;
          case 44:
            { return JavaScriptToken.FLOAT_LITERAL;
            }
            // fall through
          case 168: break;
          case 45:
            { return JavaScriptToken.LONG_LITERAL;
            }
            // fall through
          case 169: break;
          case 46:
            { return JavaScriptToken.LTLT;
            }
            // fall through
          case 170: break;
          case 47:
            { return JavaScriptToken.LTEQ;
            }
            // fall through
          case 171: break;
          case 48:
            { return JavaScriptToken.EQEQ;
            }
            // fall through
          case 172: break;
          case 49:
            { return JavaScriptToken.ARROW;
            }
            // fall through
          case 173: break;
          case 50:
            { return JavaScriptToken.GTEQ;
            }
            // fall through
          case 174: break;
          case 51:
            { return JavaScriptToken.GTGT;
            }
            // fall through
          case 175: break;
          case 52:
            { return JavaScriptToken.XOREQ;
            }
            // fall through
          case 176: break;
          case 53:
            { return JavaScriptToken.DO;
            }
            // fall through
          case 177: break;
          case 54:
            { return JavaScriptToken.IF;
            }
            // fall through
          case 178: break;
          case 55:
            { return JavaScriptToken.IN;
            }
            // fall through
          case 179: break;
          case 56:
            { return JavaScriptToken.OF;
            }
            // fall through
          case 180: break;
          case 57:
            { return JavaScriptToken.OREQ;
            }
            // fall through
          case 181: break;
          case 58:
            { return JavaScriptToken.OROR;
            }
            // fall through
          case 182: break;
          case 59:
            { return JavaScriptToken.LTLTEQ;
            }
            // fall through
          case 183: break;
          case 60:
            { return JavaScriptToken.GTGTEQ;
            }
            // fall through
          case 184: break;
          case 61:
            { return JavaScriptToken.GTGTGT;
            }
            // fall through
          case 185: break;
          case 62:
            { return JavaScriptToken.NAN;
            }
            // fall through
          case 186: break;
          case 63:
            { return JavaScriptToken.FOR;
            }
            // fall through
          case 187: break;
          case 64:
            { return JavaScriptToken.INT;
            }
            // fall through
          case 188: break;
          case 65:
            { return JavaScriptToken.LET;
            }
            // fall through
          case 189: break;
          case 66:
            { return JavaScriptToken.NEW;
            }
            // fall through
          case 190: break;
          case 67:
            { return JavaScriptToken.TRY;
            }
            // fall through
          case 191: break;
          case 68:
            { return JavaScriptToken.VAR;
            }
            // fall through
          case 192: break;
          case 69:
            { return JavaScriptToken.GTGTGTEQ;
            }
            // fall through
          case 193: break;
          case 70:
            { return JavaScriptToken.BYTE;
            }
            // fall through
          case 194: break;
          case 71:
            { return JavaScriptToken.CASE;
            }
            // fall through
          case 195: break;
          case 72:
            { return JavaScriptToken.CHAR;
            }
            // fall through
          case 196: break;
          case 73:
            { return JavaScriptToken.ELSE;
            }
            // fall through
          case 197: break;
          case 74:
            { return JavaScriptToken.ENUM;
            }
            // fall through
          case 198: break;
          case 75:
            { return JavaScriptToken.FROM;
            }
            // fall through
          case 199: break;
          case 76:
            { return JavaScriptToken.GOTO;
            }
            // fall through
          case 200: break;
          case 77:
            { return JavaScriptToken.LONG;
            }
            // fall through
          case 201: break;
          case 78:
            { return JavaScriptToken.NULL;
            }
            // fall through
          case 202: break;
          case 79:
            { return JavaScriptToken.THIS;
            }
            // fall through
          case 203: break;
          case 80:
            { return JavaScriptToken.TRUE;
            }
            // fall through
          case 204: break;
          case 81:
            { return JavaScriptToken.VOID;
            }
            // fall through
          case 205: break;
          case 82:
            { return JavaScriptToken.WITH;
            }
            // fall through
          case 206: break;
          case 83:
            { return JavaScriptToken.ASYNC;
            }
            // fall through
          case 207: break;
          case 84:
            { return JavaScriptToken.AWAIT;
            }
            // fall through
          case 208: break;
          case 85:
            { return JavaScriptToken.BREAK;
            }
            // fall through
          case 209: break;
          case 86:
            { return JavaScriptToken.CATCH;
            }
            // fall through
          case 210: break;
          case 87:
            { return JavaScriptToken.CLASS;
            }
            // fall through
          case 211: break;
          case 88:
            { return JavaScriptToken.CONST;
            }
            // fall through
          case 212: break;
          case 89:
            { return JavaScriptToken.FALSE;
            }
            // fall through
          case 213: break;
          case 90:
            { return JavaScriptToken.FINAL;
            }
            // fall through
          case 214: break;
          case 91:
            { return JavaScriptToken.FLOAT;
            }
            // fall through
          case 215: break;
          case 92:
            { return JavaScriptToken.SHORT;
            }
            // fall through
          case 216: break;
          case 93:
            { return JavaScriptToken.SUPER;
            }
            // fall through
          case 217: break;
          case 94:
            { return JavaScriptToken.THROW;
            }
            // fall through
          case 218: break;
          case 95:
            { return JavaScriptToken.WHILE;
            }
            // fall through
          case 219: break;
          case 96:
            { return JavaScriptToken.YIELD;
            }
            // fall through
          case 220: break;
          case 97:
            { return JavaScriptToken.DELETE;
            }
            // fall through
          case 221: break;
          case 98:
            { return JavaScriptToken.DOUBLE;
            }
            // fall through
          case 222: break;
          case 99:
            { return JavaScriptToken.EXPORT;
            }
            // fall through
          case 223: break;
          case 100:
            { return JavaScriptToken.IMPORT;
            }
            // fall through
          case 224: break;
          case 101:
            { return JavaScriptToken.NATIVE;
            }
            // fall through
          case 225: break;
          case 102:
            { return JavaScriptToken.PUBLIC;
            }
            // fall through
          case 226: break;
          case 103:
            { return JavaScriptToken.RETURN;
            }
            // fall through
          case 227: break;
          case 104:
            { return JavaScriptToken.STATIC;
            }
            // fall through
          case 228: break;
          case 105:
            { return JavaScriptToken.SWITCH;
            }
            // fall through
          case 229: break;
          case 106:
            { return JavaScriptToken.THROWS;
            }
            // fall through
          case 230: break;
          case 107:
            { return JavaScriptToken.TYPEOF;
            }
            // fall through
          case 231: break;
          case 108:
            { return JavaScriptToken.BOOLEAN;
            }
            // fall through
          case 232: break;
          case 109:
            { return JavaScriptToken.DEFAULT;
            }
            // fall through
          case 233: break;
          case 110:
            { return JavaScriptToken.EXTENDS;
            }
            // fall through
          case 234: break;
          case 111:
            { return JavaScriptToken.FINALLY;
            }
            // fall through
          case 235: break;
          case 112:
            { return JavaScriptToken.PACKAGE;
            }
            // fall through
          case 236: break;
          case 113:
            { return JavaScriptToken.PRIVATE;
            }
            // fall through
          case 237: break;
          case 114:
            { return JavaScriptToken.CONTINUE;
            }
            // fall through
          case 238: break;
          case 115:
            { return JavaScriptToken.DEBUGGER;
            }
            // fall through
          case 239: break;
          case 116:
            { return JavaScriptToken.FUNCTION;
            }
            // fall through
          case 240: break;
          case 117:
            { return JavaScriptToken.VOLATILE;
            }
            // fall through
          case 241: break;
          case 118:
            { return JavaScriptToken.INTERFACE;
            }
            // fall through
          case 242: break;
          case 119:
            { return JavaScriptToken.PROTECTED;
            }
            // fall through
          case 243: break;
          case 120:
            { return JavaScriptToken.PROTOTYPE;
            }
            // fall through
          case 244: break;
          case 121:
            { return JavaScriptToken.TRANSIENT;
            }
            // fall through
          case 245: break;
          case 122:
            { return JavaScriptToken.IMPLEMENTS;
            }
            // fall through
          case 246: break;
          case 123:
            { return JavaScriptToken.INSTANCEOF;
            }
            // fall through
          case 247: break;
          case 124:
            { return JavaScriptToken.SYNCHRONIZED;
            }
            // fall through
          case 248: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
