/*
 * Copyright 2021 Squircle IDE contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.blacksquircle.ui.language.python.lexer;

import org.jetbrains.annotations.NotNull;

@SuppressWarnings("all")

/**
 * This class is a scanner generated by
 * <a href="http://www.jflex.de/">JFlex</a> 1.8.2
 * from the specification file <tt>python.flex</tt>
 */
public class PythonLexer {

  /** This character denotes the end of file. */
  public static final int YYEOF = -1;

  /** Initial size of the lookahead buffer. */
  private static final int ZZ_BUFFERSIZE = 16384;

  // Lexical states.
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0, 0
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\1\u0100\1\u0200\1\u0300\1\u0400\1\u0500\1\u0600\1\u0700"+
    "\1\u0800\1\u0900\1\u0a00\1\u0b00\1\u0c00\1\u0d00\1\u0e00\1\u0f00"+
    "\1\u1000\1\u0100\1\u1100\1\u1200\1\u1300\1\u0100\1\u1400\1\u1500"+
    "\1\u1600\1\u1700\1\u1800\1\u1900\1\u1a00\1\u1b00\1\u0100\1\u1c00"+
    "\1\u1d00\1\u1e00\12\u1f00\1\u2000\1\u2100\1\u2200\1\u1f00\1\u2300"+
    "\1\u2400\2\u1f00\31\u0100\1\u2500\121\u0100\1\u2600\4\u0100\1\u2700"+
    "\1\u0100\1\u2800\1\u2900\1\u2a00\1\u2b00\1\u2c00\1\u2d00\53\u0100"+
    "\1\u2e00\10\u2f00\31\u1f00\1\u0100\1\u3000\1\u3100\1\u0100\1\u3200"+
    "\1\u3300\1\u3400\1\u3500\1\u3600\1\u3700\1\u3800\1\u3900\3\u1f00"+
    "\1\u3a00\1\u3b00\1\u3c00\1\u3d00\1\u3e00\3\u1f00\1\u3f00\1\u4000"+
    "\4\u1f00\1\u4100\11\u1f00\3\u0100\1\u4200\1\u4300\13\u1f00\4\u0100"+
    "\1\u4400\63\u1f00\2\u0100\1\u4500\4\u1f00\1\u4600\100\u1f00\1\u4700"+
    "\40\u1f00\1\u4800\1\u4900\1\u1f00\1\u4a00\1\u4b00\1\u4c00\1\u4d00"+
    "\26\u1f00\1\u4e00\21\u1f00\246\u0100\1\u4f00\20\u0100\1\u5000\1\u5100"+
    "\77\u1f00\2\u0100\1\u5100\u0b05\u1f00\1\u5200\1\u5300\u02fe\u1f00";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\11\0\1\1\1\2\1\3\1\4\1\5\16\0\4\6"+
    "\1\1\1\7\1\10\1\11\1\12\1\13\1\14\1\15"+
    "\1\16\1\17\1\20\1\21\1\22\1\23\1\24\1\25"+
    "\1\26\1\27\6\30\2\31\1\32\1\33\1\34\1\35"+
    "\1\36\1\6\1\37\1\40\1\41\2\40\1\42\1\43"+
    "\3\44\1\45\1\44\1\46\1\44\1\47\1\50\4\44"+
    "\1\51\1\52\2\44\1\53\2\44\1\54\1\55\1\56"+
    "\1\57\1\60\1\61\1\62\1\63\1\64\1\65\1\66"+
    "\1\67\1\70\1\71\1\72\1\73\1\74\1\75\1\76"+
    "\1\77\1\100\1\101\1\44\1\102\1\103\1\104\1\105"+
    "\1\106\1\107\1\110\1\111\1\112\1\113\1\114\1\115"+
    "\1\116\6\0\1\117\32\0\2\6\4\12\4\6\1\12"+
    "\2\6\1\0\7\6\1\12\4\6\1\12\5\6\27\12"+
    "\1\6\37\12\1\6\u01ca\12\4\6\14\12\16\6\5\12"+
    "\7\6\1\12\1\6\1\12\21\6\160\0\5\12\1\6"+
    "\2\12\2\6\4\12\10\6\1\12\1\6\3\12\1\6"+
    "\1\12\1\6\24\12\1\6\123\12\1\6\213\12\1\6"+
    "\5\0\2\6\236\12\11\6\46\12\2\6\1\12\7\6"+
    "\47\12\7\6\1\12\1\6\55\0\1\6\1\0\1\6"+
    "\2\0\1\6\2\0\1\6\1\0\10\6\33\12\5\6"+
    "\3\12\15\6\5\0\6\6\1\12\4\6\13\0\5\6"+
    "\53\12\37\0\4\6\2\12\1\0\143\12\1\6\1\12"+
    "\10\0\1\6\6\0\2\12\2\0\1\6\4\0\2\12"+
    "\12\0\3\12\2\6\1\12\17\6\1\0\1\12\1\0"+
    "\36\12\33\0\2\6\131\12\13\0\1\12\16\6\12\0"+
    "\41\12\11\0\2\12\4\6\1\12\5\6\26\12\4\0"+
    "\1\12\11\0\1\12\3\0\1\12\5\0\22\6\31\12"+
    "\3\0\104\6\1\12\1\6\13\12\67\6\33\0\1\6"+
    "\4\0\66\12\3\0\1\12\22\0\1\12\7\0\12\12"+
    "\2\0\2\6\12\0\1\6\7\12\1\6\7\12\1\6"+
    "\3\0\1\6\10\12\2\6\2\12\2\6\26\12\1\6"+
    "\7\12\1\6\1\12\3\6\4\12\2\6\1\0\1\12"+
    "\7\0\2\6\2\0\2\6\3\0\1\12\10\6\1\0"+
    "\4\6\2\12\1\6\3\12\2\0\2\6\12\0\4\12"+
    "\7\6\1\12\5\6\3\0\1\6\6\12\4\6\2\12"+
    "\2\6\26\12\1\6\7\12\1\6\2\12\1\6\2\12"+
    "\1\6\2\12\2\6\1\0\1\6\5\0\4\6\2\0"+
    "\2\6\3\0\3\6\1\0\7\6\4\12\1\6\1\12"+
    "\7\6\14\0\3\12\1\0\13\6\3\0\1\6\11\12"+
    "\1\6\3\12\1\6\26\12\1\6\7\12\1\6\2\12"+
    "\1\6\5\12\2\6\1\0\1\12\10\0\1\6\3\0"+
    "\1\6\3\0\2\6\1\12\17\6\2\12\2\0\2\6"+
    "\12\0\1\6\1\12\17\6\3\0\1\6\10\12\2\6"+
    "\2\12\2\6\26\12\1\6\7\12\1\6\2\12\1\6"+
    "\5\12\2\6\1\0\1\12\7\0\2\6\2\0\2\6"+
    "\3\0\10\6\2\0\4\6\2\12\1\6\3\12\2\0"+
    "\2\6\12\0\1\6\1\12\20\6\1\0\1\12\1\6"+
    "\6\12\3\6\3\12\1\6\4\12\3\6\2\12\1\6"+
    "\1\12\1\6\2\12\3\6\2\12\3\6\3\12\3\6"+
    "\14\12\4\6\5\0\3\6\3\0\1\6\4\0\2\6"+
    "\1\12\6\6\1\0\16\6\12\0\11\6\1\12\7\6"+
    "\3\0\1\6\10\12\1\6\3\12\1\6\27\12\1\6"+
    "\12\12\1\6\5\12\3\6\1\12\7\0\1\6\3\0"+
    "\1\6\4\0\7\6\2\0\1\6\2\12\6\6\2\12"+
    "\2\0\2\6\12\0\22\6\2\0\1\6\10\12\1\6"+
    "\3\12\1\6\27\12\1\6\12\12\1\6\5\12\2\6"+
    "\1\0\1\12\7\0\1\6\3\0\1\6\4\0\7\6"+
    "\2\0\7\6\1\12\1\6\2\12\2\0\2\6\12\0"+
    "\1\6\2\12\17\6\2\0\1\6\10\12\1\6\3\12"+
    "\1\6\51\12\2\6\1\12\7\0\1\6\3\0\1\6"+
    "\4\0\1\12\10\6\1\0\10\6\2\12\2\0\2\6"+
    "\12\0\12\6\6\12\2\6\2\0\1\6\22\12\3\6"+
    "\30\12\1\6\11\12\1\6\1\12\2\6\7\12\3\6"+
    "\1\0\4\6\6\0\1\6\1\0\1\6\10\0\22\6"+
    "\2\0\15\6\60\12\1\0\2\12\7\0\4\6\10\12"+
    "\10\0\1\6\12\0\47\6\2\12\1\6\1\12\2\6"+
    "\2\12\1\6\1\12\2\6\1\12\6\6\4\12\1\6"+
    "\7\12\1\6\3\12\1\6\1\12\1\6\1\12\2\6"+
    "\2\12\1\6\4\12\1\0\2\12\6\0\1\6\2\0"+
    "\1\12\2\6\5\12\1\6\1\12\1\6\6\0\2\6"+
    "\12\0\2\6\4\12\40\6\1\12\27\6\2\0\6\6"+
    "\12\0\13\6\1\0\1\6\1\0\1\6\1\0\4\6"+
    "\2\0\10\12\1\6\44\12\4\6\24\0\1\6\2\0"+
    "\5\12\13\0\1\6\44\0\11\6\1\0\71\6\53\12"+
    "\24\0\1\12\12\0\6\6\6\12\4\0\4\12\3\0"+
    "\1\12\3\0\2\12\7\0\3\12\4\0\15\12\14\0"+
    "\1\12\17\0\2\6\46\12\1\6\1\12\5\6\1\12"+
    "\2\6\53\12\1\6\115\12\1\6\4\12\2\6\7\12"+
    "\1\6\1\12\1\6\4\12\2\6\51\12\1\6\4\12"+
    "\2\6\41\12\1\6\4\12\2\6\7\12\1\6\1\12"+
    "\1\6\4\12\2\6\17\12\1\6\71\12\1\6\4\12"+
    "\2\6\103\12\2\6\3\0\40\6\20\12\20\6\125\12"+
    "\14\6\u016c\12\2\6\21\12\1\6\32\12\5\6\113\12"+
    "\3\6\3\12\17\6\15\12\1\6\4\12\3\0\13\6"+
    "\22\12\3\0\13\6\22\12\2\0\14\6\15\12\1\6"+
    "\3\12\1\6\2\0\14\6\64\12\40\0\3\6\1\12"+
    "\3\6\2\12\1\0\2\6\12\0\41\6\3\0\2\6"+
    "\12\0\6\6\130\12\10\6\51\12\1\0\1\12\5\6"+
    "\106\12\12\6\35\12\3\6\14\0\4\6\14\0\12\6"+
    "\12\0\36\12\2\6\5\12\13\6\54\12\4\6\21\0"+
    "\7\12\2\0\6\6\12\0\46\6\27\12\5\0\4\6"+
    "\65\12\12\0\1\6\35\0\2\6\13\0\6\6\12\0"+
    "\15\6\1\12\130\6\5\0\57\12\21\0\7\12\4\6"+
    "\12\0\21\6\11\0\14\6\3\0\36\12\15\0\2\12"+
    "\12\0\54\12\16\0\14\6\44\12\24\0\10\6\12\0"+
    "\3\6\3\12\12\0\44\12\122\6\3\0\1\6\25\0"+
    "\4\12\1\0\4\12\3\0\2\12\11\6\300\12\47\0"+
    "\25\6\4\0\26\12\2\6\6\12\2\6\46\12\2\6"+
    "\6\12\2\6\10\12\1\6\1\12\1\6\1\12\1\6"+
    "\1\12\1\6\37\12\2\6\65\12\1\6\7\12\1\6"+
    "\1\12\3\6\3\12\1\6\7\12\3\6\4\12\2\6"+
    "\6\12\4\6\15\12\5\6\3\12\1\6\7\12\16\6"+
    "\5\0\30\6\2\3\5\0\20\6\2\12\23\6\1\12"+
    "\13\6\5\0\5\6\6\0\1\6\1\12\15\6\1\12"+
    "\20\6\15\12\3\6\33\12\25\6\15\0\4\6\1\0"+
    "\3\6\14\0\21\6\1\12\4\6\1\12\2\6\12\12"+
    "\1\6\1\12\3\6\5\12\6\6\1\12\1\6\1\12"+
    "\1\6\1\12\1\6\4\12\1\6\13\12\2\6\4\12"+
    "\5\6\5\12\4\6\1\12\21\6\51\12\u0177\6\57\12"+
    "\1\6\57\12\1\6\205\12\6\6\4\12\3\0\2\12"+
    "\14\6\46\12\1\6\1\12\5\6\1\12\2\6\70\12"+
    "\7\6\1\12\17\6\1\0\27\12\11\6\7\12\1\6"+
    "\7\12\1\6\7\12\1\6\7\12\1\6\7\12\1\6"+
    "\7\12\1\6\7\12\1\6\7\12\1\6\40\0\57\6"+
    "\1\12\325\6\3\12\31\6\11\12\6\0\1\6\5\12"+
    "\2\6\5\12\4\6\126\12\2\6\2\0\2\6\3\12"+
    "\1\6\132\12\1\6\4\12\5\6\51\12\3\6\136\12"+
    "\21\6\33\12\65\6\306\12\112\6\315\12\63\6\215\12"+
    "\103\6\56\12\2\6\15\12\3\6\20\12\12\0\2\12"+
    "\24\6\57\12\1\0\4\6\12\0\1\6\31\12\7\6"+
    "\1\0\120\12\2\0\45\6\11\12\2\6\147\12\2\6"+
    "\4\12\1\6\4\12\14\6\13\12\115\6\12\12\1\0"+
    "\3\12\1\0\4\12\1\0\27\12\5\0\20\6\1\12"+
    "\7\6\64\12\14\6\2\0\62\12\21\0\13\6\12\0"+
    "\6\6\22\0\6\12\3\6\1\12\4\6\12\0\34\12"+
    "\10\0\2\6\27\12\15\0\14\6\35\12\3\6\4\0"+
    "\57\12\16\0\16\6\1\12\12\0\46\6\51\12\16\0"+
    "\11\6\3\12\1\0\10\12\2\0\2\6\12\0\6\6"+
    "\27\12\3\6\1\12\1\0\4\6\60\12\1\0\1\12"+
    "\3\0\2\12\2\0\5\12\2\0\1\12\1\0\1\12"+
    "\30\6\3\12\2\6\13\12\5\0\2\6\3\12\2\0"+
    "\12\6\6\12\2\6\6\12\2\6\6\12\11\6\7\12"+
    "\1\6\7\12\221\6\43\12\10\0\1\6\2\0\2\6"+
    "\12\0\6\6\244\12\14\6\27\12\4\6\61\12\4\6"+
    "\u0100\3\156\12\2\6\152\12\46\6\7\12\14\6\5\12"+
    "\5\6\1\12\1\0\12\12\1\6\15\12\1\6\5\12"+
    "\1\6\1\12\1\6\2\12\1\6\2\12\1\6\154\12"+
    "\41\6\153\12\22\6\100\12\2\6\66\12\50\6\15\12"+
    "\3\6\20\0\20\6\7\0\14\6\2\12\30\6\3\12"+
    "\31\6\1\12\6\6\5\12\1\6\207\12\2\6\1\0"+
    "\4\6\1\12\13\6\12\0\7\6\32\12\4\6\1\12"+
    "\1\6\32\12\13\6\131\12\3\6\6\12\2\6\6\12"+
    "\2\6\6\12\2\6\3\12\3\6\2\12\3\6\2\12"+
    "\22\6\3\0\4\6\14\12\1\6\32\12\1\6\23\12"+
    "\1\6\2\12\1\6\17\12\2\6\16\12\42\6\173\12"+
    "\105\6\65\12\210\6\1\0\202\6\35\12\3\6\61\12"+
    "\57\6\37\12\21\6\33\12\65\6\36\12\2\6\44\12"+
    "\4\6\10\12\1\6\5\12\52\6\236\12\2\6\12\0"+
    "\126\6\6\12\2\6\1\12\1\6\54\12\1\6\2\12"+
    "\3\6\1\12\2\6\27\12\252\6\26\12\12\6\32\12"+
    "\106\6\70\12\6\6\2\12\100\6\1\12\3\0\1\6"+
    "\2\0\5\6\4\0\4\12\1\6\3\12\1\6\33\12"+
    "\4\6\3\0\4\6\1\0\40\6\35\12\203\6\66\12"+
    "\12\6\26\12\12\6\23\12\215\6\111\12\267\6\3\0"+
    "\65\12\17\0\37\6\12\0\20\6\3\0\55\12\13\0"+
    "\2\6\1\0\22\6\31\12\7\6\12\0\6\6\3\0"+
    "\44\12\16\0\1\6\12\0\100\6\3\0\60\12\16\0"+
    "\4\12\13\6\12\0\246\6\53\12\15\0\10\6\12\0"+
    "\66\6\157\12\221\6\143\12\235\6\57\12\321\6\71\12"+
    "\307\6\105\12\13\6\1\12\56\0\20\6\4\0\15\12"+
    "\140\6\2\12\u0163\6\5\0\3\6\26\0\2\6\7\0"+
    "\36\6\4\0\224\6\3\0\273\6\125\12\1\6\107\12"+
    "\1\6\2\12\2\6\1\12\2\6\2\12\2\6\4\12"+
    "\1\6\14\12\1\6\1\12\1\6\7\12\1\6\101\12"+
    "\1\6\4\12\2\6\10\12\1\6\7\12\1\6\34\12"+
    "\1\6\4\12\1\6\5\12\1\6\1\12\3\6\7\12"+
    "\1\6\u0154\12\2\6\31\12\1\6\31\12\1\6\37\12"+
    "\1\6\31\12\1\6\37\12\1\6\31\12\1\6\37\12"+
    "\1\6\31\12\1\6\37\12\1\6\31\12\1\6\10\12"+
    "\2\6\62\0\4\12\1\6\33\12\1\6\2\12\1\6"+
    "\1\12\2\6\1\12\1\6\12\12\1\6\4\12\1\6"+
    "\1\12\1\6\1\12\6\6\1\12\4\6\1\12\1\6"+
    "\1\12\1\6\1\12\1\6\3\12\1\6\2\12\1\6"+
    "\1\12\2\6\1\12\1\6\1\12\1\6\1\12\1\6"+
    "\1\12\1\6\1\12\1\6\2\12\1\6\1\12\2\6"+
    "\4\12\1\6\7\12\1\6\4\12\1\6\4\12\1\6"+
    "\1\12\1\6\12\12\1\6\21\12\5\6\3\12\1\6"+
    "\5\12\1\6\21\12\104\6\327\12\51\6\65\12\13\6"+
    "\336\12\343\6\1\0\36\6\140\0\200\6\360\0\20\6";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[21504];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\2\2\1\1\1\3\1\4\1\5\1\6"+
    "\1\7\1\10\1\11\1\12\1\13\1\14\1\15\1\16"+
    "\1\17\1\20\2\21\1\22\1\23\1\24\1\25\1\26"+
    "\1\27\3\5\1\30\1\31\1\32\1\33\27\5\1\34"+
    "\1\35\1\36\1\37\1\0\1\40\2\3\1\0\1\41"+
    "\1\42\2\10\1\0\1\43\1\44\1\45\1\46\1\47"+
    "\1\50\1\51\1\52\1\50\1\21\3\0\1\53\1\54"+
    "\1\0\1\54\2\0\1\54\1\0\1\55\1\56\1\57"+
    "\1\60\1\61\1\62\1\63\2\0\1\64\1\65\3\5"+
    "\1\66\3\5\1\67\27\5\1\70\1\71\1\5\1\72"+
    "\1\73\12\5\1\74\24\5\1\75\1\3\1\0\2\3"+
    "\1\10\1\0\2\10\1\76\1\0\1\77\1\0\1\21"+
    "\2\0\1\50\2\54\1\21\1\0\2\54\1\21\1\0"+
    "\1\100\1\101\3\5\1\102\13\5\1\103\1\104\12\5"+
    "\1\105\6\5\1\106\6\5\1\107\17\5\1\110\10\5"+
    "\2\0\1\5\1\111\1\112\4\5\1\113\6\5\1\114"+
    "\1\115\2\5\1\116\2\5\1\117\7\5\1\120\1\5"+
    "\1\121\14\5\1\122\2\5\2\0\1\123\1\5\1\124"+
    "\1\5\1\125\10\5\1\126\5\5\1\127\1\5\1\130"+
    "\2\5\1\131\4\5\1\132\1\133\1\134\1\135\1\136"+
    "\2\5\1\137\1\5\1\140\1\5\1\141\1\142\2\5"+
    "\1\143\2\5\1\144\1\145\2\5\1\135\3\5\1\146"+
    "\3\5\1\135\1\5\1\147\1\5\1\150";

  private static int [] zzUnpackAction() {
    int [] result = new int[378];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\120\0\240\0\360\0\u0140\0\u0190\0\u01e0\0\u0230"+
    "\0\u0280\0\u02d0\0\u0320\0\120\0\120\0\u0370\0\u03c0\0\120"+
    "\0\u0410\0\u0460\0\u04b0\0\u0500\0\u0550\0\u05a0\0\120\0\u05f0"+
    "\0\u0640\0\u0690\0\u06e0\0\u0730\0\u0780\0\u07d0\0\120\0\120"+
    "\0\u0820\0\120\0\u0870\0\u08c0\0\u0910\0\u0960\0\u09b0\0\u0a00"+
    "\0\u0a50\0\u0aa0\0\u0af0\0\u0b40\0\u0b90\0\u0be0\0\u0c30\0\u0c80"+
    "\0\u0cd0\0\u0d20\0\u0d70\0\u0dc0\0\u0e10\0\u0e60\0\u0eb0\0\u0f00"+
    "\0\u0f50\0\120\0\u0fa0\0\120\0\120\0\u0ff0\0\120\0\u1040"+
    "\0\u1090\0\u10e0\0\120\0\120\0\u1130\0\u1180\0\u11d0\0\u1220"+
    "\0\120\0\120\0\120\0\120\0\u1270\0\u12c0\0\120\0\u1310"+
    "\0\u1360\0\u13b0\0\u1400\0\u1450\0\120\0\u14a0\0\u14f0\0\u1540"+
    "\0\u1590\0\u15e0\0\u1630\0\u1680\0\120\0\u16d0\0\120\0\120"+
    "\0\120\0\120\0\u1720\0\u1770\0\u17c0\0\120\0\u1810\0\u1860"+
    "\0\u18b0\0\u1900\0\120\0\u1950\0\u19a0\0\u19f0\0\u1a40\0\u1a90"+
    "\0\u1ae0\0\u1b30\0\u1b80\0\u1bd0\0\u1c20\0\u1c70\0\u1cc0\0\u1d10"+
    "\0\u1d60\0\u1db0\0\u1e00\0\u1e50\0\u1ea0\0\u1ef0\0\u1f40\0\u1f90"+
    "\0\u1fe0\0\u2030\0\u2080\0\u20d0\0\u2120\0\u2170\0\u0230\0\u0230"+
    "\0\u21c0\0\u2210\0\u2260\0\u22b0\0\u2300\0\u2350\0\u23a0\0\u23f0"+
    "\0\u2440\0\u2490\0\u24e0\0\u2530\0\u2580\0\u25d0\0\u2620\0\u2670"+
    "\0\u26c0\0\u2710\0\u2760\0\u27b0\0\u2800\0\u2850\0\u28a0\0\u28f0"+
    "\0\u2940\0\u2990\0\u29e0\0\u2a30\0\u2a80\0\u2ad0\0\u2b20\0\u2b70"+
    "\0\u2bc0\0\u2c10\0\120\0\120\0\u2c60\0\u2cb0\0\u2d00\0\120"+
    "\0\u2d50\0\u2da0\0\u2df0\0\120\0\u0460\0\120\0\u2e40\0\u2e90"+
    "\0\u2ee0\0\u2f30\0\u2f80\0\u2fd0\0\120\0\u3020\0\u3070\0\u30c0"+
    "\0\u3110\0\u3160\0\u31b0\0\120\0\120\0\u3200\0\u3250\0\u32a0"+
    "\0\u0230\0\u32f0\0\u3340\0\u3390\0\u33e0\0\u3430\0\u3480\0\u34d0"+
    "\0\u3520\0\u3570\0\u35c0\0\u3610\0\u0230\0\u3660\0\u36b0\0\u3700"+
    "\0\u3750\0\u37a0\0\u37f0\0\u3840\0\u3890\0\u38e0\0\u3930\0\u3980"+
    "\0\u0230\0\u39d0\0\u3660\0\u3a20\0\u3a70\0\u3ac0\0\u3b10\0\u3b60"+
    "\0\u3bb0\0\u3c00\0\u3c50\0\u3ca0\0\u3cf0\0\u3d40\0\u0230\0\u3d90"+
    "\0\u3de0\0\u3e30\0\u3e80\0\u3ed0\0\u3f20\0\u3f70\0\u3fc0\0\u4010"+
    "\0\u4060\0\u40b0\0\u4100\0\u4150\0\u41a0\0\u41f0\0\u0230\0\u4240"+
    "\0\u4290\0\u42e0\0\u4330\0\u4380\0\u43d0\0\u4420\0\u4470\0\u44c0"+
    "\0\u4510\0\u4560\0\u0230\0\u0230\0\u45b0\0\u4600\0\u4650\0\u46a0"+
    "\0\u0230\0\u46f0\0\u4740\0\u4790\0\u47e0\0\u4830\0\u4880\0\u0230"+
    "\0\u0230\0\u48d0\0\u4920\0\u4970\0\u49c0\0\u4a10\0\u0230\0\u4a60"+
    "\0\u4ab0\0\u4b00\0\u4b50\0\u4ba0\0\u4bf0\0\u4c40\0\u0230\0\u4c90"+
    "\0\u0230\0\u4ce0\0\u4d30\0\u4d80\0\u4dd0\0\u4e20\0\u4e70\0\u25d0"+
    "\0\u4ec0\0\u4f10\0\u4f60\0\u4fb0\0\u5000\0\u0230\0\u5050\0\u50a0"+
    "\0\u50f0\0\u5140\0\u0230\0\u5190\0\u0230\0\u51e0\0\u5230\0\u5280"+
    "\0\u52d0\0\u5320\0\u5370\0\u53c0\0\u5410\0\u5460\0\u54b0\0\u0230"+
    "\0\u5500\0\u5550\0\u55a0\0\u55f0\0\u5640\0\u0230\0\u5690\0\u0230"+
    "\0\u56e0\0\u5730\0\u0230\0\u5780\0\u57d0\0\u5820\0\u5870\0\u0230"+
    "\0\u0230\0\120\0\u58c0\0\u0230\0\u5910\0\u5960\0\u0230\0\u59b0"+
    "\0\u0230\0\u5a00\0\u1950\0\u0230\0\u5a50\0\u5aa0\0\u0230\0\u5af0"+
    "\0\u5b40\0\u0230\0\u0230\0\u5230\0\u5b90\0\u5be0\0\u5c30\0\u5c80"+
    "\0\u5cd0\0\u0230\0\u5d20\0\u5d70\0\u5dc0\0\120\0\u5e10\0\u0230"+
    "\0\u5e60\0\u0230";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[378];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\2\3\1\2\1\3\1\4\1\2\1\5\1\6"+
    "\1\7\1\10\1\11\1\12\1\13\1\14\1\15\1\16"+
    "\1\17\1\20\1\21\1\22\1\23\1\24\3\25\1\26"+
    "\1\27\1\30\1\31\1\32\1\33\3\10\1\34\3\10"+
    "\1\35\1\10\1\36\2\10\1\37\1\2\1\40\1\41"+
    "\1\10\1\42\1\43\1\44\1\45\1\46\1\47\1\50"+
    "\1\51\1\52\1\53\2\10\1\54\1\55\1\56\1\57"+
    "\1\60\1\61\1\62\1\63\1\64\1\65\1\66\1\67"+
    "\1\70\1\71\1\72\1\73\1\74\1\75\1\2\157\0"+
    "\1\76\62\0\1\3\34\0\1\76\115\0\1\77\62\0"+
    "\2\100\1\0\2\100\1\0\2\100\1\101\44\100\1\102"+
    "\42\100\2\7\4\0\111\7\1\0\1\10\11\0\1\10"+
    "\13\0\4\10\6\0\14\10\4\0\1\10\1\0\31\10"+
    "\4\0\1\10\35\0\1\103\117\0\1\104\62\0\2\105"+
    "\1\0\2\105\1\0\7\105\1\106\37\105\1\107\42\105"+
    "\20\0\1\110\14\0\1\111\117\0\1\112\117\0\1\113"+
    "\1\114\107\0\4\115\113\0\1\116\7\0\1\117\106\0"+
    "\1\120\1\0\3\121\1\122\7\0\1\123\1\124\2\0"+
    "\1\125\1\126\1\0\1\127\1\0\1\130\1\131\4\0"+
    "\1\132\2\0\1\123\2\0\1\124\4\0\1\125\1\0"+
    "\1\133\2\0\1\127\4\0\1\130\2\0\1\131\33\0"+
    "\1\120\1\0\4\25\10\0\1\124\2\0\1\125\1\126"+
    "\3\0\1\130\5\0\1\134\5\0\1\124\4\0\1\125"+
    "\1\0\1\133\7\0\1\130\47\0\1\135\116\0\1\136"+
    "\1\137\1\140\116\0\1\141\117\0\1\142\1\143\62\0"+
    "\2\144\1\0\1\144\1\145\27\0\1\146\2\0\14\147"+
    "\6\0\31\147\5\0\1\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\1\150\30\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\16\10\1\151\12\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\20\10\1\152\10\10\4\0\1\10\35\0\1\153\62\0"+
    "\1\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\1\10\1\154\13\10\1\155\1\10\1\156"+
    "\1\10\1\157\7\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\16\10\1\160"+
    "\1\10\1\161\2\10\1\162\5\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\1\163\6\10\1\164\3\10\1\165\1\166\1\10\1\167"+
    "\12\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\4\10\1\170\3\10\1\171"+
    "\5\10\1\172\12\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\13\10\1\173"+
    "\1\10\1\174\6\10\1\175\1\10\1\176\2\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\10\10\1\177\2\10\1\200\2\10\1\201"+
    "\1\10\1\202\10\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\4\10\1\203"+
    "\6\10\1\204\15\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\1\205\3\10"+
    "\1\206\24\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\3\10\1\207\1\10"+
    "\1\210\6\10\1\211\1\212\3\10\1\213\1\214\6\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\14\10"+
    "\4\0\1\10\1\0\1\215\3\10\1\216\3\10\1\217"+
    "\5\10\1\220\12\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\1\221\7\10"+
    "\1\216\20\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\16\10\1\222\12\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\14\10"+
    "\4\0\1\10\1\0\1\10\1\223\1\224\14\10\1\225"+
    "\1\226\10\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\1\227\15\10\1\230"+
    "\1\10\1\231\10\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\1\232\3\10"+
    "\1\233\11\10\1\234\12\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\14\10\4\0\1\10\1\0\4\10"+
    "\1\203\2\10\1\235\1\236\2\10\1\237\6\10\1\240"+
    "\1\241\5\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\20\10\1\242\2\10"+
    "\1\243\3\10\1\244\1\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\14\10\4\0\1\10\1\0\15\10"+
    "\1\245\13\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\1\246\15\10\1\247"+
    "\12\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\7\10\1\250\21\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\20\10\1\251\10\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\10\10\1\252\20\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\10\10\1\166"+
    "\20\10\4\0\1\10\35\0\1\253\63\0\2\144\1\0"+
    "\1\144\1\145\32\0\14\147\6\0\31\147\5\0\2\100"+
    "\1\0\2\100\1\0\2\100\1\254\44\100\1\102\42\100"+
    "\10\0\1\255\107\0\1\100\1\256\2\100\1\256\1\257"+
    "\112\100\2\105\1\0\2\105\1\0\7\105\1\260\37\105"+
    "\1\107\42\105\15\0\1\261\102\0\1\105\1\262\2\105"+
    "\1\262\1\263\112\105\35\0\1\264\110\0\4\115\10\0"+
    "\1\124\2\0\1\125\12\0\1\265\5\0\1\124\4\0"+
    "\1\125\61\0\1\266\110\0\4\115\10\0\1\124\2\0"+
    "\1\125\20\0\1\124\4\0\1\125\50\0\1\120\1\0"+
    "\3\121\1\122\10\0\1\124\2\0\1\125\1\126\3\0"+
    "\1\130\5\0\1\132\5\0\1\124\4\0\1\125\1\0"+
    "\1\133\7\0\1\130\36\0\1\120\1\0\4\122\10\0"+
    "\1\124\2\0\1\125\12\0\1\267\5\0\1\124\4\0"+
    "\1\125\52\0\2\270\30\0\1\271\60\0\1\272\1\0"+
    "\1\272\2\0\4\273\134\0\1\274\3\0\1\275\32\0"+
    "\1\275\40\0\3\276\27\0\1\277\105\0\1\300\26\0"+
    "\1\301\50\0\4\302\6\0\4\302\14\0\1\303\1\0"+
    "\6\302\56\0\3\121\1\122\140\0\1\275\22\0\1\274"+
    "\7\0\1\275\40\0\4\25\123\0\1\304\117\0\1\305"+
    "\122\0\14\147\6\0\31\147\7\0\1\144\35\0\14\147"+
    "\6\0\31\147\5\0\2\147\1\0\115\147\1\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\13\10\1\306\15\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\15\10\1\307"+
    "\13\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\23\10\1\310\5\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\21\10\1\207\7\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\3\10\1\311\25\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\17\10\1\312"+
    "\11\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\21\10\1\313\7\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\16\10\1\314\12\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\4\10\1\315\24\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\5\10\1\316"+
    "\23\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\13\10\1\317\15\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\1\320\17\10\1\207\10\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\14\10\4\0\1\10"+
    "\1\0\1\321\30\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\17\10\1\207"+
    "\11\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\4\10\1\322\7\10\1\323"+
    "\1\324\13\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\5\10\1\325\5\10"+
    "\1\326\15\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\2\10\1\224\15\10"+
    "\1\207\3\10\1\327\4\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\14\10\4\0\1\10\1\0\23\10"+
    "\1\330\5\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\10\10\1\331\10\10"+
    "\1\332\7\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\23\10\1\333\5\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\14\10"+
    "\4\0\1\10\1\0\1\314\30\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\2\10\1\334\1\10\1\335\24\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\13\10\1\336\1\10\1\337\13\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\16\10\1\340\12\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\20\10\1\341"+
    "\10\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\16\10\1\342\12\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\22\10\1\343\6\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\16\10\1\344\12\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\21\10\1\345"+
    "\7\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\26\10\1\207\2\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\17\10\1\346\11\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\17\10\1\347\2\10\1\350\6\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\10\10\1\351\10\10\1\352\7\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\4\10\1\353\24\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\14\10\1\354"+
    "\14\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\15\10\1\207\13\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\21\10\1\224\7\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\2\10\1\355\12\10\1\356\13\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\17\10\1\207\6\10\1\207\2\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\22\10\1\357\6\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\11\10\1\360"+
    "\17\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\22\10\1\207\6\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\4\10\1\216\24\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\3\10\1\207\25\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\21\10\1\361"+
    "\7\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\25\10\1\207\3\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\10\10\1\362\5\10\1\363\12\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\10\10\1\364\4\10\1\365\7\10\1\366"+
    "\3\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\3\10\1\367\7\10\1\370"+
    "\3\10\1\353\2\10\1\371\6\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\23\10\1\372\5\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\16\10\1\373"+
    "\12\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\6\10\1\374\22\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\10\10\1\375\20\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\1\376\17\10\1\207\10\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\14\10\4\0\1\10\1\0\14\10"+
    "\1\207\2\10\1\214\11\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\14\10\4\0\1\10\1\0\27\10"+
    "\1\377\1\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\17\10\1\u0100\11\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\14\10"+
    "\4\0\1\10\1\0\17\10\1\u0101\11\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\14\10\4\0\1\10"+
    "\1\0\10\10\1\u0102\10\10\1\u0103\7\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\14\10\4\0\1\10"+
    "\1\0\20\10\1\154\10\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\14\10\4\0\1\10\1\0\10\10"+
    "\1\u0104\20\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\10\10\1\u0105\20\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\14\10"+
    "\4\0\1\10\1\0\1\u0106\30\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\4\10\1\u0107\24\10\4\0\1\10\10\255\1\u0108\107\255"+
    "\1\100\1\256\2\100\1\256\1\257\2\100\1\254\44\100"+
    "\1\102\47\100\1\0\2\100\1\254\44\100\1\102\42\100"+
    "\15\261\1\u0109\102\261\1\105\1\262\2\105\1\262\1\263"+
    "\7\105\1\260\37\105\1\107\47\105\1\0\7\105\1\260"+
    "\37\105\1\107\42\105\26\0\4\122\114\0\2\270\16\0"+
    "\1\126\3\0\1\130\5\0\1\271\14\0\1\133\7\0"+
    "\1\130\40\0\2\270\116\0\4\273\114\0\4\273\13\0"+
    "\1\125\12\0\1\272\12\0\1\125\76\0\1\275\32\0"+
    "\1\275\40\0\3\276\15\0\1\126\3\0\1\130\5\0"+
    "\1\277\14\0\1\133\7\0\1\130\40\0\3\276\135\0"+
    "\1\275\146\0\1\275\50\0\4\302\6\0\4\302\2\0"+
    "\1\126\3\0\1\130\5\0\1\303\1\0\6\302\5\0"+
    "\1\133\7\0\1\130\40\0\4\302\6\0\4\302\16\0"+
    "\6\302\30\0\1\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\21\10\1\u010a\7\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\4\10\1\u010b\24\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\4\10\1\u010c\24\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\13\10\1\u010d"+
    "\15\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\4\10\1\u010e\24\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\13\10\1\207\15\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\1\u010f\30\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\5\10\1\214\23\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\14\10"+
    "\4\0\1\10\1\0\13\10\1\u0110\15\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\14\10\4\0\1\10"+
    "\1\0\20\10\1\u0111\10\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\14\10\4\0\1\10\1\0\21\10"+
    "\1\u0112\7\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\20\10\1\375\10\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\14\10"+
    "\4\0\1\10\1\0\17\10\1\u0113\11\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\14\10\4\0\1\10"+
    "\1\0\22\10\1\u0114\6\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\14\10\4\0\1\10\1\0\1\u0115"+
    "\30\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\14\10\1\u0116\14\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\1\10\1\u0117\27\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\5\10\1\u0118\23\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\4\10\1\u0119"+
    "\24\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\14\10\1\u011a\14\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\4\10\1\u011b\24\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\2\10\1\u011c\26\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\4\10\1\207"+
    "\15\10\1\214\6\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\1\u011d\30\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\14\10"+
    "\4\0\1\10\1\0\1\u011e\30\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\14\10\1\u011f\14\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\1\10\1\u0120"+
    "\27\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\1\u0115\6\10\1\207\21\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\14\10"+
    "\4\0\1\10\1\0\16\10\1\u0121\12\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\14\10\4\0\1\10"+
    "\1\0\23\10\1\224\5\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\14\10\4\0\1\10\1\0\4\10"+
    "\1\u0122\24\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\15\10\1\u0123\13\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\14\10"+
    "\4\0\1\10\1\0\23\10\1\u0124\5\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\14\10\4\0\1\10"+
    "\1\0\20\10\1\207\10\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\14\10\4\0\1\10\1\0\1\10"+
    "\1\u0125\27\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\1\u0126\30\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\6\10\1\u0127\22\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\4\10\1\u0128\24\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\21\10\1\u0129"+
    "\7\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\15\10\1\u012a\13\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\17\10\1\u012b\11\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\21\10\1\u012c\7\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\6\10\1\u0101"+
    "\22\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\u012d\1\0\31\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\23\10\1\375\5\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\16\10\1\u012e"+
    "\12\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\23\10\1\u012f\5\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\15\10\1\u0130\13\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\20\10\1\u0131\10\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\15\10\1\u0132"+
    "\13\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\2\10\1\u0101\26\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\22\10\1\u0133\6\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\13\10\1\u0101\15\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\4\10\1\207"+
    "\24\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\2\10\1\u0134\26\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\10\10\1\u0135\20\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\3\10\1\u0136\25\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\13\10\1\u0137"+
    "\15\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\15\10\1\365\13\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\13\10\1\u0138\15\10\4\0\1\10\10\0"+
    "\1\u0139\107\0\15\261\1\u013a\102\261\1\10\11\0\1\10"+
    "\13\0\4\10\6\0\14\10\4\0\1\10\1\0\4\10"+
    "\1\u013b\24\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\27\10\1\207\1\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\14\10"+
    "\4\0\1\10\1\0\20\10\1\u013c\10\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\14\10\4\0\1\10"+
    "\1\0\12\10\1\u013d\16\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\14\10\4\0\1\10\1\0\1\u013e"+
    "\30\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\21\10\1\u013f\7\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\10\10\1\u0100\2\10\1\u0140\15\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\10\10\1\u0141\20\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\22\10\1\u0142\6\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\16\10\1\u0130"+
    "\12\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\13\10\1\u0143\15\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\4\10\1\u0144\24\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\17\10\1\u0145\11\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\5\10\1\u0146"+
    "\23\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\13\10\1\u0147\15\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\22\10\1\u0148\6\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\1\u0149\30\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\20\10\1\u014a\10\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\14\10"+
    "\4\0\1\10\1\0\20\10\1\216\10\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\14\10\4\0\1\10"+
    "\1\0\21\10\1\u014b\7\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\14\10\4\0\1\10\1\0\1\10"+
    "\1\u014c\27\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\3\10\1\u014d\25\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\14\10"+
    "\4\0\1\10\1\0\13\10\1\154\15\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\14\10\4\0\1\10"+
    "\1\0\2\10\1\224\26\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\14\10\4\0\1\10\1\0\22\10"+
    "\1\u014e\6\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\4\10\1\u014f\24\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\14\10"+
    "\4\0\1\10\1\0\4\10\1\u0150\24\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\14\10\4\0\1\10"+
    "\1\0\10\10\1\u0151\20\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\14\10\4\0\1\10\1\0\1\u0130"+
    "\30\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\20\10\1\u0152\10\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\22\10\1\u0153\6\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\4\10\1\u0154\24\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\10\10\1\u0155"+
    "\20\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\7\10\1\353\6\10\1\u0156"+
    "\12\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\6\10\1\u0157\22\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\4\10\1\u0158\24\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\3\10\1\u0159\25\10\4\0\1\10\10\0\1\u015a\107\0"+
    "\15\261\1\u015b\102\261\1\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\22\10\1\u015c\6\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\14\10"+
    "\4\0\1\10\1\0\1\10\1\u0100\27\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\14\10\4\0\1\10"+
    "\1\0\14\10\1\u015d\14\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\14\10\4\0\1\10\1\0\4\10"+
    "\1\206\24\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\15\10\1\u015e\13\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\14\10"+
    "\4\0\1\10\1\0\22\10\1\353\6\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\14\10\4\0\1\10"+
    "\1\0\4\10\1\u015f\24\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\14\10\4\0\1\10\1\0\20\10"+
    "\1\u0160\10\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\22\10\1\u0161\6\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\14\10"+
    "\4\0\1\10\1\0\10\10\1\u0100\20\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\14\10\4\0\1\10"+
    "\1\0\13\10\1\u0162\15\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\14\10\4\0\1\10\1\0\13\10"+
    "\1\u0163\15\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\22\10\1\u0164\6\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\14\10"+
    "\4\0\1\10\1\0\22\10\1\u0165\6\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\14\10\4\0\1\10"+
    "\1\0\2\10\1\u0166\26\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\14\10\4\0\1\10\1\0\1\u0167"+
    "\30\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\20\10\1\u0168\10\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\15\10\1\u0169\13\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\15\10\1\u016a\13\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\3\10\1\u016b"+
    "\25\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\2\10\1\u016c\26\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\3\10\1\u0101\25\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\15\10\1\u016d\13\10\4\0\1\10\15\0\1\u016e\102\0"+
    "\1\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\4\10\1\u016f\24\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\23\10\1\u0170\5\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\1\u0171\30\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\14\10"+
    "\4\0\1\10\1\0\27\10\1\u0172\1\10\4\0\2\10"+
    "\11\0\1\10\13\0\4\10\6\0\14\10\4\0\1\10"+
    "\1\0\1\u0173\30\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\13\10\1\u0174"+
    "\15\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\22\10\1\u010d\6\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\17\10\1\347\11\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\4\10\1\u0175\24\10\4\0\1\10\15\0\1\u0176\102\0"+
    "\1\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\22\10\1\u0177\6\10\4\0\2\10\11\0"+
    "\1\10\13\0\4\10\6\0\14\10\4\0\1\10\1\0"+
    "\4\10\1\u0178\24\10\4\0\2\10\11\0\1\10\13\0"+
    "\4\10\6\0\14\10\4\0\1\10\1\0\22\10\1\u0101"+
    "\6\10\4\0\2\10\11\0\1\10\13\0\4\10\6\0"+
    "\14\10\4\0\1\10\1\0\15\10\1\375\13\10\4\0"+
    "\2\10\11\0\1\10\13\0\4\10\6\0\14\10\4\0"+
    "\1\10\1\0\1\u0179\30\10\4\0\2\10\11\0\1\10"+
    "\13\0\4\10\6\0\14\10\4\0\1\10\1\0\3\10"+
    "\1\u017a\25\10\4\0\2\10\11\0\1\10\13\0\4\10"+
    "\6\0\14\10\4\0\1\10\1\0\7\10\1\u0116\21\10"+
    "\4\0\2\10\11\0\1\10\13\0\4\10\6\0\14\10"+
    "\4\0\1\10\1\0\21\10\1\154\7\10\4\0\1\10";

  private static int [] zzUnpackTrans() {
    int [] result = new int[24240];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** Error code for "Unknown internal scanner error". */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  /** Error code for "could not match input". */
  private static final int ZZ_NO_MATCH = 1;
  /** Error code for "pushback value was too large". */
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /**
   * Error messages for {@link #ZZ_UNKNOWN_ERROR}, {@link #ZZ_NO_MATCH}, and
   * {@link #ZZ_PUSHBACK_2BIG} respectively.
   */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\1\11\11\1\2\11\2\1\1\11\6\1\1\11"+
    "\7\1\2\11\1\1\1\11\27\1\1\11\1\1\2\11"+
    "\1\0\1\11\2\1\1\0\2\11\2\1\1\0\1\1"+
    "\4\11\2\1\1\11\2\1\3\0\1\11\1\1\1\0"+
    "\1\1\2\0\1\1\1\0\1\11\1\1\4\11\1\1"+
    "\2\0\1\11\4\1\1\11\77\1\2\11\1\0\2\1"+
    "\1\11\1\0\2\1\1\11\1\0\1\11\1\0\1\1"+
    "\2\0\2\1\1\11\1\1\1\0\3\1\1\0\2\11"+
    "\102\1\2\0\57\1\2\0\37\1\1\11\33\1\1\11"+
    "\4\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[378];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** Input device. */
  private java.io.Reader zzReader;

  /** Current state of the DFA. */
  private int zzState;

  /** Current lexical state. */
  private int zzLexicalState = YYINITIAL;

  /**
   * This buffer contains the current text to be matched and is the source of the {@link #yytext()}
   * string.
   */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** Text position at the last accepting state. */
  private int zzMarkedPos;

  /** Current text position in the buffer. */
  private int zzCurrentPos;

  /** Marks the beginning of the {@link #yytext()} string in the buffer. */
  private int zzStartRead;

  /** Marks the last character in the buffer, that has been read from input. */
  private int zzEndRead;

  /**
   * Whether the scanner is at the end of file.
   * @see #yyatEOF
   */
  private boolean zzAtEOF;

  /**
   * The number of occupied positions in {@link #zzBuffer} beyond {@link #zzEndRead}.
   *
   * <p>When a lead/high surrogate has been read from the input stream into the final
   * {@link #zzBuffer} position, this will have a value of 1; otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /** Number of newlines encountered up to the start of the matched text. */
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  private int yycolumn;

  /** Number of characters up to the start of the matched text. */
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  @SuppressWarnings("unused")
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  @SuppressWarnings("unused")
  private boolean zzEOFDone;

  /* user code: */
  public final int getTokenStart() {
      return (int) yychar;
  }

  public final int getTokenEnd() {
      return getTokenStart() + yylength();
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public PythonLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  /**
   * Refills the input buffer.
   *
   * @return {@code false} iff there was new input.
   * @exception java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead - zzStartRead);

      /* translate stored positions */
      zzEndRead -= zzStartRead;
      zzCurrentPos -= zzStartRead;
      zzMarkedPos -= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length * 2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException(
          "Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
        if (numRead == requested) { // We requested too few chars to encode a full Unicode character
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        } else {                    // There is room in the buffer for at least one more char
          int c = zzReader.read();  // Expecting to read a paired low surrogate char
          if (c == -1) {
            return true;
          } else {
            zzBuffer[zzEndRead++] = (char)c;
          }
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }


  /**
   * Closes the input reader.
   *
   * @throws java.io.IOException if the reader could not be closed.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true; // indicate end of file
    zzEndRead = zzStartRead; // invalidate buffer

    if (zzReader != null) {
      zzReader.close();
    }
  }


  /**
   * Resets the scanner to read from a new input stream.
   *
   * <p>Does not close the old reader.
   *
   * <p>All internal variables are reset, the old input stream <b>cannot</b> be reused (internal
   * buffer is discarded and lost). Lexical state is set to {@code ZZ_INITIAL}.
   *
   * <p>Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader The new input stream.
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzEOFDone = false;
    yyResetPosition();
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE) {
      zzBuffer = new char[ZZ_BUFFERSIZE];
    }
  }

  /**
   * Resets the input position.
   */
  private final void yyResetPosition() {
      zzAtBOL  = true;
      zzAtEOF  = false;
      zzCurrentPos = 0;
      zzMarkedPos = 0;
      zzStartRead = 0;
      zzEndRead = 0;
      zzFinalHighSurrogate = 0;
      yyline = 0;
      yycolumn = 0;
      yychar = 0L;
  }


  /**
   * Returns whether the scanner has reached the end of the reader it reads from.
   *
   * @return whether the scanner has reached EOF.
   */
  public final boolean yyatEOF() {
    return zzAtEOF;
  }


  /**
   * Returns the current lexical state.
   *
   * @return the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state.
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   *
   * @return the matched text.
   */
  public final String yytext() {
    return new String(zzBuffer, zzStartRead, zzMarkedPos-zzStartRead);
  }


  /**
   * Returns the character at the given position from the matched text.
   *
   * <p>It is equivalent to {@code yytext().charAt(pos)}, but faster.
   *
   * @param position the position of the character to fetch. A value from 0 to {@code yylength()-1}.
   *
   * @return the character at {@code position}.
   */
  public final char yycharat(int position) {
    return zzBuffer[zzStartRead + position];
  }


  /**
   * How many characters were matched.
   *
   * @return the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * <p>In a well-formed scanner (no or only correct usage of {@code yypushback(int)} and a
   * match-all fallback rule) this method will only be called with things that
   * "Can't Possibly Happen".
   *
   * <p>If this method is called, something is seriously wrong (e.g. a JFlex bug producing a faulty
   * scanner etc.).
   *
   * <p>Usual syntax/scanner level error handling should be done in error fallback rules.
   *
   * @param errorCode the code of the error message to display.
   */
  private static void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    } catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * <p>They will be read again by then next call of the scanning method.
   *
   * @param number the number of characters to be read again. This number must not be greater than
   *     {@link #yylength()}.
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }




  /**
   * Resumes scanning until the next regular expression is matched, the end of input is encountered
   * or an I/O-Error occurs.
   *
   * @return the next token.
   * @exception java.io.IOException if any I/O-Error occurs.
   */
  @NotNull
  public PythonToken advance() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char[] zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':  // fall through
        case '\u000C':  // fall through
        case '\u0085':  // fall through
        case '\u2028':  // fall through
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn += zzCharCount;
        }
      }

      if (zzR) {
        // peek one character ahead if it is
        // (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof)
            zzPeek = false;
          else
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
              {
                return PythonToken.EOF;
              }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { return PythonToken.BAD_CHARACTER;
            }
            // fall through
          case 105: break;
          case 2:
            { return PythonToken.WHITESPACE;
            }
            // fall through
          case 106: break;
          case 3:
            { return PythonToken.DOUBLE_QUOTED_STRING;
            }
            // fall through
          case 107: break;
          case 4:
            { return PythonToken.LINE_COMMENT;
            }
            // fall through
          case 108: break;
          case 5:
            { return PythonToken.IDENTIFIER;
            }
            // fall through
          case 109: break;
          case 6:
            { return PythonToken.MOD;
            }
            // fall through
          case 110: break;
          case 7:
            { return PythonToken.AND;
            }
            // fall through
          case 111: break;
          case 8:
            { return PythonToken.SINGLE_QUOTED_STRING;
            }
            // fall through
          case 112: break;
          case 9:
            { return PythonToken.LPAREN;
            }
            // fall through
          case 113: break;
          case 10:
            { return PythonToken.RPAREN;
            }
            // fall through
          case 114: break;
          case 11:
            { return PythonToken.MULT;
            }
            // fall through
          case 115: break;
          case 12:
            { return PythonToken.PLUS;
            }
            // fall through
          case 116: break;
          case 13:
            { return PythonToken.COMMA;
            }
            // fall through
          case 117: break;
          case 14:
            { return PythonToken.MINUS;
            }
            // fall through
          case 118: break;
          case 15:
            { return PythonToken.DOT;
            }
            // fall through
          case 119: break;
          case 16:
            { return PythonToken.DIV;
            }
            // fall through
          case 120: break;
          case 17:
            { return PythonToken.INTEGER_LITERAL;
            }
            // fall through
          case 121: break;
          case 18:
            { return PythonToken.COLON;
            }
            // fall through
          case 122: break;
          case 19:
            { return PythonToken.SEMICOLON;
            }
            // fall through
          case 123: break;
          case 20:
            { return PythonToken.LT;
            }
            // fall through
          case 124: break;
          case 21:
            { return PythonToken.EQ;
            }
            // fall through
          case 125: break;
          case 22:
            { return PythonToken.GT;
            }
            // fall through
          case 126: break;
          case 23:
            { return PythonToken.AT;
            }
            // fall through
          case 127: break;
          case 24:
            { return PythonToken.LBRACK;
            }
            // fall through
          case 128: break;
          case 25:
            { return PythonToken.RBRACK;
            }
            // fall through
          case 129: break;
          case 26:
            { return PythonToken.XOR;
            }
            // fall through
          case 130: break;
          case 27:
            { return PythonToken.TICK;
            }
            // fall through
          case 131: break;
          case 28:
            { return PythonToken.LBRACE;
            }
            // fall through
          case 132: break;
          case 29:
            { return PythonToken.OR;
            }
            // fall through
          case 133: break;
          case 30:
            { return PythonToken.RBRACE;
            }
            // fall through
          case 134: break;
          case 31:
            { return PythonToken.TILDE;
            }
            // fall through
          case 135: break;
          case 32:
            { return PythonToken.NOTEQ;
            }
            // fall through
          case 136: break;
          case 33:
            { return PythonToken.MODEQ;
            }
            // fall through
          case 137: break;
          case 34:
            { return PythonToken.ANDEQ;
            }
            // fall through
          case 138: break;
          case 35:
            { return PythonToken.EXP;
            }
            // fall through
          case 139: break;
          case 36:
            { return PythonToken.MULTEQ;
            }
            // fall through
          case 140: break;
          case 37:
            { return PythonToken.PLUSEQ;
            }
            // fall through
          case 141: break;
          case 38:
            { return PythonToken.MINUSEQ;
            }
            // fall through
          case 142: break;
          case 39:
            { return PythonToken.RARROW;
            }
            // fall through
          case 143: break;
          case 40:
            { return PythonToken.FLOAT_LITERAL;
            }
            // fall through
          case 144: break;
          case 41:
            { return PythonToken.FLOORDIV;
            }
            // fall through
          case 145: break;
          case 42:
            { return PythonToken.DIVEQ;
            }
            // fall through
          case 146: break;
          case 43:
            { return PythonToken.IMAGINARY_LITERAL;
            }
            // fall through
          case 147: break;
          case 44:
            { return PythonToken.LONG_LITERAL;
            }
            // fall through
          case 148: break;
          case 45:
            { return PythonToken.COLONEQ;
            }
            // fall through
          case 149: break;
          case 46:
            { return PythonToken.LTLT;
            }
            // fall through
          case 150: break;
          case 47:
            { return PythonToken.LTEQ;
            }
            // fall through
          case 151: break;
          case 48:
            { return PythonToken.NOTEQ_OLD;
            }
            // fall through
          case 152: break;
          case 49:
            { return PythonToken.EQEQ;
            }
            // fall through
          case 153: break;
          case 50:
            { return PythonToken.GTEQ;
            }
            // fall through
          case 154: break;
          case 51:
            { return PythonToken.GTGT;
            }
            // fall through
          case 155: break;
          case 52:
            { return PythonToken.ATEQ;
            }
            // fall through
          case 156: break;
          case 53:
            { return PythonToken.DECORATOR;
            }
            // fall through
          case 157: break;
          case 54:
            { return PythonToken.XOREQ;
            }
            // fall through
          case 158: break;
          case 55:
            { return PythonToken.AS;
            }
            // fall through
          case 159: break;
          case 56:
            { return PythonToken.METHOD;
            }
            // fall through
          case 160: break;
          case 57:
            { return PythonToken.IF;
            }
            // fall through
          case 161: break;
          case 58:
            { return PythonToken.IN;
            }
            // fall through
          case 162: break;
          case 59:
            { return PythonToken.IS;
            }
            // fall through
          case 163: break;
          case 60:
            { return PythonToken.OR_KEYWORD;
            }
            // fall through
          case 164: break;
          case 61:
            { return PythonToken.OREQ;
            }
            // fall through
          case 165: break;
          case 62:
            { return PythonToken.EXPEQ;
            }
            // fall through
          case 166: break;
          case 63:
            { return PythonToken.FLOORDIVEQ;
            }
            // fall through
          case 167: break;
          case 64:
            { return PythonToken.LTLTEQ;
            }
            // fall through
          case 168: break;
          case 65:
            { return PythonToken.GTGTEQ;
            }
            // fall through
          case 169: break;
          case 66:
            { return PythonToken.AND_KEYWORD;
            }
            // fall through
          case 170: break;
          case 67:
            { return PythonToken.DEF;
            }
            // fall through
          case 171: break;
          case 68:
            { return PythonToken.DEL;
            }
            // fall through
          case 172: break;
          case 69:
            { return PythonToken.FOR;
            }
            // fall through
          case 173: break;
          case 70:
            { return PythonToken.INT;
            }
            // fall through
          case 174: break;
          case 71:
            { return PythonToken.NOT_KEYWORD;
            }
            // fall through
          case 175: break;
          case 72:
            { return PythonToken.TRY;
            }
            // fall through
          case 176: break;
          case 73:
            { return PythonToken.NONE;
            }
            // fall through
          case 177: break;
          case 74:
            { return PythonToken.TRUE;
            }
            // fall through
          case 178: break;
          case 75:
            { return PythonToken.CHAR;
            }
            // fall through
          case 179: break;
          case 76:
            { return PythonToken.ELIF;
            }
            // fall through
          case 180: break;
          case 77:
            { return PythonToken.ELSE;
            }
            // fall through
          case 181: break;
          case 78:
            { return PythonToken.EXEC;
            }
            // fall through
          case 182: break;
          case 79:
            { return PythonToken.FROM;
            }
            // fall through
          case 183: break;
          case 80:
            { return PythonToken.LONG;
            }
            // fall through
          case 184: break;
          case 81:
            { return PythonToken.PASS;
            }
            // fall through
          case 185: break;
          case 82:
            { return PythonToken.VOID;
            }
            // fall through
          case 186: break;
          case 83:
            { return PythonToken.FALSE;
            }
            // fall through
          case 187: break;
          case 84:
            { return PythonToken.BREAK;
            }
            // fall through
          case 188: break;
          case 85:
            { return PythonToken.CLASS;
            }
            // fall through
          case 189: break;
          case 86:
            { return PythonToken.FLOAT;
            }
            // fall through
          case 190: break;
          case 87:
            { return PythonToken.PRINT;
            }
            // fall through
          case 191: break;
          case 88:
            { return PythonToken.RAISE;
            }
            // fall through
          case 192: break;
          case 89:
            { return PythonToken.SHORT;
            }
            // fall through
          case 193: break;
          case 90:
            { return PythonToken.WHILE;
            }
            // fall through
          case 194: break;
          case 91:
            { return PythonToken.YIELD;
            }
            // fall through
          case 195: break;
          case 92:
            { return PythonToken.LONG_DOUBLE_QUOTED_STRING;
            }
            // fall through
          case 196: break;
          case 93:
            { return PythonToken.LONG_SINGLE_QUOTED_STRING;
            }
            // fall through
          case 197: break;
          case 94:
            { return PythonToken.ASSERT;
            }
            // fall through
          case 198: break;
          case 95:
            { return PythonToken.DOUBLE;
            }
            // fall through
          case 199: break;
          case 96:
            { return PythonToken.EXCEPT;
            }
            // fall through
          case 200: break;
          case 97:
            { return PythonToken.GLOBAL;
            }
            // fall through
          case 201: break;
          case 98:
            { return PythonToken.IMPORT;
            }
            // fall through
          case 202: break;
          case 99:
            { return PythonToken.LAMBDA;
            }
            // fall through
          case 203: break;
          case 100:
            { return PythonToken.RETURN;
            }
            // fall through
          case 204: break;
          case 101:
            { return PythonToken.SIGNED;
            }
            // fall through
          case 205: break;
          case 102:
            { return PythonToken.FINALLY;
            }
            // fall through
          case 206: break;
          case 103:
            { return PythonToken.CONTINUE;
            }
            // fall through
          case 207: break;
          case 104:
            { return PythonToken.UNSIGNED;
            }
            // fall through
          case 208: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
