/*
 * Copyright 2021 Squircle IDE contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.blacksquircle.ui.language.visualbasic.lexer;

import org.jetbrains.annotations.NotNull;

@SuppressWarnings("all")

/**
 * This class is a scanner generated by
 * <a href="http://www.jflex.de/">JFlex</a> 1.8.2
 * from the specification file <tt>visualbasic.flex</tt>
 */
public class VisualBasicLexer {

  /** This character denotes the end of file. */
  public static final int YYEOF = -1;

  /** Initial size of the lookahead buffer. */
  private static final int ZZ_BUFFERSIZE = 16384;

  // Lexical states.
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0, 0
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\1\u0100\1\u0200\1\u0300\1\u0400\1\u0500\1\u0600\1\u0700"+
    "\1\u0800\1\u0900\1\u0a00\1\u0b00\1\u0c00\1\u0d00\1\u0e00\1\u0f00"+
    "\1\u1000\1\u0100\1\u1100\1\u1200\1\u1300\1\u0100\1\u1400\1\u1500"+
    "\1\u1600\1\u1700\1\u1800\1\u1900\1\u1a00\1\u1b00\1\u0100\1\u1c00"+
    "\1\u1d00\1\u1e00\12\u1f00\1\u2000\1\u2100\1\u2200\1\u1f00\1\u2300"+
    "\1\u2400\2\u1f00\31\u0100\1\u2500\121\u0100\1\u2600\4\u0100\1\u2700"+
    "\1\u0100\1\u2800\1\u2900\1\u2a00\1\u2b00\1\u2c00\1\u2d00\53\u0100"+
    "\1\u2e00\10\u2f00\31\u1f00\1\u0100\1\u3000\1\u3100\1\u0100\1\u3200"+
    "\1\u3300\1\u3400\1\u3500\1\u3600\1\u3700\1\u3800\1\u3900\3\u1f00"+
    "\1\u3a00\1\u3b00\1\u3c00\1\u3d00\1\u3e00\3\u1f00\1\u3f00\1\u4000"+
    "\4\u1f00\1\u4100\11\u1f00\3\u0100\1\u4200\1\u4300\13\u1f00\4\u0100"+
    "\1\u4400\63\u1f00\2\u0100\1\u4500\4\u1f00\1\u4600\100\u1f00\1\u4700"+
    "\40\u1f00\1\u4800\1\u4900\1\u1f00\1\u4a00\1\u4b00\1\u4c00\1\u4d00"+
    "\26\u1f00\1\u4e00\21\u1f00\246\u0100\1\u4f00\20\u0100\1\u5000\1\u5100"+
    "\77\u1f00\2\u0100\1\u5100\u0b05\u1f00\1\u5200\1\u5300\u02fe\u1f00";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\11\0\1\1\1\2\1\3\1\4\1\5\16\0\4\6"+
    "\1\7\1\6\1\10\1\6\1\11\1\6\1\12\1\13"+
    "\1\14\1\15\1\16\1\17\1\20\1\21\1\22\1\23"+
    "\1\24\11\25\1\6\1\26\1\27\1\30\1\31\2\6"+
    "\1\32\1\33\1\34\1\35\1\36\1\37\1\40\1\41"+
    "\1\42\2\11\1\43\1\44\1\45\1\46\1\47\1\11"+
    "\1\50\1\51\1\52\1\53\1\54\1\55\1\56\2\11"+
    "\1\57\1\60\1\61\1\62\1\63\1\6\1\64\1\65"+
    "\1\66\1\67\1\70\1\71\1\72\1\73\1\74\1\75"+
    "\1\76\1\77\1\100\1\101\1\102\1\103\1\11\1\104"+
    "\1\105\1\106\1\107\1\110\1\111\1\112\1\113\1\11"+
    "\1\114\1\6\1\115\1\6\6\0\1\116\32\0\2\6"+
    "\4\11\4\6\1\11\2\6\1\0\7\6\1\11\4\6"+
    "\1\11\5\6\27\11\1\6\37\11\1\6\u01ca\11\4\6"+
    "\14\11\16\6\5\11\7\6\1\11\1\6\1\11\21\6"+
    "\160\0\5\11\1\6\2\11\2\6\4\11\10\6\1\11"+
    "\1\6\3\11\1\6\1\11\1\6\24\11\1\6\123\11"+
    "\1\6\213\11\1\6\5\0\2\6\236\11\11\6\46\11"+
    "\2\6\1\11\7\6\47\11\7\6\1\11\1\6\55\0"+
    "\1\6\1\0\1\6\2\0\1\6\2\0\1\6\1\0"+
    "\10\6\33\11\5\6\3\11\15\6\5\0\6\6\1\11"+
    "\4\6\13\0\5\6\53\11\37\0\4\6\2\11\1\0"+
    "\143\11\1\6\1\11\10\0\1\6\6\0\2\11\2\0"+
    "\1\6\4\0\2\11\12\0\3\11\2\6\1\11\17\6"+
    "\1\0\1\11\1\0\36\11\33\0\2\6\131\11\13\0"+
    "\1\11\16\6\12\0\41\11\11\0\2\11\4\6\1\11"+
    "\5\6\26\11\4\0\1\11\11\0\1\11\3\0\1\11"+
    "\5\0\22\6\31\11\3\0\104\6\1\11\1\6\13\11"+
    "\67\6\33\0\1\6\4\0\66\11\3\0\1\11\22\0"+
    "\1\11\7\0\12\11\2\0\2\6\12\0\1\6\7\11"+
    "\1\6\7\11\1\6\3\0\1\6\10\11\2\6\2\11"+
    "\2\6\26\11\1\6\7\11\1\6\1\11\3\6\4\11"+
    "\2\6\1\0\1\11\7\0\2\6\2\0\2\6\3\0"+
    "\1\11\10\6\1\0\4\6\2\11\1\6\3\11\2\0"+
    "\2\6\12\0\4\11\7\6\1\11\5\6\3\0\1\6"+
    "\6\11\4\6\2\11\2\6\26\11\1\6\7\11\1\6"+
    "\2\11\1\6\2\11\1\6\2\11\2\6\1\0\1\6"+
    "\5\0\4\6\2\0\2\6\3\0\3\6\1\0\7\6"+
    "\4\11\1\6\1\11\7\6\14\0\3\11\1\0\13\6"+
    "\3\0\1\6\11\11\1\6\3\11\1\6\26\11\1\6"+
    "\7\11\1\6\2\11\1\6\5\11\2\6\1\0\1\11"+
    "\10\0\1\6\3\0\1\6\3\0\2\6\1\11\17\6"+
    "\2\11\2\0\2\6\12\0\1\6\1\11\17\6\3\0"+
    "\1\6\10\11\2\6\2\11\2\6\26\11\1\6\7\11"+
    "\1\6\2\11\1\6\5\11\2\6\1\0\1\11\7\0"+
    "\2\6\2\0\2\6\3\0\10\6\2\0\4\6\2\11"+
    "\1\6\3\11\2\0\2\6\12\0\1\6\1\11\20\6"+
    "\1\0\1\11\1\6\6\11\3\6\3\11\1\6\4\11"+
    "\3\6\2\11\1\6\1\11\1\6\2\11\3\6\2\11"+
    "\3\6\3\11\3\6\14\11\4\6\5\0\3\6\3\0"+
    "\1\6\4\0\2\6\1\11\6\6\1\0\16\6\12\0"+
    "\11\6\1\11\7\6\3\0\1\6\10\11\1\6\3\11"+
    "\1\6\27\11\1\6\12\11\1\6\5\11\3\6\1\11"+
    "\7\0\1\6\3\0\1\6\4\0\7\6\2\0\1\6"+
    "\2\11\6\6\2\11\2\0\2\6\12\0\22\6\2\0"+
    "\1\6\10\11\1\6\3\11\1\6\27\11\1\6\12\11"+
    "\1\6\5\11\2\6\1\0\1\11\7\0\1\6\3\0"+
    "\1\6\4\0\7\6\2\0\7\6\1\11\1\6\2\11"+
    "\2\0\2\6\12\0\1\6\2\11\17\6\2\0\1\6"+
    "\10\11\1\6\3\11\1\6\51\11\2\6\1\11\7\0"+
    "\1\6\3\0\1\6\4\0\1\11\10\6\1\0\10\6"+
    "\2\11\2\0\2\6\12\0\12\6\6\11\2\6\2\0"+
    "\1\6\22\11\3\6\30\11\1\6\11\11\1\6\1\11"+
    "\2\6\7\11\3\6\1\0\4\6\6\0\1\6\1\0"+
    "\1\6\10\0\22\6\2\0\15\6\60\11\1\0\2\11"+
    "\7\0\4\6\10\11\10\0\1\6\12\0\47\6\2\11"+
    "\1\6\1\11\2\6\2\11\1\6\1\11\2\6\1\11"+
    "\6\6\4\11\1\6\7\11\1\6\3\11\1\6\1\11"+
    "\1\6\1\11\2\6\2\11\1\6\4\11\1\0\2\11"+
    "\6\0\1\6\2\0\1\11\2\6\5\11\1\6\1\11"+
    "\1\6\6\0\2\6\12\0\2\6\4\11\40\6\1\11"+
    "\27\6\2\0\6\6\12\0\13\6\1\0\1\6\1\0"+
    "\1\6\1\0\4\6\2\0\10\11\1\6\44\11\4\6"+
    "\24\0\1\6\2\0\5\11\13\0\1\6\44\0\11\6"+
    "\1\0\71\6\53\11\24\0\1\11\12\0\6\6\6\11"+
    "\4\0\4\11\3\0\1\11\3\0\2\11\7\0\3\11"+
    "\4\0\15\11\14\0\1\11\17\0\2\6\46\11\1\6"+
    "\1\11\5\6\1\11\2\6\53\11\1\6\115\11\1\6"+
    "\4\11\2\6\7\11\1\6\1\11\1\6\4\11\2\6"+
    "\51\11\1\6\4\11\2\6\41\11\1\6\4\11\2\6"+
    "\7\11\1\6\1\11\1\6\4\11\2\6\17\11\1\6"+
    "\71\11\1\6\4\11\2\6\103\11\2\6\3\0\40\6"+
    "\20\11\20\6\125\11\14\6\u016c\11\2\6\21\11\1\6"+
    "\32\11\5\6\113\11\3\6\3\11\17\6\15\11\1\6"+
    "\4\11\3\0\13\6\22\11\3\0\13\6\22\11\2\0"+
    "\14\6\15\11\1\6\3\11\1\6\2\0\14\6\64\11"+
    "\40\0\3\6\1\11\3\6\2\11\1\0\2\6\12\0"+
    "\41\6\3\0\2\6\12\0\6\6\130\11\10\6\51\11"+
    "\1\0\1\11\5\6\106\11\12\6\35\11\3\6\14\0"+
    "\4\6\14\0\12\6\12\0\36\11\2\6\5\11\13\6"+
    "\54\11\4\6\21\0\7\11\2\0\6\6\12\0\46\6"+
    "\27\11\5\0\4\6\65\11\12\0\1\6\35\0\2\6"+
    "\13\0\6\6\12\0\15\6\1\11\130\6\5\0\57\11"+
    "\21\0\7\11\4\6\12\0\21\6\11\0\14\6\3\0"+
    "\36\11\15\0\2\11\12\0\54\11\16\0\14\6\44\11"+
    "\24\0\10\6\12\0\3\6\3\11\12\0\44\11\122\6"+
    "\3\0\1\6\25\0\4\11\1\0\4\11\3\0\2\11"+
    "\11\6\300\11\47\0\25\6\4\0\26\11\2\6\6\11"+
    "\2\6\46\11\2\6\6\11\2\6\10\11\1\6\1\11"+
    "\1\6\1\11\1\6\1\11\1\6\37\11\2\6\65\11"+
    "\1\6\7\11\1\6\1\11\3\6\3\11\1\6\7\11"+
    "\3\6\4\11\2\6\6\11\4\6\15\11\5\6\3\11"+
    "\1\6\7\11\16\6\5\0\30\6\2\3\5\0\20\6"+
    "\2\11\23\6\1\11\13\6\5\0\5\6\6\0\1\6"+
    "\1\11\15\6\1\11\20\6\15\11\3\6\33\11\25\6"+
    "\15\0\4\6\1\0\3\6\14\0\21\6\1\11\4\6"+
    "\1\11\2\6\12\11\1\6\1\11\3\6\5\11\6\6"+
    "\1\11\1\6\1\11\1\6\1\11\1\6\4\11\1\6"+
    "\13\11\2\6\4\11\5\6\5\11\4\6\1\11\21\6"+
    "\51\11\u0177\6\57\11\1\6\57\11\1\6\205\11\6\6"+
    "\4\11\3\0\2\11\14\6\46\11\1\6\1\11\5\6"+
    "\1\11\2\6\70\11\7\6\1\11\17\6\1\0\27\11"+
    "\11\6\7\11\1\6\7\11\1\6\7\11\1\6\7\11"+
    "\1\6\7\11\1\6\7\11\1\6\7\11\1\6\7\11"+
    "\1\6\40\0\57\6\1\11\325\6\3\11\31\6\11\11"+
    "\6\0\1\6\5\11\2\6\5\11\4\6\126\11\2\6"+
    "\2\0\2\6\3\11\1\6\132\11\1\6\4\11\5\6"+
    "\51\11\3\6\136\11\21\6\33\11\65\6\306\11\112\6"+
    "\315\11\63\6\215\11\103\6\56\11\2\6\15\11\3\6"+
    "\20\11\12\0\2\11\24\6\57\11\1\0\4\6\12\0"+
    "\1\6\31\11\7\6\1\0\120\11\2\0\45\6\11\11"+
    "\2\6\147\11\2\6\4\11\1\6\4\11\14\6\13\11"+
    "\115\6\12\11\1\0\3\11\1\0\4\11\1\0\27\11"+
    "\5\0\20\6\1\11\7\6\64\11\14\6\2\0\62\11"+
    "\21\0\13\6\12\0\6\6\22\0\6\11\3\6\1\11"+
    "\4\6\12\0\34\11\10\0\2\6\27\11\15\0\14\6"+
    "\35\11\3\6\4\0\57\11\16\0\16\6\1\11\12\0"+
    "\46\6\51\11\16\0\11\6\3\11\1\0\10\11\2\0"+
    "\2\6\12\0\6\6\27\11\3\6\1\11\1\0\4\6"+
    "\60\11\1\0\1\11\3\0\2\11\2\0\5\11\2\0"+
    "\1\11\1\0\1\11\30\6\3\11\2\6\13\11\5\0"+
    "\2\6\3\11\2\0\12\6\6\11\2\6\6\11\2\6"+
    "\6\11\11\6\7\11\1\6\7\11\221\6\43\11\10\0"+
    "\1\6\2\0\2\6\12\0\6\6\244\11\14\6\27\11"+
    "\4\6\61\11\4\6\u0100\3\156\11\2\6\152\11\46\6"+
    "\7\11\14\6\5\11\5\6\1\11\1\0\12\11\1\6"+
    "\15\11\1\6\5\11\1\6\1\11\1\6\2\11\1\6"+
    "\2\11\1\6\154\11\41\6\153\11\22\6\100\11\2\6"+
    "\66\11\50\6\15\11\3\6\20\0\20\6\7\0\14\6"+
    "\2\11\30\6\3\11\31\6\1\11\6\6\5\11\1\6"+
    "\207\11\2\6\1\0\4\6\1\11\13\6\12\0\7\6"+
    "\32\11\4\6\1\11\1\6\32\11\13\6\131\11\3\6"+
    "\6\11\2\6\6\11\2\6\6\11\2\6\3\11\3\6"+
    "\2\11\3\6\2\11\22\6\3\0\4\6\14\11\1\6"+
    "\32\11\1\6\23\11\1\6\2\11\1\6\17\11\2\6"+
    "\16\11\42\6\173\11\105\6\65\11\210\6\1\0\202\6"+
    "\35\11\3\6\61\11\57\6\37\11\21\6\33\11\65\6"+
    "\36\11\2\6\44\11\4\6\10\11\1\6\5\11\52\6"+
    "\236\11\2\6\12\0\126\6\6\11\2\6\1\11\1\6"+
    "\54\11\1\6\2\11\3\6\1\11\2\6\27\11\252\6"+
    "\26\11\12\6\32\11\106\6\70\11\6\6\2\11\100\6"+
    "\1\11\3\0\1\6\2\0\5\6\4\0\4\11\1\6"+
    "\3\11\1\6\33\11\4\6\3\0\4\6\1\0\40\6"+
    "\35\11\203\6\66\11\12\6\26\11\12\6\23\11\215\6"+
    "\111\11\267\6\3\0\65\11\17\0\37\6\12\0\20\6"+
    "\3\0\55\11\13\0\2\6\1\0\22\6\31\11\7\6"+
    "\12\0\6\6\3\0\44\11\16\0\1\6\12\0\100\6"+
    "\3\0\60\11\16\0\4\11\13\6\12\0\246\6\53\11"+
    "\15\0\10\6\12\0\66\6\157\11\221\6\143\11\235\6"+
    "\57\11\321\6\71\11\307\6\105\11\13\6\1\11\56\0"+
    "\20\6\4\0\15\11\140\6\2\11\u0163\6\5\0\3\6"+
    "\26\0\2\6\7\0\36\6\4\0\224\6\3\0\273\6"+
    "\125\11\1\6\107\11\1\6\2\11\2\6\1\11\2\6"+
    "\2\11\2\6\4\11\1\6\14\11\1\6\1\11\1\6"+
    "\7\11\1\6\101\11\1\6\4\11\2\6\10\11\1\6"+
    "\7\11\1\6\34\11\1\6\4\11\1\6\5\11\1\6"+
    "\1\11\3\6\7\11\1\6\u0154\11\2\6\31\11\1\6"+
    "\31\11\1\6\37\11\1\6\31\11\1\6\37\11\1\6"+
    "\31\11\1\6\37\11\1\6\31\11\1\6\37\11\1\6"+
    "\31\11\1\6\10\11\2\6\62\0\4\11\1\6\33\11"+
    "\1\6\2\11\1\6\1\11\2\6\1\11\1\6\12\11"+
    "\1\6\4\11\1\6\1\11\1\6\1\11\6\6\1\11"+
    "\4\6\1\11\1\6\1\11\1\6\1\11\1\6\3\11"+
    "\1\6\2\11\1\6\1\11\2\6\1\11\1\6\1\11"+
    "\1\6\1\11\1\6\1\11\1\6\1\11\1\6\2\11"+
    "\1\6\1\11\2\6\4\11\1\6\7\11\1\6\4\11"+
    "\1\6\4\11\1\6\1\11\1\6\12\11\1\6\21\11"+
    "\5\6\3\11\1\6\5\11\1\6\21\11\104\6\327\11"+
    "\51\6\65\11\13\6\336\11\343\6\1\0\36\6\140\0"+
    "\200\6\360\0\20\6";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[21504];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\2\2\1\3\1\4\1\5\1\6\1\7"+
    "\1\10\1\11\1\12\1\13\1\14\1\15\1\16\2\17"+
    "\1\20\1\21\1\22\1\23\25\4\1\24\1\25\1\26"+
    "\1\27\2\4\1\30\1\31\1\3\1\0\1\32\1\33"+
    "\1\34\1\35\1\36\1\37\1\17\2\36\1\40\1\41"+
    "\1\17\1\42\1\43\3\4\1\44\22\4\1\44\20\4"+
    "\2\44\13\4\1\44\32\4\1\45\1\4\2\3\1\36"+
    "\1\0\1\17\1\46\1\47\2\4\1\44\33\4\1\44"+
    "\6\4\1\44\12\4\1\44\5\4\1\44\32\4\1\44"+
    "\12\4\1\0\6\4\1\50\1\4\1\51\1\4\1\52"+
    "\17\4\1\53\37\4\1\54\7\4\1\44\13\4\1\55"+
    "\33\4\1\56\1\4\1\57\6\4\1\60\10\4\1\61"+
    "\6\4\1\44\4\4\1\62\1\44\7\4\1\63\1\64"+
    "\3\4\1\65\1\4\1\66\1\67\2\4\1\70\1\4"+
    "\1\0\13\4\1\0\6\4\1\71\1\0\3\4\1\0"+
    "\2\4\5\0\1\44";

  private static int [] zzUnpackAction() {
    int [] result = new int[439];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\117\0\117\0\236\0\355\0\u013c\0\u018b\0\u01da"+
    "\0\117\0\117\0\u0229\0\u0278\0\117\0\u02c7\0\u0316\0\u0365"+
    "\0\u03b4\0\u0403\0\117\0\u0452\0\117\0\u04a1\0\u04f0\0\u053f"+
    "\0\u058e\0\u05dd\0\u062c\0\u067b\0\u06ca\0\u0719\0\u0768\0\u07b7"+
    "\0\u0806\0\u0855\0\u08a4\0\u08f3\0\u0942\0\u0991\0\u09e0\0\u0a2f"+
    "\0\u0a7e\0\u0acd\0\u0b1c\0\117\0\117\0\117\0\u0b6b\0\u0bba"+
    "\0\u0c09\0\117\0\117\0\117\0\u0c58\0\117\0\117\0\117"+
    "\0\117\0\u0ca7\0\117\0\u0cf6\0\117\0\u0d45\0\117\0\117"+
    "\0\u0d94\0\u0de3\0\u0e32\0\u0e81\0\u0ed0\0\u0f1f\0\u013c\0\u0f6e"+
    "\0\u0fbd\0\u100c\0\u105b\0\u10aa\0\u10f9\0\u1148\0\u1197\0\u11e6"+
    "\0\u1235\0\u1284\0\u12d3\0\u1322\0\u1371\0\u13c0\0\u140f\0\u145e"+
    "\0\u14ad\0\u14fc\0\u154b\0\u159a\0\u15e9\0\u1638\0\u1687\0\u16d6"+
    "\0\u1725\0\u1774\0\u17c3\0\u1812\0\u1861\0\u18b0\0\u18ff\0\u194e"+
    "\0\u199d\0\u19ec\0\u1a3b\0\u1a8a\0\u1ad9\0\u1b28\0\u1b77\0\u1bc6"+
    "\0\u1c15\0\u1c64\0\u1cb3\0\u1d02\0\u1d51\0\u1da0\0\u1def\0\u1e3e"+
    "\0\u1e8d\0\u1edc\0\u1f2b\0\u1f7a\0\u1fc9\0\u2018\0\u2067\0\u20b6"+
    "\0\u2105\0\u2154\0\u21a3\0\u21f2\0\u2241\0\u2290\0\u22df\0\u232e"+
    "\0\u237d\0\u23cc\0\u241b\0\u246a\0\u24b9\0\u2508\0\u2557\0\u25a6"+
    "\0\u25f5\0\u2644\0\117\0\u2693\0\u26e2\0\u2731\0\u2780\0\u27cf"+
    "\0\u281e\0\117\0\117\0\u286d\0\u28bc\0\u290b\0\u295a\0\u29a9"+
    "\0\u29f8\0\u2a47\0\u2a96\0\u2ae5\0\u2b34\0\u2b83\0\u2bd2\0\u2c21"+
    "\0\u2c70\0\u2cbf\0\u2d0e\0\u2d5d\0\u2dac\0\u2dfb\0\u2e4a\0\u2e99"+
    "\0\u2ee8\0\u2f37\0\u2f86\0\u2fd5\0\u3024\0\u3073\0\u30c2\0\u3111"+
    "\0\u3160\0\u31af\0\u31fe\0\u324d\0\u329c\0\u32eb\0\u333a\0\u3389"+
    "\0\u33d8\0\u3427\0\u3476\0\u34c5\0\u3514\0\u3563\0\u35b2\0\u3601"+
    "\0\u3650\0\u369f\0\u36ee\0\u373d\0\u378c\0\u37db\0\u382a\0\u3879"+
    "\0\u38c8\0\u3917\0\u3966\0\u39b5\0\u3a04\0\u3a53\0\u3aa2\0\u3af1"+
    "\0\u3b40\0\u3b8f\0\u3bde\0\u3c2d\0\u3c7c\0\u3ccb\0\u3d1a\0\u3d69"+
    "\0\u3db8\0\u3e07\0\u3e56\0\u3ea5\0\u3ef4\0\u3f43\0\u3f92\0\u3fe1"+
    "\0\u4030\0\u407f\0\u40ce\0\u411d\0\u416c\0\u41bb\0\u420a\0\u4259"+
    "\0\u42a8\0\u42f7\0\u4346\0\u4395\0\u43e4\0\u4433\0\u4482\0\u44d1"+
    "\0\u4520\0\u456f\0\u45be\0\u460d\0\u465c\0\u46ab\0\u013c\0\u46fa"+
    "\0\u013c\0\u4749\0\u013c\0\u4798\0\u47e7\0\u4836\0\u4885\0\u48d4"+
    "\0\u4923\0\u4972\0\u49c1\0\u4a10\0\u4a5f\0\u4aae\0\u4afd\0\u4b4c"+
    "\0\u4b9b\0\u4bea\0\u013c\0\u4c39\0\u4c88\0\u4cd7\0\u4d26\0\u4d75"+
    "\0\u4dc4\0\u4e13\0\u4e62\0\u4eb1\0\u4f00\0\u4f4f\0\u4f9e\0\u4fed"+
    "\0\u503c\0\u508b\0\u50da\0\u5129\0\u5178\0\u51c7\0\u5216\0\u5265"+
    "\0\u52b4\0\u5303\0\u5352\0\u53a1\0\u53f0\0\u543f\0\u548e\0\u54dd"+
    "\0\u552c\0\u557b\0\u013c\0\u55ca\0\u5619\0\u5668\0\u56b7\0\u5706"+
    "\0\u5755\0\u57a4\0\u57f3\0\u5842\0\u5891\0\u58e0\0\u592f\0\u597e"+
    "\0\u59cd\0\u5a1c\0\u5a6b\0\u5aba\0\u5b09\0\u5b58\0\u013c\0\u5ba7"+
    "\0\u5bf6\0\u5c45\0\u5c94\0\u5ce3\0\u5d32\0\u5d81\0\u5dd0\0\u5e1f"+
    "\0\u5e6e\0\u5ebd\0\u5f0c\0\u5f5b\0\u5faa\0\u5ff9\0\u6048\0\u6097"+
    "\0\u60e6\0\u6135\0\u6184\0\u61d3\0\u6222\0\u6271\0\u62c0\0\u630f"+
    "\0\u635e\0\u63ad\0\u013c\0\u63fc\0\u013c\0\u644b\0\u649a\0\u64e9"+
    "\0\u6538\0\u6587\0\u65d6\0\u013c\0\u6625\0\u6674\0\u66c3\0\u6712"+
    "\0\u6761\0\u67b0\0\u67ff\0\u416c\0\u013c\0\u684e\0\u689d\0\u68ec"+
    "\0\u693b\0\u698a\0\u69d9\0\u6a28\0\u6a77\0\u6ac6\0\u6b15\0\u6b64"+
    "\0\u013c\0\u29f8\0\u6bb3\0\u6c02\0\u6c51\0\u6ca0\0\u6cef\0\u6d3e"+
    "\0\u6d8d\0\u013c\0\u013c\0\u6ddc\0\u6e2b\0\u6e7a\0\u013c\0\u6ec9"+
    "\0\u013c\0\u013c\0\u6f18\0\u6f67\0\u013c\0\u6fb6\0\u7005\0\u7054"+
    "\0\u70a3\0\u70f2\0\u7141\0\u7190\0\u71df\0\u722e\0\u727d\0\u72cc"+
    "\0\u731b\0\u736a\0\u73b9\0\u7408\0\u7457\0\u74a6\0\u74f5\0\u7544"+
    "\0\u7593\0\u013c\0\u75e2\0\u7631\0\u7680\0\u76cf\0\u771e\0\u776d"+
    "\0\u77bc\0\u780b\0\u785a\0\u78a9\0\u78f8\0\u7947\0\117";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[439];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\2\3\1\2\1\3\1\4\1\2\1\3\1\5"+
    "\1\6\1\7\1\10\1\11\1\12\1\13\1\14\1\15"+
    "\1\16\1\17\1\20\1\21\1\22\1\23\1\24\1\25"+
    "\1\26\1\27\1\30\1\31\1\32\1\33\1\34\1\35"+
    "\1\36\1\37\1\40\1\41\1\42\1\43\1\44\1\45"+
    "\1\46\1\47\1\50\1\51\1\52\1\53\1\54\1\55"+
    "\1\56\1\57\6\6\1\60\14\6\1\61\5\6\1\62"+
    "\1\63\1\2\121\0\1\3\114\0\2\5\1\0\2\5"+
    "\1\0\2\5\1\64\47\5\1\65\36\5\1\6\10\0"+
    "\1\6\12\0\2\6\4\0\25\6\4\0\31\6\2\0"+
    "\1\6\30\0\1\66\66\0\2\10\4\0\110\10\31\0"+
    "\1\67\116\0\1\70\116\0\1\71\112\0\2\72\121\0"+
    "\1\73\110\0\1\72\1\0\2\22\5\0\1\74\1\0"+
    "\1\75\1\76\1\77\3\0\1\100\12\0\1\101\4\0"+
    "\1\22\1\0\1\74\1\0\1\75\1\76\1\77\5\0"+
    "\1\100\12\0\1\101\26\0\1\72\1\0\2\22\7\0"+
    "\1\75\1\76\1\77\3\0\1\100\17\0\1\22\3\0"+
    "\1\75\1\76\1\77\5\0\1\100\46\0\1\102\120\0"+
    "\1\103\65\0\1\6\10\0\1\6\12\0\2\6\4\0"+
    "\25\6\4\0\4\6\1\104\7\6\1\105\1\6\1\106"+
    "\3\6\1\107\6\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\17\6\1\110\10\6\1\111"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\1\6"+
    "\1\112\1\113\1\114\4\6\1\115\1\116\2\6\1\117"+
    "\2\6\1\120\1\121\1\122\3\6\4\0\1\6\1\123"+
    "\6\6\1\124\3\6\1\125\2\6\1\126\11\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\1\6\1\127\3\6\1\130\3\6\1\131\5\6\1\132"+
    "\11\6\2\0\2\6\10\0\1\6\12\0\2\6\4\0"+
    "\25\6\4\0\1\6\1\133\12\6\1\134\1\6\1\135"+
    "\2\6\1\136\3\6\1\137\1\6\1\140\1\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\1\6\1\141\7\6\1\142\5\6\1\143\1\6\1\144"+
    "\2\6\1\145\4\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\5\6\1\146\6\6\1\147"+
    "\2\6\1\150\11\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\1\6\1\151\27\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\6\6\1\107\6\6\1\152\1\153\3\6\1\154\6\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\5\6\1\155\3\6\1\156\5\6\1\157\11\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\5\6\1\107\11\6\1\160\4\6\1\161\3\6"+
    "\1\162\2\0\2\6\10\0\1\6\12\0\2\6\4\0"+
    "\25\6\4\0\1\6\1\163\3\6\1\164\11\6\1\165"+
    "\11\6\2\0\2\6\10\0\1\6\12\0\2\6\4\0"+
    "\25\6\4\0\2\6\1\166\3\6\1\107\7\6\1\107"+
    "\1\6\1\167\1\170\2\6\1\155\1\171\3\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\1\6\1\172\17\6\1\173\2\6\1\174\4\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\4\6\1\175"+
    "\20\6\4\0\1\6\1\176\3\6\1\177\23\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\1\6\1\200"+
    "\23\6\4\0\5\6\1\201\2\6\1\202\1\203\11\6"+
    "\1\204\1\205\3\6\1\206\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\10\6\1\207\6\6"+
    "\1\107\1\6\1\210\6\6\1\211\2\0\2\6\10\0"+
    "\1\6\12\0\2\6\4\0\10\6\1\212\1\213\5\6"+
    "\1\214\5\6\4\0\22\6\1\215\6\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\1\6"+
    "\1\216\27\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\5\6\1\217\2\6\1\220\1\221"+
    "\7\6\1\222\7\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\17\6\1\143\11\6\2\0"+
    "\1\6\30\0\1\223\66\0\1\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\1\6\1\141\27\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\21\6\1\224\7\6\2\0\1\6\1\5\1\225\2\5"+
    "\1\225\1\226\1\5\1\225\107\5\24\0\2\72\7\0"+
    "\1\75\1\76\1\77\23\0\1\72\3\0\1\75\1\76"+
    "\1\77\51\0\2\74\15\0\1\100\17\0\1\74\13\0"+
    "\1\100\36\0\1\227\1\0\1\227\2\0\2\227\7\0"+
    "\1\75\1\0\1\77\23\0\1\227\3\0\1\75\1\0"+
    "\1\77\47\0\1\230\1\0\2\231\4\0\6\231\3\0"+
    "\1\100\17\0\7\231\5\0\1\100\47\0\1\232\116\0"+
    "\1\233\66\0\1\6\10\0\1\6\12\0\2\6\4\0"+
    "\25\6\4\0\4\6\1\234\24\6\2\0\2\6\10\0"+
    "\1\6\12\0\2\6\4\0\25\6\4\0\11\6\1\235"+
    "\17\6\2\0\2\6\10\0\1\6\12\0\2\6\4\0"+
    "\25\6\4\0\4\6\1\236\24\6\2\0\2\6\10\0"+
    "\1\6\12\0\2\6\4\0\25\6\4\0\17\6\1\237"+
    "\11\6\2\0\2\6\10\0\1\6\12\0\2\6\4\0"+
    "\16\6\1\240\3\6\1\241\2\6\4\0\23\6\1\242"+
    "\5\6\2\0\2\6\10\0\1\6\12\0\2\6\4\0"+
    "\25\6\4\0\17\6\1\243\10\6\1\244\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\10\6"+
    "\1\245\20\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\1\6\1\244\1\246\2\6\1\247"+
    "\23\6\2\0\2\6\10\0\1\6\12\0\2\6\4\0"+
    "\25\6\4\0\16\6\1\155\12\6\2\0\2\6\10\0"+
    "\1\6\12\0\2\6\4\0\25\6\4\0\16\6\1\250"+
    "\12\6\2\0\2\6\10\0\1\6\12\0\2\6\4\0"+
    "\25\6\4\0\2\6\1\251\26\6\2\0\2\6\10\0"+
    "\1\6\12\0\2\6\4\0\1\6\1\252\23\6\4\0"+
    "\10\6\1\253\5\6\1\250\4\6\1\143\5\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\30\6\1\254\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\10\6\1\115\1\116\5\6\1\255\5\6\4\0"+
    "\31\6\2\0\2\6\10\0\1\6\12\0\2\6\4\0"+
    "\25\6\4\0\14\6\1\246\5\6\1\256\1\133\5\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\1\6\1\257\27\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\1\6\1\260\27\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\16\6\1\261\12\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\23\6\1\262\5\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\3\6\1\263\2\6\1\264\5\6\1\265\14\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\15\6\1\107\3\6\1\266\7\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\24\6"+
    "\1\267\4\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\3\6\1\270\25\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\22\6"+
    "\1\271\6\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\4\6\1\272\17\6\1\273\4\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\1\6\1\274\17\6\1\53\7\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\5\6"+
    "\1\115\23\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\11\6\1\155\17\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\14\6"+
    "\1\275\14\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\16\6\1\276\12\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\21\6"+
    "\1\107\7\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\11\6\1\277\17\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\16\6"+
    "\1\300\12\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\23\6\1\301\5\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\17\6"+
    "\1\302\11\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\17\6\1\303\1\304\4\6\4\0\31\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\16\6\1\305\12\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\20\6\1\306\10\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\10\6\1\307\12\6\1\310\5\6\2\0\2\6\10\0"+
    "\1\6\12\0\2\6\4\0\13\6\1\311\11\6\4\0"+
    "\31\6\2\0\2\6\10\0\1\6\12\0\2\6\4\0"+
    "\25\6\4\0\23\6\1\107\5\6\2\0\2\6\10\0"+
    "\1\6\12\0\2\6\4\0\25\6\4\0\2\6\1\107"+
    "\10\6\1\256\15\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\16\6\1\312\1\313\11\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\4\6\1\314\24\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\22\6\1\315\6\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\1\6"+
    "\1\316\1\317\22\6\4\0\31\6\2\0\2\6\10\0"+
    "\1\6\12\0\2\6\4\0\25\6\4\0\15\6\1\320"+
    "\3\6\1\321\7\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\26\6\1\107\1\155\1\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\23\6\1\322\5\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\12\6\1\323\16\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\5\6\1\324\15\6\1\325\5\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\4\6\1\326\20\6"+
    "\4\0\31\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\5\6\1\327\23\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\21\6"+
    "\1\330\7\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\11\6\1\331\5\6\1\332\11\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\2\6\1\333\26\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\12\6\1\107\12\6\4\0\31\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\11\6\1\334\17\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\3\6\1\335\21\6\4\0\1\6"+
    "\1\336\13\6\1\337\4\6\1\340\1\341\5\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\30\6\1\342\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\14\6\1\343\6\6\1\107\5\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\1\6\1\344\15\6\1\345\11\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\16\6"+
    "\1\346\12\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\1\6\1\347\3\6\1\313\11\6"+
    "\1\313\1\6\1\350\7\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\2\6\1\107\26\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\16\6\1\351\12\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\5\6\1\352\13\6"+
    "\1\353\7\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\24\6\1\354\3\6\1\355\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\20\6\1\356\10\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\16\6\1\357\12\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\17\6\1\360\11\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\10\6\1\361\20\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\11\6\1\116\17\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\21\6\1\362\7\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\16\6\1\363\12\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\5\6\1\352\3\6\1\364"+
    "\17\6\2\0\2\6\10\0\1\6\12\0\2\6\4\0"+
    "\25\6\4\0\4\6\1\365\16\6\1\366\5\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\11\6\1\367\17\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\24\6\1\354\4\6\2\0"+
    "\1\6\1\5\1\225\2\5\1\225\1\226\1\5\1\225"+
    "\1\64\47\5\1\65\43\5\1\0\2\5\1\64\47\5"+
    "\1\65\36\5\24\0\2\227\7\0\1\75\1\0\1\77"+
    "\23\0\1\227\3\0\1\75\1\0\1\77\51\0\2\370"+
    "\4\0\6\370\23\0\7\370\47\0\1\370\1\0\2\231"+
    "\4\0\6\231\3\0\1\100\3\0\1\76\13\0\7\231"+
    "\5\0\1\100\3\0\1\76\13\0\1\6\10\0\1\6"+
    "\12\0\2\6\4\0\7\6\1\371\15\6\4\0\21\6"+
    "\1\372\7\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\1\6\1\373\27\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\1\374\24\6\4\0"+
    "\31\6\2\0\2\6\10\0\1\6\12\0\2\6\4\0"+
    "\25\6\4\0\14\6\1\375\14\6\2\0\2\6\10\0"+
    "\1\6\12\0\2\6\4\0\25\6\4\0\5\6\1\376"+
    "\23\6\2\0\2\6\10\0\1\6\12\0\2\6\4\0"+
    "\25\6\4\0\1\6\1\246\27\6\2\0\2\6\10\0"+
    "\1\6\12\0\2\6\4\0\25\6\4\0\5\6\1\377"+
    "\23\6\2\0\2\6\10\0\1\6\12\0\2\6\4\0"+
    "\25\6\4\0\17\6\1\246\11\6\2\0\2\6\10\0"+
    "\1\6\12\0\2\6\4\0\25\6\4\0\23\6\1\256"+
    "\5\6\2\0\2\6\10\0\1\6\12\0\2\6\4\0"+
    "\25\6\4\0\1\6\1\143\27\6\2\0\2\6\10\0"+
    "\1\6\12\0\2\6\4\0\25\6\4\0\14\6\1\107"+
    "\14\6\2\0\2\6\10\0\1\6\12\0\2\6\4\0"+
    "\25\6\4\0\3\6\1\107\25\6\2\0\2\6\10\0"+
    "\1\6\12\0\2\6\4\0\25\6\4\0\7\6\1\107"+
    "\21\6\2\0\2\6\10\0\1\6\12\0\2\6\4\0"+
    "\25\6\4\0\12\6\1\107\16\6\2\0\2\6\10\0"+
    "\1\6\12\0\2\6\4\0\25\6\4\0\30\6\1\244"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\17\6\1\u0100\11\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\20\6\1\256\10\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\10\6\1\253\20\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\5\6\1\107\23\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\21\6\1\u0101\7\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\22\6\1\373\6\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\22\6\1\155\1\u0102\5\6\2\0\2\6\10\0"+
    "\1\6\12\0\2\6\4\0\25\6\4\0\5\6\1\u0103"+
    "\23\6\2\0\2\6\10\0\1\6\12\0\2\6\4\0"+
    "\25\6\4\0\11\6\1\u0104\2\6\1\u0105\14\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\1\6\1\u0106\27\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\5\6\1\u0107\23\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\5\6\1\u0108\23\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\2\6\1\u0109\26\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\10\6\1\107\20\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\5\6\1\272\23\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\10\6\1\376"+
    "\14\6\4\0\31\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\15\6\1\107\13\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\22\6\1\256\6\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\22\6\1\u010a\6\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\1\6\1\u010b\27\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\5\6\1\217\23\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\3\6\1\u010c\25\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\20\6\1\121\3\6\1\u010d\4\0\31\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\2\6\1\241\26\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\24\6\1\205\4\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\17\6\1\107\11\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\4\6\1\u010e\24\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\14\6\1\u010f\2\6\1\u0110\11\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\5\6"+
    "\1\u0111\23\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\5\6\1\u0112\23\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\17\6"+
    "\1\155\11\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\7\6\1\u0113\21\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\20\6"+
    "\1\107\10\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\24\6\1\u0114\4\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\23\6"+
    "\1\u0115\5\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\1\6\1\274\27\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\14\6"+
    "\1\125\14\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\5\6\1\u0116\23\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\21\6"+
    "\1\u0117\7\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\10\6\1\u0118\3\6\1\u0119\10\6\4\0\10\6"+
    "\1\215\20\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\5\6\1\u011a\23\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\21\6"+
    "\1\u011b\7\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\11\6\1\u011c\17\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\14\6"+
    "\1\274\14\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\21\6\1\u011d\7\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\1\6"+
    "\1\u011e\21\6\1\u011f\5\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\25\6\1\u0120\3\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\20\6\1\u0121\2\6\1\u0122\5\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\14\6"+
    "\1\u0123\14\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\22\6\1\u0124\6\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\11\6"+
    "\1\273\17\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\4\6\1\u0125\24\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\17\6"+
    "\1\u0126\11\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\24\6\1\u0127\4\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\24\6"+
    "\1\u0128\4\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\23\6\1\u0129\5\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\5\6"+
    "\1\u012a\23\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\4\6\1\u012b\14\6\1\u012c\7\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\21\6\1\u012d\7\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\7\6\1\u012e\21\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\23\6\1\u0123\5\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\11\6\1\u012f\12\6"+
    "\1\u0130\4\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\3\6\1\u0131\25\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\16\6"+
    "\1\107\12\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\17\6\1\u0132\11\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\5\6"+
    "\1\u0133\23\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\2\6\1\u0134\22\6\4\0\31\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\5\6"+
    "\1\u0135\23\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\23\6\1\u0136\5\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\16\6"+
    "\1\u0137\12\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\17\6\1\u0138\11\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\11\6"+
    "\1\u0139\17\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\4\6\1\107\24\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\14\6"+
    "\1\256\14\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\5\6\1\u013a\23\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\10\6"+
    "\1\u013b\20\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\23\6\1\u013c\5\6\2\0\1\6"+
    "\24\0\2\370\4\0\6\370\7\0\1\76\13\0\7\370"+
    "\11\0\1\76\13\0\1\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\1\6\1\u013d\27\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\5\6"+
    "\1\u013e\23\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\22\6\1\107\6\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\14\6"+
    "\1\u013f\14\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\5\6\1\u0140\23\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\6\6"+
    "\1\107\22\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\21\6\1\155\7\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\11\6"+
    "\1\u0141\17\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\15\6\1\u0142\13\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\1\6"+
    "\1\u0143\27\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\24\6\1\u0144\4\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\7\6"+
    "\1\u0120\21\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\3\6\1\u0145\25\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\14\6"+
    "\1\u0146\14\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\5\6\1\u0147\23\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\14\6"+
    "\1\u0148\14\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\23\6\1\u0149\5\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\12\6\1\u014a\12\6"+
    "\4\0\31\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\14\6\1\u014b\14\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\5\6"+
    "\1\u014c\23\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\21\6\1\u014d\7\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\21\6"+
    "\1\u014e\7\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\7\6\1\u014f\11\6\1\u0150\7\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\14\6\1\u0151\14\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\10\6\1\u0152\3\6\1\u0153\10\6"+
    "\4\0\31\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\22\6\1\u0154\6\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\17\6"+
    "\1\u0155\11\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\16\6\1\u0156\12\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\25\6"+
    "\1\u0157\3\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\3\6\1\u0158\25\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\1\6"+
    "\1\u0159\27\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\17\6\1\u015a\11\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\14\6"+
    "\1\u015b\4\6\1\u015c\7\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\15\6\1\u015d\13\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\11\6\1\241\17\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\1\6\1\244\27\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\5\6\1\u015e\23\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\5\6\1\u015f\23\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\11\6\1\247\17\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\5\6\1\u0160\23\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\14\6"+
    "\1\u0161\10\6\4\0\31\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\25\6\1\u0162\3\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\15\6\1\256\13\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\21\6\1\352\7\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\5\6\1\u0163\23\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\3\6\1\155\25\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\17\6\1\u0164\11\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\5\6\1\363\23\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\23\6\1\u0165\5\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\14\6\1\u0166\14\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\16\6\1\u0167\12\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\3\6\1\u0168\25\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\11\6"+
    "\1\u0169\13\6\4\0\31\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\26\6\1\107\2\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\1\6\1\u016a\27\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\14\6\1\376\10\6\4\0\31\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\5\6\1\u016b\23\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\7\6\1\u016c\21\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\21\6\1\u016d\7\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\1\6\1\115\27\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\16\6\1\215\12\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\4\6\1\u016e\20\6\4\0\31\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\5\6\1\u0125\23\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\16\6\1\u016f\12\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\22\6\1\u0170\6\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\22\6\1\304\6\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\1\6\1\u0171\27\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\16\6\1\u0172\12\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\1\6\1\u0173\27\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\21\6\1\256\7\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\14\6\1\155\14\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\23\6\1\u0174\5\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\5\6\1\u0175\23\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\14\6\1\u0176\14\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\11\6\1\u0177\17\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\11\6\1\u0178\13\6\4\0\31\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\5\6\1\373\23\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\15\6\1\u0179\13\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\23\6\1\373\5\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\11\6\1\u014d\17\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\5\6\1\u017a\23\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\6\6\1\u017b\22\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\5\6\1\u017c\23\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\16\6\1\u017d\12\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\25\6\1\u017e\3\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\20\6\1\u017b\10\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\26\6\1\215\2\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\10\6\1\u017f\20\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\5\6\1\u0180\23\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\23\6\1\u0181\5\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\23\6\1\53\5\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\16\6\1\u0182\12\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\17\6\1\u0183\11\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\11\6\1\u0184\17\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\1\u0185"+
    "\24\6\4\0\31\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\21\6\1\u0186\7\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\3\6\1\u0187\25\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\4\6\1\u0188\20\6\4\0\31\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\16\6\1\u0148\12\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\5\6\1\u0189\23\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\26\6\1\373\2\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\5\6\1\u018a\23\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\7\6\1\u018b\21\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\23\6\1\u018c\5\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\17\6\1\u018d\11\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\22\6\1\155\6\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\7\6\1\u018e\21\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\23\6\1\u018f\5\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\25\6\1\u0179\3\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\4\6\1\u0190\24\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\22\6\1\u0135\6\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\16\6\1\u0191\12\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\24\6\1\256\4\6\2\0\2\6\10\0\1\6\12\0"+
    "\2\6\4\0\25\6\4\0\14\6\1\u0192\14\6\2\0"+
    "\2\6\10\0\1\6\12\0\2\6\4\0\25\6\4\0"+
    "\30\6\1\107\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\17\6\1\352\11\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\13\6\1\u0193\11\6"+
    "\4\0\31\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\5\6\1\u0194\23\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\21\6"+
    "\1\u0195\7\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\1\6\1\u0196\27\6\2\0\2\6"+
    "\6\0\1\u0197\1\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\31\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\10\6\1\u0198\20\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\5\6"+
    "\1\u0199\23\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\5\6\1\u019a\23\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\21\6"+
    "\1\u019b\7\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\1\6\1\u019c\27\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\4\6"+
    "\1\u019d\24\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\21\6\1\u019e\7\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\23\6"+
    "\1\u0176\5\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\23\6\1\u012c\5\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\25\6"+
    "\1\137\3\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\7\6\1\371\15\6\4\0\31\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\24\6"+
    "\1\u0143\4\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\3\6\1\u019f\25\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\5\6"+
    "\1\u01a0\23\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\14\6\1\u01a1\14\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\1\6"+
    "\1\u01a2\27\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\16\6\1\u014d\12\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\3\6"+
    "\1\256\25\6\2\0\1\6\51\0\1\u01a3\45\0\1\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\5\6"+
    "\1\u01a4\23\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\21\6\1\u01a5\7\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\21\6"+
    "\1\u01a6\7\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\21\6\1\u01a7\7\6\2\0\2\6"+
    "\10\0\1\6\12\0\2\6\4\0\25\6\4\0\4\6"+
    "\1\373\24\6\2\0\2\6\10\0\1\6\12\0\2\6"+
    "\4\0\25\6\4\0\1\6\1\u01a8\3\6\1\373\23\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\21\6\1\u01a9\7\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\13\6\1\107\15\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\21\6\1\u01aa\7\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\5\6\1\143\23\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\15\6\1\320\13\6\2\0\1\6\106\0\1\u01ab"+
    "\10\0\1\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\21\6\1\140\7\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\21\6\1\u01ac\7\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\11\6\1\u01ad\17\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\11\6\1\u01ae\17\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\2\6\1\364\26\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\1\6\1\u0176\27\6"+
    "\2\0\1\6\64\0\1\u01af\32\0\1\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\11\6\1\u01b0\17\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\23\6\1\u01b1\5\6\2\0\2\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\4\6\1\u01b1\24\6"+
    "\2\0\1\6\106\0\1\u01b2\10\0\1\6\10\0\1\6"+
    "\12\0\2\6\4\0\25\6\4\0\4\6\1\256\24\6"+
    "\2\0\2\6\10\0\1\6\12\0\2\6\4\0\25\6"+
    "\4\0\1\6\1\u01a8\27\6\2\0\1\6\70\0\1\u01b3"+
    "\126\0\1\u01b4\106\0\1\u01b5\127\0\1\u01b6\123\0\1\u01b7"+
    "\10\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[31126];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** Error code for "Unknown internal scanner error". */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  /** Error code for "could not match input". */
  private static final int ZZ_NO_MATCH = 1;
  /** Error code for "pushback value was too large". */
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /**
   * Error messages for {@link #ZZ_UNKNOWN_ERROR}, {@link #ZZ_NO_MATCH}, and
   * {@link #ZZ_PUSHBACK_2BIG} respectively.
   */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\2\11\5\1\2\11\2\1\1\11\5\1\1\11"+
    "\1\1\1\11\26\1\3\11\3\1\3\11\1\0\4\11"+
    "\1\1\1\11\1\1\1\11\1\1\2\11\122\1\1\11"+
    "\4\1\1\0\1\1\2\11\134\1\1\0\236\1\1\0"+
    "\13\1\1\0\7\1\1\0\3\1\1\0\2\1\5\0"+
    "\1\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[439];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** Input device. */
  private java.io.Reader zzReader;

  /** Current state of the DFA. */
  private int zzState;

  /** Current lexical state. */
  private int zzLexicalState = YYINITIAL;

  /**
   * This buffer contains the current text to be matched and is the source of the {@link #yytext()}
   * string.
   */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** Text position at the last accepting state. */
  private int zzMarkedPos;

  /** Current text position in the buffer. */
  private int zzCurrentPos;

  /** Marks the beginning of the {@link #yytext()} string in the buffer. */
  private int zzStartRead;

  /** Marks the last character in the buffer, that has been read from input. */
  private int zzEndRead;

  /**
   * Whether the scanner is at the end of file.
   * @see #yyatEOF
   */
  private boolean zzAtEOF;

  /**
   * The number of occupied positions in {@link #zzBuffer} beyond {@link #zzEndRead}.
   *
   * <p>When a lead/high surrogate has been read from the input stream into the final
   * {@link #zzBuffer} position, this will have a value of 1; otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /** Number of newlines encountered up to the start of the matched text. */
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  private int yycolumn;

  /** Number of characters up to the start of the matched text. */
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  @SuppressWarnings("unused")
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  @SuppressWarnings("unused")
  private boolean zzEOFDone;

  /* user code: */
  public final int getTokenStart() {
      return (int) yychar;
  }

  public final int getTokenEnd() {
      return getTokenStart() + yylength();
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public VisualBasicLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  /**
   * Refills the input buffer.
   *
   * @return {@code false} iff there was new input.
   * @exception java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead - zzStartRead);

      /* translate stored positions */
      zzEndRead -= zzStartRead;
      zzCurrentPos -= zzStartRead;
      zzMarkedPos -= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length * 2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException(
          "Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
        if (numRead == requested) { // We requested too few chars to encode a full Unicode character
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        } else {                    // There is room in the buffer for at least one more char
          int c = zzReader.read();  // Expecting to read a paired low surrogate char
          if (c == -1) {
            return true;
          } else {
            zzBuffer[zzEndRead++] = (char)c;
          }
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }


  /**
   * Closes the input reader.
   *
   * @throws java.io.IOException if the reader could not be closed.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true; // indicate end of file
    zzEndRead = zzStartRead; // invalidate buffer

    if (zzReader != null) {
      zzReader.close();
    }
  }


  /**
   * Resets the scanner to read from a new input stream.
   *
   * <p>Does not close the old reader.
   *
   * <p>All internal variables are reset, the old input stream <b>cannot</b> be reused (internal
   * buffer is discarded and lost). Lexical state is set to {@code ZZ_INITIAL}.
   *
   * <p>Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader The new input stream.
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzEOFDone = false;
    yyResetPosition();
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE) {
      zzBuffer = new char[ZZ_BUFFERSIZE];
    }
  }

  /**
   * Resets the input position.
   */
  private final void yyResetPosition() {
      zzAtBOL  = true;
      zzAtEOF  = false;
      zzCurrentPos = 0;
      zzMarkedPos = 0;
      zzStartRead = 0;
      zzEndRead = 0;
      zzFinalHighSurrogate = 0;
      yyline = 0;
      yycolumn = 0;
      yychar = 0L;
  }


  /**
   * Returns whether the scanner has reached the end of the reader it reads from.
   *
   * @return whether the scanner has reached EOF.
   */
  public final boolean yyatEOF() {
    return zzAtEOF;
  }


  /**
   * Returns the current lexical state.
   *
   * @return the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state.
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   *
   * @return the matched text.
   */
  public final String yytext() {
    return new String(zzBuffer, zzStartRead, zzMarkedPos-zzStartRead);
  }


  /**
   * Returns the character at the given position from the matched text.
   *
   * <p>It is equivalent to {@code yytext().charAt(pos)}, but faster.
   *
   * @param position the position of the character to fetch. A value from 0 to {@code yylength()-1}.
   *
   * @return the character at {@code position}.
   */
  public final char yycharat(int position) {
    return zzBuffer[zzStartRead + position];
  }


  /**
   * How many characters were matched.
   *
   * @return the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * <p>In a well-formed scanner (no or only correct usage of {@code yypushback(int)} and a
   * match-all fallback rule) this method will only be called with things that
   * "Can't Possibly Happen".
   *
   * <p>If this method is called, something is seriously wrong (e.g. a JFlex bug producing a faulty
   * scanner etc.).
   *
   * <p>Usual syntax/scanner level error handling should be done in error fallback rules.
   *
   * @param errorCode the code of the error message to display.
   */
  private static void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    } catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * <p>They will be read again by then next call of the scanning method.
   *
   * @param number the number of characters to be read again. This number must not be greater than
   *     {@link #yylength()}.
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }




  /**
   * Resumes scanning until the next regular expression is matched, the end of input is encountered
   * or an I/O-Error occurs.
   *
   * @return the next token.
   * @exception java.io.IOException if any I/O-Error occurs.
   */
  @NotNull
  public VisualBasicToken advance() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char[] zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':  // fall through
        case '\u000C':  // fall through
        case '\u0085':  // fall through
        case '\u2028':  // fall through
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn += zzCharCount;
        }
      }

      if (zzR) {
        // peek one character ahead if it is
        // (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof)
            zzPeek = false;
          else
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
              {
                return VisualBasicToken.EOF;
              }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { return VisualBasicToken.BAD_CHARACTER;
            }
            // fall through
          case 58: break;
          case 2:
            { return VisualBasicToken.WHITESPACE;
            }
            // fall through
          case 59: break;
          case 3:
            { return VisualBasicToken.DOUBLE_QUOTED_STRING;
            }
            // fall through
          case 60: break;
          case 4:
            { return VisualBasicToken.IDENTIFIER;
            }
            // fall through
          case 61: break;
          case 5:
            { return VisualBasicToken.AND;
            }
            // fall through
          case 62: break;
          case 6:
            { return VisualBasicToken.LINE_COMMENT;
            }
            // fall through
          case 63: break;
          case 7:
            { return VisualBasicToken.LPAREN;
            }
            // fall through
          case 64: break;
          case 8:
            { return VisualBasicToken.RPAREN;
            }
            // fall through
          case 65: break;
          case 9:
            { return VisualBasicToken.MULT;
            }
            // fall through
          case 66: break;
          case 10:
            { return VisualBasicToken.PLUS;
            }
            // fall through
          case 67: break;
          case 11:
            { return VisualBasicToken.COMMA;
            }
            // fall through
          case 68: break;
          case 12:
            { return VisualBasicToken.MINUS;
            }
            // fall through
          case 69: break;
          case 13:
            { return VisualBasicToken.DOT;
            }
            // fall through
          case 70: break;
          case 14:
            { return VisualBasicToken.DIV;
            }
            // fall through
          case 71: break;
          case 15:
            { return VisualBasicToken.INTEGER_LITERAL;
            }
            // fall through
          case 72: break;
          case 16:
            { return VisualBasicToken.SEMICOLON;
            }
            // fall through
          case 73: break;
          case 17:
            { return VisualBasicToken.LT;
            }
            // fall through
          case 74: break;
          case 18:
            { return VisualBasicToken.EQ;
            }
            // fall through
          case 75: break;
          case 19:
            { return VisualBasicToken.GT;
            }
            // fall through
          case 76: break;
          case 20:
            { return VisualBasicToken.LBRACK;
            }
            // fall through
          case 77: break;
          case 21:
            { return VisualBasicToken.BACKSLASH;
            }
            // fall through
          case 78: break;
          case 22:
            { return VisualBasicToken.RBRACK;
            }
            // fall through
          case 79: break;
          case 23:
            { return VisualBasicToken.XOR;
            }
            // fall through
          case 80: break;
          case 24:
            { return VisualBasicToken.LBRACE;
            }
            // fall through
          case 81: break;
          case 25:
            { return VisualBasicToken.RBRACE;
            }
            // fall through
          case 82: break;
          case 26:
            { return VisualBasicToken.ANDEQ;
            }
            // fall through
          case 83: break;
          case 27:
            { return VisualBasicToken.MULTEQ;
            }
            // fall through
          case 84: break;
          case 28:
            { return VisualBasicToken.PLUSEQ;
            }
            // fall through
          case 85: break;
          case 29:
            { return VisualBasicToken.MINUSEQ;
            }
            // fall through
          case 86: break;
          case 30:
            { return VisualBasicToken.DOUBLE_LITERAL;
            }
            // fall through
          case 87: break;
          case 31:
            { return VisualBasicToken.DIVEQ;
            }
            // fall through
          case 88: break;
          case 32:
            { return VisualBasicToken.FLOAT_LITERAL;
            }
            // fall through
          case 89: break;
          case 33:
            { return VisualBasicToken.LONG_LITERAL;
            }
            // fall through
          case 90: break;
          case 34:
            { return VisualBasicToken.LTLT;
            }
            // fall through
          case 91: break;
          case 35:
            { return VisualBasicToken.GTGT;
            }
            // fall through
          case 92: break;
          case 36:
            { return VisualBasicToken.KEYWORD;
            }
            // fall through
          case 93: break;
          case 37:
            { return VisualBasicToken.XOREQ;
            }
            // fall through
          case 94: break;
          case 38:
            { return VisualBasicToken.LTLTEQ;
            }
            // fall through
          case 95: break;
          case 39:
            { return VisualBasicToken.GTGTEQ;
            }
            // fall through
          case 96: break;
          case 40:
            { return VisualBasicToken.BYTE;
            }
            // fall through
          case 97: break;
          case 41:
            { return VisualBasicToken.CHAR;
            }
            // fall through
          case 98: break;
          case 42:
            { return VisualBasicToken.DATE;
            }
            // fall through
          case 99: break;
          case 43:
            { return VisualBasicToken.LONG;
            }
            // fall through
          case 100: break;
          case 44:
            { return VisualBasicToken.TRUE;
            }
            // fall through
          case 101: break;
          case 45:
            { return VisualBasicToken.FALSE;
            }
            // fall through
          case 102: break;
          case 46:
            { return VisualBasicToken.SBYTE;
            }
            // fall through
          case 103: break;
          case 47:
            { return VisualBasicToken.SHORT;
            }
            // fall through
          case 104: break;
          case 48:
            { return VisualBasicToken.ULONG;
            }
            // fall through
          case 105: break;
          case 49:
            { return VisualBasicToken.DOUBLE;
            }
            // fall through
          case 106: break;
          case 50:
            { return VisualBasicToken.OBJECT;
            }
            // fall through
          case 107: break;
          case 51:
            { return VisualBasicToken.SINGLE;
            }
            // fall through
          case 108: break;
          case 52:
            { return VisualBasicToken.STRING;
            }
            // fall through
          case 109: break;
          case 53:
            { return VisualBasicToken.USHORT;
            }
            // fall through
          case 110: break;
          case 54:
            { return VisualBasicToken.BOOLEAN;
            }
            // fall through
          case 111: break;
          case 55:
            { return VisualBasicToken.DECIMAL;
            }
            // fall through
          case 112: break;
          case 56:
            { return VisualBasicToken.INTEGER;
            }
            // fall through
          case 113: break;
          case 57:
            { return VisualBasicToken.UINTEGER;
            }
            // fall through
          case 114: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
