/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.AlphaAnimAction;
import com.bladecoder.engine.actions.AnimationAction;
import com.bladecoder.engine.actions.CameraAction;
import com.bladecoder.engine.actions.CancelVerbAction;
import com.bladecoder.engine.actions.ChooseAction;
import com.bladecoder.engine.actions.CommentAction;
import com.bladecoder.engine.actions.DisableActionAction;
import com.bladecoder.engine.actions.DropItemAction;
import com.bladecoder.engine.actions.EndAction;
import com.bladecoder.engine.actions.EndGameAction;
import com.bladecoder.engine.actions.GotoAction;
import com.bladecoder.engine.actions.IfAttrAction;
import com.bladecoder.engine.actions.IfInkVariableAction;
import com.bladecoder.engine.actions.IfPropertyAction;
import com.bladecoder.engine.actions.IfSceneAttrAction;
import com.bladecoder.engine.actions.InkNewStoryAction;
import com.bladecoder.engine.actions.InkRunAction;
import com.bladecoder.engine.actions.InkVariable;
import com.bladecoder.engine.actions.LeaveAction;
import com.bladecoder.engine.actions.LoadChapterAction;
import com.bladecoder.engine.actions.LookAtAction;
import com.bladecoder.engine.actions.MoveToSceneAction;
import com.bladecoder.engine.actions.MusicAction;
import com.bladecoder.engine.actions.MusicVolumeAction;
import com.bladecoder.engine.actions.OpenURLAction;
import com.bladecoder.engine.actions.PickUpAction;
import com.bladecoder.engine.actions.PlaySoundAction;
import com.bladecoder.engine.actions.PositionAction;
import com.bladecoder.engine.actions.PositionAnimAction;
import com.bladecoder.engine.actions.PropertyAction;
import com.bladecoder.engine.actions.RandomPositionAction;
import com.bladecoder.engine.actions.RemoveInventoryItemAction;
import com.bladecoder.engine.actions.RepeatAction;
import com.bladecoder.engine.actions.RotateAction;
import com.bladecoder.engine.actions.RunOnceAction;
import com.bladecoder.engine.actions.RunVerbAction;
import com.bladecoder.engine.actions.SayAction;
import com.bladecoder.engine.actions.SayDialogAction;
import com.bladecoder.engine.actions.ScaleAction;
import com.bladecoder.engine.actions.ScaleAnimActionXY;
import com.bladecoder.engine.actions.ScreenPositionAction;
import com.bladecoder.engine.actions.SetActorAttrAction;
import com.bladecoder.engine.actions.SetCutmodeAction;
import com.bladecoder.engine.actions.SetDescAction;
import com.bladecoder.engine.actions.SetDialogOptionAttrAction;
import com.bladecoder.engine.actions.SetPlayerAction;
import com.bladecoder.engine.actions.SetSceneStateAction;
import com.bladecoder.engine.actions.SetStateAction;
import com.bladecoder.engine.actions.SetWalkzoneAction;
import com.bladecoder.engine.actions.ShowInventoryAction;
import com.bladecoder.engine.actions.SoundAction;
import com.bladecoder.engine.actions.TalktoAction;
import com.bladecoder.engine.actions.TextAction;
import com.bladecoder.engine.actions.TintAnimAction;
import com.bladecoder.engine.actions.TransitionAction;
import com.bladecoder.engine.actions.WaitAction;
import com.bladecoder.engine.util.ActionUtils;
import com.bladecoder.engine.util.EngineLogger;
import java.util.HashMap;

public class ActionFactory {
    private static ClassLoader loader = ActionFactory.class.getClassLoader();
    private static ObjectMap<String, Class<? extends Action>> tagToClass = new ObjectMap();

    private static void addClassTag(Class<? extends Action> cls) {
        tagToClass.put((Object)ActionUtils.getName(cls), cls);
    }

    public static ObjectMap<String, Class<? extends Action>> getClassTags() {
        return tagToClass;
    }

    public static void setActionClassLoader(ClassLoader loader) {
        ActionFactory.loader = loader;
    }

    public static ClassLoader getActionClassLoader() {
        return loader;
    }

    public static Action create(String tag, HashMap<String, String> params) throws ClassNotFoundException, ReflectionException {
        Action a = null;
        Class<?> c = (Class<?>)tagToClass.get((Object)tag);
        if (c == null) {
            c = Class.forName(tag, true, loader);
        }
        a = (Action)ClassReflection.newInstance((Class)c);
        if (params != null) {
            for (String key : params.keySet()) {
                String value = params.get(key);
                try {
                    ActionUtils.setParam(a, key, value);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                    EngineLogger.error("Error Setting Action Param - Action:" + tag + " Param: " + key + " Value: " + value + " Msg: NOT FOUND " + e.getMessage());
                }
            }
        }
        return a;
    }

    static {
        ActionFactory.addClassTag(AlphaAnimAction.class);
        ActionFactory.addClassTag(AnimationAction.class);
        ActionFactory.addClassTag(CameraAction.class);
        ActionFactory.addClassTag(CancelVerbAction.class);
        ActionFactory.addClassTag(ChooseAction.class);
        ActionFactory.addClassTag(CommentAction.class);
        ActionFactory.addClassTag(DisableActionAction.class);
        ActionFactory.addClassTag(DropItemAction.class);
        ActionFactory.addClassTag(EndAction.class);
        ActionFactory.addClassTag(EndGameAction.class);
        ActionFactory.addClassTag(GotoAction.class);
        ActionFactory.addClassTag(IfAttrAction.class);
        ActionFactory.addClassTag(IfInkVariableAction.class);
        ActionFactory.addClassTag(IfPropertyAction.class);
        ActionFactory.addClassTag(IfSceneAttrAction.class);
        ActionFactory.addClassTag(InkNewStoryAction.class);
        ActionFactory.addClassTag(InkRunAction.class);
        ActionFactory.addClassTag(InkVariable.class);
        ActionFactory.addClassTag(LeaveAction.class);
        ActionFactory.addClassTag(LoadChapterAction.class);
        ActionFactory.addClassTag(LookAtAction.class);
        ActionFactory.addClassTag(MoveToSceneAction.class);
        ActionFactory.addClassTag(MusicAction.class);
        ActionFactory.addClassTag(MusicVolumeAction.class);
        ActionFactory.addClassTag(OpenURLAction.class);
        ActionFactory.addClassTag(PickUpAction.class);
        ActionFactory.addClassTag(PlaySoundAction.class);
        ActionFactory.addClassTag(PositionAction.class);
        ActionFactory.addClassTag(PositionAnimAction.class);
        ActionFactory.addClassTag(PropertyAction.class);
        ActionFactory.addClassTag(RandomPositionAction.class);
        ActionFactory.addClassTag(RemoveInventoryItemAction.class);
        ActionFactory.addClassTag(RepeatAction.class);
        ActionFactory.addClassTag(RotateAction.class);
        ActionFactory.addClassTag(RunOnceAction.class);
        ActionFactory.addClassTag(RunVerbAction.class);
        ActionFactory.addClassTag(SayAction.class);
        ActionFactory.addClassTag(SayDialogAction.class);
        ActionFactory.addClassTag(ScaleAction.class);
        ActionFactory.addClassTag(ScaleAnimActionXY.class);
        ActionFactory.addClassTag(ScreenPositionAction.class);
        ActionFactory.addClassTag(SetActorAttrAction.class);
        ActionFactory.addClassTag(SetCutmodeAction.class);
        ActionFactory.addClassTag(SetDialogOptionAttrAction.class);
        ActionFactory.addClassTag(SetPlayerAction.class);
        ActionFactory.addClassTag(SetSceneStateAction.class);
        ActionFactory.addClassTag(SetStateAction.class);
        ActionFactory.addClassTag(SetDescAction.class);
        ActionFactory.addClassTag(SetWalkzoneAction.class);
        ActionFactory.addClassTag(ShowInventoryAction.class);
        ActionFactory.addClassTag(SoundAction.class);
        ActionFactory.addClassTag(TalktoAction.class);
        ActionFactory.addClassTag(TextAction.class);
        ActionFactory.addClassTag(TintAnimAction.class);
        ActionFactory.addClassTag(TransitionAction.class);
        ActionFactory.addClassTag(WaitAction.class);
    }
}

