/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.ActorAnimationRef;
import com.bladecoder.engine.anim.Tween;
import com.bladecoder.engine.model.AnimationRenderer;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;

@ActionDescription(value="Sets the animation for an actor")
public class AnimationAction
implements Action {
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="The Animation to set")
    private ActorAnimationRef animation;
    @ActionProperty(required=true, defaultValue="-1")
    @ActionPropertyDescription(value="The times to repeat. -1 to infinity repeat")
    private int count = -1;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="Waits to finish the animation.")
    private boolean wait = true;
    @ActionProperty(required=true, defaultValue="SPRITE_DEFINED")
    @ActionPropertyDescription(value="The repeat mode")
    private Tween.Type repeat = Tween.Type.SPRITE_DEFINED;
    @ActionProperty(required=true, defaultValue="false")
    @ActionPropertyDescription(value="Keeps the current actor animation direction.")
    private boolean keepDirection = false;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        String actorId = this.animation.getActorId();
        SpriteActor a = (SpriteActor)this.w.getCurrentScene().getActor(actorId, true);
        String anim = this.animation.getAnimationId();
        if (this.keepDirection) {
            String c = ((AnimationRenderer)a.getRenderer()).getCurrentAnimationId();
            if (anim.endsWith("left") && c.endsWith("right") || anim.endsWith("right") && c.endsWith("left")) {
                anim = AnimationRenderer.getFlipId(anim);
            }
        }
        a.startAnimation(anim, this.repeat, this.count, this.wait ? cb : null);
        return this.wait;
    }
}

