/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.serialization.ActionCallbackSerializer;
import com.bladecoder.engine.serialization.BladeJson;

public abstract class BaseCallbackAction
implements Action,
ActionCallback,
Json.Serializable {
    private ActionCallback verbCb;
    private String sCb;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="If this param is 'false' the text is showed and the action continues inmediatly")
    private boolean wait = true;
    protected World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public void resume() {
        if (this.verbCb != null || this.sCb != null) {
            if (this.verbCb == null) {
                this.verbCb = ActionCallbackSerializer.find(this.w, this.w.getCurrentScene(), this.sCb);
            }
            ActionCallback cb2 = this.verbCb;
            this.verbCb = null;
            this.sCb = null;
            cb2.resume();
        }
    }

    public void setVerbCb(ActionCallback cb) {
        this.verbCb = cb;
        this.sCb = null;
    }

    public void setWait(boolean wait) {
        this.wait = wait;
    }

    public boolean getWait() {
        return this.wait;
    }

    public void write(Json json) {
        if (this.verbCb != null) {
            World w = ((BladeJson)json).getWorld();
            Scene s = ((BladeJson)json).getScene();
            json.writeValue("cb", (Object)ActionCallbackSerializer.find(w, s, this.verbCb));
        }
    }

    public void read(Json json, JsonValue jsonData) {
        this.sCb = (String)json.readValue("cb", String.class, jsonData);
    }
}

