/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.badlogic.gdx.math.Vector2;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.Param;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.SceneCamera;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.InterpolationMode;

@ActionDescription(value="Set/Animates the camera position and zoom. Also can stablish the follow character parameter")
public class CameraAction
implements Action {
    @ActionPropertyDescription(value="Sets the camera position relative to this actor.")
    @ActionProperty(type=Param.Type.ACTOR)
    private String target;
    @ActionProperty
    @ActionPropertyDescription(value="The target position")
    private Vector2 pos;
    @ActionProperty
    @ActionPropertyDescription(value="The target 'zoom'. If not set, the current zoom is used.")
    private Float zoom;
    @ActionProperty
    @ActionPropertyDescription(value="Duration of the animation in seconds. If not '0' and animation is triggered")
    private Float duration;
    @ActionPropertyDescription(value="Sets the actor to follow. 'none' puts no actor to follow")
    @ActionProperty(type=Param.Type.ACTOR)
    private String followActor;
    @ActionProperty
    @ActionPropertyDescription(value="The interpolation mode")
    private InterpolationMode interpolation;
    @ActionProperty(defaultValue="true", required=true)
    @ActionPropertyDescription(value="If this param is 'false' the text is showed and the action continues inmediatly")
    private boolean wait = true;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        Vector2 pos2 = null;
        Float zoom2 = this.zoom;
        if (this.pos != null) {
            pos2 = new Vector2(this.pos);
        }
        float scale = EngineAssetManager.getInstance().getScale();
        SceneCamera camera = this.w.getSceneCamera();
        if (zoom2 == null || zoom2.floatValue() < 0.0f) {
            zoom2 = Float.valueOf(camera.getZoom());
        }
        if (this.pos == null && this.target == null) {
            pos2 = new Vector2(camera.getPosition());
            pos2.x /= scale;
            pos2.y /= scale;
        }
        if (this.target != null) {
            BaseActor target = this.w.getCurrentScene().getActor(this.target, false);
            float x = target.getX();
            float y = target.getY();
            if (target instanceof InteractiveActor) {
                Vector2 refPoint = ((InteractiveActor)target).getRefPoint();
                x += refPoint.x;
                y += refPoint.y;
            }
            if (pos2 != null) {
                pos2.x += x;
                pos2.y += y;
            } else {
                pos2 = new Vector2(x, y);
            }
        }
        camera.stopAnim();
        if (this.followActor != null) {
            if (this.followActor.equals("none")) {
                this.w.getCurrentScene().setCameraFollowActor(null);
            } else {
                this.w.getCurrentScene().setCameraFollowActor((SpriteActor)this.w.getCurrentScene().getActor(this.followActor, false));
            }
        }
        if (this.duration == null || this.duration.floatValue() == 0.0f) {
            camera.setZoom(zoom2.floatValue());
            camera.setPosition(pos2.x * scale, pos2.y * scale);
            return false;
        }
        camera.startAnimation(pos2.x * scale, pos2.y * scale, zoom2.floatValue(), this.duration.floatValue(), this.interpolation, this.wait ? cb : null);
        return this.wait;
    }
}

