/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.badlogic.gdx.graphics.Color;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.Param;
import com.bladecoder.engine.model.Text;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.EngineLogger;

@ActionDescription(name="Comment", value="Comment action for documentation porposes. Does nothing.")
public class CommentAction
implements Action {
    @ActionProperty(required=false, type=Param.Type.SMALL_TEXT)
    @ActionPropertyDescription(value="The comment.")
    private String comment;
    @ActionProperty(required=true, defaultValue="false")
    @ActionPropertyDescription(value="When true, the comment will be showed on screen while testing.")
    private boolean debug = false;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        if (EngineLogger.debugMode() && this.comment != null) {
            EngineLogger.debug(this.comment);
            if (this.debug) {
                this.w.getCurrentScene().getTextManager().addText(this.comment, -2.0f, -2.0f, false, Text.Type.UI, Color.YELLOW, null, null, null, null, null);
            }
        }
        return false;
    }
}

