/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.EngineLogger;

@ActionDescription(value="Jump an Ink knot or stich.")
public class InkRunAction
implements Action {
    @ActionPropertyDescription(value="The knot/stich path to jump. Ej: 'myKnotName' or 'myKnotName.theStitchWithin'")
    @ActionProperty(required=true)
    private String path;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="Waits for the action to finish.")
    private boolean wait = true;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        try {
            this.w.getInkManager().runPath(this.path, this.wait ? cb : null);
        }
        catch (Exception e) {
            EngineLogger.error("Cannot jump to: " + this.path + " " + e.getMessage());
        }
        return this.wait;
    }
}

