/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.Param;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.EngineLogger;

@ActionDescription(value="Load the specified Chapter. Scene can be empty to load the default scene.")
public class LoadChapterAction
implements Action {
    @ActionPropertyDescription(value="The target chapter")
    @ActionProperty(type=Param.Type.CHAPTER, required=true)
    private String chapter;
    @ActionPropertyDescription(value="The target scene")
    @ActionProperty(type=Param.Type.STRING, required=false)
    private String scene;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        try {
            this.w.loadChapter(this.chapter, this.scene, false);
        }
        catch (Exception e) {
            EngineLogger.error(e.getMessage());
        }
        return true;
    }
}

