/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.Param;
import com.bladecoder.engine.model.CharacterActor;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Text;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;

@ActionDescription(value="Shows the text and puts the player looking at the selected actor direction")
public class LookAtAction
implements Action {
    @ActionPropertyDescription(value="The target actor")
    @ActionProperty(type=Param.Type.ACTOR)
    private String actor;
    @ActionPropertyDescription(value="The 'text' to show")
    @ActionProperty(type=Param.Type.SMALL_TEXT)
    private String text;
    @ActionPropertyDescription(value="The 'voice' file to play if selected.")
    @ActionProperty(type=Param.Type.VOICE)
    private String voiceId;
    @ActionProperty
    @ActionPropertyDescription(value="The direction to lookat. If empty, the player lookat to the actor")
    private Direction direction;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="If this param is 'false' the text is shown and the action continues inmediatly")
    private boolean wait = true;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        InteractiveActor a = (InteractiveActor)this.w.getCurrentScene().getActor(this.actor, true);
        if (this.w.getInventory().get(this.actor) == null) {
            CharacterActor player = this.w.getCurrentScene().getPlayer();
            if (this.direction != null && player != null) {
                player.lookat(this.direction.getDirection());
            } else if (a != null && player != null) {
                Rectangle bbox = a.getBBox().getBoundingRectangle();
                player.lookat(new Vector2(bbox.width / 2.0f + bbox.x, bbox.y));
            }
        }
        if (this.text != null) {
            String actorId = this.w.getCurrentScene().getPlayer() != null ? this.w.getCurrentScene().getPlayer().getId() : null;
            this.w.getCurrentScene().getTextManager().addText(this.text, -2.0f, -2.0f, false, Text.Type.SUBTITLE, null, null, actorId, this.voiceId, null, this.wait ? cb : null);
            return this.wait;
        }
        return false;
    }

    public static enum Direction {
        FRONT("front"),
        BACK("back"),
        LEFT("left"),
        RIGHT("right"),
        FRONTLEFT("frontleft"),
        FRONTRIGHT("frontright"),
        BACKLEFT("backleft"),
        BACKRIGHT("backright");

        private final String direction;

        private Direction(String direction) {
            this.direction = direction;
        }

        public String getDirection() {
            return this.direction;
        }
    }
}

