/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.Param;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;

@ActionDescription(value="Play/Stop a sound")
public class PlaySoundAction
implements Action {
    @ActionPropertyDescription(value="The 'soundId' to play. ")
    @ActionProperty(required=true, type=Param.Type.SOUND)
    private String sound;
    @ActionProperty(required=true, defaultValue="false")
    @ActionPropertyDescription(value="When 'true' stops the sound instead of playing it.")
    private boolean stop = false;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        if (!this.stop) {
            this.w.getCurrentScene().getSoundManager().playSound(this.sound);
        } else {
            this.w.getCurrentScene().getSoundManager().stopSound(this.sound);
        }
        return false;
    }
}

