/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.badlogic.gdx.math.Vector2;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.SceneActorRef;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;

@ActionDescription(value="Sets actor position.")
public class PositionAction
implements Action {
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="The actor to change his position")
    private SceneActorRef actor;
    @ActionProperty
    @ActionPropertyDescription(value="Obtain the target position from this actor.")
    private SceneActorRef target;
    @ActionProperty
    @ActionPropertyDescription(value="The absolute position to set if no target is selected. Relative if target is selected.")
    private Vector2 position;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        Scene s = this.actor.getScene(this.w);
        BaseActor a = s.getActor(this.actor.getActorId(), true);
        float x = a.getX();
        float y = a.getY();
        if (this.target != null) {
            Scene ts = this.target.getScene(this.w);
            BaseActor anchorActor = ts.getActor(this.target.getActorId(), false);
            x = anchorActor.getX();
            y = anchorActor.getY();
            if (anchorActor instanceof InteractiveActor && a != anchorActor) {
                Vector2 refPoint = ((InteractiveActor)anchorActor).getRefPoint();
                x += refPoint.x;
                y += refPoint.y;
            }
            if (this.position != null) {
                float scale = EngineAssetManager.getInstance().getScale();
                x += this.position.x * scale;
                y += this.position.y * scale;
            }
        } else if (this.position != null) {
            float scale = EngineAssetManager.getInstance().getScale();
            x = this.position.x * scale;
            y = this.position.y * scale;
        }
        a.setPosition(x, y);
        return false;
    }
}

