/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.badlogic.gdx.math.Vector2;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.Param;
import com.bladecoder.engine.anim.SpritePosTween;
import com.bladecoder.engine.anim.Tween;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.InterpolationMode;

@ActionDescription(value="Sets an actor Position animation")
public class PositionAnimAction
implements Action {
    @ActionPropertyDescription(value="The moving actor")
    @ActionProperty(type=Param.Type.SPRITE_ACTOR, required=true)
    private String actor;
    @ActionPropertyDescription(value="Sets the position from this actor")
    @ActionProperty(type=Param.Type.ACTOR)
    private String target;
    @ActionProperty
    @ActionPropertyDescription(value="The absolute world position if no target is selected. Relative to target if selected.")
    private Vector2 pos;
    @ActionProperty(required=true, defaultValue="1.0")
    @ActionPropertyDescription(value="Duration or speed in pixels/sec. mode")
    private float speed;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="Duration or speed of the animation")
    private Mode mode;
    @ActionProperty(required=true, defaultValue="-1")
    @ActionPropertyDescription(value="The times to repeat. -1 for infinity")
    private int count = -1;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="If this param is 'false' the text is showed and the action continues inmediatly")
    private boolean wait = true;
    @ActionProperty(required=true, defaultValue="NO_REPEAT")
    @ActionPropertyDescription(value="The repeat mode")
    private Tween.Type repeat = Tween.Type.NO_REPEAT;
    @ActionProperty
    @ActionPropertyDescription(value="The target actor")
    private InterpolationMode interpolation;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        float s;
        float scale = EngineAssetManager.getInstance().getScale();
        BaseActor a = this.w.getCurrentScene().getActor(this.actor, true);
        float x = a.getX();
        float y = a.getY();
        if (this.target != null) {
            BaseActor target = this.w.getCurrentScene().getActor(this.target, false);
            x = target.getX();
            y = target.getY();
            if (target instanceof InteractiveActor && target != a) {
                Vector2 refPoint = ((InteractiveActor)target).getRefPoint();
                x += refPoint.x;
                y += refPoint.y;
            }
            if (this.pos != null) {
                x += this.pos.x * scale;
                y += this.pos.y * scale;
            }
        } else if (this.pos != null) {
            x = this.pos.x * scale;
            y = this.pos.y * scale;
        }
        if (!(a instanceof SpriteActor)) {
            a.setPosition(x, y);
            return false;
        }
        if (this.mode != null && this.mode == Mode.SPEED) {
            Vector2 p0 = new Vector2(a.getX(), a.getY());
            s = p0.dst(x, y) / (scale * this.speed);
        } else {
            s = this.speed;
        }
        SpritePosTween t = new SpritePosTween();
        t.start((SpriteActor)a, this.repeat, this.count, x, y, s, this.interpolation, this.wait ? cb : null);
        ((SpriteActor)a).addTween(t);
        return this.wait;
    }

    public static enum Mode {
        DURATION,
        SPEED;

    }
}

