/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.badlogic.gdx.math.Vector2;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.SceneActorRef;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;

@ActionDescription(value="Sets actor position randomly.")
public class RandomPositionAction
implements Action {
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="The actor to change his position")
    private SceneActorRef actor;
    @ActionProperty
    @ActionPropertyDescription(value="Obtain the target position from this actor.")
    private SceneActorRef target;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="Maximum xy values. The absolute position to set if no target is selected. Relative if target is selected.")
    private Vector2 maxPosition;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="Minimum xy values. The absolute position to set if no target is selected. Relative if target is selected.")
    private Vector2 minPosition;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        Scene s = this.actor.getScene(this.w);
        BaseActor a = s.getActor(this.actor.getActorId(), true);
        float x = a.getX();
        float y = a.getY();
        float rx = (float)((double)this.minPosition.x + Math.random() * (double)(this.maxPosition.x - this.minPosition.x));
        float ry = (float)((double)this.minPosition.y + Math.random() * (double)(this.maxPosition.y - this.minPosition.y));
        if (this.target != null) {
            Scene ts = this.target.getScene(this.w);
            BaseActor anchorActor = ts.getActor(this.target.getActorId(), false);
            x = anchorActor.getX();
            y = anchorActor.getY();
            if (anchorActor instanceof InteractiveActor && a != anchorActor) {
                Vector2 refPoint = ((InteractiveActor)anchorActor).getRefPoint();
                x += refPoint.x;
                y += refPoint.y;
            }
            float scale = EngineAssetManager.getInstance().getScale();
            x += rx * scale;
            y += ry * scale;
        } else {
            float scale = EngineAssetManager.getInstance().getScale();
            x = rx * scale;
            y = ry * scale;
        }
        a.setPosition(x, y);
        return false;
    }
}

