/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.Param;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.Verb;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.EngineLogger;
import java.text.MessageFormat;
import java.util.ArrayList;

@ActionDescription(value="Runs an actor verb")
public class RunVerbAction
implements VerbRunner,
Action {
    @ActionPropertyDescription(value="The actor with the verb. If empty, the verb is searched in the scene and in the world.")
    @ActionProperty(type=Param.Type.INTERACTIVE_ACTOR)
    private String actor;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="The 'verbId' to run")
    private String verb;
    @ActionProperty
    @ActionPropertyDescription(value="Aditional actor for 'use' verb")
    private String target;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="If this param is 'false' the text is showed and the action continues inmediatly")
    private boolean wait = true;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        this.run(cb.getCurrentTarget(), this.wait ? cb : null);
        return this.wait;
    }

    private Verb getVerb() {
        Verb v = null;
        Scene s = this.w.getCurrentScene();
        if (this.actor != null) {
            InteractiveActor a = (InteractiveActor)s.getActor(this.actor, true);
            v = a.getVerbManager().getVerb(this.verb, a.getState(), this.target);
        }
        if (v == null) {
            v = s.getVerbManager().getVerb(this.verb, s.getState(), this.target);
        }
        if (v == null) {
            v = this.w.getVerbManager().getVerb(this.verb, null, this.target);
        }
        if (v == null) {
            EngineLogger.error("Cannot find VERB: " + this.verb + " for ACTOR: " + this.actor);
        }
        return v;
    }

    @Override
    public void resume() {
        this.getVerb().resume();
    }

    @Override
    public void cancel() {
        InteractiveActor a;
        if (this.actor != null && (a = (InteractiveActor)this.w.getCurrentScene().getActor(this.actor, true)) == null) {
            return;
        }
        this.getVerb().cancel();
    }

    @Override
    public String getCurrentTarget() {
        return this.getVerb().getCurrentTarget();
    }

    @Override
    public ArrayList<Action> getActions() {
        Verb v = this.getVerb();
        if (v == null) {
            if (this.actor != null) {
                EngineLogger.error(MessageFormat.format("Verb ''{0}'' not found for actor ''{1}({3})'' and target ''{2}''.", this.verb, this.actor, this.target, ((InteractiveActor)this.w.getCurrentScene().getActor(this.actor, true)).getState()));
            } else {
                EngineLogger.error(MessageFormat.format("Verb ''{0}'' not found.", this.verb));
            }
            return new ArrayList<Action>(0);
        }
        return v.getActions();
    }

    @Override
    public void run(String currentTarget, ActionCallback cb) {
        Verb v = this.getVerb();
        v.run(currentTarget, cb);
    }

    @Override
    public int getIP() {
        return this.getVerb().getIP();
    }

    @Override
    public void setIP(int ip) {
        this.getVerb().setIP(ip);
    }
}

