/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.Param;
import com.bladecoder.engine.model.CharacterActor;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Text;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;

@ActionDescription(value="Says a text")
public class SayAction
implements Action {
    @ActionPropertyDescription(value="The target actor.")
    @ActionProperty(type=Param.Type.CHARACTER_ACTOR, required=true)
    private String actor;
    @ActionPropertyDescription(value="The 'text' to show.")
    @ActionProperty(type=Param.Type.SMALL_TEXT)
    private String text;
    @ActionPropertyDescription(value="The 'voice' file to play if selected.")
    @ActionProperty(type=Param.Type.VOICE)
    private String voiceId;
    @ActionProperty(required=true, defaultValue="SUBTITLE")
    @ActionPropertyDescription(value="The type of the text.")
    private Text.Type type = Text.Type.SUBTITLE;
    @ActionPropertyDescription(value="The animation to set when talking.")
    @ActionProperty(required=false)
    private String animation;
    @ActionPropertyDescription(value="The style to use (an entry in your `ui.json` in the `com.bladecoder.engine.ui.TextManagerUI$TextManagerUIStyle` section)")
    @ActionProperty(type=Param.Type.TEXT_STYLE, required=false)
    private String style;
    @ActionProperty(defaultValue="false")
    @ActionPropertyDescription(value="Queue the text if other text is showing, or show it immediately.")
    private boolean queue = false;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="If this param is 'false' the text is showed and the action continues inmediatly")
    private boolean wait = true;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        float x = -2.0f;
        float y = -2.0f;
        Color color = null;
        if (this.text == null) {
            return false;
        }
        InteractiveActor a = (InteractiveActor)this.w.getCurrentScene().getActor(this.actor, false);
        if (this.type == Text.Type.TALK && a != null) {
            Rectangle boundingRectangle = a.getBBox().getBoundingRectangle();
            x = boundingRectangle.getX() + boundingRectangle.getWidth() / 2.0f;
            y = boundingRectangle.getY() + boundingRectangle.getHeight();
            color = ((CharacterActor)a).getTextColor();
            Vector2 talkingTextPos = ((CharacterActor)a).getTalkingTextPos();
            if (talkingTextPos != null) {
                x += talkingTextPos.x;
                y += talkingTextPos.y;
            }
        }
        this.w.getCurrentScene().getTextManager().addText(this.text, x, y, this.queue, this.type, color, this.style, a != null ? a.getId() : this.actor, this.voiceId, this.animation, this.wait ? cb : null);
        return this.wait;
    }
}

