/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.World;

public class SceneActorRef {
    private final String sceneId;
    private final String actorId;

    public SceneActorRef() {
        this(null, null);
    }

    public SceneActorRef(String sceneId, String actorId) {
        this.sceneId = sceneId;
        this.actorId = actorId;
    }

    public SceneActorRef(String sceneActor) {
        if (sceneActor == null) {
            this.sceneId = null;
            this.actorId = null;
            return;
        }
        int idx = sceneActor.indexOf("#".charAt(0));
        if (idx == -1) {
            idx = sceneActor.indexOf(46);
        }
        if (idx != -1) {
            this.sceneId = sceneActor.substring(0, idx);
            this.actorId = sceneActor.substring(idx + 1);
        } else {
            this.sceneId = null;
            this.actorId = sceneActor;
        }
    }

    public String getSceneId() {
        return this.sceneId;
    }

    public String getActorId() {
        return this.actorId;
    }

    public Scene getScene(World world) {
        if (this.sceneId != null && !this.sceneId.trim().isEmpty()) {
            return world.getScene(this.sceneId);
        }
        return world.getCurrentScene();
    }

    public BaseActor getActor(World w, boolean searchInventory) {
        Scene scn = this.getScene(w);
        if (scn == null) {
            scn = w.getCurrentScene();
        }
        return scn.getActor(this.actorId, searchInventory);
    }

    public BaseActor getActor(World w) {
        return this.getActor(w, true);
    }

    public String toString() {
        if (this.sceneId == null || this.sceneId.isEmpty()) {
            return this.actorId;
        }
        return this.sceneId + "#" + this.actorId;
    }
}

