/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.Param;
import com.bladecoder.engine.actions.SceneActorRef;
import com.bladecoder.engine.model.CharacterActor;
import com.bladecoder.engine.model.Dialog;
import com.bladecoder.engine.model.DialogOption;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.EngineLogger;

@ActionDescription(value="Change the selected dialog option properties")
public class SetDialogOptionAttrAction
implements Action {
    @ActionProperty(type=Param.Type.SCENE_CHARACTER_ACTOR, required=true)
    @ActionPropertyDescription(value="The target actor")
    private SceneActorRef actor;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="The dialog")
    private String dialog;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="The option")
    private int option;
    @ActionProperty
    @ActionPropertyDescription(value="Show/Hide the dialog option")
    private Boolean visible;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        Scene s = this.actor.getScene(this.w);
        CharacterActor a = (CharacterActor)s.getActor(this.actor.getActorId(), true);
        Dialog d = a.getDialog(this.dialog);
        if (d == null) {
            EngineLogger.error("SetDialogOptionAttrAction: Dialog '" + this.dialog + "' not found");
            return false;
        }
        DialogOption o = d.getOptions().get(this.option);
        if (o == null) {
            EngineLogger.error("SetDialogOptionAttrAction: Option '" + this.option + "' not found");
            return false;
        }
        if (this.visible != null) {
            o.setVisible(this.visible);
        }
        return false;
    }
}

