/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.Param;
import com.bladecoder.engine.actions.SceneActorRef;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.EngineLogger;

@ActionDescription(name="ActorState", value="Sets the actor state")
public class SetStateAction
implements Action {
    @ActionProperty(type=Param.Type.SCENE_INTERACTIVE_ACTOR, required=true)
    @ActionPropertyDescription(value="The target actor")
    private SceneActorRef actor;
    @ActionProperty
    @ActionPropertyDescription(value="The actor 'state'")
    private String state;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        Scene s = this.actor.getScene(this.w);
        String actorId = this.actor.getActorId();
        if (actorId == null) {
            s.setState(this.state);
            return false;
        }
        InteractiveActor a = (InteractiveActor)s.getActor(actorId, true);
        if (a != null) {
            a.setState(this.state);
        } else {
            EngineLogger.error("SetState - Actor not found: " + actorId);
        }
        return false;
    }
}

