/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.anim;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.anim.Tween;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.util.InterpolationMode;

public class SpriteTintTween
extends Tween<SpriteActor> {
    private Color startColor;
    private Color targetColor;

    public void start(SpriteActor target, Tween.Type repeatType, int count, Color tColor, float duration, InterpolationMode interpolation, ActionCallback cb) {
        this.setTarget(target);
        if (target.getTint() == null) {
            target.setTint(Color.WHITE.cpy());
        } else {
            target.setTint(target.getTint());
        }
        this.startColor = target.getTint().cpy();
        this.targetColor = tColor.cpy();
        this.setDuration(duration);
        this.setType(repeatType);
        this.setCount(count);
        this.setInterpolation(interpolation);
        if (cb != null) {
            this.setCb(cb);
        }
        this.restart();
    }

    @Override
    public void updateTarget() {
        ((SpriteActor)this.target).getTint().a = this.startColor.a + this.getPercent() * (this.targetColor.a - this.startColor.a);
        ((SpriteActor)this.target).getTint().r = this.startColor.r + this.getPercent() * (this.targetColor.r - this.startColor.r);
        ((SpriteActor)this.target).getTint().g = this.startColor.g + this.getPercent() * (this.targetColor.g - this.startColor.g);
        ((SpriteActor)this.target).getTint().b = this.startColor.b + this.getPercent() * (this.targetColor.b - this.startColor.b);
    }

    @Override
    public void write(Json json) {
        super.write(json);
        json.writeValue("startColor", (Object)this.startColor);
        json.writeValue("targetColor", (Object)this.targetColor);
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        super.read(json, jsonData);
        this.startColor = (Color)json.readValue("startColor", Color.class, (Object)Color.WHITE, jsonData);
        this.targetColor = (Color)json.readValue("targetColor", Color.class, (Object)Color.WHITE, jsonData);
    }
}

