/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.anim;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.serialization.ActionCallbackSerializer;
import com.bladecoder.engine.serialization.BladeJson;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Timers {
    private List<Timer> timers = new ArrayList<Timer>(3);
    private transient List<Timer> timersTmp = new ArrayList<Timer>(3);

    public void addTimer(float time, ActionCallback cb) {
        Timer t = new Timer();
        t.time = time;
        t.cb = cb;
        this.timers.add(t);
    }

    public void clear() {
        this.timers.clear();
    }

    public boolean isEmpty() {
        return this.timers.isEmpty();
    }

    public void removeTimerWithCb(ActionCallback cb) {
        Iterator<Timer> it = this.timers.iterator();
        while (it.hasNext()) {
            Timer t = it.next();
            if (t.cb != cb) continue;
            it.remove();
            return;
        }
    }

    public void update(float delta) {
        Iterator<Timer> it = this.timers.iterator();
        while (it.hasNext()) {
            Timer t = it.next();
            t.currentTime = t.currentTime + delta;
            if (!(t.currentTime >= t.time)) continue;
            it.remove();
            this.timersTmp.add(t);
        }
        if (this.timersTmp.size() > 0) {
            for (Timer t : this.timersTmp) {
                t.cb.resume();
            }
            this.timersTmp.clear();
        }
    }

    private static class Timer
    implements Json.Serializable {
        private float time;
        private float currentTime = 0.0f;
        private ActionCallback cb;

        private Timer() {
        }

        public void write(Json json) {
            json.writeValue("time", (Object)Float.valueOf(this.time));
            json.writeValue("currentTime", (Object)Float.valueOf(this.currentTime));
            if (this.cb != null) {
                World w = ((BladeJson)json).getWorld();
                Scene s = ((BladeJson)json).getScene();
                json.writeValue("cb", (Object)ActionCallbackSerializer.find(w, s, this.cb));
            }
        }

        public void read(Json json, JsonValue jsonData) {
            this.time = ((Float)json.readValue("time", Float.class, jsonData)).floatValue();
            this.currentTime = ((Float)json.readValue("currentTime", Float.class, jsonData)).floatValue();
            BladeJson bjson = (BladeJson)json;
            this.cb = ActionCallbackSerializer.find(bjson.getWorld(), bjson.getScene(), (String)json.readValue("cb", String.class, jsonData));
        }
    }
}

