/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.assets;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.TextureAtlasLoader;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.ResolutionFileResolver;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGeneratorLoader;
import com.badlogic.gdx.graphics.g2d.freetype.FreetypeFontLoader;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.utils.Array;
import com.bladecoder.engine.assets.BasePathResolver;
import com.bladecoder.engine.assets.EngineResolutionFileResolver;
import com.bladecoder.engine.assets.InternalFolderResolver;
import com.bladecoder.engine.util.Config;
import com.bladecoder.engine.util.EngineLogger;
import com.bladecoder.engine.util.FileUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class EngineAssetManager
extends AssetManager {
    public static final String WORLD_FILENAME = "world";
    public static final String DESKTOP_PREFS_DIR = "BladeEngine";
    public static final String NOT_DESKTOP_PREFS_DIR = "data/";
    public static final String ATLASES_DIR = "atlases/";
    public static final String MODEL_DIR = "model/";
    public static final String MUSIC_DIR = "music/";
    public static final String IMAGE_DIR = "images/";
    public static final String SOUND_DIR = "sounds/";
    public static final String MODEL3D_DIR = "3d/";
    public static final String SPINE_DIR = "spine/";
    public static final String PARTICLE_DIR = "particles/";
    public static final String FONT_DIR = "ui/fonts/";
    public static final String VOICE_DIR = "voices/";
    public static final String MODEL3D_EXT = ".g3db";
    public static final String SPINE_EXT = ".skel";
    public static final String ATLAS_EXT = ".atlas";
    public static final String INK_EXT = ".ink.json";
    public static final String FONT_EXT = ".ttf";
    public static final String CHAPTER_EXT = ".chapter.json";
    private static final String OGG_EXT = ".ogg";
    private static final String AAC_EXT = ".m4a";
    private static EngineAssetManager instance = null;
    private float scale = 1.0f;
    private EngineResolutionFileResolver resResolver;

    protected EngineAssetManager() {
        this((FileHandleResolver)new InternalFileHandleResolver());
    }

    protected EngineAssetManager(FileHandleResolver resolver) {
        super(resolver);
        this.resResolver = new EngineResolutionFileResolver(resolver);
        this.setLoader(Texture.class, (AssetLoader)new TextureLoader((FileHandleResolver)this.resResolver));
        this.setLoader(TextureAtlas.class, (AssetLoader)new TextureAtlasLoader((FileHandleResolver)this.resResolver));
        this.setLoader(FreeTypeFontGenerator.class, (AssetLoader)new FreeTypeFontGeneratorLoader(resolver));
        this.setLoader(BitmapFont.class, FONT_EXT, (AssetLoader)new FreetypeFontLoader(resolver));
        Texture.setAssetManager((AssetManager)this);
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(int worldWidth, int worldHeight) {
        ResolutionFileResolver.Resolution[] r = this.getResolutions(this.resResolver.getBaseResolver(), worldWidth, worldHeight);
        if (r == null || r.length == 0) {
            EngineLogger.error("No resolutions defined. Maybe your 'assets' folder doesn't exists or it's empty");
            return;
        }
        this.resResolver.setResolutions(r);
        this.resResolver.selectResolution();
        this.scale = (float)this.resResolver.getResolution().portraitWidth / (float)worldWidth;
        EngineLogger.debug("Setting ASSETS SCALE: " + this.scale);
    }

    public static EngineAssetManager getInstance() {
        if (instance == null) {
            instance = new EngineAssetManager();
        }
        return instance;
    }

    public static void createEditInstance(String base) {
        if (instance != null) {
            instance.dispose();
        }
        instance = new EngineAssetManager(new BasePathResolver(base));
        instance.forceResolution("1");
    }

    public static void setAssetFolder(String base) {
        if (instance != null) {
            instance.dispose();
        }
        instance = new EngineAssetManager(new InternalFolderResolver(base));
    }

    public void forceResolution(String suffix) {
        this.resResolver.setFixedResolution(suffix);
        EngineLogger.debug("FORCING ASSETS RESOLUTION SCALE: " + suffix);
    }

    public ResolutionFileResolver.Resolution getResolution() {
        return this.resResolver.getResolution();
    }

    public boolean isLoading() {
        return !this.update();
    }

    public void loadAtlas(String name) {
        this.load(ATLASES_DIR + name + ATLAS_EXT, TextureAtlas.class);
    }

    public boolean isAtlasLoaded(String name) {
        return this.isLoaded(ATLASES_DIR + name + ATLAS_EXT);
    }

    public void disposeAtlas(String name) {
        if (this.isAtlasLoaded(name)) {
            this.unload(ATLASES_DIR + name + ATLAS_EXT);
        }
    }

    public FileHandle getModelFile(String filename) {
        return this.resResolver.baseResolve(MODEL_DIR + filename);
    }

    public FileHandle getResAsset(String filename) {
        return this.resResolver.resolve(filename);
    }

    public FileHandle getAsset(String filename) {
        return this.resResolver.baseResolve(filename);
    }

    public TextureAtlas.AtlasRegion getRegion(String atlas, String name) {
        TextureAtlas a = (TextureAtlas)this.get(ATLASES_DIR + atlas + ATLAS_EXT, TextureAtlas.class);
        TextureAtlas.AtlasRegion region = a.findRegion(name);
        if (region == null) {
            EngineLogger.debug("Region " + name + " not found in atlas " + atlas);
        }
        return region;
    }

    public TextureAtlas getTextureAtlas(String atlas) {
        TextureAtlas a = (TextureAtlas)this.get(ATLASES_DIR + atlas + ATLAS_EXT, TextureAtlas.class);
        return a;
    }

    public Array<TextureAtlas.AtlasRegion> getRegions(String atlas, String name) {
        TextureAtlas a = (TextureAtlas)this.get(ATLASES_DIR + atlas + ATLAS_EXT, TextureAtlas.class);
        Array region = a.findRegions(name);
        if (region == null) {
            EngineLogger.error("Regions for " + name + " not found in atlas " + atlas);
        }
        return region;
    }

    public void loadTexture(String filename) {
        this.load(filename, Texture.class);
    }

    public void disposeTexture(Texture t) {
        if (this.isLoaded(this.getAssetFileName(t))) {
            this.unload(this.getAssetFileName(t));
        }
    }

    public Texture getTexture(String filename) {
        return (Texture)this.get(filename, Texture.class);
    }

    public void dispose() {
        super.dispose();
        instance = null;
    }

    public String checkIOSSoundName(String filename) {
        if (Gdx.app.getType() == Application.ApplicationType.iOS && filename.toLowerCase().endsWith(OGG_EXT)) {
            String aac = filename.substring(0, filename.length() - OGG_EXT.length()) + AAC_EXT;
            if (FileUtils.exists(EngineAssetManager.getInstance().getAsset(aac))) {
                return aac;
            }
            EngineLogger.debug("OGG files not supported in IOS: " + filename);
            return null;
        }
        return filename;
    }

    public void loadMusic(String filename) {
        String n = this.checkIOSSoundName(MUSIC_DIR + filename);
        if (n == null) {
            return;
        }
        this.load(n, Music.class);
    }

    public void disposeMusic(String filename) {
        String n = this.checkIOSSoundName(MUSIC_DIR + filename);
        if (n == null) {
            return;
        }
        if (this.isLoaded(n)) {
            this.unload(n);
        }
    }

    public Music getMusic(String filename) {
        String n = this.checkIOSSoundName(MUSIC_DIR + filename);
        if (n == null) {
            return null;
        }
        return (Music)this.get(n, Music.class);
    }

    public void loadSound(String filename) {
        String n = this.checkIOSSoundName(SOUND_DIR + filename);
        if (n == null) {
            return;
        }
        this.load(n, Sound.class);
    }

    public Sound getSound(String filename) {
        String n = this.checkIOSSoundName(SOUND_DIR + filename);
        if (n == null) {
            return null;
        }
        return (Sound)this.get(n, Sound.class);
    }

    public void disposeSound(String filename) {
        String n = this.checkIOSSoundName(SOUND_DIR + filename);
        if (n == null) {
            return;
        }
        if (this.isLoaded(n)) {
            this.unload(n);
        }
    }

    public FileHandle getParticle(String name) {
        return this.resResolver.baseResolve(PARTICLE_DIR + name);
    }

    public void loadModel3D(String name) {
        this.load(MODEL3D_DIR + name + MODEL3D_EXT, Model.class);
    }

    public Model getModel3D(String name) {
        return (Model)this.get(MODEL3D_DIR + name + MODEL3D_EXT, Model.class);
    }

    public void disposeModel3D(String name) {
        if (this.isLoaded(MODEL3D_DIR + name + MODEL3D_EXT)) {
            this.unload(MODEL3D_DIR + name + MODEL3D_EXT);
        }
    }

    public boolean assetExists(String filename) {
        return this.resResolver.exists(filename);
    }

    private ResolutionFileResolver.Resolution[] getResolutions(FileHandleResolver resolver, int worldWidth, int worldHeight) {
        ArrayList<ResolutionFileResolver.Resolution> rl = new ArrayList<ResolutionFileResolver.Resolution>();
        String[] list = null;
        String configRes = Config.getInstance().getProperty("resolutions", null);
        list = configRes != null ? configRes.split(",") : this.listAssetFiles("ui");
        for (String name : list) {
            try {
                float scale = Float.parseFloat(name);
                EngineLogger.debug("RES FOUND: " + scale);
                ResolutionFileResolver.Resolution r = new ResolutionFileResolver.Resolution((int)((float)worldWidth * scale), (int)((float)worldHeight * scale), name);
                rl.add(r);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Collections.sort(rl, new Comparator<ResolutionFileResolver.Resolution>(){

            @Override
            public int compare(ResolutionFileResolver.Resolution a, ResolutionFileResolver.Resolution b) {
                return a.portraitWidth - b.portraitWidth;
            }
        });
        return rl.toArray(new ResolutionFileResolver.Resolution[rl.size()]);
    }

    public String[] listAssetFiles(String base) {
        FileHandleResolver resolver = this.resResolver.getBaseResolver();
        String[] list = null;
        if (Gdx.app.getType() != Application.ApplicationType.Desktop) {
            FileHandle[] l = resolver.resolve(base).list();
            list = new String[l.length];
            for (int i = 0; i < l.length; ++i) {
                list[i] = l[i].name();
            }
        } else {
            URL u = EngineAssetManager.class.getResource("/" + resolver.resolve(base).path());
            if (u != null && u.getProtocol().equals("jar")) {
                list = this.getFilesFromJar("/" + base);
            } else {
                String n = resolver.resolve(base).path();
                if (u != null) {
                    n = u.getFile();
                }
                FileHandle f = null;
                try {
                    f = Gdx.files.absolute(URLDecoder.decode(n, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    EngineLogger.error("Error decoding URL", e);
                    return new String[0];
                }
                FileHandle[] l = f.list();
                list = new String[l.length];
                for (int i = 0; i < l.length; ++i) {
                    list[i] = l[i].name();
                }
            }
        }
        return list;
    }

    private String[] getFilesFromJar(String base) {
        URL dirURL = EngineAssetManager.class.getResource(base);
        HashSet<String> result = new HashSet<String>();
        if (dirURL.getProtocol().equals("jar")) {
            JarFile jar;
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            try {
                jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            }
            catch (Exception e) {
                EngineLogger.error("Locating jar file", e);
                return result.toArray(new String[result.size()]);
            }
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                int end;
                String name = entries.nextElement().getName();
                int start = name.indexOf(47);
                if (start == (end = name.lastIndexOf(47))) continue;
                String entry = name.substring(start + 1, end);
                result.add(entry);
            }
            try {
                jar.close();
            }
            catch (IOException e) {
                EngineLogger.error("Closing jar file", e);
                return result.toArray(new String[result.size()]);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public FileHandle getUserFile(String filename) {
        String desktopFolder = Config.getInstance().getProperty("title", DESKTOP_PREFS_DIR);
        return this.getUserFile(filename, desktopFolder);
    }

    public FileHandle getUserFile(String filename, String desktopFolder) {
        FileHandle file = null;
        if (Gdx.app.getType() == Application.ApplicationType.Desktop) {
            String dir = desktopFolder != null ? desktopFolder : DESKTOP_PREFS_DIR;
            dir.replace(" ", "");
            StringBuilder sb = new StringBuilder();
            sb.append(".").append(dir).append("/").append(filename);
            file = System.getProperty("os.name").toLowerCase().contains("mac") && System.getenv("HOME").contains("Containers") ? Gdx.files.absolute(System.getenv("HOME") + "/" + sb.toString()) : Gdx.files.external(sb.toString());
        } else {
            file = Gdx.files.local(NOT_DESKTOP_PREFS_DIR + filename);
        }
        return file;
    }

    public FileHandle getUserFolder() {
        FileHandle file = null;
        if (Gdx.app.getType() == Application.ApplicationType.Desktop) {
            String dir = Config.getInstance().getProperty("title", DESKTOP_PREFS_DIR);
            dir.replace(" ", "");
            StringBuilder sb = new StringBuilder(".");
            file = System.getProperty("os.name").toLowerCase().contains("mac") && System.getenv("HOME").contains("Containers") ? Gdx.files.absolute(System.getenv("HOME") + "/" + sb.append(dir).toString()) : Gdx.files.external(sb.append(dir).toString());
        } else {
            file = Gdx.files.local(NOT_DESKTOP_PREFS_DIR);
        }
        return file;
    }
}

