/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ink;

import com.bladecoder.engine.actions.SceneActorRef;
import com.bladecoder.engine.ink.InkManager;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.EngineLogger;
import com.bladecoder.ink.runtime.Story;

public class ExternalFunctions {
    private InkManager inkManager;

    public void bindExternalFunctions(final World w, InkManager ink) throws Exception {
        this.inkManager = ink;
        this.inkManager.getStory().bindExternalFunction("inInventory", (Story.ExternalFunction)new Story.ExternalFunction1<String, Boolean>(){

            public Boolean call(String actor) throws Exception {
                if (actor.charAt(0) == '>') {
                    actor = actor.substring(1);
                }
                return w.getInventory().get(actor) != null;
            }
        });
        this.inkManager.getStory().bindExternalFunction("getActorState", (Story.ExternalFunction)new Story.ExternalFunction1<String, String>(){

            public String call(String act) throws Exception {
                String actorId;
                SceneActorRef actor = new SceneActorRef(act);
                Scene s = actor.getScene(w);
                InteractiveActor a = (InteractiveActor)s.getActor(actorId = actor.getActorId(), true);
                if (a == null) {
                    EngineLogger.error("getActorState - Actor not found: " + actorId);
                    return "";
                }
                return a.getState() == null ? "" : a.getState();
            }
        });
        this.inkManager.getStory().bindExternalFunction("getSceneState", (Story.ExternalFunction)new Story.ExternalFunction1<String, String>(){

            public String call(String scene) throws Exception {
                Scene s = w.getScene(scene);
                if (s == null) {
                    EngineLogger.error("getSceneState - Scene not found: " + scene);
                    return "";
                }
                return s.getState() == null ? "" : s.getState();
            }
        });
    }
}

