/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ink;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.actions.ActionFactory;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.ink.ExternalFunctions;
import com.bladecoder.engine.model.Text;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.serialization.ActionCallbackSerializer;
import com.bladecoder.engine.serialization.BladeJson;
import com.bladecoder.engine.util.ActionUtils;
import com.bladecoder.engine.util.EngineLogger;
import com.bladecoder.ink.runtime.Choice;
import com.bladecoder.ink.runtime.InkList;
import com.bladecoder.ink.runtime.ListDefinition;
import com.bladecoder.ink.runtime.Story;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;

public class InkManager
implements Json.Serializable {
    public static final int KEY_SIZE = 10;
    public static final char NAME_VALUE_TAG_SEPARATOR = ':';
    public static final char NAME_VALUE_PARAM_SEPARATOR = '=';
    private static final String PARAM_SEPARATOR = ",";
    public static final char COMMAND_MARK = '>';
    private ResourceBundle i18n;
    private Story story = null;
    private ExternalFunctions externalFunctions;
    private ActionCallback cb;
    private String sCb;
    private boolean wasInCutmode;
    private String storyName;
    private final World w;
    private InkVerbRunner inkVerbRunner = new InkVerbRunner();
    private Thread loaderThread;

    public InkManager(World w) {
        this.w = w;
        this.externalFunctions = new ExternalFunctions();
    }

    public void newStory(String name) throws Exception {
        this.loadThreaded(name, null);
    }

    private void loadStory(String name) {
        try {
            FileHandle asset = EngineAssetManager.getInstance().getAsset("model/" + name + ".ink.json");
            long initTime = System.currentTimeMillis();
            String json = this.getJsonString(asset.read());
            this.story = new Story(json);
            this.externalFunctions.bindExternalFunctions(this.w, this);
            this.storyName = name;
            this.loadI18NBundle();
            EngineLogger.debug("INK STORY LOADING TIME (ms): " + (System.currentTimeMillis() - initTime));
        }
        catch (Exception e) {
            EngineLogger.error("Cannot load Ink Story: " + name + " " + e.getMessage());
            this.story = null;
            this.storyName = null;
        }
    }

    private void loadStoryState(String stateString) {
        try {
            long initTime = System.currentTimeMillis();
            this.story.getState().loadJson(stateString);
            EngineLogger.debug("INK *SAVED STATE* LOADING TIME (ms): " + (System.currentTimeMillis() - initTime));
        }
        catch (Exception e) {
            EngineLogger.error("Cannot load Ink Story State for: " + this.storyName + " " + e.getMessage());
        }
    }

    public void loadI18NBundle() {
        if (this.getStoryName() != null && EngineAssetManager.getInstance().getModelFile(this.storyName + "-ink.properties").exists()) {
            this.i18n = this.w.getI18N().getBundle("model/" + this.storyName + "-ink", true);
        }
    }

    public String translateLine(String line) {
        if (line.charAt(0) == '@') {
            String key = line.substring(1);
            String[] keys = key.split("@");
            String translated = "";
            for (String k : keys) {
                try {
                    String k2 = k.substring(0, 10);
                    translated = translated + this.i18n.getString(k2);
                    if (k.length() <= 10) continue;
                    String trailing = k.substring(10);
                    translated = translated + trailing;
                }
                catch (Exception e) {
                    EngineLogger.error("MISSING TRANSLATION KEY: " + key);
                    return key;
                }
            }
            translated = translated.replace('_', ' ');
            return translated;
        }
        return line;
    }

    public String getVariable(String name) {
        return this.story.getVariablesState().get(name).toString();
    }

    public boolean compareVariable(String name, String value) {
        this.waitIfNotLoaded();
        if (this.story.getVariablesState().get(name) instanceof InkList) {
            return ((InkList)this.story.getVariablesState().get(name)).ContainsItemNamed(value);
        }
        return this.story.getVariablesState().get(name).toString().equals(value == null ? "" : value);
    }

    public void setVariable(String name, String value) throws Exception {
        this.waitIfNotLoaded();
        if (this.story.getVariablesState().get(name) instanceof InkList) {
            List names;
            InkList rawList = (InkList)this.story.getVariablesState().get(name);
            if (rawList.getOrigins() == null && (names = rawList.getOriginNames()) != null) {
                ArrayList<ListDefinition> origins = new ArrayList<ListDefinition>();
                for (String n : names) {
                    ListDefinition def = this.story.getListDefinitions().getListDefinition(n);
                    if (origins.contains(def)) continue;
                    origins.add(def);
                }
                rawList.setOrigins(origins);
            }
            rawList.addItem(value);
        } else {
            this.story.getVariablesState().set(name, (Object)value);
        }
    }

    private void continueMaximally() {
        this.waitIfNotLoaded();
        String line = null;
        this.inkVerbRunner.cancel();
        this.inkVerbRunner = new InkVerbRunner();
        HashMap<String, String> currentLineParams = new HashMap<String, String>();
        while (this.story.canContinue()) {
            try {
                line = this.story.Continue();
                currentLineParams.clear();
                if (!line.isEmpty()) {
                    line = line.substring(0, line.length() - 1);
                }
                if (!line.isEmpty()) {
                    if (EngineLogger.debugMode()) {
                        EngineLogger.debug("INK LINE: " + this.translateLine(line));
                    }
                    this.processParams(this.story.getCurrentTags(), currentLineParams);
                    if (line.charAt(0) == '>') {
                        this.processCommand(currentLineParams, line);
                    } else {
                        this.processTextLine(currentLineParams, line);
                    }
                } else {
                    EngineLogger.debug("INK EMPTY LINE!");
                }
            }
            catch (Exception e) {
                EngineLogger.error(e.getMessage(), e);
            }
            if (this.story.getCurrentErrors() == null || this.story.getCurrentErrors().isEmpty()) continue;
            EngineLogger.error((String)this.story.getCurrentErrors().get(0));
        }
        if (this.inkVerbRunner.getActions().size() > 0) {
            this.inkVerbRunner.run(null, null);
        } else if (this.hasChoices()) {
            this.wasInCutmode = this.w.inCutMode();
            this.w.setCutMode(false);
            this.w.getListener().dialogOptions();
        } else if (this.cb != null || this.sCb != null) {
            if (this.cb == null) {
                this.cb = ActionCallbackSerializer.find(this.w, this.w.getCurrentScene(), this.sCb);
            }
            ActionCallback tmpcb = this.cb;
            this.cb = null;
            tmpcb.resume();
        }
    }

    private void processParams(List<String> input, HashMap<String, String> output) {
        for (String t : input) {
            String value;
            String key;
            int i = t.indexOf(58);
            if (i == -1) {
                i = t.indexOf(61);
            }
            if (i != -1) {
                key = t.substring(0, i).trim();
                value = t.substring(i + 1, t.length()).trim();
            } else {
                key = t.trim();
                value = null;
            }
            EngineLogger.debug("PARAM: " + key + " value: " + value);
            output.put(key, value);
        }
    }

    private void processCommand(HashMap<String, String> params, String line) {
        String commandName = null;
        String[] commandParams = null;
        int i = line.indexOf(58);
        if (i == -1) {
            commandName = line.substring(1).trim();
        } else {
            commandName = line.substring(1, i).trim();
            commandParams = line.substring(i + 1).split(PARAM_SEPARATOR);
            this.processParams(Arrays.asList(commandParams), params);
        }
        if ("LeaveNow".equals(commandName)) {
            boolean init = true;
            String initVerb = null;
            if (params.get("init") != null) {
                init = Boolean.parseBoolean(params.get("init"));
            }
            if (params.get("initVerb") != null) {
                initVerb = params.get("initVerb");
            }
            this.w.setCurrentScene(params.get("scene"), init, initVerb);
        } else if (commandName.length() > 0) {
            try {
                Class c = (Class)ActionFactory.getClassTags().get((Object)commandName);
                if (c == null && commandName.indexOf(46) == -1) {
                    commandName = "com.bladecoder.engine.actions." + commandName + "Action";
                }
                Action action = ActionFactory.create(commandName, params);
                action.init(this.w);
                this.inkVerbRunner.getActions().add(action);
            }
            catch (ReflectionException | ClassNotFoundException e) {
                EngineLogger.error(e.getMessage(), (Exception)e);
            }
        } else {
            EngineLogger.error("Ink command not found: " + commandName);
        }
    }

    private void processTextLine(HashMap<String, String> params, String line) {
        int idx;
        if (!params.containsKey("actor") && (idx = line.indexOf(62)) != -1) {
            params.put("actor", line.substring(0, idx).trim());
            line = line.substring(idx + 1).trim();
        }
        if (!params.containsKey("actor") && this.w.getCurrentScene().getPlayer() != null) {
            if (!params.containsKey("type")) {
                params.put("type", Text.Type.SUBTITLE.toString());
            }
        } else if (params.containsKey("actor") && !params.containsKey("type")) {
            params.put("type", Text.Type.TALK.toString());
        } else if (!params.containsKey("type")) {
            params.put("type", Text.Type.SUBTITLE.toString());
        }
        params.put("text", this.translateLine(line));
        try {
            Action action = null;
            action = !params.containsKey("actor") ? ActionFactory.create("Text", params) : ActionFactory.create("Say", params);
            action.init(this.w);
            this.inkVerbRunner.getActions().add(action);
        }
        catch (ReflectionException | ClassNotFoundException e) {
            EngineLogger.error(e.getMessage(), (Exception)e);
        }
    }

    public Story getStory() {
        return this.story;
    }

    public void runPath(String path, ActionCallback cb) throws Exception {
        this.waitIfNotLoaded();
        if (this.story == null) {
            EngineLogger.error("Ink Story not loaded!");
            return;
        }
        this.cb = cb;
        this.story.choosePathString(path);
        this.continueMaximally();
    }

    public boolean hasChoices() {
        this.waitIfNotLoaded();
        return this.story != null && this.inkVerbRunner.getActions().size() == 0 && this.story.getCurrentChoices().size() > 0;
    }

    public List<String> getChoices() {
        List options = this.story.getCurrentChoices();
        ArrayList<String> choices = new ArrayList<String>(options.size());
        for (Choice o : options) {
            String line = o.getText();
            if (line.isEmpty()) continue;
            int idx = line.indexOf(62);
            if (idx != -1) {
                line = line.substring(idx + 1).trim();
            }
            choices.add(this.translateLine(line));
        }
        return choices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJsonString(InputStream is) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));){
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            if (line != null) {
                line = line.replace('\ufeff', ' ');
            }
            while (line != null) {
                sb.append(line);
                sb.append("\n");
                line = br.readLine();
            }
            String string = sb.toString();
            return string;
        }
    }

    public void selectChoice(int i) {
        this.w.setCutMode(this.wasInCutmode);
        try {
            this.story.chooseChoiceIndex(i);
            this.continueMaximally();
        }
        catch (Exception e) {
            EngineLogger.error(e.getMessage(), e);
        }
    }

    public String getStoryName() {
        return this.storyName;
    }

    public void setStoryName(String storyName) {
        this.storyName = storyName;
    }

    private void waitIfNotLoaded() {
        if (this.loaderThread != null && this.loaderThread.isAlive()) {
            EngineLogger.debug(">>> Loader thread not finished. Waiting for it!!!");
            try {
                this.loaderThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void loadThreaded(final String name, final String state) {
        EngineLogger.debug("LOADING INK STORY: " + name + (state == null ? "" : " WITH SAVED STATE."));
        this.loaderThread = new Thread(){

            @Override
            public void run() {
                if (name != null) {
                    InkManager.this.loadStory(name);
                }
                if (state != null) {
                    InkManager.this.loadStoryState(state);
                }
            }
        };
        this.loaderThread.start();
    }

    public InkVerbRunner getVerbRunner() {
        return this.inkVerbRunner;
    }

    public void write(Json json) {
        BladeJson bjson = (BladeJson)json;
        World w = bjson.getWorld();
        json.writeValue("storyName", (Object)this.storyName);
        if (bjson.getMode() == BladeJson.Mode.STATE) {
            json.writeValue("wasInCutmode", (Object)this.wasInCutmode);
            if (this.cb == null && this.sCb != null) {
                this.cb = ActionCallbackSerializer.find(w, w.getCurrentScene(), this.sCb);
            }
            if (this.cb != null) {
                json.writeValue("cb", (Object)ActionCallbackSerializer.find(w, w.getCurrentScene(), this.cb));
            }
            json.writeArrayStart("actions");
            for (Action a : this.inkVerbRunner.getActions()) {
                ActionUtils.writeJson(a, json);
            }
            json.writeArrayEnd();
            json.writeValue("ip", (Object)this.inkVerbRunner.getIP());
            json.writeArrayStart("actionsSer");
            for (Action a : this.inkVerbRunner.getActions()) {
                if (!(a instanceof Json.Serializable)) continue;
                json.writeObjectStart();
                ((Json.Serializable)a).write(json);
                json.writeObjectEnd();
            }
            json.writeArrayEnd();
            if (this.story != null) {
                try {
                    json.writeValue("story", (Object)this.story.getState().toJson());
                }
                catch (Exception e) {
                    EngineLogger.error(e.getMessage(), e);
                }
            }
        }
    }

    public void read(Json json, JsonValue jsonData) {
        BladeJson bjson = (BladeJson)json;
        World w = bjson.getWorld();
        String name = (String)json.readValue("storyName", String.class, jsonData);
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            this.story = null;
            this.storyName = name;
            if (bjson.getInit()) {
                this.loadThreaded(name, null);
            }
        } else {
            String storyString;
            int i;
            this.wasInCutmode = (Boolean)json.readValue("wasInCutmode", Boolean.class, jsonData);
            this.sCb = (String)json.readValue("cb", String.class, jsonData);
            JsonValue actionsValue = jsonData.get("actions");
            this.inkVerbRunner = new InkVerbRunner();
            for (i = 0; i < actionsValue.size; ++i) {
                JsonValue aValue = actionsValue.get(i);
                Action a = ActionUtils.readJson(w, json, aValue);
                this.inkVerbRunner.getActions().add(a);
            }
            this.inkVerbRunner.setIP((Integer)json.readValue("ip", Integer.class, jsonData));
            actionsValue = jsonData.get("actionsSer");
            i = 0;
            for (Action a : this.inkVerbRunner.getActions()) {
                if (!(a instanceof Json.Serializable) || i >= actionsValue.size) continue;
                if (actionsValue.get(i) == null) break;
                ((Json.Serializable)a).read(json, actionsValue.get(i));
                ++i;
            }
            if ((storyString = (String)json.readValue("story", String.class, jsonData)) != null) {
                this.loadThreaded(name, storyString);
            }
        }
    }

    public final class InkVerbRunner
    implements VerbRunner {
        private ArrayList<Action> actions = new ArrayList();
        private int ip = -1;
        private boolean cancelled = false;

        @Override
        public void resume() {
            ++this.ip;
            this.nextStep();
        }

        @Override
        public ArrayList<Action> getActions() {
            return this.actions;
        }

        @Override
        public void run(String currentTarget, ActionCallback cb) {
            this.ip = 0;
            this.nextStep();
        }

        @Override
        public int getIP() {
            return this.ip;
        }

        @Override
        public void setIP(int ip) {
            this.ip = ip;
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.ip = this.actions.size();
        }

        @Override
        public String getCurrentTarget() {
            return null;
        }

        private void nextStep() {
            if (this.cancelled) {
                return;
            }
            if (this.ip < 0) {
                InkManager.this.continueMaximally();
            } else {
                boolean stop = false;
                while (this.ip < this.actions.size() && !stop && !this.cancelled) {
                    Action a = this.actions.get(this.ip);
                    try {
                        if (a.run(this)) {
                            stop = true;
                            continue;
                        }
                        ++this.ip;
                    }
                    catch (Exception e) {
                        EngineLogger.error("EXCEPTION EXECUTING ACTION: " + a.getClass().getSimpleName(), e);
                        ++this.ip;
                    }
                }
                if (this.ip >= this.actions.size() && !stop) {
                    InkManager.this.continueMaximally();
                }
            }
        }
    }
}

