/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.anim.AnimationDesc;
import com.bladecoder.engine.anim.Tween;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.AnimationRenderer;
import com.bladecoder.engine.serialization.BladeJson;
import com.bladecoder.engine.util.EngineLogger;
import com.bladecoder.engine.util.RectangleRenderer;
import java.util.HashMap;

public class ImageRenderer
extends AnimationRenderer {
    @Override
    public String[] getInternalAnimations(AnimationDesc anim) {
        return new String[]{anim.source.substring(0, anim.source.lastIndexOf(46))};
    }

    @Override
    public void update(float delta) {
    }

    @Override
    public void draw(SpriteBatch batch, float x, float y, float scaleX, float scaleY, float rotation, Color tint) {
        float dx = ImageRenderer.getAlignDx(this.getWidth(), this.orgAlign);
        float dy = ImageRenderer.getAlignDy(this.getHeight(), this.orgAlign);
        ImageCacheEntry source = (ImageCacheEntry)this.currentSource;
        if (source == null || source.tex == null) {
            RectangleRenderer.draw((Batch)batch, x + dx * scaleX, y + dy * scaleY, this.getWidth() * scaleX, this.getHeight() * scaleY, Color.RED);
            return;
        }
        if (tint != null) {
            batch.setColor(tint);
        }
        batch.draw(source.tex, x += dx, y += dy, -dx, -dy, this.getWidth(), this.getHeight(), scaleX, scaleY, rotation, 0, 0, source.tex.getWidth(), source.tex.getHeight(), this.flipX, false);
        if (tint != null) {
            batch.setColor(Color.WHITE);
        }
    }

    @Override
    public float getWidth() {
        ImageCacheEntry source = (ImageCacheEntry)this.currentSource;
        if (source == null || source.tex == null) {
            return super.getWidth();
        }
        return source.tex.getWidth();
    }

    @Override
    public float getHeight() {
        ImageCacheEntry source = (ImageCacheEntry)this.currentSource;
        if (source == null || source.tex == null) {
            return super.getHeight();
        }
        return source.tex.getHeight();
    }

    @Override
    public void startAnimation(String id, Tween.Type repeatType, int count, ActionCallback cb) {
        AnimationDesc fa = this.getAnimation(id);
        if (fa == null) {
            EngineLogger.error("AnimationDesc not found: " + id);
            return;
        }
        if (cb != null) {
            ActionCallback tmpcb = cb;
            cb = null;
            tmpcb.resume();
        }
        if (this.currentAnimation != null && this.currentAnimation.disposeWhenPlayed) {
            this.disposeSource(this.currentAnimation.source);
        }
        this.currentAnimation = fa;
        this.currentSource = (AnimationRenderer.CacheEntry)this.sourceCache.get(fa.source);
        if (this.currentSource == null || this.currentSource.refCounter < 1) {
            this.loadSource(fa.source);
            EngineAssetManager.getInstance().finishLoading();
            this.retrieveSource(fa.source);
            this.currentSource = (AnimationRenderer.CacheEntry)this.sourceCache.get(fa.source);
            if (this.currentSource == null) {
                EngineLogger.error("Could not load AnimationDesc: " + id);
                this.currentAnimation = null;
                this.computeBbox();
                return;
            }
        }
        this.computeBbox();
    }

    @Override
    public void startAnimation(String id, Tween.Type repeatType, int count, ActionCallback cb, String direction) {
        StringBuilder sb = new StringBuilder(id);
        if (direction == null) {
            int idx = this.getCurrentAnimationId().indexOf(46);
            if (idx != -1) {
                String dir = this.getCurrentAnimationId().substring(idx);
                sb.append(dir);
            }
        } else {
            sb.append('.');
            sb.append(direction);
        }
        String anim = sb.toString();
        if (this.getAnimation(anim) == null) {
            anim = id;
        }
        this.startAnimation(anim, repeatType, count, null);
    }

    @Override
    public void startAnimation(String id, Tween.Type repeatType, int count, ActionCallback cb, Vector2 p0, Vector2 pf) {
        this.startAnimation(id, repeatType, count, cb, this.getDirectionString(p0, pf, this.getDirs(id, this.fanims)));
    }

    private void loadSource(String source) {
        AnimationRenderer.CacheEntry entry = (AnimationRenderer.CacheEntry)this.sourceCache.get(source);
        if (entry == null) {
            entry = new ImageCacheEntry();
            this.sourceCache.put(source, entry);
        }
        if (entry.refCounter == 0) {
            if (source.charAt(0) == '@') {
                source = this.getI18NSource(source.substring(1));
            }
            EngineAssetManager.getInstance().loadTexture("images/" + source);
        }
        ++entry.refCounter;
    }

    private void retrieveSource(String source) {
        AnimationRenderer.CacheEntry entry = (AnimationRenderer.CacheEntry)this.sourceCache.get(source);
        if (entry == null || entry.refCounter < 1) {
            this.loadSource(source);
            EngineAssetManager.getInstance().finishLoading();
            entry = (AnimationRenderer.CacheEntry)this.sourceCache.get(source);
        }
        if (((ImageCacheEntry)entry).tex == null) {
            if (source.charAt(0) == '@') {
                source = this.getI18NSource(source.substring(1));
            }
            ((ImageCacheEntry)entry).tex = EngineAssetManager.getInstance().getTexture("images/" + source);
            ((ImageCacheEntry)entry).tex.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        }
    }

    private String getI18NSource(String source) {
        String lang = this.world.getI18N().getCurrentLocale().getLanguage();
        int pointIdx = source.lastIndexOf(46);
        String ext = source.substring(pointIdx);
        String name = source.substring(0, pointIdx);
        String localName = name + "_" + lang + ext;
        if (EngineAssetManager.getInstance().assetExists("images/" + localName)) {
            return localName;
        }
        return source;
    }

    private void disposeSource(String source) {
        ImageCacheEntry entry = (ImageCacheEntry)this.sourceCache.get(source);
        if (entry.refCounter == 1) {
            EngineAssetManager.getInstance().disposeTexture(entry.tex);
            entry.tex = null;
        }
        --entry.refCounter;
    }

    @Override
    public void loadAssets() {
        AnimationDesc fa;
        for (AnimationDesc fa2 : this.fanims.values()) {
            if (!fa2.preload) continue;
            this.loadSource(fa2.source);
        }
        if (this.currentAnimation != null && !this.currentAnimation.preload) {
            this.loadSource(this.currentAnimation.source);
        } else if (this.currentAnimation == null && this.initAnimation != null && (fa = (AnimationDesc)this.fanims.get(this.initAnimation)) != null && !fa.preload) {
            this.loadSource(fa.source);
        }
    }

    @Override
    public void retrieveAssets() {
        for (String key : this.sourceCache.keySet()) {
            if (((AnimationRenderer.CacheEntry)this.sourceCache.get((Object)key)).refCounter <= 0) continue;
            this.retrieveSource(key);
        }
        if (this.currentAnimation != null) {
            AnimationRenderer.CacheEntry entry;
            this.currentSource = entry = (AnimationRenderer.CacheEntry)this.sourceCache.get(this.currentAnimation.source);
        } else if (this.initAnimation != null) {
            this.startAnimation(this.initAnimation, Tween.Type.SPRITE_DEFINED, 1, null);
        }
        this.computeBbox();
    }

    public void dispose() {
        for (AnimationRenderer.CacheEntry entry : this.sourceCache.values()) {
            Texture tex = ((ImageCacheEntry)entry).tex;
            if (entry.refCounter <= 0 || tex == null) continue;
            EngineAssetManager.getInstance().disposeTexture(tex);
        }
        this.sourceCache.clear();
        this.currentSource = null;
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        super.read(json, jsonData);
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            this.fanims = (HashMap)json.readValue("fanims", HashMap.class, AnimationDesc.class, jsonData);
        }
    }

    class ImageCacheEntry
    extends AnimationRenderer.CacheEntry {
        Texture tex;

        ImageCacheEntry() {
        }
    }
}

