/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.CharacterActor;
import com.bladecoder.engine.model.DirtyProps;
import com.bladecoder.engine.model.SoundDesc;
import com.bladecoder.engine.model.Verb;
import com.bladecoder.engine.model.VerbManager;
import com.bladecoder.engine.serialization.BladeJson;
import java.util.HashMap;
import java.util.Map;

public class InteractiveActor
extends BaseActor
implements Comparable<InteractiveActor> {
    protected String desc;
    protected float zIndex;
    protected boolean interaction = true;
    protected String state;
    protected final VerbManager verbs = new VerbManager();
    private boolean playerInside = false;
    protected String layer;
    private final Vector2 refPoint = new Vector2();

    public void setLayer(String layer) {
        this.layer = layer;
        this.setDirtyProp(DirtyProps.LAYER);
    }

    public String getLayer() {
        return this.layer;
    }

    public boolean canInteract() {
        return this.interaction && this.isVisible();
    }

    public boolean getInteraction() {
        return this.interaction;
    }

    public void setInteraction(boolean interaction) {
        this.interaction = interaction;
        this.setDirtyProp(DirtyProps.INTERACTION);
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
        this.setDirtyProp(DirtyProps.DESC);
    }

    public Vector2 getRefPoint() {
        return this.refPoint;
    }

    public void setRefPoint(float x, float y) {
        this.refPoint.set(x, y);
    }

    public VerbManager getVerbManager() {
        return this.verbs;
    }

    @Override
    public void update(float delta) {
        CharacterActor player = null;
        if (this.scene != null) {
            player = this.scene.getPlayer();
        }
        if (this.isVisible() && player != null) {
            boolean hit = this.hit(player.getX(), player.getY());
            if (!hit && this.playerInside) {
                this.playerInside = false;
                Verb v = this.getVerb("exit");
                if (v != null) {
                    v.run(null, null);
                }
            } else if (hit && !this.playerInside) {
                this.playerInside = true;
                Verb v = this.getVerb("enter");
                if (v != null) {
                    v.run(null, null);
                }
            }
        }
    }

    public Verb getVerb(String id) {
        return this.verbs.getVerb(id, this.state, null);
    }

    public Verb getVerb(String id, String target) {
        return this.verbs.getVerb(id, this.state, target);
    }

    public void runVerb(String id) {
        this.verbs.runVerb(id, this.state, null, null);
    }

    public void runVerb(String id, String target) {
        this.verbs.runVerb(id, this.state, target, null);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("  State: ").append(this.state);
        sb.append("\n  Desc: ").append(this.desc);
        sb.append("\n  Verbs:");
        for (String v : this.verbs.getVerbs().keySet()) {
            sb.append(" ").append(v);
        }
        sb.append("\n");
        return sb.toString();
    }

    public float getZIndex() {
        return this.zIndex;
    }

    public void setZIndex(float z) {
        this.zIndex = z;
        this.setDirtyProp(DirtyProps.ZINDEX);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
        this.setDirtyProp(DirtyProps.STATE);
    }

    @Override
    public int compareTo(InteractiveActor o) {
        return (int)(o.getBBox().getY() - this.getBBox().getY());
    }

    @Override
    public void write(Json json) {
        super.write(json);
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            if (this.desc != null) {
                json.writeValue("desc", (Object)this.desc);
            }
            if (this.state != null) {
                json.writeValue("state", (Object)this.state);
            }
            float worldScale = EngineAssetManager.getInstance().getScale();
            json.writeValue("refPoint", (Object)new Vector2(this.getRefPoint().x / worldScale, this.getRefPoint().y / worldScale));
        } else {
            json.writeValue("playerInside", (Object)this.playerInside);
            if (this.isDirty(DirtyProps.DESC)) {
                json.writeValue("desc", (Object)this.desc);
            }
            if (this.isDirty(DirtyProps.STATE)) {
                json.writeValue("state", (Object)this.state);
            }
        }
        this.verbs.write(json);
        if (bjson.getMode() == BladeJson.Mode.MODEL || this.isDirty(DirtyProps.INTERACTION)) {
            json.writeValue("interaction", (Object)this.interaction);
        }
        if (bjson.getMode() == BladeJson.Mode.MODEL || this.isDirty(DirtyProps.ZINDEX)) {
            json.writeValue("zIndex", (Object)Float.valueOf(this.zIndex));
        }
        if (bjson.getMode() == BladeJson.Mode.MODEL || this.isDirty(DirtyProps.LAYER)) {
            json.writeValue("layer", (Object)this.layer);
        }
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        super.read(json, jsonData);
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            HashMap sounds;
            this.layer = (String)json.readValue("layer", String.class, jsonData);
            Vector2 r = (Vector2)json.readValue("refPoint", Vector2.class, jsonData);
            if (r != null) {
                float worldScale = EngineAssetManager.getInstance().getScale();
                this.getRefPoint().set(r.x * worldScale, r.y * worldScale);
            }
            if ((sounds = (HashMap)json.readValue("sounds", HashMap.class, SoundDesc.class, jsonData)) != null) {
                for (Map.Entry e : sounds.entrySet()) {
                    ((SoundDesc)e.getValue()).setId(this.id + "_" + (String)e.getKey());
                    bjson.getWorld().getSounds().put(this.id + "_" + (String)e.getKey(), (SoundDesc)e.getValue());
                }
            }
        } else {
            this.playerInside = (Boolean)json.readValue("playerInside", Boolean.TYPE, (Object)false, jsonData);
            String newLayer = (String)json.readValue("layer", String.class, jsonData);
            if (newLayer != null && !newLayer.equals(this.layer)) {
                if (this.scene != null && this.scene.getLayer(this.layer).remove(this)) {
                    this.scene.getLayer(newLayer).add(this);
                }
                this.layer = newLayer;
            }
        }
        this.verbs.read(json, jsonData);
        this.interaction = (Boolean)json.readValue("interaction", Boolean.TYPE, (Object)this.interaction, jsonData);
        this.state = (String)json.readValue("state", String.class, (Object)this.state, jsonData);
        this.zIndex = ((Float)json.readValue("zIndex", Float.TYPE, (Object)Float.valueOf(this.zIndex), jsonData)).floatValue();
        this.desc = (String)json.readValue("desc", String.class, (Object)this.desc, jsonData);
    }
}

