/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.SceneActorRef;
import com.bladecoder.engine.assets.AssetConsumer;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.serialization.BladeJson;
import com.bladecoder.engine.util.EngineLogger;
import java.util.ArrayList;

public class Inventory
implements AssetConsumer,
Json.Serializable {
    private ArrayList<SpriteActor> items = new ArrayList();
    private boolean visible = true;
    private transient boolean disposed = true;

    public int getNumItems() {
        return this.items.size();
    }

    public SpriteActor get(int i) {
        return this.items.get(i);
    }

    public SpriteActor get(String actorId) {
        for (SpriteActor a : this.items) {
            if (!a.getId().equals(actorId)) continue;
            return a;
        }
        return null;
    }

    public void addItem(SpriteActor actor) {
        if (!this.items.contains(actor)) {
            this.items.add(actor);
        } else {
            EngineLogger.error("BaseActor already in inventory: " + actor.getId());
        }
    }

    public void removeItem(SpriteActor item) {
        this.items.remove(item);
    }

    public SpriteActor removeItem(String item) {
        for (SpriteActor a : this.items) {
            if (!a.getId().equals(item)) continue;
            this.items.remove(a);
            return a;
        }
        return null;
    }

    public void update(float delta) {
        for (SpriteActor a : this.items) {
            a.update(delta);
        }
    }

    public void removeAllItems() {
        for (SpriteActor a : this.items) {
            a.dispose();
        }
        this.items.clear();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public void loadAssets() {
        for (SpriteActor a : this.items) {
            a.loadAssets();
        }
    }

    @Override
    public void retrieveAssets() {
        for (SpriteActor a : this.items) {
            a.retrieveAssets();
        }
        this.disposed = false;
    }

    public void dispose() {
        for (SpriteActor a : this.items) {
            a.dispose();
        }
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void write(Json json) {
        json.writeValue("visible", (Object)this.visible);
        json.writeObjectStart("items");
        for (SpriteActor a : this.items) {
            SceneActorRef actorRef = new SceneActorRef(a.getInitScene(), a.getId());
            json.writeValue(actorRef.toString(), (Object)a);
        }
        json.writeObjectEnd();
    }

    public void read(Json json, JsonValue jsonData) {
        SceneActorRef actorRef;
        JsonValue jsonValueAct;
        int i;
        BladeJson bjson = (BladeJson)json;
        this.visible = (Boolean)json.readValue("visible", Boolean.class, jsonData);
        this.items.clear();
        JsonValue jsonValueActors = jsonData.get("items");
        for (i = 0; i < jsonValueActors.size; ++i) {
            jsonValueAct = jsonValueActors.get(i);
            actorRef = new SceneActorRef(jsonValueAct.name);
            Scene sourceScn = bjson.getWorld().getScene(actorRef.getSceneId());
            BaseActor actor = sourceScn.getActor(actorRef.getActorId(), false);
            sourceScn.removeActor(actor);
            this.addItem((SpriteActor)actor);
        }
        for (i = 0; i < jsonValueActors.size; ++i) {
            jsonValueAct = jsonValueActors.get(i);
            actorRef = new SceneActorRef(jsonValueAct.name);
            SpriteActor actor = this.items.get(i);
            actor.read(json, jsonValueAct);
        }
    }
}

