/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.utils.Json;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.serialization.BladeJson;
import com.bladecoder.engine.util.PolygonUtils;

public class ObstacleActor
extends BaseActor {
    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.scene != null && this.scene.getPolygonalNavGraph() != null) {
            if (visible) {
                this.scene.getPolygonalNavGraph().addDinamicObstacle(this.getBBox());
            } else {
                this.scene.getPolygonalNavGraph().removeDinamicObstacle(this.getBBox());
            }
        }
    }

    @Override
    public void update(float delta) {
    }

    @Override
    public void setPosition(float x, float y) {
        boolean inNavGraph = false;
        if (this.scene != null && this.scene.getPolygonalNavGraph() != null) {
            inNavGraph = this.scene.getPolygonalNavGraph().removeDinamicObstacle(this.getBBox());
        }
        this.getBBox().setPosition(x, y);
        if (inNavGraph) {
            this.scene.getPolygonalNavGraph().addDinamicObstacle(this.getBBox());
        }
    }

    @Override
    public void write(Json json) {
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            PolygonUtils.ensureClockWise(this.getBBox().getVertices(), 0, this.getBBox().getVertices().length);
            this.getBBox().dirty();
        }
        super.write(json);
    }
}

