/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.anim.CameraTween;
import com.bladecoder.engine.anim.Tween;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.util.InterpolationMode;

public class SceneCamera
extends OrthographicCamera
implements Json.Serializable {
    private static final float START_SCROLLX = 0.1f;
    private static final float START_SCROLLY = 0.15f;
    private static final Vector2 tmpPos = new Vector2();
    private float startScrollDistanceX;
    private float startScrollDistanceY;
    private float scrollingWidth;
    private float scrollingHeight;
    private CameraTween cameraTween;
    private Matrix4 parallaxView = new Matrix4();
    private Matrix4 parallaxCombined = new Matrix4();
    private Vector3 tmp = new Vector3();
    private Vector3 tmp2 = new Vector3();

    public void create(float worldWidth, float worldHeight) {
        this.scrollingWidth = worldWidth;
        this.scrollingHeight = worldHeight;
        this.zoom = 1.0f;
        this.setToOrtho(false, worldWidth, worldHeight);
        this.update();
        this.startScrollDistanceX = worldWidth * 0.1f;
        this.startScrollDistanceY = worldHeight * 0.15f;
    }

    public float getWidth() {
        return this.viewportWidth;
    }

    public float getHeight() {
        return this.viewportHeight;
    }

    public float getScrollingWidth() {
        return this.scrollingWidth;
    }

    public float getScrollingHeight() {
        return this.scrollingHeight;
    }

    public void setScrollingDimensions(float w, float h) {
        this.scrollingWidth = Math.max(w, this.viewportWidth);
        this.scrollingHeight = Math.max(h, this.viewportHeight);
    }

    public void update(float delta) {
        if (this.cameraTween != null) {
            this.cameraTween.update(delta);
            if (this.cameraTween != null && this.cameraTween.isComplete()) {
                this.cameraTween = null;
            }
        }
    }

    public void setPosition(float x, float y) {
        float maxleft = this.viewportWidth / 2.0f * this.zoom;
        float maxright = this.scrollingWidth - this.viewportWidth / 2.0f * this.zoom;
        float maxbottom = this.viewportHeight / 2.0f * this.zoom;
        float maxtop = this.scrollingHeight - this.viewportHeight / 2.0f * this.zoom;
        x = MathUtils.clamp((float)x, (float)maxleft, (float)maxright);
        y = MathUtils.clamp((float)y, (float)maxbottom, (float)maxtop);
        this.position.set(x, y, 0.0f);
        this.update();
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
        this.update();
    }

    public Vector2 getPosition() {
        Vector3 p = this.position;
        return tmpPos.set(p.x, p.y);
    }

    public float getZoom() {
        return this.zoom;
    }

    public void stopAnim() {
        this.cameraTween = null;
    }

    public void startAnimation(float destX, float destY, float zoom, float duration, InterpolationMode interpolation, ActionCallback cb) {
        this.cameraTween = new CameraTween();
        this.cameraTween.start(this, Tween.Type.NO_REPEAT, 1, destX, destY, zoom, duration, interpolation, cb);
    }

    public void getInputUnProject(Viewport viewport, Vector3 out) {
        out.set((float)Gdx.input.getX(), (float)Gdx.input.getY(), 0.0f);
        this.unproject(out, viewport.getScreenX(), viewport.getScreenY(), viewport.getScreenWidth(), viewport.getScreenHeight());
        out.x = MathUtils.clamp((float)out.x, (float)0.0f, (float)(this.scrollingWidth - 1.0f));
        out.y = MathUtils.clamp((float)out.y, (float)0.0f, (float)(this.scrollingHeight - 1.0f));
    }

    public void updatePos(SpriteActor followActor) {
        float cx = this.position.x;
        float posx = followActor.getX();
        float cy = this.position.y;
        float posy = followActor.getY();
        boolean translate = false;
        if (cx - posx > this.startScrollDistanceX * this.zoom) {
            cx -= cx - posx - this.startScrollDistanceX * this.zoom;
            translate = true;
        } else if (posx - cx > this.startScrollDistanceX * this.zoom) {
            cx += posx - cx - this.startScrollDistanceX * this.zoom;
            translate = true;
        }
        if (cy - posy + followActor.getHeight() > this.startScrollDistanceY * this.zoom) {
            cy -= cy - posy - this.startScrollDistanceY * this.zoom;
            translate = true;
        } else if (posy - cy > this.startScrollDistanceY * this.zoom) {
            cy += posy - cy - this.startScrollDistanceY * this.zoom;
            translate = true;
        }
        if (translate) {
            this.setPosition(cx, cy);
        }
    }

    public void scene2screen(Viewport viewport, Vector3 out) {
        this.project(out, 0.0f, 0.0f, viewport.getScreenWidth(), viewport.getScreenHeight());
    }

    public Matrix4 calculateParallaxMatrix(float parallaxX, float parallaxY) {
        this.update();
        this.tmp.set(this.position);
        this.tmp.y *= parallaxY;
        this.tmp.x = (this.tmp.x - this.scrollingWidth / 2.0f) * parallaxX + this.scrollingWidth / 2.0f;
        this.parallaxView.setToLookAt(this.tmp, this.tmp2.set(this.tmp).add(this.direction), this.up);
        this.parallaxCombined.set(this.projection);
        Matrix4.mul((float[])this.parallaxCombined.val, (float[])this.parallaxView.val);
        return this.parallaxCombined;
    }

    public void write(Json json) {
        float worldScale = EngineAssetManager.getInstance().getScale();
        json.writeValue("width", (Object)Float.valueOf(this.viewportWidth / worldScale));
        json.writeValue("height", (Object)Float.valueOf(this.viewportHeight / worldScale));
        json.writeValue("scrollingWidth", (Object)Float.valueOf(this.scrollingWidth / worldScale));
        json.writeValue("scrollingHeight", (Object)Float.valueOf(this.scrollingHeight / worldScale));
        Vector2 p = this.getPosition();
        p.x /= worldScale;
        p.y /= worldScale;
        json.writeValue("pos", (Object)p);
        json.writeValue("zoom", (Object)Float.valueOf(this.getZoom()));
        if (this.cameraTween != null) {
            json.writeValue("cameraTween", (Object)this.cameraTween);
        }
    }

    public void read(Json json, JsonValue jsonData) {
        float worldScale = EngineAssetManager.getInstance().getScale();
        this.viewportWidth = ((Float)json.readValue("width", Float.class, jsonData)).floatValue() * worldScale;
        this.viewportHeight = ((Float)json.readValue("height", Float.class, jsonData)).floatValue() * worldScale;
        this.scrollingWidth = ((Float)json.readValue("scrollingWidth", Float.class, jsonData)).floatValue() * worldScale;
        this.scrollingHeight = ((Float)json.readValue("scrollingHeight", Float.class, jsonData)).floatValue() * worldScale;
        Vector2 pos = (Vector2)json.readValue("pos", Vector2.class, jsonData);
        pos.x *= worldScale;
        pos.y *= worldScale;
        float z = ((Float)json.readValue("zoom", Float.class, jsonData)).floatValue();
        this.create(this.viewportWidth, this.viewportHeight);
        this.zoom = z;
        this.position.set(pos.x, pos.y, 0.0f);
        this.update();
        this.cameraTween = (CameraTween)json.readValue("cameraTween", CameraTween.class, jsonData);
        if (this.cameraTween != null) {
            this.cameraTween.setTarget(this);
        }
    }
}

