/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalShadowLight;
import com.badlogic.gdx.graphics.g3d.environment.PointLight;
import com.badlogic.gdx.graphics.g3d.model.Animation;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader;
import com.badlogic.gdx.graphics.g3d.utils.AnimationController;
import com.badlogic.gdx.graphics.g3d.utils.DefaultShaderProvider;
import com.badlogic.gdx.graphics.g3d.utils.DepthShaderProvider;
import com.badlogic.gdx.graphics.g3d.utils.ShaderProvider;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.anim.AnimationDesc;
import com.bladecoder.engine.anim.Tween;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.AnimationRenderer;
import com.bladecoder.engine.serialization.ActionCallbackSerializer;
import com.bladecoder.engine.serialization.BladeJson;
import com.bladecoder.engine.util.EngineLogger;
import com.bladecoder.engine.util.Utils3D;
import java.nio.IntBuffer;
import java.util.HashMap;

public class Sprite3DRenderer
extends AnimationRenderer {
    private static final String FRAGMENT_SHADER = "com/bladecoder/engine/shading/cel.fragment.glsl";
    private static final String FLOOR_FRAGMENT_SHADER = "com/bladecoder/engine/shading/floor.fragment.glsl";
    private static final String VERTEX_SHADER = "com/bladecoder/engine/shading/cel.vertex.glsl";
    private static final boolean USE_FBO = false;
    private static final int MAX_BONES = 40;
    private static final Rectangle VIEWPORT = new Rectangle();
    private static final IntBuffer VIEWPORT_RESULTS = BufferUtils.newIntBuffer((int)16);
    private int currentCount;
    private Tween.Type currentAnimationType;
    private TextureRegion tex;
    private Environment environment;
    private Environment shadowEnvironment;
    private FrameBuffer fb = null;
    private int width = 200;
    private int height = 200;
    private Vector3 cameraPos;
    private Vector3 cameraRot;
    private String cameraName = "Camera";
    private float cameraFOV = 49.3f;
    private float modelRotation = 0.0f;
    private static ModelBatch modelBatch;
    private static ModelBatch shadowBatch;
    private static ModelBatch floorBatch;
    private final DirectionalShadowLight shadowLight = (DirectionalShadowLight)new DirectionalShadowLight(1024, 1024, 30.0f, 30.0f, 1.0f, 100.0f).set(1.0f, 1.0f, 1.0f, 0.01f, -1.0f, 0.01f);
    PointLight celLight;
    String celLightName = "Light";
    private ActionCallback animationCb = null;
    private float lastAnimationTime = 0.0f;
    private boolean renderShadow = true;
    private final AnimationController.AnimationListener animationListener = new AnimationController.AnimationListener(){

        public void onLoop(AnimationController.AnimationDesc animation) {
        }

        public void onEnd(AnimationController.AnimationDesc animation) {
            if (Sprite3DRenderer.this.animationCb != null) {
                ActionCallback tmpcb = Sprite3DRenderer.this.animationCb;
                Sprite3DRenderer.this.animationCb = null;
                tmpcb.resume();
            }
        }
    };
    private static final Vector3 tmp;

    @Override
    public String getCurrentAnimationId() {
        return this.currentAnimation.id;
    }

    @Override
    public String[] getInternalAnimations(AnimationDesc anim) {
        this.retrieveSource(anim.source);
        Array animations = ((ModelCacheEntry)this.sourceCache.get((Object)anim.source)).modelInstance.animations;
        String[] result = new String[animations.size];
        for (int i = 0; i < animations.size; ++i) {
            Animation a = (Animation)animations.get(i);
            result[i] = a.id;
        }
        return result;
    }

    private void renderTex() {
        Sprite3DRenderer.updateViewport();
        this.fb.begin();
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        Gdx.gl.glClear(16640);
        this.drawModel();
        this.fb.end((int)Sprite3DRenderer.VIEWPORT.x, (int)Sprite3DRenderer.VIEWPORT.y, (int)Sprite3DRenderer.VIEWPORT.width, (int)Sprite3DRenderer.VIEWPORT.height);
    }

    private void genShadowMap() {
        Sprite3DRenderer.updateViewport();
        ModelCacheEntry cs = (ModelCacheEntry)this.currentSource;
        this.shadowLight.begin(Vector3.Zero, cs.camera3d.direction);
        shadowBatch.begin(this.shadowLight.getCamera());
        shadowBatch.render((RenderableProvider)cs.modelInstance);
        shadowBatch.end();
        this.shadowLight.end();
        Gdx.graphics.getGL20().glViewport((int)Sprite3DRenderer.VIEWPORT.x, (int)Sprite3DRenderer.VIEWPORT.y, (int)Sprite3DRenderer.VIEWPORT.width, (int)Sprite3DRenderer.VIEWPORT.height);
    }

    private void drawModel() {
        if (this.currentSource != null) {
            ModelCacheEntry cs = (ModelCacheEntry)this.currentSource;
            if (this.renderShadow) {
                floorBatch.begin((Camera)cs.camera3d);
                floorBatch.render((RenderableProvider)Utils3D.getFloor(), this.shadowEnvironment);
                floorBatch.end();
            }
            modelBatch.begin((Camera)cs.camera3d);
            if (EngineLogger.debugMode() && EngineLogger.debugLevel == 1) {
                modelBatch.render((RenderableProvider)Utils3D.getAxes(), this.environment);
            }
            modelBatch.render((RenderableProvider)cs.modelInstance, this.environment);
            modelBatch.end();
        }
    }

    public void setCameraPos(float x, float y, float z) {
        if (this.cameraPos == null) {
            this.cameraPos = new Vector3(x, y, z);
        } else {
            this.cameraPos.set(x, y, z);
        }
    }

    public void setCameraRot(float x, float y, float z) {
        if (this.cameraRot == null) {
            this.cameraRot = new Vector3(x, y, z);
        } else {
            this.cameraRot.set(x, y, z);
        }
    }

    public void setCameraFOV(float fov) {
        this.cameraFOV = fov;
    }

    public void setCameraName(String name) {
        this.cameraName = name;
    }

    public void setCelLightName(String name) {
        this.celLightName = name;
    }

    public float getCameraFOV() {
        return this.cameraFOV;
    }

    public String getCameraName() {
        return this.cameraName;
    }

    public Vector2 getSpriteSize() {
        return new Vector2((float)this.width, (float)this.height);
    }

    private PerspectiveCamera getCamera(ModelInstance modelInstance) {
        Node n;
        PerspectiveCamera camera3d = new PerspectiveCamera(this.cameraFOV, (float)this.width, (float)this.height);
        if (this.cameraPos == null) {
            n = null;
            n = modelInstance.getNode(this.cameraName);
            this.cameraPos = n != null ? n.translation : new Vector3(0.0f, 0.0f, 5.0f);
        }
        if (this.cameraRot == null) {
            n = null;
            n = modelInstance.getNode(this.cameraName);
            if (n != null) {
                float rx = (float)(57.2957763671875 * Math.asin(2.0f * n.rotation.x * n.rotation.y + 2.0f * n.rotation.z * n.rotation.w));
                float ry = (float)(57.2957763671875 * Math.atan2(2.0f * n.rotation.x * n.rotation.w - 2.0f * n.rotation.y * n.rotation.z, 1.0f - 2.0f * n.rotation.x * n.rotation.x - 2.0f * n.rotation.z * n.rotation.z));
                float rz = (float)Math.atan2(2.0f * n.rotation.y * n.rotation.w - 2.0f * n.rotation.x * n.rotation.z, 1.0f - 2.0f * n.rotation.y * n.rotation.y - 2.0f * n.rotation.z * n.rotation.z);
                this.setCameraRot(rx, ry, rz);
            } else {
                this.cameraRot = new Vector3();
            }
        }
        camera3d.position.set(this.cameraPos);
        camera3d.rotate(this.cameraRot.x, 1.0f, 0.0f, 0.0f);
        camera3d.rotate(this.cameraRot.y, 0.0f, 1.0f, 0.0f);
        camera3d.rotate(this.cameraRot.z, 0.0f, 0.0f, 1.0f);
        camera3d.near = 0.1f;
        camera3d.far = 30.0f;
        camera3d.update();
        return camera3d;
    }

    @Override
    public void startAnimation(String id, Tween.Type repeatType, int count, ActionCallback cb) {
        AnimationDesc fa = (AnimationDesc)this.fanims.get(id);
        if (fa == null) {
            EngineLogger.error("AnimationDesc not found: " + id);
            return;
        }
        if (this.currentAnimation != null && this.currentAnimation.disposeWhenPlayed) {
            this.disposeSource(this.currentAnimation.source);
        }
        this.currentAnimation = fa;
        this.currentSource = (AnimationRenderer.CacheEntry)this.sourceCache.get(fa.source);
        this.animationCb = cb;
        if (this.currentSource == null || this.currentSource.refCounter < 1) {
            this.loadSource(fa.source);
            EngineAssetManager.getInstance().finishLoading();
            this.retrieveSource(fa.source);
            this.currentSource = (AnimationRenderer.CacheEntry)this.sourceCache.get(fa.source);
            if (this.currentSource == null) {
                EngineLogger.error("Could not load AnimationDesc: " + id);
                this.currentAnimation = null;
                return;
            }
        }
        if (repeatType == Tween.Type.SPRITE_DEFINED) {
            this.currentAnimationType = this.currentAnimation.animationType;
            this.currentCount = this.currentAnimation.count;
        } else {
            this.currentCount = count;
            this.currentAnimationType = repeatType;
        }
        this.lastAnimationTime = 0.0f;
        float speed = this.currentAnimation.duration;
        if (this.currentAnimationType == Tween.Type.REVERSE || this.currentAnimationType == Tween.Type.REVERSE_REPEAT) {
            speed *= -1.0f;
        }
        ModelCacheEntry cs = (ModelCacheEntry)this.currentSource;
        if (cs.modelInstance.getAnimation(id) != null) {
            this.animationCb = cb;
            cs.controller.setAnimation(id, this.currentCount, speed, this.animationListener);
            this.computeBbox();
            return;
        }
        int idx = id.indexOf(46);
        if (idx != -1) {
            String s = id.substring(0, idx);
            String dir = id.substring(idx + 1);
            this.lookat(dir);
            if (cs.modelInstance.getAnimation(s) != null) {
                cs.controller.setAnimation(s, count, speed, this.animationListener);
                this.computeBbox();
                return;
            }
        }
        EngineLogger.error("Animation NOT FOUND: " + id);
        for (Animation a : cs.modelInstance.animations) {
            EngineLogger.debug(a.id);
        }
        if (cb != null) {
            ActionCallback tmpcb = cb;
            cb = null;
            tmpcb.resume();
        }
        this.computeBbox();
    }

    @Override
    public void startAnimation(String id, Tween.Type repeatType, int count, ActionCallback cb, String direction) {
        this.startAnimation(id, repeatType, count, null);
        if (direction != null && this.currentAnimation != null) {
            this.lookat(direction);
        }
    }

    @Override
    public void startAnimation(String id, Tween.Type repeatType, int count, ActionCallback cb, Vector2 p0, Vector2 pf) {
        this.startAnimation(id, repeatType, count, null);
        if (this.currentAnimation != null) {
            Vector2 tmp = new Vector2(pf);
            float angle = tmp.sub(p0).angle() + 90.0f;
            this.lookat(angle);
        }
    }

    private void lookat(String dir) {
        EngineLogger.debug("LOOKAT DIRECTION - " + dir);
        if (dir.equals("back")) {
            this.lookat(180.0f);
        } else if (dir.equals("front")) {
            this.lookat(0.0f);
        } else if (dir.equals("left")) {
            this.lookat(270.0f);
        } else if (dir.equals("right")) {
            this.lookat(90.0f);
        } else if (dir.equals("backleft")) {
            this.lookat(225.0f);
        } else if (dir.equals("backright")) {
            this.lookat(135.0f);
        } else if (dir.equals("frontleft")) {
            this.lookat(-45.0f);
        } else if (dir.equals("frontright")) {
            this.lookat(45.0f);
        } else {
            EngineLogger.error("LOOKAT: Direction not found - " + dir);
        }
    }

    private void lookat(float angle) {
        ((ModelCacheEntry)this.currentSource).modelInstance.transform.setToRotation(Vector3.Y, angle);
        this.modelRotation = angle;
    }

    public void setSpriteSize(Vector2 size) {
        this.width = (int)size.x;
        this.height = (int)size.y;
    }

    @Override
    public void update(float delta) {
        ModelCacheEntry cs = (ModelCacheEntry)this.currentSource;
        if (cs != null && cs.controller.current != null && cs.controller.current.loopCount != 0) {
            cs.controller.update(delta);
            this.lastAnimationTime += delta;
            if (this.renderShadow) {
                this.genShadowMap();
            }
        }
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public void draw(SpriteBatch batch, float x, float y, float scaleX, float scaleY, float rotation, Color tint) {
        Sprite3DRenderer.updateViewport();
        tmp.set(x -= this.getWidth() / 2.0f * scaleX, y, 0.0f);
        tmp.mul(batch.getTransformMatrix());
        tmp.prj(batch.getProjectionMatrix());
        float p0x = Sprite3DRenderer.VIEWPORT.width * (Sprite3DRenderer.tmp.x + 1.0f) / 2.0f;
        float p0y = Sprite3DRenderer.VIEWPORT.height * (Sprite3DRenderer.tmp.y + 1.0f) / 2.0f;
        tmp.set(x + (float)this.width * scaleX, y + (float)this.height * scaleY, 0.0f);
        tmp.mul(batch.getTransformMatrix());
        tmp.prj(batch.getProjectionMatrix());
        float pfx = Sprite3DRenderer.VIEWPORT.width * (Sprite3DRenderer.tmp.x + 1.0f) / 2.0f;
        float pfy = Sprite3DRenderer.VIEWPORT.height * (Sprite3DRenderer.tmp.y + 1.0f) / 2.0f;
        batch.end();
        Gdx.gl20.glViewport((int)(p0x + Sprite3DRenderer.VIEWPORT.x), (int)(p0y + Sprite3DRenderer.VIEWPORT.y), (int)(pfx - p0x), (int)(pfy - p0y));
        Gdx.gl.glClear(0x100 | (Gdx.graphics.getBufferFormat().coverageSampling ? 32768 : 0));
        this.drawModel();
        Gdx.gl20.glViewport((int)Sprite3DRenderer.VIEWPORT.x, (int)Sprite3DRenderer.VIEWPORT.y, (int)Sprite3DRenderer.VIEWPORT.width, (int)Sprite3DRenderer.VIEWPORT.height);
        batch.begin();
    }

    private void createEnvirontment() {
        this.environment = new Environment();
        if (this.celLight == null) {
            Node n = null;
            if (this.currentSource != null) {
                n = ((ModelCacheEntry)this.currentSource).modelInstance.getNode(this.celLightName);
            }
            this.celLight = n != null ? new PointLight().set(1.0f, 1.0f, 1.0f, n.translation, 1.0f) : new PointLight().set(1.0f, 1.0f, 1.0f, 0.5f, 1.0f, 1.0f, 1.0f);
        }
        this.environment.add(this.celLight);
        if (this.renderShadow) {
            this.shadowEnvironment = new Environment();
            this.shadowEnvironment.add((DirectionalLight)this.shadowLight);
            this.shadowEnvironment.shadowMap = this.shadowLight;
        }
    }

    private static void updateViewport() {
        Gdx.gl20.glGetIntegerv(2978, VIEWPORT_RESULTS);
        Sprite3DRenderer.VIEWPORT.x = VIEWPORT_RESULTS.get(0);
        Sprite3DRenderer.VIEWPORT.y = VIEWPORT_RESULTS.get(1);
        Sprite3DRenderer.VIEWPORT.width = VIEWPORT_RESULTS.get(2);
        Sprite3DRenderer.VIEWPORT.height = VIEWPORT_RESULTS.get(3);
    }

    public static void createBatchs() {
        DefaultShader.Config modelConfigShader = new DefaultShader.Config(Gdx.files.classpath(VERTEX_SHADER).readString(), Gdx.files.classpath(FRAGMENT_SHADER).readString());
        modelConfigShader.numBones = 40;
        modelConfigShader.numDirectionalLights = 0;
        modelConfigShader.numPointLights = 0;
        modelConfigShader.numSpotLights = 0;
        modelBatch = new ModelBatch((ShaderProvider)new DefaultShaderProvider(modelConfigShader));
        shadowBatch = new ModelBatch((ShaderProvider)new DepthShaderProvider());
        floorBatch = new ModelBatch((ShaderProvider)new DefaultShaderProvider(Gdx.files.classpath(VERTEX_SHADER), Gdx.files.classpath(FLOOR_FRAGMENT_SHADER)));
    }

    private void loadSource(String source) {
        ModelCacheEntry entry = (ModelCacheEntry)this.sourceCache.get(source);
        if (entry == null) {
            entry = new ModelCacheEntry();
            this.sourceCache.put(source, entry);
        }
        if (entry.refCounter == 0) {
            EngineAssetManager.getInstance().loadModel3D(source);
        }
        ++entry.refCounter;
    }

    private void retrieveSource(String source) {
        ModelCacheEntry entry = (ModelCacheEntry)this.sourceCache.get(source);
        if (entry == null || entry.refCounter < 1) {
            this.loadSource(source);
            EngineAssetManager.getInstance().finishLoading();
            entry = (ModelCacheEntry)this.sourceCache.get(source);
        }
        if (entry.modelInstance == null) {
            Model model3d = EngineAssetManager.getInstance().getModel3D(source);
            entry.modelInstance = new ModelInstance(model3d);
            entry.controller = new AnimationController(entry.modelInstance);
            entry.camera3d = this.getCamera(entry.modelInstance);
        }
    }

    private void disposeSource(String source) {
        ModelCacheEntry entry = (ModelCacheEntry)this.sourceCache.get(source);
        if (entry.refCounter == 1) {
            EngineAssetManager.getInstance().disposeModel3D(source);
            entry.modelInstance = null;
        }
        --entry.refCounter;
    }

    @Override
    public void loadAssets() {
        for (AnimationDesc fa : this.fanims.values()) {
            if (!fa.preload) continue;
            this.loadSource(fa.source);
        }
        if (this.currentAnimation != null && !this.currentAnimation.preload) {
            this.loadSource(this.currentAnimation.source);
        } else if (this.currentAnimation == null && this.initAnimation != null) {
            AnimationDesc fa = (AnimationDesc)this.fanims.get(this.initAnimation);
            if (!fa.preload) {
                this.loadSource(fa.source);
            }
        }
    }

    @Override
    public void retrieveAssets() {
        if (modelBatch == null) {
            Sprite3DRenderer.createBatchs();
        }
        this.createEnvirontment();
        for (String key : this.sourceCache.keySet()) {
            if (((AnimationRenderer.CacheEntry)this.sourceCache.get((Object)key)).refCounter <= 0) continue;
            this.retrieveSource(key);
        }
        if (this.currentAnimation != null) {
            ModelCacheEntry entry = (ModelCacheEntry)this.sourceCache.get(this.currentAnimation.source);
            this.currentSource = entry;
            float speed = this.currentAnimation.duration;
            if (this.currentAnimationType == Tween.Type.REVERSE || this.currentAnimationType == Tween.Type.REVERSE_REPEAT) {
                speed *= -1.0f;
            }
            ((ModelCacheEntry)this.currentSource).controller.setAnimation(this.currentAnimation.id, this.currentCount, speed, this.animationListener);
            this.update(this.lastAnimationTime);
        } else if (this.initAnimation != null) {
            this.startAnimation(this.initAnimation, Tween.Type.SPRITE_DEFINED, 1, null);
            if (this.currentAnimation != null) {
                this.lookat(this.modelRotation);
            }
        }
        if (this.currentSource != null && this.renderShadow) {
            this.genShadowMap();
        }
        this.computeBbox();
    }

    public void dispose() {
        for (String key : this.sourceCache.keySet()) {
            if (((AnimationRenderer.CacheEntry)this.sourceCache.get((Object)key)).refCounter <= 0) continue;
            EngineAssetManager.getInstance().disposeModel3D(key);
        }
        this.sourceCache.clear();
        this.currentSource = null;
        this.environment = null;
        this.shadowEnvironment = null;
    }

    public static void disposeBatchs() {
        if (modelBatch == null) {
            return;
        }
        modelBatch.dispose();
        shadowBatch.dispose();
        floorBatch.dispose();
        floorBatch = null;
        shadowBatch = null;
        modelBatch = null;
    }

    @Override
    public void write(Json json) {
        super.write(json);
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            float worldScale = EngineAssetManager.getInstance().getScale();
            json.writeValue("width", (Object)Float.valueOf((float)this.width / worldScale));
            json.writeValue("height", (Object)Float.valueOf((float)this.height / worldScale));
            json.writeValue("cameraPos", (Object)this.cameraPos, this.cameraPos == null ? null : Vector3.class);
            json.writeValue("cameraRot", (Object)this.cameraRot, this.cameraRot == null ? null : Vector3.class);
            json.writeValue("cameraName", (Object)this.cameraName, this.cameraName == null ? null : String.class);
            json.writeValue("cameraFOV", (Object)Float.valueOf(this.cameraFOV));
            json.writeValue("renderShadow", (Object)this.renderShadow);
        } else {
            if (this.animationCb != null) {
                json.writeValue("animationCb", (Object)ActionCallbackSerializer.find(bjson.getWorld(), bjson.getScene(), this.animationCb));
            }
            json.writeValue("currentCount", (Object)this.currentCount);
            json.writeValue("currentAnimationType", (Object)this.currentAnimationType);
            json.writeValue("lastAnimationTime", (Object)Float.valueOf(this.lastAnimationTime));
        }
        json.writeValue("modelRotation", (Object)Float.valueOf(this.modelRotation));
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        super.read(json, jsonData);
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            this.fanims = (HashMap)json.readValue("fanims", HashMap.class, AnimationDesc.class, jsonData);
            float worldScale = EngineAssetManager.getInstance().getScale();
            this.width = (int)((float)((Integer)json.readValue("width", Integer.class, jsonData)).intValue() * worldScale);
            this.height = (int)((float)((Integer)json.readValue("height", Integer.class, jsonData)).intValue() * worldScale);
            this.cameraPos = (Vector3)json.readValue("cameraPos", Vector3.class, jsonData);
            this.cameraRot = (Vector3)json.readValue("cameraRot", Vector3.class, jsonData);
            this.cameraName = (String)json.readValue("cameraName", String.class, jsonData);
            this.cameraFOV = ((Float)json.readValue("cameraFOV", Float.class, jsonData)).floatValue();
            this.renderShadow = (Boolean)json.readValue("renderShadow", Boolean.class, jsonData);
        } else {
            this.animationCb = ActionCallbackSerializer.find(bjson.getWorld(), bjson.getScene(), (String)json.readValue("animationCb", String.class, jsonData));
            this.currentCount = (Integer)json.readValue("currentCount", Integer.class, jsonData);
            this.currentAnimationType = (Tween.Type)((Object)json.readValue("currentAnimationType", Tween.Type.class, jsonData));
            this.lastAnimationTime = ((Float)json.readValue("lastAnimationTime", Float.class, jsonData)).floatValue();
        }
        this.modelRotation = ((Float)json.readValue("modelRotation", Float.class, jsonData)).floatValue();
    }

    static {
        tmp = new Vector3();
    }

    class ModelCacheEntry
    extends AnimationRenderer.CacheEntry {
        ModelInstance modelInstance;
        AnimationController controller;
        PerspectiveCamera camera3d;

        ModelCacheEntry() {
        }
    }
}

