/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.anim.AnimationDesc;
import com.bladecoder.engine.anim.Tween;
import com.bladecoder.engine.anim.WalkTween;
import com.bladecoder.engine.assets.AssetConsumer;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.ActorRenderer;
import com.bladecoder.engine.model.AnimationRenderer;
import com.bladecoder.engine.model.DirtyProps;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.serialization.BladeJson;
import com.bladecoder.engine.util.EngineLogger;
import java.util.ArrayList;

public class SpriteActor
extends InteractiveActor
implements AssetConsumer {
    protected ActorRenderer renderer;
    protected ArrayList<Tween<SpriteActor>> tweens = new ArrayList(0);
    private float rot = 0.0f;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private Color tint;
    private boolean fakeDepth = false;
    private boolean bboxFromRenderer = false;
    private String playingSound;

    public void setRenderer(ActorRenderer r) {
        this.renderer = r;
    }

    public ActorRenderer getRenderer() {
        return this.renderer;
    }

    public boolean getFakeDepth() {
        return this.fakeDepth;
    }

    public void setFakeDepth(boolean fd) {
        this.fakeDepth = fd;
        this.setDirtyProp(DirtyProps.FAKE_DEPTH);
    }

    @Override
    public void setPosition(float x, float y) {
        super.setPosition(x, y);
        if (this.scene != null && this.fakeDepth) {
            float s = this.scene.getFakeDepthScale(y);
            this.setScale(s);
        }
    }

    public boolean isBboxFromRenderer() {
        return this.bboxFromRenderer;
    }

    public void setBboxFromRenderer(boolean v) {
        this.bboxFromRenderer = v;
        if (v) {
            this.renderer.updateBboxFromRenderer(this.getBBox());
        } else {
            this.renderer.updateBboxFromRenderer(null);
        }
        this.setDirtyProp(DirtyProps.BBOX_FROM_RENDERER);
    }

    public float getWidth() {
        return this.renderer.getWidth() * this.scaleX;
    }

    public float getHeight() {
        return this.renderer.getHeight() * this.scaleY;
    }

    public float getScale() {
        return this.scaleX;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public Color getTint() {
        return this.tint;
    }

    public void setTint(Color tint) {
        this.tint = tint;
        this.setDirtyProp(DirtyProps.TINT);
    }

    public void setScale(float scale) {
        this.setScale(scale, scale);
    }

    public void setScale(float scaleX, float scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        if (this.bboxFromRenderer) {
            this.getBBox().setScale(scaleX, scaleY);
        } else {
            float worldScale = EngineAssetManager.getInstance().getScale();
            this.getBBox().setScale(scaleX * worldScale, scaleY * worldScale);
        }
        this.setDirtyProp(DirtyProps.SCALEX);
        this.setDirtyProp(DirtyProps.SCALEY);
    }

    public void setRot(float rot) {
        this.rot = rot;
        this.getBBox().setRotation(rot);
        this.setDirtyProp(DirtyProps.ROT);
    }

    public float getRot() {
        return this.rot;
    }

    @Override
    public void update(float delta) {
        super.update(delta);
        if (this.isVisible()) {
            this.renderer.update(delta);
            for (int i = 0; i < this.tweens.size(); ++i) {
                Tween<SpriteActor> t = this.tweens.get(i);
                t.update(delta);
                if (!t.isComplete() || i >= this.tweens.size() || this.tweens.get(i) != t) continue;
                this.tweens.remove(i);
                --i;
            }
        }
    }

    public void draw(SpriteBatch batch) {
        if (this.isVisible() && this.scaleX != 0.0f && this.scaleY != 0.0f) {
            this.renderer.draw(batch, this.getX(), this.getY(), this.scaleX, this.scaleY, this.rot, this.tint);
        }
    }

    public void startAnimation(String id, ActionCallback cb) {
        this.startAnimation(id, Tween.Type.SPRITE_DEFINED, 1, cb);
    }

    public void startAnimation(String id, Tween.Type repeatType, int count, ActionCallback cb) {
        if (!(this.renderer instanceof AnimationRenderer)) {
            return;
        }
        this.inAnim();
        this.removeTween(WalkTween.class);
        EngineLogger.debug("ANIMATION: " + this.id + "." + id);
        ((AnimationRenderer)this.renderer).startAnimation(id, repeatType, count, cb);
        this.outAnim(repeatType);
    }

    public void removeTween(Class<?> clazz) {
        for (int i = 0; i < this.tweens.size(); ++i) {
            Tween<SpriteActor> t = this.tweens.get(i);
            if (!clazz.isInstance(t)) continue;
            this.tweens.remove(i);
            --i;
        }
    }

    protected void inAnim() {
        AnimationDesc fa = ((AnimationRenderer)this.renderer).getCurrentAnimation();
        if (fa != null) {
            Vector2 outD;
            if (fa.sound != null) {
                String sid = fa.sound;
                if (this.scene != null && this.scene.getWorld().getSounds().get(sid) == null) {
                    sid = this.id + "_" + fa.sound;
                }
                if (this.scene != null) {
                    this.scene.getSoundManager().stopSound(sid);
                }
            }
            if ((outD = fa.outD) != null) {
                float s = EngineAssetManager.getInstance().getScale();
                this.setPosition(this.getX() + outD.x * s, this.getY() + outD.y * s);
            }
        }
    }

    protected void outAnim(Tween.Type repeatType) {
        AnimationDesc fa = ((AnimationRenderer)this.renderer).getCurrentAnimation();
        if (fa != null) {
            Vector2 inD;
            if (fa.sound != null && repeatType != Tween.Type.REVERSE) {
                String sid = fa.sound;
                if (this.scene != null && this.scene.getWorld().getSounds().get(sid) == null) {
                    sid = this.id + "_" + fa.sound;
                }
                if (this.scene != null) {
                    this.scene.getSoundManager().playSound(sid);
                }
            }
            if ((inD = fa.inD) != null) {
                float s = EngineAssetManager.getInstance().getScale();
                this.setPosition(this.getX() + inD.x * s, this.getY() + inD.y * s);
            }
        }
    }

    public void addTween(Tween<SpriteActor> tween) {
        this.removeTween(tween.getClass());
        this.tweens.add(tween);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("  Sprite Bbox: ").append(this.getBBox().toString());
        sb.append(this.renderer);
        return sb.toString();
    }

    @Override
    public void loadAssets() {
        this.renderer.loadAssets();
    }

    @Override
    public void retrieveAssets() {
        this.renderer.retrieveAssets();
        this.setPosition(this.getBBox().getX(), this.getBBox().getY());
    }

    public void dispose() {
        this.renderer.dispose();
    }

    @Override
    public void write(Json json) {
        BladeJson bjson = (BladeJson)json;
        if (this.bboxFromRenderer && bjson.getMode() == BladeJson.Mode.MODEL) {
            float[] verts = this.getBBox().getVertices();
            this.getBBox().setVertices(new float[8]);
            super.write(json);
            this.getBBox().setVertices(verts);
        } else {
            super.write(json);
        }
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            json.writeValue("renderer", (Object)this.renderer, null);
            if (this.tint != null) {
                json.writeValue("tint", (Object)this.tint);
            }
        } else {
            json.writeValue("renderer", (Object)this.renderer);
            json.writeValue("tweens", this.tweens, ArrayList.class, Tween.class);
            if (this.playingSound != null) {
                json.writeValue("playingSound", (Object)this.playingSound);
            }
            if (this.isDirty(DirtyProps.TINT)) {
                json.writeValue("tint", (Object)this.tint);
            }
        }
        if (bjson.getMode() == BladeJson.Mode.MODEL || this.isDirty(DirtyProps.SCALEX)) {
            json.writeValue("scaleX", (Object)Float.valueOf(this.scaleX));
        }
        if (bjson.getMode() == BladeJson.Mode.MODEL || this.isDirty(DirtyProps.SCALEY)) {
            json.writeValue("scaleY", (Object)Float.valueOf(this.scaleY));
        }
        if (bjson.getMode() == BladeJson.Mode.MODEL || this.isDirty(DirtyProps.ROT)) {
            json.writeValue("rot", (Object)Float.valueOf(this.rot));
        }
        if (bjson.getMode() == BladeJson.Mode.MODEL || this.isDirty(DirtyProps.FAKE_DEPTH)) {
            json.writeValue("fakeDepth", (Object)this.fakeDepth);
        }
        if (bjson.getMode() == BladeJson.Mode.MODEL || this.isDirty(DirtyProps.BBOX_FROM_RENDERER)) {
            json.writeValue("bboxFromRenderer", (Object)this.bboxFromRenderer);
        }
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        super.read(json, jsonData);
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            this.renderer = (ActorRenderer)json.readValue("renderer", ActorRenderer.class, jsonData);
        } else {
            this.tweens = (ArrayList)json.readValue("tweens", ArrayList.class, Tween.class, jsonData);
            if (this.tweens == null) {
                EngineLogger.debug("Couldn't load state of actor: " + this.id);
                return;
            }
            for (Tween<SpriteActor> t : this.tweens) {
                t.setTarget(this);
            }
            this.renderer.read(json, jsonData.get("renderer"));
            this.playingSound = (String)json.readValue("playingSound", String.class, jsonData);
        }
        this.renderer.setWorld(bjson.getWorld());
        if (jsonData.get("scale") != null) {
            this.scaleY = this.scaleX = ((Float)json.readValue("scale", Float.TYPE, jsonData)).floatValue();
        } else {
            this.scaleX = ((Float)json.readValue("scaleX", Float.TYPE, (Object)Float.valueOf(this.scaleX), jsonData)).floatValue();
            this.scaleY = ((Float)json.readValue("scaleY", Float.TYPE, (Object)Float.valueOf(this.scaleY), jsonData)).floatValue();
        }
        this.rot = ((Float)json.readValue("rot", Float.TYPE, (Object)Float.valueOf(this.rot), jsonData)).floatValue();
        this.tint = (Color)json.readValue("tint", Color.class, (Object)this.tint, jsonData);
        if (jsonData.get("depthType") != null) {
            String depthType = (String)json.readValue("depthType", String.class, (Object)null, jsonData);
            this.fakeDepth = "VECTOR".equals(depthType);
        } else {
            this.fakeDepth = (Boolean)json.readValue("fakeDepth", Boolean.TYPE, (Object)this.fakeDepth, jsonData);
        }
        this.bboxFromRenderer = (Boolean)json.readValue("bboxFromRenderer", Boolean.TYPE, (Object)this.bboxFromRenderer, jsonData);
        if (this.bboxFromRenderer) {
            this.renderer.updateBboxFromRenderer(this.getBBox());
        }
        this.setScale(this.scaleX, this.scaleY);
        this.setRot(this.rot);
        this.dirtyProps = (Long)json.readValue("dirtyProps", Long.TYPE, (Object)0L, jsonData);
    }
}

