/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.serialization.ActionCallbackSerializer;
import com.bladecoder.engine.serialization.BladeJson;

public class Text
implements Json.Serializable {
    private static final float DEFAULT_TIME = 1.0f;
    public static float TIME_MULTIPLIER = 1.0f;
    public String str;
    public float x;
    public float y;
    public float time;
    public Type type;
    public Color color;
    public String style;
    private ActionCallback cb;
    public String actorId;
    public String voiceId;
    public String animation;

    public Text() {
    }

    public Text(String str, float x, float y, float time, Type type, Color color, String style, String actorId, String voiceId, String talkAnimation, ActionCallback cb) {
        this.str = str;
        this.x = x;
        this.y = y;
        this.time = time * TIME_MULTIPLIER;
        this.type = type;
        this.color = color;
        this.style = style;
        this.cb = cb;
        this.actorId = actorId;
        this.voiceId = voiceId;
        this.animation = talkAnimation;
        if (this.time < 0.0f || voiceId != null) {
            this.time = Float.MAX_VALUE;
        } else if (this.time == 0.0f) {
            this.setAutoTime();
        }
    }

    public void setAutoTime() {
        this.time = (1.0f + 1.0f * (float)this.str.length() / 20.0f) * TIME_MULTIPLIER;
    }

    public void callCb() {
        if (this.cb != null) {
            ActionCallback tmpcb = this.cb;
            this.cb = null;
            tmpcb.resume();
        }
    }

    public void write(Json json) {
        json.writeValue("str", (Object)this.str);
        json.writeValue("x", (Object)Float.valueOf(this.x));
        json.writeValue("y", (Object)Float.valueOf(this.y));
        json.writeValue("time", (Object)Float.valueOf(this.time));
        json.writeValue("type", (Object)this.type);
        json.writeValue("color", (Object)this.color);
        json.writeValue("style", (Object)this.style);
        json.writeValue("actorId", (Object)this.actorId);
        json.writeValue("voiceId", (Object)this.voiceId);
        json.writeValue("animation", (Object)this.animation);
        if (this.cb != null) {
            World w = ((BladeJson)json).getWorld();
            Scene s = ((BladeJson)json).getScene();
            json.writeValue("cb", (Object)ActionCallbackSerializer.find(w, s, this.cb));
        }
    }

    public void read(Json json, JsonValue jsonData) {
        this.str = (String)json.readValue("str", String.class, jsonData);
        this.x = ((Float)json.readValue("x", Float.class, jsonData)).floatValue();
        this.y = ((Float)json.readValue("y", Float.class, jsonData)).floatValue();
        this.time = ((Float)json.readValue("time", Float.class, jsonData)).floatValue();
        this.type = (Type)((Object)json.readValue("type", Type.class, jsonData));
        this.color = (Color)json.readValue("color", Color.class, jsonData);
        this.style = (String)json.readValue("style", String.class, jsonData);
        this.actorId = (String)json.readValue("actorId", String.class, jsonData);
        this.voiceId = (String)json.readValue("voiceId", String.class, jsonData);
        this.animation = (String)json.readValue("animation", String.class, jsonData);
        BladeJson bjson = (BladeJson)json;
        this.cb = ActionCallbackSerializer.find(bjson.getWorld(), bjson.getScene(), (String)json.readValue("cb", String.class, jsonData));
    }

    public static enum Type {
        PLAIN,
        SUBTITLE,
        TALK,
        UI;

    }
}

